// Copyright (c) 2003-2014, Jodd Team (io.prestosql.hive.$internal.jodd.org). All Rights Reserved.

package io.prestosql.hive.$internal.jodd.typeconverter.impl;

import io.prestosql.hive.$internal.jodd.mutable.MutableLong;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverter;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverterManagerBean;

/**
 * Converts given object to a {@link MutableLong}.
 */
public class MutableLongConverter implements TypeConverter<MutableLong> {

	protected final TypeConverter<Long> typeConverter;

	@SuppressWarnings("unchecked")
	public MutableLongConverter(TypeConverterManagerBean typeConverterManagerBean) {
		typeConverter = typeConverterManagerBean.lookup(Long.class);
	}

	public MutableLong convert(Object value) {
		if (value == null) {
			return null;
		}

		if (value.getClass() == MutableLong.class) {
			return (MutableLong) value;
		}

		return new MutableLong(typeConverter.convert(value));
	}
}