// Copyright (c) 2003-2014, Jodd Team (io.prestosql.hive.$internal.jodd.org). All Rights Reserved.

package io.prestosql.hive.$internal.jodd.typeconverter.impl;

import io.prestosql.hive.$internal.jodd.mutable.MutableShort;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverter;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverterManagerBean;

/**
 * Converts given object to {@link MutableShort}.
 */
public class MutableShortConverter implements TypeConverter<MutableShort> {

	protected final TypeConverter<Short> typeConverter;

	@SuppressWarnings("unchecked")
	public MutableShortConverter(TypeConverterManagerBean typeConverterManagerBean) {
		typeConverter = typeConverterManagerBean.lookup(Short.class);
	}

	public MutableShort convert(Object value) {
		if (value == null) {
			return null;
		}

		if (value.getClass() == MutableShort.class) {
			return (MutableShort) value;
		}

		return new MutableShort(typeConverter.convert(value));
	}

}