package io.prestosql.hive.$internal.org.codehaus.jackson.map.deser.std;

import java.io.IOException;

import io.prestosql.hive.$internal.org.codehaus.jackson.JsonParser;
import io.prestosql.hive.$internal.org.codehaus.jackson.JsonProcessingException;
import io.prestosql.hive.$internal.org.codehaus.jackson.map.DeserializationContext;
import io.prestosql.hive.$internal.org.codehaus.jackson.map.TypeDeserializer;
import io.prestosql.hive.$internal.org.codehaus.jackson.type.JavaType;

/**
 * Base class for deserializers that handle types that are serialized
 * as JSON scalars (non-structured, i.e. non-Object, non-Array, values).
 * 
 * @since 1.9 (moved from higher-level package)
 */
public abstract class StdScalarDeserializer<T> extends StdDeserializer<T>
{
    protected StdScalarDeserializer(Class<?> vc) {
        super(vc);
    }

    protected StdScalarDeserializer(JavaType valueType) {
        super(valueType);
    }
    
    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt,
            TypeDeserializer typeDeserializer)
        throws IOException, JsonProcessingException
    {
        return typeDeserializer.deserializeTypedFromScalar(jp, ctxt);
    }
}
