/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.parquet.it.unimi.dsi.fastutil.chars;

import io.prestosql.hive.$internal.parquet.it.unimi.dsi.fastutil.chars.AbstractChar2ReferenceFunction;
import io.prestosql.hive.$internal.parquet.it.unimi.dsi.fastutil.chars.AbstractCharSet;
import io.prestosql.hive.$internal.parquet.it.unimi.dsi.fastutil.chars.Char2ReferenceMap;
import io.prestosql.hive.$internal.parquet.it.unimi.dsi.fastutil.chars.Char2ReferenceMaps;
import io.prestosql.hive.$internal.parquet.it.unimi.dsi.fastutil.chars.CharIterator;
import io.prestosql.hive.$internal.parquet.it.unimi.dsi.fastutil.chars.CharSet;
import io.prestosql.hive.$internal.parquet.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import io.prestosql.hive.$internal.parquet.it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import io.prestosql.hive.$internal.parquet.it.unimi.dsi.fastutil.objects.ObjectIterator;
import io.prestosql.hive.$internal.parquet.it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractChar2ReferenceMap<V>
extends AbstractChar2ReferenceFunction<V>
implements Char2ReferenceMap<V>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractChar2ReferenceMap() {
    }

    @Override
    public boolean containsValue(Object v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(char k) {
        Iterator i = this.char2ReferenceEntrySet().iterator();
        while (i.hasNext()) {
            if (((Char2ReferenceMap.Entry)i.next()).getCharKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharSet keySet() {
        return new AbstractCharSet(){

            @Override
            public boolean contains(char k) {
                return AbstractChar2ReferenceMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractChar2ReferenceMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2ReferenceMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Char2ReferenceMap.Entry<V>> i;
                    {
                        this.i = Char2ReferenceMaps.fastIterator(AbstractChar2ReferenceMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Char2ReferenceMap.Entry)this.i.next()).getCharKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ReferenceCollection<V> values() {
        return new AbstractReferenceCollection<V>(){

            @Override
            public boolean contains(Object k) {
                return AbstractChar2ReferenceMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractChar2ReferenceMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2ReferenceMap.this.clear();
            }

            @Override
            public ObjectIterator<V> iterator() {
                return new ObjectIterator<V>(){
                    private final ObjectIterator<Char2ReferenceMap.Entry<V>> i;
                    {
                        this.i = Char2ReferenceMaps.fastIterator(AbstractChar2ReferenceMap.this);
                    }

                    @Override
                    public V next() {
                        return ((Char2ReferenceMap.Entry)this.i.next()).getValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Character, ? extends V> m) {
        if (m instanceof Char2ReferenceMap) {
            ObjectIterator i = Char2ReferenceMaps.fastIterator((Char2ReferenceMap)m);
            while (i.hasNext()) {
                Char2ReferenceMap.Entry e = (Char2ReferenceMap.Entry)i.next();
                this.put(e.getCharKey(), e.getValue());
            }
        } else {
            int n = m.size();
            Iterator<Map.Entry<Character, V>> i = m.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<Character, V> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator i = Char2ReferenceMaps.fastIterator(this);
        while (n-- != 0) {
            h += ((Char2ReferenceMap.Entry)i.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.char2ReferenceEntrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator i = Char2ReferenceMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Char2ReferenceMap.Entry e = (Char2ReferenceMap.Entry)i.next();
            s.append(String.valueOf(e.getCharKey()));
            s.append("=>");
            if (this == e.getValue()) {
                s.append("(this map)");
                continue;
            }
            s.append(String.valueOf(e.getValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static abstract class BasicEntrySet<V>
    extends AbstractObjectSet<Char2ReferenceMap.Entry<V>> {
        protected final Char2ReferenceMap<V> map;

        public BasicEntrySet(Char2ReferenceMap<V> map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Char2ReferenceMap.Entry) {
                Char2ReferenceMap.Entry e = (Char2ReferenceMap.Entry)o;
                char k = e.getCharKey();
                return this.map.containsKey(k) && this.map.get(k) == e.getValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k = ((Character)key).charValue();
            Object value = e.getValue();
            return this.map.containsKey(k) && this.map.get(k) == value;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Char2ReferenceMap.Entry) {
                Char2ReferenceMap.Entry e = (Char2ReferenceMap.Entry)o;
                return this.map.remove(e.getCharKey(), e.getValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k = ((Character)key).charValue();
            Object v = e.getValue();
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry<V>
    implements Char2ReferenceMap.Entry<V> {
        protected char key;
        protected V value;

        public BasicEntry() {
        }

        public BasicEntry(Character key, V value) {
            this.key = key.charValue();
            this.value = value;
        }

        public BasicEntry(char key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char getCharKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Char2ReferenceMap.Entry) {
                Char2ReferenceMap.Entry e = (Char2ReferenceMap.Entry)o;
                return this.key == e.getCharKey() && this.value == e.getValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            Object value = e.getValue();
            return this.key == ((Character)key).charValue() && this.value == value;
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : System.identityHashCode(this.value));
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

