/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Semaphore;

public class WritableByteChannelAdapter
implements WritableByteChannel {
    private static final Logger LOG = LoggerFactory.getLogger(WritableByteChannelAdapter.class);
    private ChannelHandlerContext chc;
    private final int maxPendingWrites;
    private final Semaphore writeResources;
    private boolean closed = false;
    private final String id;
    private ChannelFutureListener writeListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) {
            WritableByteChannelAdapter.this.writeResources.release();
            if (future.isCancelled()) {
                LOG.error("Write cancelled on ID " + WritableByteChannelAdapter.this.id);
            } else if (!future.isSuccess()) {
                LOG.error("Write error on ID " + WritableByteChannelAdapter.this.id, future.cause());
            }
        }
    };
    private ChannelFutureListener closeListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) {
            if (future.isCancelled()) {
                LOG.error("Close cancelled on ID " + WritableByteChannelAdapter.this.id);
            } else if (!future.isSuccess()) {
                LOG.error("Close failed on ID " + WritableByteChannelAdapter.this.id, future.cause());
            }
        }
    };

    public WritableByteChannelAdapter(ChannelHandlerContext chc, int maxPendingWrites, String id) {
        this.chc = chc;
        this.maxPendingWrites = maxPendingWrites;
        this.writeResources = new Semaphore(maxPendingWrites);
        this.id = id;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int size = src.remaining();
        this.takeWriteResources(1);
        this.chc.writeAndFlush((Object)Unpooled.wrappedBuffer((ByteBuffer)src)).addListener((GenericFutureListener)this.writeListener);
        return size;
    }

    @Override
    public boolean isOpen() {
        return this.chc.channel().isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed: " + this.id);
        }
        this.closed = true;
        this.takeWriteResources(this.maxPendingWrites);
        try {
            this.chc.close().addListener((GenericFutureListener)this.closeListener);
        }
        finally {
            this.chc = null;
            this.closed = true;
        }
    }

    private void takeWriteResources(int numResources) throws IOException {
        try {
            this.writeResources.acquire(numResources);
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted while waiting for write resources for " + this.id);
        }
    }
}

