/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import io.prestosql.hive.$internal.com.codahale.metrics.Counter;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.metrics.Metrics;

public class HMSMetricsListener
extends MetaStoreEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HMSMetricsListener.class);
    private Counter createdDatabases = Metrics.getOrCreateCounter("create_total_count_dbs");
    private Counter deletedDatabases = Metrics.getOrCreateCounter("delete_total_count_dbs");
    private Counter createdTables = Metrics.getOrCreateCounter("create_total_count_tables");
    private Counter deletedTables = Metrics.getOrCreateCounter("delete_total_count_tables");
    private Counter createdParts = Metrics.getOrCreateCounter("create_total_count_partitions");
    private Counter deletedParts = Metrics.getOrCreateCounter("delete_total_count_partitions");

    public HMSMetricsListener(Configuration config) {
        super(config);
    }

    @Override
    public void onCreateDatabase(CreateDatabaseEvent dbEvent) throws MetaException {
        Metrics.getOrCreateGauge("total_count_dbs").incrementAndGet();
        this.createdDatabases.inc();
    }

    @Override
    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        Metrics.getOrCreateGauge("total_count_dbs").decrementAndGet();
        this.deletedDatabases.inc();
    }

    @Override
    public void onCreateTable(CreateTableEvent tableEvent) throws MetaException {
        Metrics.getOrCreateGauge("total_count_tables").incrementAndGet();
        this.createdTables.inc();
    }

    @Override
    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        Metrics.getOrCreateGauge("total_count_tables").decrementAndGet();
        this.deletedTables.inc();
    }

    @Override
    public void onDropPartition(DropPartitionEvent partitionEvent) throws MetaException {
        Metrics.getOrCreateGauge("total_count_partitions").decrementAndGet();
        this.deletedParts.inc();
    }

    @Override
    public void onAddPartition(AddPartitionEvent partitionEvent) throws MetaException {
        Metrics.getOrCreateGauge("total_count_partitions").incrementAndGet();
        this.createdParts.inc();
    }
}

