/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;

public class MaterializationsRebuildLockCleanerTask
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializationsRebuildLockCleanerTask.class);
    private Configuration conf;
    private TxnStore txnHandler;

    @Override
    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.TXN_TIMEOUT, unit) / 2L;
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleaning up materialization rebuild locks");
        }
        TxnStore.MutexAPI.LockHandle handle = null;
        try {
            handle = this.txnHandler.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.MaterializationRebuild.name());
            ValidTxnList validTxnList = TxnUtils.createValidReadTxnList(this.txnHandler.getOpenTxns(), 0L);
            long removedCnt = this.txnHandler.cleanupMaterializationRebuildLocks(validTxnList, MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.TXN_TIMEOUT, TimeUnit.MILLISECONDS));
            if (removedCnt > 0L && LOG.isDebugEnabled()) {
                LOG.debug("Number of materialization locks deleted: " + removedCnt);
            }
        }
        catch (Throwable t) {
            LOG.error("Serious error in {}", Thread.currentThread().getName(), ": {}" + t.getMessage(), t);
        }
        finally {
            if (handle != null) {
                handle.releaseLocks();
            }
        }
    }
}

