/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import io.prestosql.hive.;
import io.prestosql.hive.$internal.com.codahale.metrics.Counter;
import io.prestosql.hive.$internal.com.codahale.metrics.MetricRegistry;
import io.prestosql.hive.$internal.com.google.common.base.Preconditions;
import io.prestosql.hive.$internal.com.google.common.base.Strings;
import io.prestosql.hive.$internal.com.google.common.collect.Lists;
import io.prestosql.hive.$internal.com.google.common.collect.Maps;
import io.prestosql.hive.$internal.com.google.common.collect.Sets;
import io.prestosql.hive.$internal.org.apache.commons.lang.ArrayUtils;
import io.prestosql.hive.$internal.org.apache.commons.lang.exception.ExceptionUtils;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.jdo.JDOCanRetryException;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.datastore.DataStoreCache;
import javax.jdo.datastore.JDOConnection;
import javax.jdo.identity.IntIdentity;
import javax.sql.DataSource;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.FileMetadataHandler;
import org.apache.hadoop.hive.metastore.IMetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.MetaStoreDirectSql;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfoFactory;
import org.apache.hadoop.hive.metastore.PartFilterExprUtil;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.StatObjectConverter;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.ISchemaName;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountResponse;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRow;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SchemaCompatibility;
import org.apache.hadoop.hive.metastore.api.SchemaType;
import org.apache.hadoop.hive.metastore.api.SchemaValidation;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionDescriptor;
import org.apache.hadoop.hive.metastore.api.SchemaVersionState;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SerdeType;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMPoolTrigger;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMResourcePlanStatus;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProviderFactory;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.model.MCatalog;
import org.apache.hadoop.hive.metastore.model.MColumnDescriptor;
import org.apache.hadoop.hive.metastore.model.MConstraint;
import org.apache.hadoop.hive.metastore.model.MCreationMetadata;
import org.apache.hadoop.hive.metastore.model.MDBPrivilege;
import org.apache.hadoop.hive.metastore.model.MDatabase;
import org.apache.hadoop.hive.metastore.model.MDelegationToken;
import org.apache.hadoop.hive.metastore.model.MFieldSchema;
import org.apache.hadoop.hive.metastore.model.MFunction;
import org.apache.hadoop.hive.metastore.model.MGlobalPrivilege;
import org.apache.hadoop.hive.metastore.model.MISchema;
import org.apache.hadoop.hive.metastore.model.MMasterKey;
import org.apache.hadoop.hive.metastore.model.MMetastoreDBProperties;
import org.apache.hadoop.hive.metastore.model.MNotificationLog;
import org.apache.hadoop.hive.metastore.model.MNotificationNextId;
import org.apache.hadoop.hive.metastore.model.MOrder;
import org.apache.hadoop.hive.metastore.model.MPartition;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnStatistics;
import org.apache.hadoop.hive.metastore.model.MPartitionEvent;
import org.apache.hadoop.hive.metastore.model.MPartitionPrivilege;
import org.apache.hadoop.hive.metastore.model.MResourceUri;
import org.apache.hadoop.hive.metastore.model.MRole;
import org.apache.hadoop.hive.metastore.model.MRoleMap;
import org.apache.hadoop.hive.metastore.model.MRuntimeStat;
import org.apache.hadoop.hive.metastore.model.MSchemaVersion;
import org.apache.hadoop.hive.metastore.model.MSerDeInfo;
import org.apache.hadoop.hive.metastore.model.MStorageDescriptor;
import org.apache.hadoop.hive.metastore.model.MStringList;
import org.apache.hadoop.hive.metastore.model.MTable;
import org.apache.hadoop.hive.metastore.model.MTableColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MTableColumnStatistics;
import org.apache.hadoop.hive.metastore.model.MTablePrivilege;
import org.apache.hadoop.hive.metastore.model.MType;
import org.apache.hadoop.hive.metastore.model.MVersionTable;
import org.apache.hadoop.hive.metastore.model.MWMMapping;
import org.apache.hadoop.hive.metastore.model.MWMPool;
import org.apache.hadoop.hive.metastore.model.MWMResourcePlan;
import org.apache.hadoop.hive.metastore.model.MWMTrigger;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.ObjectPair;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.thrift.TException;
import org.datanucleus.AbstractNucleusContext;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassLoaderResolverImpl;
import org.datanucleus.ExecutionContext;
import org.datanucleus.ExecutionContextThreadedImpl;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.PersistenceNucleusContextImpl;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.plugin.NonManagedPluginRegistry;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.MissingTableException;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.types.TypeManagerImpl;
import org.datanucleus.util.WeakValueMap;

public class ObjectStore
implements RawStore,
Configurable {
    private static Properties prop = null;
    private static PersistenceManagerFactory pmf = null;
    private static boolean forTwoMetastoreTesting = false;
    private static final DateTimeFormatter YMDHMS_FORMAT = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss");
    private static Lock pmfPropLock = new ReentrantLock();
    private static final AtomicBoolean isSchemaVerified = new AtomicBoolean(false);
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStore.class);
    private static final Map<String, Class<?>> PINCLASSMAP;
    private static final String HOSTNAME;
    private static final String USER;
    private static final String JDO_PARAM = ":param";
    private boolean isInitialized = false;
    private PersistenceManager pm = null;
    private SQLGenerator sqlGenerator = null;
    private MetaStoreDirectSql directSql = null;
    private DatabaseProduct dbType = null;
    private PartitionExpressionProxy expressionProxy = null;
    private Configuration conf;
    private volatile int openTrasactionCalls = 0;
    private Transaction currentTransaction = null;
    private TXN_STATUS transactionStatus = TXN_STATUS.NO_STATE;
    private Pattern partitionValidationPattern;
    private Counter directSqlErrors;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static final Set<Class<? extends Throwable>> retriableExceptionClasses;
    private static final int stackLimit = 3;

    public ObjectStore() {
        if (this.classLoader == null) {
            this.classLoader = ObjectStore.class.getClassLoader();
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConf(Configuration conf) {
        pmfPropLock.lock();
        try {
            boolean propsChanged;
            this.isInitialized = false;
            this.conf = conf;
            ObjectStore.configureSSL(conf);
            Properties propsFromConf = ObjectStore.getDataSourceProps(conf);
            boolean bl = propsChanged = !propsFromConf.equals(prop);
            if (propsChanged) {
                if (pmf != null) {
                    ObjectStore.clearOutPmfClassLoaderCache(pmf);
                    if (!forTwoMetastoreTesting) {
                        pmf.close();
                    }
                }
                pmf = null;
                prop = null;
            }
            assert (!this.isActiveTransaction());
            this.shutdown();
            this.pm = null;
            this.directSql = null;
            this.expressionProxy = null;
            this.openTrasactionCalls = 0;
            this.currentTransaction = null;
            this.transactionStatus = TXN_STATUS.NO_STATE;
            this.initialize(propsFromConf);
            String partitionValidationRegex = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN);
            this.partitionValidationPattern = partitionValidationRegex != null && !partitionValidationRegex.isEmpty() ? Pattern.compile(partitionValidationRegex) : null;
            MetricRegistry registry = Metrics.getRegistry();
            if (registry != null) {
                this.directSqlErrors = Metrics.getOrCreateCounter("directsql_errors");
            }
            if (!this.isInitialized) {
                throw new RuntimeException("Unable to create persistence manager. Check dss.log for details");
            }
            LOG.info("Initialized ObjectStore");
        }
        finally {
            pmfPropLock.unlock();
        }
    }

    private void initialize(Properties dsProps) {
        int retryLimit = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.HMS_HANDLER_ATTEMPTS);
        long retryInterval = MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.HMS_HANDLER_INTERVAL, TimeUnit.MILLISECONDS);
        int numTries = retryLimit;
        while (numTries > 0) {
            try {
                this.initializeHelper(dsProps);
                return;
            }
            catch (Exception e) {
                boolean retriable = this.isRetriableException(e);
                if (--numTries > 0 && retriable) {
                    LOG.info("Retriable exception while instantiating ObjectStore, retrying. {} tries left", (Object)numTries, (Object)e);
                    try {
                        Thread.sleep(retryInterval);
                    }
                    catch (InterruptedException ie) {
                        LOG.debug("Interrupted while sleeping before retrying.", ie);
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                if (retriable) {
                    LOG.warn("Exception retry limit reached, not retrying any longer.", e);
                } else {
                    LOG.debug("Non-retriable exception during ObjectStore initialize.", e);
                }
                throw e;
            }
        }
    }

    private boolean isRetriableException(Throwable e) {
        if (e == null) {
            return false;
        }
        if (retriableExceptionClasses.contains(e.getClass())) {
            return true;
        }
        for (Class<? extends Throwable> c : retriableExceptionClasses) {
            if (!c.isInstance(e)) continue;
            return true;
        }
        if (e.getCause() == null) {
            return false;
        }
        return this.isRetriableException(e.getCause());
    }

    private void initializeHelper(Properties dsProps) {
        LOG.info("ObjectStore, initialize called");
        prop = dsProps;
        this.pm = this.getPersistenceManager();
        try {
            String productName = MetaStoreDirectSql.getProductName(this.pm);
            this.sqlGenerator = new SQLGenerator(DatabaseProduct.determineDatabaseProduct(productName), this.conf);
        }
        catch (SQLException e) {
            LOG.error("error trying to figure out the database product", e);
            throw new RuntimeException(e);
        }
        boolean bl = this.isInitialized = this.pm != null;
        if (this.isInitialized) {
            this.dbType = this.determineDatabaseProduct();
            this.expressionProxy = ObjectStore.createExpressionProxy(this.conf);
            if (MetastoreConf.getBoolVar(this.getConf(), MetastoreConf.ConfVars.TRY_DIRECT_SQL)) {
                String schema = prop.getProperty("javax.jdo.mapping.Schema");
                schema = io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.defaultIfBlank(schema, null);
                this.directSql = new MetaStoreDirectSql(this.pm, this.conf, schema);
            }
        }
        LOG.debug("RawStore: {}, with PersistenceManager: {} created in the thread with id: {}", this, this.pm, Thread.currentThread().getId());
    }

    private DatabaseProduct determineDatabaseProduct() {
        try {
            return DatabaseProduct.determineDatabaseProduct(ObjectStore.getProductName(this.pm));
        }
        catch (SQLException e) {
            LOG.warn("Cannot determine database product; assuming OTHER", e);
            return DatabaseProduct.OTHER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProductName(PersistenceManager pm) {
        try (JDOConnection jdoConn = pm.getDataStoreConnection();){
            String string = ((Connection)jdoConn.getNativeConnection()).getMetaData().getDatabaseProductName();
            return string;
        }
    }

    private static PartitionExpressionProxy createExpressionProxy(Configuration conf) {
        String className = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS);
        try {
            Class<PartitionExpressionProxy> clazz = JavaUtils.getClass(className, PartitionExpressionProxy.class);
            return JavaUtils.newInstance(clazz, new Class[0], new Object[0]);
        }
        catch (MetaException e) {
            LOG.error("Error loading PartitionExpressionProxy", (Throwable)((Object)e));
            throw new RuntimeException("Error loading PartitionExpressionProxy: " + e.getMessage());
        }
    }

    private static void configureSSL(Configuration conf) {
        String sslPropString = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.DBACCESS_SSL_PROPS);
        if (io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.isNotEmpty(sslPropString)) {
            LOG.info("Metastore setting SSL properties of the connection to backed DB");
            for (String sslProp : sslPropString.split(",")) {
                String[] pair = sslProp.trim().split("=");
                if (pair != null && pair.length == 2) {
                    System.setProperty(pair[0].trim(), pair[1].trim());
                    continue;
                }
                LOG.warn("Invalid metastore property value for {}", (Object)MetastoreConf.ConfVars.DBACCESS_SSL_PROPS);
            }
        }
    }

    private static Properties getDataSourceProps(Configuration conf) {
        Properties prop = new Properties();
        ObjectStore.correctAutoStartMechanism(conf);
        for (MetastoreConf.ConfVars var : MetastoreConf.dataNucleusAndJdoConfs) {
            String confVal = MetastoreConf.getAsString(conf, var);
            String varName = var.getVarname();
            Object prevVal = prop.setProperty(varName, confVal);
            if (!MetastoreConf.isPrintable(varName)) continue;
            LOG.debug("Overriding {} value {} from jpox.properties with {}", varName, prevVal, confVal);
        }
        try {
            String passwd = MetastoreConf.getPassword(conf, MetastoreConf.ConfVars.PWD);
            if (io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.isNotEmpty(passwd)) {
                prop.setProperty(MetastoreConf.ConfVars.PWD.getVarname(), passwd);
            }
        }
        catch (IOException err) {
            throw new RuntimeException("Error getting metastore password: " + err.getMessage(), err);
        }
        if (LOG.isDebugEnabled()) {
            for (Map.Entry entry : prop.entrySet()) {
                if (!MetastoreConf.isPrintable(entry.getKey().toString())) continue;
                LOG.debug("{} = {}", entry.getKey(), entry.getValue());
            }
        }
        return prop;
    }

    private static void correctAutoStartMechanism(Configuration conf) {
        String autoStartKey = "datanucleus.autoStartMechanismMode";
        String autoStartIgnore = "ignored";
        String currentAutoStartVal = conf.get("datanucleus.autoStartMechanismMode");
        if (!"ignored".equalsIgnoreCase(currentAutoStartVal)) {
            LOG.warn("{} is set to unsupported value {} . Setting it to value: {}", "datanucleus.autoStartMechanismMode", conf.get("datanucleus.autoStartMechanismMode"), "ignored");
        }
        conf.set("datanucleus.autoStartMechanismMode", "ignored");
    }

    private static synchronized PersistenceManagerFactory getPMF() {
        if (pmf == null) {
            Configuration conf = MetastoreConf.newMetastoreConf();
            DataSourceProvider dsp = DataSourceProviderFactory.getDataSourceProvider(conf);
            if (dsp == null) {
                pmf = JDOHelper.getPersistenceManagerFactory((Map)prop);
            } else {
                try {
                    DataSource ds = dsp.create(conf);
                    HashMap<Object, Object> dsProperties = new HashMap<Object, Object>();
                    dsProperties.putAll(prop);
                    dsProperties.put("datanucleus.ConnectionFactory", ds);
                    dsProperties.put("javax.jdo.PersistenceManagerFactoryClass", "org.datanucleus.api.jdo.JDOPersistenceManagerFactory");
                    pmf = JDOHelper.getPersistenceManagerFactory(dsProperties);
                }
                catch (SQLException e) {
                    LOG.warn("Could not create PersistenceManagerFactory using connection pool properties, will fall back", e);
                    pmf = JDOHelper.getPersistenceManagerFactory((Map)prop);
                }
            }
            DataStoreCache dsc = pmf.getDataStoreCache();
            if (dsc != null) {
                String objTypes = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CACHE_PINOBJTYPES);
                LOG.info("Setting MetaStore object pin classes with hive.metastore.cache.pinobjtypes=\"{}\"", (Object)objTypes);
                if (io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.isNotEmpty(objTypes)) {
                    String[] typeTokens;
                    for (String type : typeTokens = objTypes.toLowerCase().split(",")) {
                        if (PINCLASSMAP.containsKey(type = type.trim())) {
                            dsc.pinAll(true, PINCLASSMAP.get(type));
                            continue;
                        }
                        LOG.warn("{} is not one of the pinnable object types: {}", (Object)type, (Object)io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.join(PINCLASSMAP.keySet(), " "));
                    }
                }
            } else {
                LOG.warn("PersistenceManagerFactory returned null DataStoreCache object. Unable to initialize object pin types defined by hive.metastore.cache.pinobjtypes");
            }
        }
        return pmf;
    }

    @InterfaceAudience.LimitedPrivate(value={"HCATALOG"})
    @InterfaceStability.Evolving
    public PersistenceManager getPersistenceManager() {
        return ObjectStore.getPMF().getPersistenceManager();
    }

    @Override
    public void shutdown() {
        LOG.debug("RawStore: {}, with PersistenceManager: {} will be shutdown", (Object)this, (Object)this.pm);
        if (this.pm != null) {
            this.pm.close();
            this.pm = null;
        }
    }

    @Override
    public boolean openTransaction() {
        ++this.openTrasactionCalls;
        if (this.openTrasactionCalls == 1) {
            this.currentTransaction = this.pm.currentTransaction();
            this.currentTransaction.begin();
            this.transactionStatus = TXN_STATUS.OPEN;
        } else if (this.currentTransaction == null || !this.currentTransaction.isActive()) {
            throw new RuntimeException("openTransaction called in an interior transaction scope, but currentTransaction is not active.");
        }
        boolean result = this.currentTransaction.isActive();
        this.debugLog("Open transaction: count = " + this.openTrasactionCalls + ", isActive = " + result);
        return result;
    }

    @Override
    public boolean commitTransaction() {
        if (TXN_STATUS.ROLLBACK == this.transactionStatus) {
            this.debugLog("Commit transaction: rollback");
            return false;
        }
        if (this.openTrasactionCalls <= 0) {
            RuntimeException e = new RuntimeException("commitTransaction was called but openTransactionCalls = " + this.openTrasactionCalls + ". This probably indicates that there are unbalanced calls to openTransaction/commitTransaction");
            LOG.error("Unbalanced calls to open/commit Transaction", e);
            throw e;
        }
        if (!this.currentTransaction.isActive()) {
            RuntimeException e = new RuntimeException("commitTransaction was called but openTransactionCalls = " + this.openTrasactionCalls + ". This probably indicates that there are unbalanced calls to openTransaction/commitTransaction");
            LOG.error("Unbalanced calls to open/commit Transaction", e);
            throw e;
        }
        --this.openTrasactionCalls;
        this.debugLog("Commit transaction: count = " + this.openTrasactionCalls + ", isactive " + this.currentTransaction.isActive());
        if (this.openTrasactionCalls == 0 && this.currentTransaction.isActive()) {
            this.transactionStatus = TXN_STATUS.COMMITED;
            this.currentTransaction.commit();
        }
        return true;
    }

    @Override
    public boolean isActiveTransaction() {
        if (this.currentTransaction == null) {
            return false;
        }
        return this.currentTransaction.isActive();
    }

    @Override
    public void rollbackTransaction() {
        if (this.openTrasactionCalls < 1) {
            this.debugLog("rolling back transaction: no open transactions: " + this.openTrasactionCalls);
            return;
        }
        this.debugLog("Rollback transaction, isActive: " + this.currentTransaction.isActive());
        try {
            if (this.currentTransaction.isActive() && this.transactionStatus != TXN_STATUS.ROLLBACK) {
                this.currentTransaction.rollback();
            }
        }
        finally {
            this.openTrasactionCalls = 0;
            this.transactionStatus = TXN_STATUS.ROLLBACK;
            this.pm.evictAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCatalog(Catalog cat) throws MetaException {
        LOG.debug("Creating catalog " + cat.getName());
        boolean committed = false;
        MCatalog mCat = this.catToMCat(cat);
        try {
            this.openTransaction();
            this.pm.makePersistent((Object)mCat);
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterCatalog(String catName, Catalog cat) throws MetaException, InvalidOperationException {
        if (!cat.getName().equals(catName)) {
            throw new InvalidOperationException("You cannot change a catalog's name");
        }
        boolean committed = false;
        try {
            MCatalog mCat = this.getMCatalog(catName);
            if (io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.isNotBlank(cat.getLocationUri())) {
                mCat.setLocationUri(cat.getLocationUri());
            }
            if (io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.isNotBlank(cat.getDescription())) {
                mCat.setDescription(cat.getDescription());
            }
            this.openTransaction();
            this.pm.makePersistent((Object)mCat);
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    @Override
    public Catalog getCatalog(String catalogName) throws NoSuchObjectException, MetaException {
        LOG.debug("Fetching catalog " + catalogName);
        MCatalog mCat = this.getMCatalog(catalogName);
        if (mCat == null) {
            throw new NoSuchObjectException("No catalog " + catalogName);
        }
        return this.mCatToCat(mCat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCatalogs() throws MetaException {
        LOG.debug("Fetching all catalog names");
        boolean commited = false;
        ArrayList<String> catalogs = null;
        String queryStr = "select name from org.apache.hadoop.hive.metastore.model.MCatalog";
        Query query = null;
        this.openTransaction();
        try {
            query = this.pm.newQuery(queryStr);
            query.setResult("name");
            catalogs = new ArrayList<String>((Collection)query.execute());
            commited = this.commitTransaction();
        }
        finally {
            this.rollbackAndCleanup(commited, query);
        }
        Collections.sort(catalogs);
        return catalogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropCatalog(String catalogName) throws NoSuchObjectException, MetaException {
        LOG.debug("Dropping catalog " + catalogName);
        boolean committed = false;
        try {
            this.openTransaction();
            MCatalog mCat = this.getMCatalog(catalogName);
            this.pm.retrieve((Object)mCat);
            if (mCat == null) {
                throw new NoSuchObjectException("No catalog " + catalogName);
            }
            this.pm.deletePersistent((Object)mCat);
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MCatalog getMCatalog(String catalogName) throws MetaException {
        boolean committed = false;
        Query query = null;
        try {
            this.openTransaction();
            catalogName = StringUtils.normalizeIdentifier(catalogName);
            query = this.pm.newQuery(MCatalog.class, "name == catname");
            query.declareParameters("java.lang.String catname");
            query.setUnique(true);
            MCatalog mCat = (MCatalog)query.execute((Object)catalogName);
            this.pm.retrieve((Object)mCat);
            committed = this.commitTransaction();
            MCatalog mCatalog = mCat;
            this.rollbackAndCleanup(committed, query);
            return mCatalog;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
    }

    private MCatalog catToMCat(Catalog cat) {
        MCatalog mCat = new MCatalog();
        mCat.setName(StringUtils.normalizeIdentifier(cat.getName()));
        if (cat.isSetDescription()) {
            mCat.setDescription(cat.getDescription());
        }
        mCat.setLocationUri(cat.getLocationUri());
        return mCat;
    }

    private Catalog mCatToCat(MCatalog mCat) {
        Catalog cat = new Catalog(mCat.getName(), mCat.getLocationUri());
        if (mCat.getDescription() != null) {
            cat.setDescription(mCat.getDescription());
        }
        return cat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDatabase(Database db) throws InvalidObjectException, MetaException {
        boolean commited = false;
        MDatabase mdb = new MDatabase();
        assert (db.getCatalogName() != null);
        mdb.setCatalogName(StringUtils.normalizeIdentifier(db.getCatalogName()));
        assert (mdb.getCatalogName() != null);
        mdb.setName(db.getName().toLowerCase());
        mdb.setLocationUri(db.getLocationUri());
        mdb.setDescription(db.getDescription());
        mdb.setParameters(db.getParameters());
        mdb.setOwnerName(db.getOwnerName());
        PrincipalType ownerType = db.getOwnerType();
        mdb.setOwnerType(null == ownerType ? PrincipalType.USER.name() : ownerType.name());
        try {
            this.openTransaction();
            this.pm.makePersistent((Object)mdb);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MDatabase getMDatabase(String catName, String name) throws NoSuchObjectException {
        MDatabase mdb = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            name = StringUtils.normalizeIdentifier(name);
            catName = StringUtils.normalizeIdentifier(catName);
            query = this.pm.newQuery(MDatabase.class, "name == dbname && catalogName == catname");
            query.declareParameters("java.lang.String dbname, java.lang.String catname");
            query.setUnique(true);
            mdb = (MDatabase)query.execute((Object)name, (Object)catName);
            this.pm.retrieve((Object)mdb);
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        if (mdb == null) {
            throw new NoSuchObjectException("There is no database " + catName + "." + name);
        }
        return mdb;
    }

    @Override
    public Database getDatabase(String catalogName, String name) throws NoSuchObjectException {
        MetaException ex = null;
        Database db = null;
        try {
            db = this.getDatabaseInternal(catalogName, name);
        }
        catch (MetaException e) {
            ex = e;
        }
        if (db == null) {
            LOG.warn("Failed to get database {}.{}, returning NoSuchObjectException", catalogName, name, ex);
            throw new NoSuchObjectException(name + (ex == null ? "" : ": " + ex.getMessage()));
        }
        return db;
    }

    public Database getDatabaseInternal(final String catalogName, String name) throws MetaException, NoSuchObjectException {
        return (Database)new GetDbHelper(catalogName, name, true, true){

            @Override
            protected Database getSqlResult(GetHelper<Database> ctx) throws MetaException {
                return ObjectStore.this.directSql.getDatabase(catalogName, this.dbName);
            }

            @Override
            protected Database getJdoResult(GetHelper<Database> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getJDODatabase(catalogName, this.dbName);
            }
        }.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database getJDODatabase(String catName, String name) throws NoSuchObjectException {
        MDatabase mdb = null;
        boolean commited = false;
        try {
            this.openTransaction();
            mdb = this.getMDatabase(catName, name);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        Database db = new Database();
        db.setName(mdb.getName());
        db.setDescription(mdb.getDescription());
        db.setLocationUri(mdb.getLocationUri());
        db.setParameters(this.convertMap(mdb.getParameters()));
        db.setOwnerName(mdb.getOwnerName());
        String type = io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.defaultIfBlank(mdb.getOwnerType(), null);
        PrincipalType principalType = type == null ? null : PrincipalType.valueOf(type);
        db.setOwnerType(principalType);
        db.setCatalogName(catName);
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alterDatabase(String catName, String dbName, Database db) throws MetaException, NoSuchObjectException {
        MDatabase mdb = null;
        boolean committed = false;
        try {
            mdb = this.getMDatabase(catName, dbName);
            mdb.setParameters(db.getParameters());
            mdb.setOwnerName(db.getOwnerName());
            if (db.getOwnerType() != null) {
                mdb.setOwnerType(db.getOwnerType().name());
            }
            if (io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.isNotBlank(db.getDescription())) {
                mdb.setDescription(db.getDescription());
            }
            if (io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.isNotBlank(db.getLocationUri())) {
                mdb.setLocationUri(db.getLocationUri());
            }
            this.openTransaction();
            this.pm.makePersistent((Object)mdb);
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropDatabase(String catName, String dbname) throws NoSuchObjectException, MetaException {
        boolean success = false;
        LOG.info("Dropping database {}.{} along with all tables", (Object)catName, (Object)dbname);
        dbname = StringUtils.normalizeIdentifier(dbname);
        catName = StringUtils.normalizeIdentifier(catName);
        QueryWrapper queryWrapper = new QueryWrapper();
        try {
            this.openTransaction();
            MDatabase db = this.getMDatabase(catName, dbname);
            this.pm.retrieve((Object)db);
            if (db != null) {
                List<MDBPrivilege> dbGrants = this.listDatabaseGrants(catName, dbname, null, queryWrapper);
                if (.CollectionUtils.isNotEmpty(dbGrants)) {
                    this.pm.deletePersistentAll(dbGrants);
                }
                this.pm.deletePersistent((Object)db);
            }
            success = this.commitTransaction();
        }
        finally {
            this.rollbackAndCleanup(success, queryWrapper);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDatabases(String catName, String pattern) throws MetaException {
        if (pattern == null || pattern.equals("*")) {
            return this.getAllDatabases(catName);
        }
        boolean commited = false;
        ArrayList<String> databases = null;
        Query query = null;
        try {
            this.openTransaction();
            String[] subpatterns = pattern.trim().split("\\|");
            StringBuilder filterBuilder = new StringBuilder();
            ArrayList<String> parameterVals = new ArrayList<String>(subpatterns.length);
            this.appendSimpleCondition(filterBuilder, "catalogName", new String[]{catName}, parameterVals);
            this.appendPatternCondition(filterBuilder, "name", subpatterns, parameterVals);
            query = this.pm.newQuery(MDatabase.class, filterBuilder.toString());
            query.setResult("name");
            query.setOrdering("name ascending");
            Collection names = (Collection)query.executeWithArray((Object[])parameterVals.toArray(new String[0]));
            databases = new ArrayList<String>(names);
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return databases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllDatabases(String catName) throws MetaException {
        boolean commited = false;
        ArrayList<String> databases = null;
        Query query = null;
        catName = StringUtils.normalizeIdentifier(catName);
        this.openTransaction();
        try {
            query = this.pm.newQuery("select name from org.apache.hadoop.hive.metastore.model.MDatabase where catalogName == catname");
            query.declareParameters("java.lang.String catname");
            query.setResult("name");
            databases = new ArrayList<String>((Collection)query.execute((Object)catName));
            commited = this.commitTransaction();
        }
        finally {
            this.rollbackAndCleanup(commited, query);
        }
        Collections.sort(databases);
        return databases;
    }

    private MType getMType(Type type) {
        ArrayList<MFieldSchema> fields = new ArrayList<MFieldSchema>();
        if (type.getFields() != null) {
            for (FieldSchema field : type.getFields()) {
                fields.add(new MFieldSchema(field.getName(), field.getType(), field.getComment()));
            }
        }
        return new MType(type.getName(), type.getType1(), type.getType2(), fields);
    }

    private Type getType(MType mtype) {
        ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
        if (mtype.getFields() != null) {
            for (MFieldSchema field : mtype.getFields()) {
                fields.add(new FieldSchema(field.getName(), field.getType(), field.getComment()));
            }
        }
        Type ret = new Type();
        ret.setName(mtype.getName());
        ret.setType1(mtype.getType1());
        ret.setType2(mtype.getType2());
        ret.setFields(fields);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createType(Type type) {
        boolean success = false;
        MType mtype = this.getMType(type);
        boolean commited = false;
        try {
            this.openTransaction();
            this.pm.makePersistent((Object)mtype);
            commited = this.commitTransaction();
            success = true;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type getType(String typeName) {
        Type type = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MType.class, "name == typeName");
            query.declareParameters("java.lang.String typeName");
            query.setUnique(true);
            MType mtype = (MType)query.execute((Object)typeName.trim());
            this.pm.retrieve(type);
            if (mtype != null) {
                type = this.getType(mtype);
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropType(String typeName) {
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MType.class, "name == typeName");
            query.declareParameters("java.lang.String typeName");
            query.setUnique(true);
            MType type = (MType)query.execute((Object)typeName.trim());
            this.pm.retrieve((Object)type);
            if (type != null) {
                this.pm.deletePersistent((Object)type);
            }
            success = this.commitTransaction();
            this.rollbackAndCleanup(success, query);
        }
        catch (JDOObjectNotFoundException e) {
            try {
                success = this.commitTransaction();
                LOG.debug("type not found {}", (Object)typeName, (Object)e);
                this.rollbackAndCleanup(success, query);
            }
            catch (Throwable throwable) {
                this.rollbackAndCleanup(success, query);
                throw throwable;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> createTableWithConstraints(Table tbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws InvalidObjectException, MetaException {
        boolean success = false;
        try {
            this.openTransaction();
            this.createTable(tbl);
            ArrayList<String> constraintNames = new ArrayList<String>();
            if (foreignKeys != null) {
                constraintNames.addAll(this.addForeignKeys(foreignKeys, false, primaryKeys, uniqueConstraints));
            }
            if (primaryKeys != null) {
                constraintNames.addAll(this.addPrimaryKeys(primaryKeys, false));
            }
            if (uniqueConstraints != null) {
                constraintNames.addAll(this.addUniqueConstraints(uniqueConstraints, false));
            }
            if (notNullConstraints != null) {
                constraintNames.addAll(this.addNotNullConstraints(notNullConstraints, false));
            }
            if (defaultConstraints != null) {
                constraintNames.addAll(this.addDefaultConstraints(defaultConstraints, false));
            }
            if (checkConstraints != null) {
                constraintNames.addAll(this.addCheckConstraints(checkConstraints, false));
            }
            success = this.commitTransaction();
            ArrayList<String> arrayList = constraintNames;
            return arrayList;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(Table tbl) throws InvalidObjectException, MetaException {
        boolean commited = false;
        try {
            this.openTransaction();
            MTable mtbl = this.convertToMTable(tbl);
            this.pm.makePersistent((Object)mtbl);
            if (tbl.getCreationMetadata() != null) {
                MCreationMetadata mcm = this.convertToMCreationMetadata(tbl.getCreationMetadata());
                this.pm.makePersistent((Object)mcm);
            }
            PrincipalPrivilegeSet principalPrivs = tbl.getPrivileges();
            ArrayList<Object> toPersistPrivObjs = new ArrayList<Object>();
            if (principalPrivs != null) {
                int now = (int)(System.currentTimeMillis() / 1000L);
                Map<String, List<PrivilegeGrantInfo>> userPrivs = principalPrivs.getUserPrivileges();
                this.putPersistentPrivObjects(mtbl, toPersistPrivObjs, now, userPrivs, PrincipalType.USER, "SQL");
                Map<String, List<PrivilegeGrantInfo>> groupPrivs = principalPrivs.getGroupPrivileges();
                this.putPersistentPrivObjects(mtbl, toPersistPrivObjs, now, groupPrivs, PrincipalType.GROUP, "SQL");
                Map<String, List<PrivilegeGrantInfo>> rolePrivs = principalPrivs.getRolePrivileges();
                this.putPersistentPrivObjects(mtbl, toPersistPrivObjs, now, rolePrivs, PrincipalType.ROLE, "SQL");
            }
            this.pm.makePersistentAll(toPersistPrivObjs);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
    }

    private void putPersistentPrivObjects(MTable mtbl, List<Object> toPersistPrivObjs, int now, Map<String, List<PrivilegeGrantInfo>> privMap, PrincipalType type, String authorizer) {
        if (privMap != null) {
            for (Map.Entry<String, List<PrivilegeGrantInfo>> entry : privMap.entrySet()) {
                String principalName = entry.getKey();
                List<PrivilegeGrantInfo> privs = entry.getValue();
                for (int i = 0; i < privs.size(); ++i) {
                    PrivilegeGrantInfo priv = privs.get(i);
                    if (priv == null) continue;
                    MTablePrivilege mTblSec = new MTablePrivilege(principalName, type.toString(), mtbl, priv.getPrivilege(), now, priv.getGrantor(), priv.getGrantorType().toString(), priv.isGrantOption(), authorizer);
                    toPersistPrivObjs.add(mTblSec);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropTable(String catName, String dbName, String tableName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        boolean materializedView = false;
        boolean success = false;
        try {
            this.openTransaction();
            MTable tbl = this.getMTable(catName, dbName, tableName);
            this.pm.retrieve((Object)tbl);
            if (tbl != null) {
                List<MPartitionColumnPrivilege> partColGrants;
                List<MPartitionPrivilege> partGrants;
                List<MTableColumnPrivilege> tblColGrants;
                materializedView = TableType.MATERIALIZED_VIEW.toString().equals(tbl.getTableType());
                List<MTablePrivilege> tabGrants = this.listAllTableGrants(catName, dbName, tableName);
                if (.CollectionUtils.isNotEmpty(tabGrants)) {
                    this.pm.deletePersistentAll(tabGrants);
                }
                if (.CollectionUtils.isNotEmpty(tblColGrants = this.listTableAllColumnGrants(catName, dbName, tableName))) {
                    this.pm.deletePersistentAll(tblColGrants);
                }
                if (.CollectionUtils.isNotEmpty(partGrants = this.listTableAllPartitionGrants(catName, dbName, tableName))) {
                    this.pm.deletePersistentAll(partGrants);
                }
                if (.CollectionUtils.isNotEmpty(partColGrants = this.listTableAllPartitionColumnGrants(catName, dbName, tableName))) {
                    this.pm.deletePersistentAll(partColGrants);
                }
                try {
                    this.deleteTableColumnStatistics(catName, dbName, tableName, null);
                }
                catch (NoSuchObjectException e) {
                    LOG.info("Found no table level column statistics associated with {} to delete", (Object)Warehouse.getCatalogQualifiedTableName(catName, dbName, tableName));
                }
                List<MConstraint> tabConstraints = this.listAllTableConstraintsWithOptionalConstraintName(catName, dbName, tableName, null);
                if (.CollectionUtils.isNotEmpty(tabConstraints)) {
                    this.pm.deletePersistentAll(tabConstraints);
                }
                this.preDropStorageDescriptor(tbl.getSd());
                if (materializedView) {
                    this.dropCreationMetadata(tbl.getDatabase().getCatalogName(), tbl.getDatabase().getName(), tbl.getTableName());
                }
                this.pm.deletePersistentAll(new Object[]{tbl});
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropCreationMetadata(String catName, String dbName, String tableName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        boolean success = false;
        dbName = StringUtils.normalizeIdentifier(dbName);
        tableName = StringUtils.normalizeIdentifier(tableName);
        try {
            this.openTransaction();
            MCreationMetadata mcm = this.getCreationMetadata(catName, dbName, tableName);
            this.pm.retrieve((Object)mcm);
            if (mcm != null) {
                this.pm.deletePersistentAll(new Object[]{mcm});
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MConstraint> listAllTableConstraintsWithOptionalConstraintName(String catName, String dbName, String tableName, String constraintname) {
        catName = StringUtils.normalizeIdentifier(catName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        tableName = StringUtils.normalizeIdentifier(tableName);
        constraintname = constraintname != null ? StringUtils.normalizeIdentifier(constraintname) : null;
        ArrayList<MConstraint> mConstraints = null;
        ArrayList<String> constraintNames = new ArrayList<String>();
        Query query = null;
        try {
            query = this.pm.newQuery("select constraintName from org.apache.hadoop.hive.metastore.model.MConstraint  where ((parentTable.tableName == ptblname && parentTable.database.name == pdbname && parentTable.database.catalogName == pcatname) || (childTable != null && childTable.tableName == ctblname &&childTable.database.name == cdbname && childTable.database.catalogName == ccatname)) " + (constraintname != null ? " && constraintName == constraintname" : ""));
            query.declareParameters("java.lang.String ptblname, java.lang.String pdbname,java.lang.String pcatname, java.lang.String ctblname, java.lang.String cdbname,java.lang.String ccatname" + (constraintname != null ? ", java.lang.String constraintname" : ""));
            Collection constraintNamesColl = constraintname != null ? (Collection)query.executeWithArray(new Object[]{tableName, dbName, catName, tableName, dbName, catName, constraintname}) : (Collection)query.executeWithArray(new Object[]{tableName, dbName, catName, tableName, dbName, catName});
            for (String currName : constraintNamesColl) {
                constraintNames.add(currName);
            }
            query = this.pm.newQuery(MConstraint.class);
            query.setFilter("param.contains(constraintName)");
            query.declareParameters("java.util.Collection param");
            Collection constraints = (Collection)query.execute(constraintNames);
            mConstraints = new ArrayList<MConstraint>();
            for (MConstraint currConstraint : constraints) {
                mConstraints.add(currConstraint);
            }
        }
        finally {
            if (query != null) {
                query.closeAll();
            }
        }
        return mConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table getTable(String catName, String dbName, String tableName) throws MetaException {
        boolean commited = false;
        Table tbl = null;
        try {
            this.openTransaction();
            tbl = this.convertToTable(this.getMTable(catName, dbName, tableName));
            if (tbl != null && TableType.MATERIALIZED_VIEW.toString().equals(tbl.getTableType())) {
                tbl.setCreationMetadata(this.convertToCreationMetadata(this.getCreationMetadata(catName, dbName, tableName)));
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return tbl;
    }

    @Override
    public List<String> getTables(String catName, String dbName, String pattern) throws MetaException {
        return this.getTables(catName, dbName, pattern, null);
    }

    @Override
    public List<String> getTables(String catName, String dbName, String pattern, TableType tableType) throws MetaException {
        try {
            return this.getTablesInternal(catName, dbName, pattern, tableType, pattern == null || pattern.equals(".*"), true);
        }
        catch (NoSuchObjectException e) {
            throw new MetaException(ExceptionUtils.getStackTrace((Throwable)((Object)e)));
        }
    }

    @Override
    public List<MetaStoreUtils.FullTableName> getTableNamesWithStats() throws MetaException, NoSuchObjectException {
        return (List)new GetListHelper<MetaStoreUtils.FullTableName>(null, null, null, true, false){

            @Override
            protected List<MetaStoreUtils.FullTableName> getSqlResult(GetHelper<List<MetaStoreUtils.FullTableName>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getTableNamesWithStats();
            }

            @Override
            protected List<MetaStoreUtils.FullTableName> getJdoResult(GetHelper<List<MetaStoreUtils.FullTableName>> ctx) throws MetaException {
                throw new UnsupportedOperationException("UnsupportedOperationException");
            }
        }.run(false);
    }

    @Override
    public Map<String, List<String>> getPartitionColsWithStats(String catName, String dbName, final String tableName) throws MetaException, NoSuchObjectException {
        return (Map)new GetHelper<Map<String, List<String>>>(catName, dbName, null, true, false){

            @Override
            protected Map<String, List<String>> getSqlResult(GetHelper<Map<String, List<String>>> ctx) throws MetaException {
                try {
                    return ObjectStore.this.directSql.getColAndPartNamesWithStats(this.catName, this.dbName, tableName);
                }
                catch (Throwable ex) {
                    LOG.error("DirectSQL failed", ex);
                    throw new MetaException(ex.getMessage());
                }
            }

            @Override
            protected Map<String, List<String>> getJdoResult(GetHelper<Map<String, List<String>>> ctx) throws MetaException {
                throw new UnsupportedOperationException("UnsupportedOperationException");
            }

            @Override
            protected String describeResult() {
                return ((Map)this.results).size() + " partitions";
            }
        }.run(false);
    }

    @Override
    public List<MetaStoreUtils.FullTableName> getAllTableNamesForStats() throws MetaException, NoSuchObjectException {
        return (List)new GetListHelper<MetaStoreUtils.FullTableName>(null, null, null, true, false){

            @Override
            protected List<MetaStoreUtils.FullTableName> getSqlResult(GetHelper<List<MetaStoreUtils.FullTableName>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getAllTableNamesForStats();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected List<MetaStoreUtils.FullTableName> getJdoResult(GetHelper<List<MetaStoreUtils.FullTableName>> ctx) throws MetaException {
                boolean commited = false;
                Query query = null;
                ArrayList<MetaStoreUtils.FullTableName> result = new ArrayList<MetaStoreUtils.FullTableName>();
                ObjectStore.this.openTransaction();
                try {
                    String paramStr = "";
                    String whereStr = "";
                    for (int i = 0; i < MetaStoreDirectSql.STATS_TABLE_TYPES.length; ++i) {
                        if (i != 0) {
                            paramStr = paramStr + ", ";
                            whereStr = whereStr + "||";
                        }
                        paramStr = paramStr + "java.lang.String tt" + i;
                        whereStr = whereStr + " tableType == tt" + i;
                    }
                    query = ObjectStore.this.pm.newQuery(MTable.class, whereStr);
                    query.declareParameters(paramStr);
                    Collection tbls = (Collection)query.executeWithArray(new Object[]{query, MetaStoreDirectSql.STATS_TABLE_TYPES});
                    ObjectStore.this.pm.retrieveAll(tbls);
                    for (MTable tbl : tbls) {
                        result.add(new MetaStoreUtils.FullTableName(tbl.getDatabase().getCatalogName(), tbl.getDatabase().getName(), tbl.getTableName()));
                    }
                    commited = ObjectStore.this.commitTransaction();
                    ObjectStore.this.rollbackAndCleanup(commited, query);
                }
                catch (Throwable throwable) {
                    ObjectStore.this.rollbackAndCleanup(commited, query);
                    throw throwable;
                }
                return result;
            }
        }.run(false);
    }

    protected List<String> getTablesInternal(String catName, String dbName, final String pattern, final TableType tableType, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        final String db_name = StringUtils.normalizeIdentifier(dbName);
        final String cat_name = StringUtils.normalizeIdentifier(catName);
        return (List)new GetListHelper<String>(cat_name, dbName, null, allowSql, allowJdo){

            @Override
            protected List<String> getSqlResult(GetHelper<List<String>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getTables(cat_name, db_name, tableType);
            }

            @Override
            protected List<String> getJdoResult(GetHelper<List<String>> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getTablesInternalViaJdo(cat_name, db_name, pattern, tableType);
            }
        }.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getTablesInternalViaJdo(String catName, String dbName, String pattern, TableType tableType) throws MetaException {
        boolean commited = false;
        Query query = null;
        ArrayList<String> tbls = null;
        try {
            this.openTransaction();
            dbName = StringUtils.normalizeIdentifier(dbName);
            ArrayList<String> parameterVals = new ArrayList<String>();
            StringBuilder filterBuilder = new StringBuilder();
            this.appendSimpleCondition(filterBuilder, "database.name", new String[]{dbName}, parameterVals);
            this.appendSimpleCondition(filterBuilder, "database.catalogName", new String[]{catName}, parameterVals);
            if (pattern != null) {
                this.appendPatternCondition(filterBuilder, "tableName", pattern, parameterVals);
            }
            if (tableType != null) {
                this.appendPatternCondition(filterBuilder, "tableType", new String[]{tableType.toString()}, parameterVals);
            }
            query = this.pm.newQuery(MTable.class, filterBuilder.toString());
            query.setResult("tableName");
            query.setOrdering("tableName ascending");
            Collection names = (Collection)query.executeWithArray((Object[])parameterVals.toArray(new String[0]));
            tbls = new ArrayList<String>(names);
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return tbls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMaterializedViewsForRewriting(String catName, String dbName) throws MetaException, NoSuchObjectException {
        String db_name = StringUtils.normalizeIdentifier(dbName);
        catName = StringUtils.normalizeIdentifier(catName);
        boolean commited = false;
        Query query = null;
        ArrayList<String> tbls = null;
        try {
            this.openTransaction();
            dbName = StringUtils.normalizeIdentifier(dbName);
            query = this.pm.newQuery(MTable.class, "database.name == db && database.catalogName == cat && tableType == tt && rewriteEnabled == re");
            query.declareParameters("java.lang.String db, java.lang.String cat, java.lang.String tt, boolean re");
            query.setResult("tableName");
            Collection names = (Collection)query.executeWithArray(new Object[]{db_name, catName, TableType.MATERIALIZED_VIEW.toString(), true});
            tbls = new ArrayList<String>(names);
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return tbls;
    }

    @Override
    public int getDatabaseCount() throws MetaException {
        return this.getObjectCount("name", MDatabase.class.getName());
    }

    @Override
    public int getPartitionCount() throws MetaException {
        return this.getObjectCount("partitionName", MPartition.class.getName());
    }

    @Override
    public int getTableCount() throws MetaException {
        return this.getObjectCount("tableName", MTable.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getObjectCount(String fieldName, String objName) {
        Long result = 0L;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            String queryStr = "select count(" + fieldName + ") from " + objName;
            query = this.pm.newQuery(queryStr);
            result = (Long)query.execute();
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return result.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableMeta> getTableMeta(String catName, String dbNames, String tableNames, List<String> tableTypes) throws MetaException {
        boolean commited = false;
        Query query = null;
        ArrayList<TableMeta> metas = new ArrayList<TableMeta>();
        try {
            this.openTransaction();
            StringBuilder filterBuilder = new StringBuilder();
            ArrayList<String> parameterVals = new ArrayList<String>();
            this.appendSimpleCondition(filterBuilder, "database.catalogName", new String[]{catName}, parameterVals);
            if (dbNames != null && !dbNames.equals("*")) {
                this.appendPatternCondition(filterBuilder, "database.name", dbNames, parameterVals);
            }
            if (tableNames != null && !tableNames.equals("*")) {
                this.appendPatternCondition(filterBuilder, "tableName", tableNames, parameterVals);
            }
            if (tableTypes != null && !tableTypes.isEmpty()) {
                this.appendSimpleCondition(filterBuilder, "tableType", tableTypes.toArray(new String[0]), parameterVals);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getTableMeta with filter " + filterBuilder.toString() + " params: " + io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.join(parameterVals, ", "));
            }
            query = this.pm.newQuery(MTable.class, filterBuilder.toString());
            Collection tables = (Collection)query.executeWithArray((Object[])parameterVals.toArray(new String[parameterVals.size()]));
            for (MTable table : tables) {
                TableMeta metaData = new TableMeta(table.getDatabase().getName(), table.getTableName(), table.getTableType());
                metaData.setComments(table.getParameters().get("comment"));
                metas.add(metaData);
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return metas;
    }

    private StringBuilder appendPatternCondition(StringBuilder filterBuilder, String fieldName, String[] elements, List<String> parameterVals) {
        return this.appendCondition(filterBuilder, fieldName, elements, true, parameterVals);
    }

    private StringBuilder appendPatternCondition(StringBuilder builder, String fieldName, String elements, List<String> parameters) {
        elements = StringUtils.normalizeIdentifier(elements);
        return this.appendCondition(builder, fieldName, elements.split("\\|"), true, parameters);
    }

    private StringBuilder appendSimpleCondition(StringBuilder builder, String fieldName, String[] elements, List<String> parameters) {
        return this.appendCondition(builder, fieldName, elements, false, parameters);
    }

    private StringBuilder appendCondition(StringBuilder builder, String fieldName, String[] elements, boolean pattern, List<String> parameters) {
        if (builder.length() > 0) {
            builder.append(" && ");
        }
        builder.append(" (");
        int length = builder.length();
        for (String element : elements) {
            if (pattern) {
                element = "(?i)" + element.replaceAll("\\*", ".*");
            }
            parameters.add(element);
            if (builder.length() > length) {
                builder.append(" || ");
            }
            builder.append(fieldName);
            if (pattern) {
                builder.append(".matches(").append(JDO_PARAM).append(parameters.size()).append(")");
                continue;
            }
            builder.append(" == ").append(JDO_PARAM).append(parameters.size());
        }
        builder.append(" )");
        return builder;
    }

    @Override
    public List<String> getAllTables(String catName, String dbName) throws MetaException {
        return this.getTables(catName, dbName, ".*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttachedMTableInfo getMTable(String catName, String db, String table, boolean retrieveCD) {
        AttachedMTableInfo nmtbl = new AttachedMTableInfo();
        MTable mtbl = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            catName = StringUtils.normalizeIdentifier(catName);
            db = StringUtils.normalizeIdentifier(db);
            table = StringUtils.normalizeIdentifier(table);
            query = this.pm.newQuery(MTable.class, "tableName == table && database.name == db && database.catalogName == catname");
            query.declareParameters("java.lang.String table, java.lang.String db, java.lang.String catname");
            query.setUnique(true);
            LOG.debug("Executing getMTable for " + Warehouse.getCatalogQualifiedTableName(catName, db, table));
            mtbl = (MTable)query.execute((Object)table, (Object)db, (Object)catName);
            this.pm.retrieve((Object)mtbl);
            if (mtbl != null && retrieveCD) {
                this.pm.retrieve((Object)mtbl.getSd());
                this.pm.retrieveAll(new Object[]{mtbl.getSd().getCD()});
                nmtbl.mcd = mtbl.getSd().getCD();
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        nmtbl.mtbl = mtbl;
        return nmtbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MCreationMetadata getCreationMetadata(String catName, String dbName, String tblName) {
        boolean commited = false;
        MCreationMetadata mcm = null;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MCreationMetadata.class, "tblName == table && dbName == db && catalogName == cat");
            query.declareParameters("java.lang.String table, java.lang.String db, java.lang.String cat");
            query.setUnique(true);
            mcm = (MCreationMetadata)query.execute((Object)tblName, (Object)dbName, (Object)catName);
            this.pm.retrieve((Object)mcm);
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return mcm;
    }

    private MTable getMTable(String catName, String db, String table) {
        AttachedMTableInfo nmtbl = this.getMTable(catName, db, table, false);
        return nmtbl.mtbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Table> getTableObjectsByName(String catName, String db, List<String> tbl_names) throws MetaException, UnknownDBException {
        ArrayList<Table> tables = new ArrayList<Table>();
        boolean committed = false;
        Query dbExistsQuery = null;
        Query query = null;
        try {
            this.openTransaction();
            db = StringUtils.normalizeIdentifier(db);
            catName = StringUtils.normalizeIdentifier(catName);
            ArrayList<String> lowered_tbl_names = new ArrayList<String>(tbl_names.size());
            for (String t : tbl_names) {
                lowered_tbl_names.add(StringUtils.normalizeIdentifier(t));
            }
            query = this.pm.newQuery(MTable.class);
            query.setFilter("database.name == db && database.catalogName == cat && tbl_names.contains(tableName)");
            query.declareParameters("java.lang.String db, java.lang.String cat, java.util.Collection tbl_names");
            Collection mtables = (Collection)query.execute((Object)db, (Object)catName, lowered_tbl_names);
            if (mtables == null || mtables.isEmpty()) {
                dbExistsQuery = this.pm.newQuery(MDatabase.class, "name == db && catalogName == cat");
                dbExistsQuery.declareParameters("java.lang.String db, java.lang.String cat");
                dbExistsQuery.setUnique(true);
                dbExistsQuery.setResult("name");
                String dbNameIfExists = (String)dbExistsQuery.execute((Object)db, (Object)catName);
                if (io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.isEmpty(dbNameIfExists)) {
                    throw new UnknownDBException("Could not find database " + Warehouse.getCatalogQualifiedDbName(catName, db));
                }
            } else {
                Iterator iter = mtables.iterator();
                while (iter.hasNext()) {
                    Table tbl = this.convertToTable((MTable)iter.next());
                    if (TableType.MATERIALIZED_VIEW.toString().equals(tbl.getTableType())) {
                        tbl.setCreationMetadata(this.convertToCreationMetadata(this.getCreationMetadata(tbl.getCatName(), tbl.getDbName(), tbl.getTableName())));
                    }
                    tables.add(tbl);
                }
            }
            committed = this.commitTransaction();
            this.rollbackAndCleanup(committed, query);
            if (dbExistsQuery == null) return tables;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            if (dbExistsQuery == null) throw throwable;
            dbExistsQuery.closeAll();
            throw throwable;
        }
        dbExistsQuery.closeAll();
        return tables;
    }

    private <T> List<T> convertList(List<T> dnList) {
        return dnList == null ? null : Lists.newArrayList(dnList);
    }

    private Map<String, String> convertMap(Map<String, String> dnMap) {
        return MetaStoreUtils.trimMapNulls(dnMap, MetastoreConf.getBoolVar(this.getConf(), MetastoreConf.ConfVars.ORM_RETRIEVE_MAPNULLS_AS_EMPTY_STRINGS));
    }

    private Table convertToTable(MTable mtbl) throws MetaException {
        if (mtbl == null) {
            return null;
        }
        String tableType = mtbl.getTableType();
        if (tableType == null) {
            tableType = mtbl.getViewOriginalText() != null ? TableType.VIRTUAL_VIEW.toString() : (Boolean.parseBoolean(mtbl.getParameters().get("EXTERNAL")) ? TableType.EXTERNAL_TABLE.toString() : TableType.MANAGED_TABLE.toString());
        }
        Table t = new Table(mtbl.getTableName(), mtbl.getDatabase().getName(), mtbl.getOwner(), mtbl.getCreateTime(), mtbl.getLastAccessTime(), mtbl.getRetention(), this.convertToStorageDescriptor(mtbl.getSd()), this.convertToFieldSchemas(mtbl.getPartitionKeys()), this.convertMap(mtbl.getParameters()), mtbl.getViewOriginalText(), mtbl.getViewExpandedText(), tableType);
        if (Strings.isNullOrEmpty(mtbl.getOwnerType())) {
            t.setOwnerType(PrincipalType.USER);
        } else {
            t.setOwnerType(PrincipalType.valueOf(mtbl.getOwnerType()));
        }
        t.setRewriteEnabled(mtbl.isRewriteEnabled());
        t.setCatName(mtbl.getDatabase().getCatalogName());
        return t;
    }

    private MTable convertToMTable(Table tbl) throws InvalidObjectException, MetaException {
        PrincipalType ownerPrincipalType;
        if (tbl == null) {
            return null;
        }
        MDatabase mdb = null;
        String catName = tbl.isSetCatName() ? tbl.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
        try {
            mdb = this.getMDatabase(catName, tbl.getDbName());
        }
        catch (NoSuchObjectException e) {
            LOG.error("Could not convert to MTable", (Throwable)((Object)e));
            throw new InvalidObjectException("Database " + Warehouse.getCatalogQualifiedDbName(catName, tbl.getDbName()) + " doesn't exist.");
        }
        String tableType = tbl.getTableType();
        boolean isExternal = Boolean.parseBoolean(tbl.getParameters().get("EXTERNAL"));
        if (TableType.MANAGED_TABLE.toString().equalsIgnoreCase(tableType) && isExternal) {
            tableType = TableType.EXTERNAL_TABLE.toString();
        }
        if (TableType.EXTERNAL_TABLE.toString().equalsIgnoreCase(tableType) && !isExternal) {
            tableType = TableType.MANAGED_TABLE.toString();
        }
        String ownerType = (ownerPrincipalType = tbl.getOwnerType()) == null ? PrincipalType.USER.name() : ownerPrincipalType.name();
        return new MTable(StringUtils.normalizeIdentifier(tbl.getTableName()), mdb, this.convertToMStorageDescriptor(tbl.getSd()), tbl.getOwner(), ownerType, tbl.getCreateTime(), tbl.getLastAccessTime(), tbl.getRetention(), this.convertToMFieldSchemas(tbl.getPartitionKeys()), tbl.getParameters(), tbl.getViewOriginalText(), tbl.getViewExpandedText(), tbl.isRewriteEnabled(), tableType);
    }

    private List<MFieldSchema> convertToMFieldSchemas(List<FieldSchema> keys) {
        ArrayList<MFieldSchema> mkeys = null;
        if (keys != null) {
            mkeys = new ArrayList<MFieldSchema>(keys.size());
            for (FieldSchema part : keys) {
                mkeys.add(new MFieldSchema(part.getName().toLowerCase(), part.getType(), part.getComment()));
            }
        }
        return mkeys;
    }

    private List<FieldSchema> convertToFieldSchemas(List<MFieldSchema> mkeys) {
        ArrayList<FieldSchema> keys = null;
        if (mkeys != null) {
            keys = new ArrayList<FieldSchema>(mkeys.size());
            for (MFieldSchema part : mkeys) {
                keys.add(new FieldSchema(part.getName(), part.getType(), part.getComment()));
            }
        }
        return keys;
    }

    private List<MOrder> convertToMOrders(List<Order> keys) {
        ArrayList<MOrder> mkeys = null;
        if (keys != null) {
            mkeys = new ArrayList<MOrder>(keys.size());
            for (Order part : keys) {
                mkeys.add(new MOrder(StringUtils.normalizeIdentifier(part.getCol()), part.getOrder()));
            }
        }
        return mkeys;
    }

    private List<Order> convertToOrders(List<MOrder> mkeys) {
        ArrayList<Order> keys = null;
        if (mkeys != null) {
            keys = new ArrayList<Order>(mkeys.size());
            for (MOrder part : mkeys) {
                keys.add(new Order(part.getCol(), part.getOrder()));
            }
        }
        return keys;
    }

    private SerDeInfo convertToSerDeInfo(MSerDeInfo ms) throws MetaException {
        if (ms == null) {
            throw new MetaException("Invalid SerDeInfo object");
        }
        SerDeInfo serde = new SerDeInfo(ms.getName(), ms.getSerializationLib(), this.convertMap(ms.getParameters()));
        if (ms.getDescription() != null) {
            serde.setDescription(ms.getDescription());
        }
        if (ms.getSerializerClass() != null) {
            serde.setSerializerClass(ms.getSerializerClass());
        }
        if (ms.getDeserializerClass() != null) {
            serde.setDeserializerClass(ms.getDeserializerClass());
        }
        if (ms.getSerdeType() > 0) {
            serde.setSerdeType(SerdeType.findByValue(ms.getSerdeType()));
        }
        return serde;
    }

    private MSerDeInfo convertToMSerDeInfo(SerDeInfo ms) throws MetaException {
        if (ms == null) {
            throw new MetaException("Invalid SerDeInfo object");
        }
        return new MSerDeInfo(ms.getName(), ms.getSerializationLib(), ms.getParameters(), ms.getDescription(), ms.getSerializerClass(), ms.getDeserializerClass(), ms.getSerdeType() == null ? 0 : ms.getSerdeType().getValue());
    }

    private MColumnDescriptor createNewMColumnDescriptor(List<MFieldSchema> cols) {
        if (cols == null) {
            return null;
        }
        return new MColumnDescriptor(cols);
    }

    private StorageDescriptor convertToStorageDescriptor(MStorageDescriptor msd, boolean noFS) throws MetaException {
        if (msd == null) {
            return null;
        }
        List<MFieldSchema> mFieldSchemas = msd.getCD() == null ? null : msd.getCD().getCols();
        StorageDescriptor sd = new StorageDescriptor(noFS ? null : this.convertToFieldSchemas(mFieldSchemas), msd.getLocation(), msd.getInputFormat(), msd.getOutputFormat(), msd.isCompressed(), msd.getNumBuckets(), this.convertToSerDeInfo(msd.getSerDeInfo()), this.convertList(msd.getBucketCols()), this.convertToOrders(msd.getSortCols()), this.convertMap(msd.getParameters()));
        SkewedInfo skewedInfo = new SkewedInfo(this.convertList(msd.getSkewedColNames()), this.convertToSkewedValues(msd.getSkewedColValues()), this.covertToSkewedMap(msd.getSkewedColValueLocationMaps()));
        sd.setSkewedInfo(skewedInfo);
        sd.setStoredAsSubDirectories(msd.isStoredAsSubDirectories());
        return sd;
    }

    private StorageDescriptor convertToStorageDescriptor(MStorageDescriptor msd) throws MetaException {
        return this.convertToStorageDescriptor(msd, false);
    }

    private List<List<String>> convertToSkewedValues(List<MStringList> mLists) {
        ArrayList<ArrayList<String>> lists = null;
        if (mLists != null) {
            lists = new ArrayList<ArrayList<String>>(mLists.size());
            for (MStringList element : mLists) {
                lists.add(new ArrayList<String>(element.getInternalList()));
            }
        }
        return lists;
    }

    private List<MStringList> convertToMStringLists(List<List<String>> mLists) {
        ArrayList<MStringList> lists = null;
        if (null != mLists) {
            lists = new ArrayList<MStringList>();
            for (List<String> mList : mLists) {
                lists.add(new MStringList(mList));
            }
        }
        return lists;
    }

    private Map<List<String>, String> covertToSkewedMap(Map<MStringList, String> mMap) {
        HashMap<ArrayList<String>, String> map = null;
        if (mMap != null) {
            map = new HashMap<ArrayList<String>, String>(mMap.size());
            Set<MStringList> keys = mMap.keySet();
            for (MStringList key : keys) {
                map.put(new ArrayList<String>(key.getInternalList()), mMap.get(key));
            }
        }
        return map;
    }

    private Map<MStringList, String> covertToMapMStringList(Map<List<String>, String> mMap) {
        HashMap<MStringList, String> map = null;
        if (mMap != null) {
            map = new HashMap<MStringList, String>(mMap.size());
            Set<List<String>> keys = mMap.keySet();
            for (List<String> key : keys) {
                map.put(new MStringList(key), mMap.get(key));
            }
        }
        return map;
    }

    private MStorageDescriptor convertToMStorageDescriptor(StorageDescriptor sd) throws MetaException {
        if (sd == null) {
            return null;
        }
        MColumnDescriptor mcd = this.createNewMColumnDescriptor(this.convertToMFieldSchemas(sd.getCols()));
        return this.convertToMStorageDescriptor(sd, mcd);
    }

    private MStorageDescriptor convertToMStorageDescriptor(StorageDescriptor sd, MColumnDescriptor mcd) throws MetaException {
        if (sd == null) {
            return null;
        }
        return new MStorageDescriptor(mcd, sd.getLocation(), sd.getInputFormat(), sd.getOutputFormat(), sd.isCompressed(), sd.getNumBuckets(), this.convertToMSerDeInfo(sd.getSerdeInfo()), sd.getBucketCols(), this.convertToMOrders(sd.getSortCols()), sd.getParameters(), null == sd.getSkewedInfo() ? null : sd.getSkewedInfo().getSkewedColNames(), this.convertToMStringLists(null == sd.getSkewedInfo() ? null : sd.getSkewedInfo().getSkewedColValues()), this.covertToMapMStringList(null == sd.getSkewedInfo() ? null : sd.getSkewedInfo().getSkewedColValueLocationMaps()), sd.isStoredAsSubDirectories());
    }

    private MCreationMetadata convertToMCreationMetadata(CreationMetadata m) throws MetaException {
        if (m == null) {
            return null;
        }
        assert (!m.isSetMaterializationTime());
        HashSet<MTable> tablesUsed = new HashSet<MTable>();
        for (String fullyQualifiedName : m.getTablesUsed()) {
            String[] names = fullyQualifiedName.split("\\.");
            tablesUsed.add(this.getMTable((String)m.getCatName(), (String)names[0], (String)names[1], (boolean)false).mtbl);
        }
        return new MCreationMetadata(m.getCatName(), m.getDbName(), m.getTblName(), tablesUsed, m.getValidTxnList(), System.currentTimeMillis());
    }

    private CreationMetadata convertToCreationMetadata(MCreationMetadata s) throws MetaException {
        if (s == null) {
            return null;
        }
        HashSet<String> tablesUsed = new HashSet<String>();
        for (MTable mtbl : s.getTables()) {
            tablesUsed.add(Warehouse.getQualifiedName(mtbl.getDatabase().getName(), mtbl.getTableName()));
        }
        CreationMetadata r = new CreationMetadata(s.getCatalogName(), s.getDbName(), s.getTblName(), tablesUsed);
        r.setMaterializationTime(s.getMaterializationTime());
        if (s.getTxnList() != null) {
            r.setValidTxnList(s.getTxnList());
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPartitions(String catName, String dbName, String tblName, List<Partition> parts) throws InvalidObjectException, MetaException {
        boolean success = false;
        this.openTransaction();
        try {
            List<MTablePrivilege> tabGrants = null;
            List<MTableColumnPrivilege> tabColumnGrants = null;
            MTable table = this.getMTable(catName, dbName, tblName);
            if ("TRUE".equalsIgnoreCase(table.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
                tabGrants = this.listAllTableGrants(catName, dbName, tblName);
                tabColumnGrants = this.listTableAllColumnGrants(catName, dbName, tblName);
            }
            ArrayList<Object> toPersist = new ArrayList<Object>();
            for (Partition part : parts) {
                if (!part.getTableName().equals(tblName) || !part.getDbName().equals(dbName)) {
                    throw new MetaException("Partition does not belong to target table " + dbName + "." + tblName + ": " + part);
                }
                MPartition mpart = this.convertToMPart(part, true);
                toPersist.add(mpart);
                int now = (int)(System.currentTimeMillis() / 1000L);
                if (tabGrants != null) {
                    for (MTablePrivilege tab : tabGrants) {
                        toPersist.add(new MPartitionPrivilege(tab.getPrincipalName(), tab.getPrincipalType(), mpart, tab.getPrivilege(), now, tab.getGrantor(), tab.getGrantorType(), tab.getGrantOption(), tab.getAuthorizer()));
                    }
                }
                if (tabColumnGrants == null) continue;
                for (MTableColumnPrivilege col : tabColumnGrants) {
                    toPersist.add(new MPartitionColumnPrivilege(col.getPrincipalName(), col.getPrincipalType(), mpart, col.getColumnName(), col.getPrivilege(), now, col.getGrantor(), col.getGrantorType(), col.getGrantOption(), col.getAuthorizer()));
                }
            }
            if (.CollectionUtils.isNotEmpty(toPersist)) {
                this.pm.makePersistentAll(toPersist);
                this.pm.flush();
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    private boolean isValidPartition(Partition part, boolean ifNotExists) throws MetaException {
        MetaStoreUtils.validatePartitionNameCharacters(part.getValues(), this.partitionValidationPattern);
        boolean doesExist = this.doesPartitionExist(part.getCatName(), part.getDbName(), part.getTableName(), part.getValues());
        if (doesExist && !ifNotExists) {
            throw new MetaException("Partition already exists: " + part);
        }
        return !doesExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPartitions(String catName, String dbName, String tblName, PartitionSpecProxy partitionSpec, boolean ifNotExists) throws InvalidObjectException, MetaException {
        boolean success = false;
        this.openTransaction();
        try {
            List<MTablePrivilege> tabGrants = null;
            List<MTableColumnPrivilege> tabColumnGrants = null;
            MTable table = this.getMTable(catName, dbName, tblName);
            if ("TRUE".equalsIgnoreCase(table.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
                tabGrants = this.listAllTableGrants(catName, dbName, tblName);
                tabColumnGrants = this.listTableAllColumnGrants(catName, dbName, tblName);
            }
            if (!partitionSpec.getTableName().equals(tblName) || !partitionSpec.getDbName().equals(dbName)) {
                throw new MetaException("Partition does not belong to target table " + dbName + "." + tblName + ": " + partitionSpec);
            }
            PartitionSpecProxy.PartitionIterator iterator = partitionSpec.getPartitionIterator();
            int now = (int)(System.currentTimeMillis() / 1000L);
            while (iterator.hasNext()) {
                Partition part = (Partition)iterator.next();
                if (!this.isValidPartition(part, ifNotExists)) continue;
                MPartition mpart = this.convertToMPart(part, true);
                this.pm.makePersistent((Object)mpart);
                if (tabGrants != null) {
                    for (MTablePrivilege tab : tabGrants) {
                        this.pm.makePersistent((Object)new MPartitionPrivilege(tab.getPrincipalName(), tab.getPrincipalType(), mpart, tab.getPrivilege(), now, tab.getGrantor(), tab.getGrantorType(), tab.getGrantOption(), tab.getAuthorizer()));
                    }
                }
                if (tabColumnGrants == null) continue;
                for (MTableColumnPrivilege col : tabColumnGrants) {
                    this.pm.makePersistent((Object)new MPartitionColumnPrivilege(col.getPrincipalName(), col.getPrincipalType(), mpart, col.getColumnName(), col.getPrivilege(), now, col.getGrantor(), col.getGrantorType(), col.getGrantOption(), col.getAuthorizer()));
                }
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPartition(Partition part) throws InvalidObjectException, MetaException {
        boolean success = false;
        boolean commited = false;
        try {
            String catName = part.isSetCatName() ? part.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            MTable table = this.getMTable(catName, part.getDbName(), part.getTableName());
            List<MTablePrivilege> tabGrants = null;
            List<MTableColumnPrivilege> tabColumnGrants = null;
            if ("TRUE".equalsIgnoreCase(table.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
                tabGrants = this.listAllTableGrants(catName, part.getDbName(), part.getTableName());
                tabColumnGrants = this.listTableAllColumnGrants(catName, part.getDbName(), part.getTableName());
            }
            this.openTransaction();
            MPartition mpart = this.convertToMPart(part, true);
            this.pm.makePersistent((Object)mpart);
            int now = (int)(System.currentTimeMillis() / 1000L);
            ArrayList<Object> toPersist = new ArrayList<Object>();
            if (tabGrants != null) {
                for (MTablePrivilege tab : tabGrants) {
                    MPartitionPrivilege partGrant = new MPartitionPrivilege(tab.getPrincipalName(), tab.getPrincipalType(), mpart, tab.getPrivilege(), now, tab.getGrantor(), tab.getGrantorType(), tab.getGrantOption(), tab.getAuthorizer());
                    toPersist.add(partGrant);
                }
            }
            if (tabColumnGrants != null) {
                for (MTableColumnPrivilege col : tabColumnGrants) {
                    MPartitionColumnPrivilege partColumn = new MPartitionColumnPrivilege(col.getPrincipalName(), col.getPrincipalType(), mpart, col.getColumnName(), col.getPrivilege(), now, col.getGrantor(), col.getGrantorType(), col.getGrantOption(), col.getAuthorizer());
                    toPersist.add(partColumn);
                }
                if (.CollectionUtils.isNotEmpty(toPersist)) {
                    this.pm.makePersistentAll(toPersist);
                }
            }
            commited = this.commitTransaction();
            success = true;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    @Override
    public Partition getPartition(String catName, String dbName, String tableName, List<String> part_vals) throws NoSuchObjectException, MetaException {
        this.openTransaction();
        Partition part = this.convertToPart(this.getMPartition(catName, dbName, tableName, part_vals));
        this.commitTransaction();
        if (part == null) {
            throw new NoSuchObjectException("partition values=" + part_vals.toString());
        }
        part.setValues(part_vals);
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MPartition getMPartition(String catName, String dbName, String tableName, List<String> part_vals) throws MetaException {
        MTable mtbl;
        Query query;
        boolean commited;
        MPartition ret;
        List mparts;
        block7: {
            mparts = null;
            ret = null;
            commited = false;
            query = null;
            try {
                this.openTransaction();
                catName = StringUtils.normalizeIdentifier(catName);
                dbName = StringUtils.normalizeIdentifier(dbName);
                tableName = StringUtils.normalizeIdentifier(tableName);
                mtbl = this.getMTable(catName, dbName, tableName);
                if (mtbl != null) break block7;
                commited = this.commitTransaction();
                MPartition mPartition = null;
                this.rollbackAndCleanup(commited, query);
                return mPartition;
            }
            catch (Throwable throwable) {
                this.rollbackAndCleanup(commited, query);
                throw throwable;
            }
        }
        String name = Warehouse.makePartName(this.convertToFieldSchemas(mtbl.getPartitionKeys()), part_vals);
        query = this.pm.newQuery(MPartition.class, "table.tableName == t1 && table.database.name == t2 && partitionName == t3  && table.database.catalogName == t4");
        query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4");
        mparts = (List)query.executeWithArray(new Object[]{tableName, dbName, name, catName});
        this.pm.retrieveAll((Collection)mparts);
        commited = this.commitTransaction();
        if (.CollectionUtils.isNotEmpty((Collection)mparts)) {
            if (mparts.size() > 1) {
                throw new MetaException("Expecting only one partition but more than one partitions are found.");
            }
            MPartition mpart = (MPartition)mparts.get(0);
            if (name.equals(mpart.getPartitionName())) {
                ret = mpart;
            } else {
                throw new MetaException("Expecting a partition with name " + name + ", but metastore is returning a partition with name " + mpart.getPartitionName() + ".");
            }
        }
        this.rollbackAndCleanup(commited, query);
        return ret;
    }

    private MPartition convertToMPart(Partition part, boolean useTableCD) throws InvalidObjectException, MetaException {
        if (part == null) {
            return null;
        }
        MTable mt = this.getMTable(part.getCatName(), part.getDbName(), part.getTableName());
        if (mt == null) {
            throw new InvalidObjectException("Partition doesn't have a valid table or database name");
        }
        MStorageDescriptor msd = useTableCD && mt.getSd() != null && mt.getSd().getCD() != null && mt.getSd().getCD().getCols() != null && part.getSd() != null && this.convertToFieldSchemas(mt.getSd().getCD().getCols()).equals(part.getSd().getCols()) ? this.convertToMStorageDescriptor(part.getSd(), mt.getSd().getCD()) : this.convertToMStorageDescriptor(part.getSd());
        return new MPartition(Warehouse.makePartName(this.convertToFieldSchemas(mt.getPartitionKeys()), part.getValues()), mt, part.getValues(), part.getCreateTime(), part.getLastAccessTime(), msd, part.getParameters());
    }

    private Partition convertToPart(MPartition mpart) throws MetaException {
        if (mpart == null) {
            return null;
        }
        Partition p = new Partition(this.convertList(mpart.getValues()), mpart.getTable().getDatabase().getName(), mpart.getTable().getTableName(), mpart.getCreateTime(), mpart.getLastAccessTime(), this.convertToStorageDescriptor(mpart.getSd()), this.convertMap(mpart.getParameters()));
        p.setCatName(mpart.getTable().getDatabase().getCatalogName());
        return p;
    }

    private Partition convertToPart(String catName, String dbName, String tblName, MPartition mpart) throws MetaException {
        if (mpart == null) {
            return null;
        }
        Partition p = new Partition(this.convertList(mpart.getValues()), dbName, tblName, mpart.getCreateTime(), mpart.getLastAccessTime(), this.convertToStorageDescriptor(mpart.getSd(), false), this.convertMap(mpart.getParameters()));
        p.setCatName(catName);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropPartition(String catName, String dbName, String tableName, List<String> part_vals) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        boolean success = false;
        try {
            this.openTransaction();
            MPartition part = this.getMPartition(catName, dbName, tableName, part_vals);
            this.dropPartitionCommon(part);
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropPartitions(String catName, String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException {
        if (.CollectionUtils.isEmpty(partNames)) {
            return;
        }
        boolean success = false;
        this.openTransaction();
        try {
            this.dropPartitionGrantsNoTxn(catName, dbName, tblName, partNames);
            this.dropPartitionAllColumnGrantsNoTxn(catName, dbName, tblName, partNames);
            this.dropPartitionColumnStatisticsNoTxn(catName, dbName, tblName, partNames);
            for (MColumnDescriptor mcd : this.detachCdsFromSdsNoTxn(catName, dbName, tblName, partNames)) {
                this.removeUnusedColumnDescriptor(mcd);
            }
            this.dropPartitionsNoTxn(catName, dbName, tblName, partNames);
            success = this.commitTransaction();
            if (!success) {
                throw new MetaException("Failed to drop partitions");
            }
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropPartitionCommon(MPartition part) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        boolean success = false;
        try {
            this.openTransaction();
            if (part != null) {
                List<MPartitionColumnPrivilege> partColumnGrants;
                List<MFieldSchema> schemas = part.getTable().getPartitionKeys();
                ArrayList<String> colNames = new ArrayList<String>();
                for (MFieldSchema col : schemas) {
                    colNames.add(col.getName());
                }
                String partName = FileUtils.makePartName(colNames, part.getValues());
                List<MPartitionPrivilege> partGrants = this.listPartitionGrants(part.getTable().getDatabase().getCatalogName(), part.getTable().getDatabase().getName(), part.getTable().getTableName(), Lists.newArrayList(partName));
                if (.CollectionUtils.isNotEmpty(partGrants)) {
                    this.pm.deletePersistentAll(partGrants);
                }
                if (.CollectionUtils.isNotEmpty(partColumnGrants = this.listPartitionAllColumnGrants(part.getTable().getDatabase().getCatalogName(), part.getTable().getDatabase().getName(), part.getTable().getTableName(), Lists.newArrayList(partName)))) {
                    this.pm.deletePersistentAll(partColumnGrants);
                }
                String catName = part.getTable().getDatabase().getCatalogName();
                String dbName = part.getTable().getDatabase().getName();
                String tableName = part.getTable().getTableName();
                try {
                    this.deletePartitionColumnStatistics(catName, dbName, tableName, partName, part.getValues(), null);
                }
                catch (NoSuchObjectException e) {
                    LOG.info("No column statistics records found to delete");
                }
                this.preDropStorageDescriptor(part.getSd());
                this.pm.deletePersistent((Object)part);
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    @Override
    public List<Partition> getPartitions(String catName, String dbName, String tableName, int maxParts) throws MetaException, NoSuchObjectException {
        return this.getPartitionsInternal(catName, dbName, tableName, maxParts, true, true);
    }

    protected List<Partition> getPartitionsInternal(String catName, String dbName, String tblName, final int maxParts, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        return (List)new GetListHelper<Partition>(catName, dbName, tblName, allowSql, allowJdo){

            @Override
            protected List<Partition> getSqlResult(GetHelper<List<Partition>> ctx) throws MetaException {
                Integer max = maxParts < 0 ? null : Integer.valueOf(maxParts);
                return ObjectStore.this.directSql.getPartitions(this.catName, this.dbName, this.tblName, max);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected List<Partition> getJdoResult(GetHelper<List<Partition>> ctx) throws MetaException {
                try (QueryWrapper queryWrapper = new QueryWrapper();){
                    List list = ObjectStore.this.convertToParts(ObjectStore.this.listMPartitions(this.catName, this.dbName, this.tblName, maxParts, queryWrapper));
                    return list;
                }
            }
        }.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Partition> getPartitionsWithAuth(String catName, String dbName, String tblName, short max, String userName, List<String> groupNames) throws MetaException, InvalidObjectException {
        boolean success = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        try {
            this.openTransaction();
            List<MPartition> mparts = this.listMPartitions(catName, dbName, tblName, max, queryWrapper);
            ArrayList<Partition> parts = new ArrayList<Partition>(mparts.size());
            if (.CollectionUtils.isNotEmpty(mparts)) {
                for (MPartition mpart : mparts) {
                    MTable mtbl = mpart.getTable();
                    Partition part = this.convertToPart(mpart);
                    parts.add(part);
                    if (!"TRUE".equalsIgnoreCase(mtbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) continue;
                    String partName = Warehouse.makePartName(this.convertToFieldSchemas(mtbl.getPartitionKeys()), part.getValues());
                    PrincipalPrivilegeSet partAuth = this.getPartitionPrivilegeSet(catName, dbName, tblName, partName, userName, groupNames);
                    part.setPrivileges(partAuth);
                }
            }
            success = this.commitTransaction();
            ArrayList<Partition> arrayList = parts;
            return arrayList;
        }
        finally {
            this.rollbackAndCleanup(success, queryWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition getPartitionWithAuth(String catName, String dbName, String tblName, List<String> partVals, String user_name, List<String> group_names) throws NoSuchObjectException, MetaException, InvalidObjectException {
        boolean success = false;
        try {
            this.openTransaction();
            MPartition mpart = this.getMPartition(catName, dbName, tblName, partVals);
            if (mpart == null) {
                this.commitTransaction();
                throw new NoSuchObjectException("partition values=" + partVals.toString());
            }
            Partition part = null;
            MTable mtbl = mpart.getTable();
            part = this.convertToPart(mpart);
            if ("TRUE".equalsIgnoreCase(mtbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
                String partName = Warehouse.makePartName(this.convertToFieldSchemas(mtbl.getPartitionKeys()), partVals);
                PrincipalPrivilegeSet partAuth = this.getPartitionPrivilegeSet(catName, dbName, tblName, partName, user_name, group_names);
                part.setPrivileges(partAuth);
            }
            success = this.commitTransaction();
            Partition partition = part;
            return partition;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    private List<Partition> convertToParts(List<MPartition> mparts) throws MetaException {
        return this.convertToParts(mparts, null);
    }

    private List<Partition> convertToParts(List<MPartition> src, List<Partition> dest) throws MetaException {
        if (src == null) {
            return dest;
        }
        if (dest == null) {
            dest = new ArrayList<Partition>(src.size());
        }
        for (MPartition mp : src) {
            dest.add(this.convertToPart(mp));
            Deadline.checkTimeout();
        }
        return dest;
    }

    private List<Partition> convertToParts(String catName, String dbName, String tblName, List<MPartition> mparts) throws MetaException {
        ArrayList<Partition> parts = new ArrayList<Partition>(mparts.size());
        for (MPartition mp : mparts) {
            parts.add(this.convertToPart(catName, dbName, tblName, mp));
            Deadline.checkTimeout();
        }
        return parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listPartitionNames(String catName, String dbName, String tableName, short max) throws MetaException {
        List<String> pns = null;
        boolean success = false;
        try {
            this.openTransaction();
            LOG.debug("Executing getPartitionNames");
            pns = this.getPartitionNamesNoTxn(catName, dbName, tableName, max);
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return pns;
    }

    private String extractPartitionKey(FieldSchema key, List<FieldSchema> pkeys) {
        StringBuilder buffer = new StringBuilder(256);
        assert (pkeys.size() >= 1);
        String partKey = "/" + key.getName() + "=";
        if (pkeys.size() == 1 && pkeys.get(0).getName().matches(key.getName())) {
            buffer.append("partitionName.substring(partitionName.indexOf(\"").append(key.getName()).append("=\") + ").append(key.getName().length() + 1).append(")");
        } else if (pkeys.get(0).getName().matches(key.getName())) {
            buffer.append("partitionName.substring(partitionName.indexOf(\"").append(key.getName()).append("=\") + ").append(key.getName().length() + 1).append(", ").append("partitionName.indexOf(\"/\")").append(")");
        } else if (pkeys.get(pkeys.size() - 1).getName().matches(key.getName())) {
            buffer.append("partitionName.substring(partitionName.indexOf(\"").append(partKey).append("\") + ").append(partKey.length()).append(")");
        } else {
            buffer.append("partitionName.substring(partitionName.indexOf(\"").append(partKey).append("\") + ").append(partKey.length()).append(", ").append("partitionName.indexOf(\"/\", partitionName.indexOf(\"").append(partKey).append("\") + 1))");
        }
        LOG.info("Query for Key:" + key.getName() + " is :" + buffer);
        return buffer.toString();
    }

    @Override
    public PartitionValuesResponse listPartitionValues(String catName, String dbName, String tableName, List<FieldSchema> cols, boolean applyDistinct, String filter, boolean ascending, List<FieldSchema> order, long maxParts) throws MetaException {
        catName = StringUtils.normalizeIdentifier(catName);
        dbName = dbName.toLowerCase().trim();
        tableName = tableName.toLowerCase().trim();
        try {
            if (filter == null || filter.isEmpty()) {
                PartitionValuesResponse response = this.getDistinctValuesForPartitionsNoTxn(catName, dbName, tableName, cols, applyDistinct, maxParts);
                LOG.info("Number of records fetched: {}", (Object)response.getPartitionValues().size());
                return response;
            }
            PartitionValuesResponse response = this.extractPartitionNamesByFilter(catName, dbName, tableName, filter, cols, ascending, maxParts);
            if (response != null && response.getPartitionValues() != null) {
                LOG.info("Number of records fetched with filter: {}", (Object)response.getPartitionValues().size());
            }
            return response;
        }
        catch (Exception t) {
            LOG.error("Exception in ORM", t);
            throw new MetaException("Error retrieving partition values: " + t);
        }
    }

    private PartitionValuesResponse extractPartitionNamesByFilter(String catName, String dbName, String tableName, String filter, List<FieldSchema> cols, boolean ascending, long maxParts) throws MetaException, NoSuchObjectException {
        LOG.info("Table: {} filter: \"{}\" cols: {}", Warehouse.getCatalogQualifiedTableName(catName, dbName, tableName), filter, cols);
        List<String> partitionNames = null;
        List<Partition> partitions = null;
        Table tbl = this.getTable(catName, dbName, tableName);
        try {
            partitionNames = this.getPartitionNamesByFilter(catName, dbName, tableName, filter, ascending, maxParts);
        }
        catch (MetaException e) {
            LOG.warn("Querying by partition names failed, trying out with partition objects, filter: {}", (Object)filter);
        }
        if (partitionNames == null) {
            partitions = this.getPartitionsByFilter(catName, dbName, tableName, filter, (short)maxParts);
        }
        if (partitions != null) {
            partitionNames = new ArrayList<String>(partitions.size());
            for (Partition partition : partitions) {
                if (tbl.getPartitionKeys() == null || partition.getValues() == null) continue;
                partitionNames.add(Warehouse.makePartName(tbl.getPartitionKeys(), partition.getValues()));
            }
        }
        if (partitionNames == null && partitions == null) {
            throw new MetaException("Cannot obtain list of partitions by filter:\"" + filter + "\" for " + Warehouse.getCatalogQualifiedTableName(catName, dbName, tableName));
        }
        if (!ascending) {
            Collections.sort(partitionNames, Collections.reverseOrder());
        }
        PartitionValuesResponse response = new PartitionValuesResponse();
        response.setPartitionValues(new ArrayList<PartitionValuesRow>(partitionNames.size()));
        LOG.info("Converting responses to Partition values for items: {}", (Object)partitionNames.size());
        for (String partName : partitionNames) {
            ArrayList<Object> vals = new ArrayList<Object>(Collections.nCopies(tbl.getPartitionKeys().size(), null));
            PartitionValuesRow row = new PartitionValuesRow();
            Warehouse.makeValsFromName(partName, vals);
            for (String string : vals) {
                row.addToRow(string);
            }
            response.addToPartitionValues(row);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getPartitionNamesByFilter(String catName, String dbName, String tableName, String filter, boolean ascending, long maxParts) throws MetaException {
        boolean success = false;
        ArrayList<String> partNames = new ArrayList<String>();
        try {
            this.openTransaction();
            LOG.debug("Executing getPartitionNamesByFilter");
            catName = StringUtils.normalizeIdentifier(catName);
            dbName = dbName.toLowerCase();
            tableName = tableName.toLowerCase();
            MTable mtable = this.getMTable(catName, dbName, tableName);
            if (mtable == null) {
                ArrayList<String> arrayList = partNames;
                return arrayList;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            String queryFilterString = this.makeQueryFilterString(catName, dbName, mtable, filter, params);
            Query query = this.pm.newQuery("select partitionName from org.apache.hadoop.hive.metastore.model.MPartition where " + queryFilterString);
            if (maxParts >= 0L) {
                query.setRange(0L, maxParts);
            }
            LOG.debug("Filter specified is {}, JDOQL filter is {}", (Object)filter, (Object)queryFilterString);
            LOG.debug("Parms is {}", (Object)params);
            String parameterDeclaration = this.makeParameterDeclarationStringObj(params);
            query.declareParameters(parameterDeclaration);
            if (ascending) {
                query.setOrdering("partitionName ascending");
            } else {
                query.setOrdering("partitionName descending");
            }
            query.setResult("partitionName");
            Collection names = (Collection)query.executeWithMap(params);
            partNames = new ArrayList(names);
            LOG.debug("Done executing query for getPartitionNamesByFilter");
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for getPartitionNamesByFilter, size: {}", (Object)partNames.size());
            query.closeAll();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return partNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartitionValuesResponse getDistinctValuesForPartitionsNoTxn(String catName, String dbName, String tableName, List<FieldSchema> cols, boolean applyDistinct, long maxParts) throws MetaException {
        try {
            List results;
            this.openTransaction();
            Query q = this.pm.newQuery("select partitionName from org.apache.hadoop.hive.metastore.model.MPartition where table.database.name == t1 && table.database.catalogName == t2 && table.tableName == t3 ");
            q.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
            if (maxParts > 0L) {
                q.setRange(0L, maxParts);
            }
            StringBuilder partValuesSelect = new StringBuilder(256);
            if (applyDistinct) {
                partValuesSelect.append("DISTINCT ");
            }
            List<FieldSchema> partitionKeys = this.getTable(catName, dbName, tableName).getPartitionKeys();
            for (FieldSchema key : cols) {
                partValuesSelect.append(this.extractPartitionKey(key, partitionKeys)).append(", ");
            }
            partValuesSelect.setLength(partValuesSelect.length() - 2);
            LOG.info("Columns to be selected from Partitions: {}", (Object)partValuesSelect);
            q.setResult(partValuesSelect.toString());
            PartitionValuesResponse response = new PartitionValuesResponse();
            response.setPartitionValues(new ArrayList<PartitionValuesRow>());
            if (cols.size() > 1) {
                results = (List)q.execute((Object)dbName, (Object)catName, (Object)tableName);
                for (Object[] row : results) {
                    PartitionValuesRow rowResponse = new PartitionValuesRow();
                    for (Object columnValue : row) {
                        rowResponse.addToRow((String)columnValue);
                    }
                    response.addToPartitionValues(rowResponse);
                }
            } else {
                results = (List)q.execute((Object)dbName, (Object)catName, (Object)tableName);
                for (Object row : results) {
                    PartitionValuesRow rowResponse = new PartitionValuesRow();
                    rowResponse.addToRow((String)row);
                    response.addToPartitionValues(rowResponse);
                }
            }
            q.closeAll();
            PartitionValuesResponse partitionValuesResponse = response;
            return partitionValuesResponse;
        }
        finally {
            this.commitTransaction();
        }
    }

    private List<String> getPartitionNamesNoTxn(String catName, String dbName, String tableName, short max) {
        ArrayList<String> pns = new ArrayList<String>();
        if (max == 0) {
            return pns;
        }
        catName = StringUtils.normalizeIdentifier(catName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        tableName = StringUtils.normalizeIdentifier(tableName);
        Query query = this.pm.newQuery("select partitionName from org.apache.hadoop.hive.metastore.model.MPartition where table.database.name == t1 && table.tableName == t2 && table.database.catalogName == t3 order by partitionName asc");
        query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
        query.setResult("partitionName");
        if (max > 0) {
            query.setRange(0L, (long)max);
        }
        Collection names = (Collection)query.execute((Object)dbName, (Object)tableName, (Object)catName);
        pns.addAll(names);
        if (query != null) {
            query.closeAll();
        }
        return pns;
    }

    private Collection getPartitionPsQueryResults(String catName, String dbName, String tableName, List<String> part_vals, short max_parts, String resultsCol, QueryWrapper queryWrapper) throws MetaException, NoSuchObjectException {
        Table table = this.getTable(catName = StringUtils.normalizeIdentifier(catName), dbName = StringUtils.normalizeIdentifier(dbName), tableName = StringUtils.normalizeIdentifier(tableName));
        if (table == null) {
            throw new NoSuchObjectException(Warehouse.getCatalogQualifiedTableName(catName, dbName, tableName) + " table not found");
        }
        String partNameMatcher = MetaStoreUtils.makePartNameMatcher(table, part_vals);
        Query query = queryWrapper.query = this.pm.newQuery(MPartition.class);
        StringBuilder queryFilter = new StringBuilder("table.database.name == dbName");
        queryFilter.append(" && table.database.catalogName == catName");
        queryFilter.append(" && table.tableName == tableName");
        queryFilter.append(" && partitionName.matches(partialRegex)");
        query.setFilter(queryFilter.toString());
        query.declareParameters("java.lang.String dbName, java.lang.String catName, java.lang.String tableName, java.lang.String partialRegex");
        if (max_parts >= 0) {
            query.setRange(0L, (long)max_parts);
        }
        if (resultsCol != null && !resultsCol.isEmpty()) {
            query.setResult(resultsCol);
        }
        return (Collection)query.executeWithArray(new Object[]{dbName, catName, tableName, partNameMatcher});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Partition> listPartitionsPsWithAuth(String catName, String db_name, String tbl_name, List<String> part_vals, short max_parts, String userName, List<String> groupNames) throws MetaException, InvalidObjectException, NoSuchObjectException {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        boolean success = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        try {
            this.openTransaction();
            LOG.debug("executing listPartitionNamesPsWithAuth");
            Collection parts = this.getPartitionPsQueryResults(catName, db_name, tbl_name, part_vals, max_parts, null, queryWrapper);
            MTable mtbl = this.getMTable(catName, db_name, tbl_name);
            for (Object o : parts) {
                Partition part = this.convertToPart((MPartition)o);
                if (null != userName && null != groupNames && "TRUE".equalsIgnoreCase(mtbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
                    String partName = Warehouse.makePartName(this.convertToFieldSchemas(mtbl.getPartitionKeys()), part.getValues());
                    PrincipalPrivilegeSet partAuth = this.getPartitionPrivilegeSet(catName, db_name, tbl_name, partName, userName, groupNames);
                    part.setPrivileges(partAuth);
                }
                partitions.add(part);
            }
            success = this.commitTransaction();
        }
        finally {
            this.rollbackAndCleanup(success, queryWrapper);
        }
        return partitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listPartitionNamesPs(String catName, String dbName, String tableName, List<String> part_vals, short max_parts) throws MetaException, NoSuchObjectException {
        ArrayList<String> partitionNames = new ArrayList<String>();
        boolean success = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        try {
            this.openTransaction();
            LOG.debug("Executing listPartitionNamesPs");
            Collection names = this.getPartitionPsQueryResults(catName, dbName, tableName, part_vals, max_parts, "partitionName", queryWrapper);
            partitionNames.addAll(names);
            success = this.commitTransaction();
        }
        finally {
            this.rollbackAndCleanup(success, queryWrapper);
        }
        return partitionNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartition> listMPartitions(String catName, String dbName, String tableName, int max, QueryWrapper queryWrapper) {
        boolean success = false;
        List mparts = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listMPartitions");
            dbName = StringUtils.normalizeIdentifier(dbName);
            tableName = StringUtils.normalizeIdentifier(tableName);
            Query query = queryWrapper.query = this.pm.newQuery(MPartition.class, "table.tableName == t1 && table.database.name == t2 && table.database.catalogName == t3");
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
            query.setOrdering("partitionName ascending");
            if (max > 0) {
                query.setRange(0L, (long)max);
            }
            mparts = (List)query.execute((Object)tableName, (Object)dbName, (Object)catName);
            LOG.debug("Done executing query for listMPartitions");
            this.pm.retrieveAll((Collection)mparts);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listMPartitions {}", (Object)mparts);
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mparts;
    }

    @Override
    public List<Partition> getPartitionsByNames(String catName, String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException {
        return this.getPartitionsByNamesInternal(catName, dbName, tblName, partNames, true, true);
    }

    protected List<Partition> getPartitionsByNamesInternal(String catName, String dbName, String tblName, final List<String> partNames, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        return (List)new GetListHelper<Partition>(catName, dbName, tblName, allowSql, allowJdo){

            @Override
            protected List<Partition> getSqlResult(GetHelper<List<Partition>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getPartitionsViaSqlFilter(this.catName, this.dbName, this.tblName, partNames);
            }

            @Override
            protected List<Partition> getJdoResult(GetHelper<List<Partition>> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getPartitionsViaOrmFilter(this.catName, this.dbName, this.tblName, partNames);
            }
        }.run(false);
    }

    @Override
    public boolean getPartitionsByExpr(String catName, String dbName, String tblName, byte[] expr, String defaultPartitionName, short maxParts, List<Partition> result) throws TException {
        return this.getPartitionsByExprInternal(catName, dbName, tblName, expr, defaultPartitionName, maxParts, result, true, true);
    }

    protected boolean getPartitionsByExprInternal(String catName, String dbName, String tblName, final byte[] expr, final String defaultPartitionName, final short maxParts, List<Partition> result, boolean allowSql, boolean allowJdo) throws TException {
        assert (result != null);
        final ExpressionTree exprTree = PartFilterExprUtil.makeExpressionTree(this.expressionProxy, expr);
        final AtomicBoolean hasUnknownPartitions = new AtomicBoolean(false);
        result.addAll((Collection)new GetListHelper<Partition>(catName, dbName, tblName, allowSql, allowJdo){

            @Override
            protected List<Partition> getSqlResult(GetHelper<List<Partition>> ctx) throws MetaException {
                Object result = null;
                if (exprTree != null) {
                    MetaStoreDirectSql.SqlFilterForPushdown filter = new MetaStoreDirectSql.SqlFilterForPushdown();
                    if (ObjectStore.this.directSql.generateSqlFilterForPushdown(ctx.getTable(), exprTree, filter)) {
                        return ObjectStore.this.directSql.getPartitionsViaSqlFilter(filter, null);
                    }
                }
                LinkedList<String> partNames = new LinkedList<String>();
                hasUnknownPartitions.set(ObjectStore.this.getPartitionNamesPrunedByExprNoTxn(ctx.getTable(), expr, defaultPartitionName, maxParts, partNames));
                return ObjectStore.this.directSql.getPartitionsViaSqlFilter(this.catName, this.dbName, this.tblName, partNames);
            }

            @Override
            protected List<Partition> getJdoResult(GetHelper<List<Partition>> ctx) throws MetaException, NoSuchObjectException {
                List result = null;
                if (exprTree != null) {
                    result = ObjectStore.this.getPartitionsViaOrmFilter(ctx.getTable(), exprTree, maxParts, false);
                }
                if (result == null) {
                    ArrayList partNames = new ArrayList();
                    hasUnknownPartitions.set(ObjectStore.this.getPartitionNamesPrunedByExprNoTxn(ctx.getTable(), expr, defaultPartitionName, maxParts, partNames));
                    result = ObjectStore.this.getPartitionsViaOrmFilter(this.catName, this.dbName, this.tblName, partNames);
                }
                return result;
            }
        }.run(true));
        return hasUnknownPartitions.get();
    }

    private boolean getPartitionNamesPrunedByExprNoTxn(Table table, byte[] expr, String defaultPartName, short maxParts, List<String> result) throws MetaException {
        result.addAll(this.getPartitionNamesNoTxn(table.getCatName(), table.getDbName(), table.getTableName(), maxParts));
        if (defaultPartName == null || defaultPartName.isEmpty()) {
            defaultPartName = MetastoreConf.getVar(this.getConf(), MetastoreConf.ConfVars.DEFAULTPARTITIONNAME);
        }
        return this.expressionProxy.filterPartitionsByExpr(table.getPartitionKeys(), expr, defaultPartName, result);
    }

    private List<Partition> getPartitionsViaOrmFilter(Table table, ExpressionTree tree, short maxParts, boolean isValidatedFilter) throws MetaException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String jdoFilter = this.makeQueryFilterString(table.getCatName(), table.getDbName(), table, tree, params, isValidatedFilter);
        if (jdoFilter == null) {
            assert (!isValidatedFilter);
            return null;
        }
        Query query = this.pm.newQuery(MPartition.class, jdoFilter);
        if (maxParts >= 0) {
            query.setRange(0L, (long)maxParts);
        }
        String parameterDeclaration = this.makeParameterDeclarationStringObj(params);
        query.declareParameters(parameterDeclaration);
        query.setOrdering("partitionName ascending");
        List mparts = (List)query.executeWithMap(params);
        LOG.debug("Done executing query for getPartitionsViaOrmFilter");
        this.pm.retrieveAll((Collection)mparts);
        LOG.debug("Done retrieving all objects for getPartitionsViaOrmFilter");
        List<Partition> results = this.convertToParts(mparts);
        query.closeAll();
        return results;
    }

    private Integer getNumPartitionsViaOrmFilter(Table table, ExpressionTree tree, boolean isValidatedFilter) throws MetaException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String jdoFilter = this.makeQueryFilterString(table.getCatName(), table.getDbName(), table, tree, params, isValidatedFilter);
        if (jdoFilter == null) {
            assert (!isValidatedFilter);
            return null;
        }
        Query query = this.pm.newQuery("select count(partitionName) from org.apache.hadoop.hive.metastore.model.MPartition");
        query.setFilter(jdoFilter);
        String parameterDeclaration = this.makeParameterDeclarationStringObj(params);
        query.declareParameters(parameterDeclaration);
        Long result = (Long)query.executeWithMap(params);
        query.closeAll();
        return result.intValue();
    }

    private List<Partition> getPartitionsViaOrmFilter(String catName, String dbName, String tblName, List<String> partNames) throws MetaException {
        if (partNames.isEmpty()) {
            return new ArrayList<Partition>();
        }
        ObjectPair<Query, Map<String, String>> queryWithParams = this.getPartQueryWithParams(catName, dbName, tblName, partNames);
        Query query = queryWithParams.getFirst();
        query.setResultClass(MPartition.class);
        query.setClass(MPartition.class);
        query.setOrdering("partitionName ascending");
        List mparts = (List)query.executeWithMap(queryWithParams.getSecond());
        List<Partition> partitions = this.convertToParts(catName, dbName, tblName, mparts);
        if (query != null) {
            query.closeAll();
        }
        return partitions;
    }

    private void dropPartitionsNoTxn(String catName, String dbName, String tblName, List<String> partNames) {
        ObjectPair<Query, Map<String, String>> queryWithParams = this.getPartQueryWithParams(catName, dbName, tblName, partNames);
        Query query = queryWithParams.getFirst();
        query.setClass(MPartition.class);
        long deleted = query.deletePersistentAll(queryWithParams.getSecond());
        LOG.debug("Deleted {} partition from store", (Object)deleted);
        query.closeAll();
    }

    private HashSet<MColumnDescriptor> detachCdsFromSdsNoTxn(String catName, String dbName, String tblName, List<String> partNames) {
        ObjectPair<Query, Map<String, String>> queryWithParams = this.getPartQueryWithParams(catName, dbName, tblName, partNames);
        Query query = queryWithParams.getFirst();
        query.setClass(MPartition.class);
        query.setResult("sd");
        List sds = (List)query.executeWithMap(queryWithParams.getSecond());
        HashSet<MColumnDescriptor> candidateCds = new HashSet<MColumnDescriptor>();
        for (MStorageDescriptor sd : sds) {
            if (sd == null || sd.getCD() == null) continue;
            candidateCds.add(sd.getCD());
            sd.setCD(null);
        }
        if (query != null) {
            query.closeAll();
        }
        return candidateCds;
    }

    private ObjectPair<Query, Map<String, String>> getPartQueryWithParams(String catName, String dbName, String tblName, List<String> partNames) {
        StringBuilder sb = new StringBuilder("table.tableName == t1 && table.database.name == t2 && table.database.catalogName == t3 && (");
        int n = 0;
        HashMap<String, String> params = new HashMap<String, String>();
        Iterator<String> itr = partNames.iterator();
        while (itr.hasNext()) {
            String pn = "p" + n;
            ++n;
            String part = itr.next();
            params.put(pn, part);
            sb.append("partitionName == ").append(pn);
            sb.append(" || ");
        }
        sb.setLength(sb.length() - 4);
        sb.append(')');
        Query query = this.pm.newQuery();
        query.setFilter(sb.toString());
        LOG.debug(" JDOQL filter is {}", (Object)sb);
        params.put("t1", StringUtils.normalizeIdentifier(tblName));
        params.put("t2", StringUtils.normalizeIdentifier(dbName));
        params.put("t3", StringUtils.normalizeIdentifier(catName));
        query.declareParameters(this.makeParameterDeclarationString(params));
        return new ObjectPair<Query, Map<String, String>>(query, params);
    }

    @Override
    public List<Partition> getPartitionsByFilter(String catName, String dbName, String tblName, String filter, short maxParts) throws MetaException, NoSuchObjectException {
        return this.getPartitionsByFilterInternal(catName, dbName, tblName, filter, maxParts, true, true);
    }

    @Override
    public int getNumPartitionsByFilter(String catName, String dbName, String tblName, String filter) throws MetaException, NoSuchObjectException {
        final ExpressionTree exprTree = io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.isNotEmpty(filter) ? PartFilterExprUtil.getFilterParser((String)filter).tree : ExpressionTree.EMPTY_TREE;
        return (Integer)new GetHelper<Integer>(catName, dbName, tblName, true, true){
            private final MetaStoreDirectSql.SqlFilterForPushdown filter;
            {
                super(catalogName, dbName, tblName, allowSql, allowJdo);
                this.filter = new MetaStoreDirectSql.SqlFilterForPushdown();
            }

            @Override
            protected String describeResult() {
                return "Partition count";
            }

            @Override
            protected boolean canUseDirectSql(GetHelper<Integer> ctx) throws MetaException {
                return ObjectStore.this.directSql.generateSqlFilterForPushdown(ctx.getTable(), exprTree, this.filter);
            }

            @Override
            protected Integer getSqlResult(GetHelper<Integer> ctx) throws MetaException {
                return ObjectStore.this.directSql.getNumPartitionsViaSqlFilter(this.filter);
            }

            @Override
            protected Integer getJdoResult(GetHelper<Integer> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getNumPartitionsViaOrmFilter(ctx.getTable(), exprTree, true);
            }
        }.run(true);
    }

    @Override
    public int getNumPartitionsByExpr(String catName, String dbName, String tblName, byte[] expr) throws MetaException, NoSuchObjectException {
        final ExpressionTree exprTree = PartFilterExprUtil.makeExpressionTree(this.expressionProxy, expr);
        final byte[] tempExpr = expr;
        return (Integer)new GetHelper<Integer>(catName, dbName, tblName, true, true){
            private final MetaStoreDirectSql.SqlFilterForPushdown filter;
            {
                super(catalogName, dbName, tblName, allowSql, allowJdo);
                this.filter = new MetaStoreDirectSql.SqlFilterForPushdown();
            }

            @Override
            protected String describeResult() {
                return "Partition count";
            }

            @Override
            protected boolean canUseDirectSql(GetHelper<Integer> ctx) throws MetaException {
                return ObjectStore.this.directSql.generateSqlFilterForPushdown(ctx.getTable(), exprTree, this.filter);
            }

            @Override
            protected Integer getSqlResult(GetHelper<Integer> ctx) throws MetaException {
                return ObjectStore.this.directSql.getNumPartitionsViaSqlFilter(this.filter);
            }

            @Override
            protected Integer getJdoResult(GetHelper<Integer> ctx) throws MetaException, NoSuchObjectException {
                Integer numPartitions = null;
                if (exprTree != null) {
                    try {
                        numPartitions = ObjectStore.this.getNumPartitionsViaOrmFilter(ctx.getTable(), exprTree, true);
                    }
                    catch (MetaException e) {
                        numPartitions = null;
                    }
                }
                if (numPartitions == null) {
                    ArrayList filteredPartNames = new ArrayList();
                    ObjectStore.this.getPartitionNamesPrunedByExprNoTxn(ctx.getTable(), tempExpr, "", (short)-1, filteredPartNames);
                    numPartitions = filteredPartNames.size();
                }
                return numPartitions;
            }
        }.run(true);
    }

    protected List<Partition> getPartitionsByFilterInternal(String catName, String dbName, String tblName, String filter, final short maxParts, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        final ExpressionTree tree = filter != null && !filter.isEmpty() ? PartFilterExprUtil.getFilterParser((String)filter).tree : ExpressionTree.EMPTY_TREE;
        return (List)new GetListHelper<Partition>(catName, dbName, tblName, allowSql, allowJdo){
            private final MetaStoreDirectSql.SqlFilterForPushdown filter;
            {
                super(catName, dbName, tblName, allowSql, allowJdo);
                this.filter = new MetaStoreDirectSql.SqlFilterForPushdown();
            }

            @Override
            protected boolean canUseDirectSql(GetHelper<List<Partition>> ctx) throws MetaException {
                return ObjectStore.this.directSql.generateSqlFilterForPushdown(ctx.getTable(), tree, this.filter);
            }

            @Override
            protected List<Partition> getSqlResult(GetHelper<List<Partition>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getPartitionsViaSqlFilter(this.filter, maxParts < 0 ? null : Integer.valueOf(maxParts));
            }

            @Override
            protected List<Partition> getJdoResult(GetHelper<List<Partition>> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getPartitionsViaOrmFilter(ctx.getTable(), tree, maxParts, true);
            }
        }.run(true);
    }

    private MTable ensureGetMTable(String catName, String dbName, String tblName) throws NoSuchObjectException, MetaException {
        MTable mtable = this.getMTable(catName, dbName, tblName);
        if (mtable == null) {
            throw new NoSuchObjectException("Specified catalog.database.table does not exist : " + Warehouse.getCatalogQualifiedTableName(catName, dbName, tblName));
        }
        return mtable;
    }

    private Table ensureGetTable(String catName, String dbName, String tblName) throws NoSuchObjectException, MetaException {
        return this.convertToTable(this.ensureGetMTable(catName, dbName, tblName));
    }

    private String makeQueryFilterString(String catName, String dbName, MTable mtable, String filter, Map<String, Object> params) throws MetaException {
        ExpressionTree tree = filter != null && !filter.isEmpty() ? PartFilterExprUtil.getFilterParser((String)filter).tree : ExpressionTree.EMPTY_TREE;
        return this.makeQueryFilterString(catName, dbName, this.convertToTable(mtable), tree, params, true);
    }

    private String makeQueryFilterString(String catName, String dbName, Table table, ExpressionTree tree, Map<String, Object> params, boolean isValidatedFilter) throws MetaException {
        assert (tree != null);
        ExpressionTree.FilterBuilder queryBuilder = new ExpressionTree.FilterBuilder(isValidatedFilter);
        if (table != null) {
            queryBuilder.append("table.tableName == t1 && table.database.name == t2 && table.database.catalogName == t3");
            params.put("t1", table.getTableName());
            params.put("t2", table.getDbName());
            params.put("t3", table.getCatName());
        } else {
            queryBuilder.append("database.name == dbName && database.catalogName == catName");
            params.put("dbName", dbName);
            params.put("catName", catName);
        }
        tree.generateJDOFilterFragment(this.getConf(), table, params, queryBuilder);
        if (queryBuilder.hasError()) {
            assert (!isValidatedFilter);
            LOG.info("JDO filter pushdown cannot be used: {}", (Object)queryBuilder.getErrorMessage());
            return null;
        }
        String jdoFilter = queryBuilder.getFilter();
        LOG.debug("jdoFilter = {}", (Object)jdoFilter);
        return jdoFilter;
    }

    private String makeParameterDeclarationString(Map<String, String> params) {
        StringBuilder paramDecl = new StringBuilder();
        for (String key : params.keySet()) {
            paramDecl.append(", java.lang.String ").append(key);
        }
        return paramDecl.toString();
    }

    private String makeParameterDeclarationStringObj(Map<String, Object> params) {
        StringBuilder paramDecl = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            paramDecl.append(", ");
            paramDecl.append(entry.getValue().getClass().getName());
            paramDecl.append(' ');
            paramDecl.append(entry.getKey());
        }
        return paramDecl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listTableNamesByFilter(String catName, String dbName, String filter, short maxTables) throws MetaException {
        boolean success = false;
        Query query = null;
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            this.openTransaction();
            LOG.debug("Executing listTableNamesByFilter");
            catName = StringUtils.normalizeIdentifier(catName);
            dbName = StringUtils.normalizeIdentifier(dbName);
            HashMap<String, Object> params = new HashMap<String, Object>();
            String queryFilterString = this.makeQueryFilterString(catName, dbName, null, filter, params);
            query = this.pm.newQuery(MTable.class);
            query.declareImports("import java.lang.String");
            query.setResult("tableName");
            query.setResultClass(String.class);
            if (maxTables >= 0) {
                query.setRange(0L, (long)maxTables);
            }
            LOG.debug("filter specified is {}, JDOQL filter is {}", (Object)filter, (Object)queryFilterString);
            if (LOG.isDebugEnabled()) {
                for (Map.Entry entry : params.entrySet()) {
                    LOG.debug("key: {} value: {} class: {}", entry.getKey(), entry.getValue(), entry.getValue().getClass().getName());
                }
            }
            String parameterDeclaration = this.makeParameterDeclarationStringObj(params);
            query.declareParameters(parameterDeclaration);
            query.setFilter(queryFilterString);
            Collection names = (Collection)query.executeWithMap(params);
            tableNames = new ArrayList(new HashSet(names));
            LOG.debug("Done executing query for listTableNamesByFilter");
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listTableNamesByFilter");
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterTable(String catName, String dbname, String name, Table newTable) throws InvalidObjectException, MetaException {
        boolean success = false;
        boolean registerCreationSignature = false;
        try {
            this.openTransaction();
            name = StringUtils.normalizeIdentifier(name);
            dbname = StringUtils.normalizeIdentifier(dbname);
            catName = StringUtils.normalizeIdentifier(catName);
            MTable newt = this.convertToMTable(newTable);
            if (newt == null) {
                throw new InvalidObjectException("new table is invalid");
            }
            MTable oldt = this.getMTable(catName, dbname, name);
            if (oldt == null) {
                throw new MetaException("table " + dbname + "." + name + " doesn't exist");
            }
            oldt.setDatabase(newt.getDatabase());
            oldt.setTableName(StringUtils.normalizeIdentifier(newt.getTableName()));
            oldt.setParameters(newt.getParameters());
            oldt.setOwner(newt.getOwner());
            oldt.setOwnerType(newt.getOwnerType());
            MColumnDescriptor oldCD = null;
            MStorageDescriptor oldSD = oldt.getSd();
            if (oldSD != null) {
                oldCD = oldSD.getCD();
            }
            this.copyMSD(newt.getSd(), oldt.getSd());
            this.removeUnusedColumnDescriptor(oldCD);
            oldt.setRetention(newt.getRetention());
            oldt.setPartitionKeys(newt.getPartitionKeys());
            oldt.setTableType(newt.getTableType());
            oldt.setLastAccessTime(newt.getLastAccessTime());
            oldt.setViewOriginalText(newt.getViewOriginalText());
            oldt.setViewExpandedText(newt.getViewExpandedText());
            oldt.setRewriteEnabled(newt.isRewriteEnabled());
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCreationMetadata(String catName, String dbname, String tablename, CreationMetadata cm) throws MetaException {
        boolean success = false;
        try {
            this.openTransaction();
            catName = StringUtils.normalizeIdentifier(catName);
            dbname = StringUtils.normalizeIdentifier(dbname);
            tablename = StringUtils.normalizeIdentifier(tablename);
            MCreationMetadata newMcm = this.convertToMCreationMetadata(cm);
            MCreationMetadata mcm = this.getCreationMetadata(catName, dbname, tablename);
            mcm.setTables(newMcm.getTables());
            mcm.setMaterializationTime(newMcm.getMaterializationTime());
            mcm.setTxnList(newMcm.getTxnList());
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    private MColumnDescriptor alterPartitionNoTxn(String catName, String dbname, String name, List<String> part_vals, Partition newPart) throws InvalidObjectException, MetaException {
        catName = StringUtils.normalizeIdentifier(catName);
        name = StringUtils.normalizeIdentifier(name);
        dbname = StringUtils.normalizeIdentifier(dbname);
        MPartition oldp = this.getMPartition(catName, dbname, name, part_vals);
        MPartition newp = this.convertToMPart(newPart, false);
        MColumnDescriptor oldCD = null;
        MStorageDescriptor oldSD = oldp.getSd();
        if (oldSD != null) {
            oldCD = oldSD.getCD();
        }
        if (oldp == null || newp == null) {
            throw new InvalidObjectException("partition does not exist.");
        }
        oldp.setValues(newp.getValues());
        oldp.setPartitionName(newp.getPartitionName());
        oldp.setParameters(newPart.getParameters());
        if (!TableType.VIRTUAL_VIEW.name().equals(oldp.getTable().getTableType())) {
            this.copyMSD(newp.getSd(), oldp.getSd());
        }
        if (newp.getCreateTime() != oldp.getCreateTime()) {
            oldp.setCreateTime(newp.getCreateTime());
        }
        if (newp.getLastAccessTime() != oldp.getLastAccessTime()) {
            oldp.setLastAccessTime(newp.getLastAccessTime());
        }
        return oldCD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartition(String catName, String dbname, String name, List<String> part_vals, Partition newPart) throws InvalidObjectException, MetaException {
        block6: {
            boolean success = false;
            Exception e = null;
            try {
                this.openTransaction();
                MColumnDescriptor oldCd = this.alterPartitionNoTxn(catName, dbname, name, part_vals, newPart);
                this.removeUnusedColumnDescriptor(oldCd);
                success = this.commitTransaction();
            }
            catch (Exception exception) {
                e = exception;
            }
            finally {
                if (success) break block6;
                this.rollbackTransaction();
                MetaException metaException = new MetaException("The transaction for alter partition did not commit successfully.");
                if (e != null) {
                    metaException.initCause(e);
                }
                throw metaException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartitions(String catName, String dbname, String name, List<List<String>> part_vals, List<Partition> newParts) throws InvalidObjectException, MetaException {
        block8: {
            boolean success = false;
            Exception e = null;
            try {
                this.openTransaction();
                Iterator<List<String>> part_val_itr = part_vals.iterator();
                HashSet<MColumnDescriptor> oldCds = new HashSet<MColumnDescriptor>();
                for (Partition tmpPart : newParts) {
                    List<String> tmpPartVals = part_val_itr.next();
                    MColumnDescriptor oldCd = this.alterPartitionNoTxn(catName, dbname, name, tmpPartVals, tmpPart);
                    if (oldCd == null) continue;
                    oldCds.add(oldCd);
                }
                for (MColumnDescriptor oldCd : oldCds) {
                    this.removeUnusedColumnDescriptor(oldCd);
                }
                success = this.commitTransaction();
            }
            catch (Exception exception) {
                e = exception;
            }
            finally {
                if (success) break block8;
                this.rollbackTransaction();
                MetaException metaException = new MetaException("The transaction for alter partition did not commit successfully.");
                if (e != null) {
                    metaException.initCause(e);
                }
                throw metaException;
            }
        }
    }

    private void copyMSD(MStorageDescriptor newSd, MStorageDescriptor oldSd) {
        oldSd.setLocation(newSd.getLocation());
        if (oldSd == null || oldSd.getCD() == null || oldSd.getCD().getCols() == null || newSd == null || newSd.getCD() == null || newSd.getCD().getCols() == null || !this.convertToFieldSchemas(newSd.getCD().getCols()).equals(this.convertToFieldSchemas(oldSd.getCD().getCols()))) {
            oldSd.setCD(newSd.getCD());
        }
        oldSd.setBucketCols(newSd.getBucketCols());
        oldSd.setCompressed(newSd.isCompressed());
        oldSd.setInputFormat(newSd.getInputFormat());
        oldSd.setOutputFormat(newSd.getOutputFormat());
        oldSd.setNumBuckets(newSd.getNumBuckets());
        oldSd.getSerDeInfo().setName(newSd.getSerDeInfo().getName());
        oldSd.getSerDeInfo().setSerializationLib(newSd.getSerDeInfo().getSerializationLib());
        oldSd.getSerDeInfo().setParameters(newSd.getSerDeInfo().getParameters());
        oldSd.setSkewedColNames(newSd.getSkewedColNames());
        oldSd.setSkewedColValues(newSd.getSkewedColValues());
        oldSd.setSkewedColValueLocationMaps(newSd.getSkewedColValueLocationMaps());
        oldSd.setSortCols(newSd.getSortCols());
        oldSd.setParameters(newSd.getParameters());
        oldSd.setStoredAsSubDirectories(newSd.isStoredAsSubDirectories());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnusedColumnDescriptor(MColumnDescriptor oldCD) {
        if (oldCD == null) {
            return;
        }
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            LOG.debug("execute removeUnusedColumnDescriptor");
            query = this.pm.newQuery("select count(1) from org.apache.hadoop.hive.metastore.model.MStorageDescriptor where (this.cd == inCD)");
            query.declareParameters("MColumnDescriptor inCD");
            long count = (Long)query.execute((Object)oldCD);
            if (count == 0L) {
                this.pm.retrieve((Object)oldCD);
                this.pm.deletePersistent((Object)oldCD);
            }
            success = this.commitTransaction();
            LOG.debug("successfully deleted a CD in removeUnusedColumnDescriptor");
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
    }

    private void preDropStorageDescriptor(MStorageDescriptor msd) {
        if (msd == null || msd.getCD() == null) {
            return;
        }
        MColumnDescriptor mcd = msd.getCD();
        msd.setCD(null);
        this.removeUnusedColumnDescriptor(mcd);
    }

    private static MFieldSchema getColumnFromTableColumns(List<MFieldSchema> cols, String col) {
        if (cols == null) {
            return null;
        }
        for (MFieldSchema mfs : cols) {
            if (!mfs.getName().equalsIgnoreCase(col)) continue;
            return mfs;
        }
        return null;
    }

    private static int getColumnIndexFromTableColumns(List<MFieldSchema> cols, String col) {
        if (cols == null) {
            return -1;
        }
        for (int i = 0; i < cols.size(); ++i) {
            MFieldSchema mfs = cols.get(i);
            if (!mfs.getName().equalsIgnoreCase(col)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean constraintNameAlreadyExists(String name) {
        boolean commited = false;
        Query constraintExistsQuery = null;
        String constraintNameIfExists = null;
        try {
            this.openTransaction();
            name = StringUtils.normalizeIdentifier(name);
            constraintExistsQuery = this.pm.newQuery(MConstraint.class, "constraintName == name");
            constraintExistsQuery.declareParameters("java.lang.String name");
            constraintExistsQuery.setUnique(true);
            constraintExistsQuery.setResult("name");
            constraintNameIfExists = (String)constraintExistsQuery.execute((Object)name);
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, constraintExistsQuery);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, constraintExistsQuery);
            throw throwable;
        }
        return constraintNameIfExists != null && !constraintNameIfExists.isEmpty();
    }

    private String generateConstraintName(String ... parameters) throws MetaException {
        int hashcode = ArrayUtils.toString(parameters).hashCode() & 0xFFFFFFF;
        int counter = 0;
        int MAX_RETRIES = 10;
        while (counter < 10) {
            String currName = (parameters.length == 0 ? "constraint_" : parameters[parameters.length - 1]) + "_" + hashcode + "_" + System.currentTimeMillis() + "_" + counter++;
            if (this.constraintNameAlreadyExists(currName)) continue;
            return currName;
        }
        throw new MetaException("Error while trying to generate the constraint name for " + ArrayUtils.toString(parameters));
    }

    @Override
    public List<String> addForeignKeys(List<SQLForeignKey> fks) throws InvalidObjectException, MetaException {
        return this.addForeignKeys(fks, true, null, null);
    }

    @Override
    public String getMetastoreDbUuid() throws MetaException {
        String ret = this.getGuidFromDB();
        if (ret != null) {
            return ret;
        }
        return this.createDbGuidAndPersist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createDbGuidAndPersist() throws MetaException {
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            MMetastoreDBProperties prop = new MMetastoreDBProperties();
            prop.setPropertykey("guid");
            String guid = UUID.randomUUID().toString();
            LOG.debug("Attempting to add a guid {} for the metastore db", (Object)guid);
            prop.setPropertyValue(guid);
            prop.setDescription("Metastore DB GUID generated on " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")));
            this.pm.makePersistent((Object)prop);
            success = this.commitTransaction();
            if (success) {
                LOG.info("Metastore db guid {} created successfully", (Object)guid);
                String string = guid;
                return string;
            }
        }
        catch (Exception e) {
            LOG.warn("Metastore db guid creation failed", e);
        }
        finally {
            this.rollbackAndCleanup(success, query);
        }
        String guid = this.getGuidFromDB();
        if (guid == null) {
            throw new MetaException("Unable to create or fetch the metastore database uuid");
        }
        return guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGuidFromDB() throws MetaException {
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MMetastoreDBProperties.class, "this.propertyKey == key");
            query.declareParameters("java.lang.String key");
            Collection names = (Collection)query.execute((Object)"guid");
            ArrayList<String> uuids = new ArrayList<String>();
            Iterator i = names.iterator();
            while (i.hasNext()) {
                String uuid = ((MMetastoreDBProperties)i.next()).getPropertyValue();
                LOG.debug("Found guid {}", (Object)uuid);
                uuids.add(uuid);
            }
            success = this.commitTransaction();
            if (uuids.size() > 1) {
                throw new MetaException("Multiple uuids found");
            }
            if (!uuids.isEmpty()) {
                LOG.debug("Returning guid of metastore db : {}", uuids.get(0));
                String string = (String)uuids.get(0);
                this.rollbackAndCleanup(success, query);
                return string;
            }
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        LOG.warn("Guid for metastore db not found");
        return null;
    }

    private List<String> addForeignKeys(List<SQLForeignKey> foreignKeys, boolean retrieveCD, List<SQLPrimaryKey> primaryKeys, List<SQLUniqueConstraint> uniqueConstraints) throws InvalidObjectException, MetaException {
        ArrayList<String> fkNames = new ArrayList<String>();
        if (.CollectionUtils.isNotEmpty(foreignKeys)) {
            ArrayList<MConstraint> mpkfks = new ArrayList<MConstraint>();
            String currentConstraintName = null;
            String catName = null;
            for (int i = 0; i < foreignKeys.size(); ++i) {
                String referenced;
                List<SQLUniqueConstraint> existingTableUniqueConstraints;
                List<SQLPrimaryKey> existingTablePrimaryKeys;
                ArrayList<MFieldSchema> parentCols;
                MColumnDescriptor parentCD;
                MTable parentTable;
                AttachedMTableInfo nParentTable;
                boolean sameTable;
                ArrayList<MFieldSchema> childCols;
                if (catName == null) {
                    catName = StringUtils.normalizeIdentifier(foreignKeys.get(i).isSetCatName() ? foreignKeys.get(i).getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf));
                } else {
                    String tmpCatName = StringUtils.normalizeIdentifier(foreignKeys.get(i).isSetCatName() ? foreignKeys.get(i).getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf));
                    if (!catName.equals(tmpCatName)) {
                        throw new InvalidObjectException("Foreign keys cannot span catalogs");
                    }
                }
                String fkTableDB = StringUtils.normalizeIdentifier(foreignKeys.get(i).getFktable_db());
                String fkTableName = StringUtils.normalizeIdentifier(foreignKeys.get(i).getFktable_name());
                AttachedMTableInfo nChildTable = this.getMTable(catName, fkTableDB, fkTableName, retrieveCD);
                MTable childTable = nChildTable.mtbl;
                if (childTable == null) {
                    throw new InvalidObjectException("Child table not found: " + fkTableName);
                }
                MColumnDescriptor childCD = retrieveCD ? nChildTable.mcd : childTable.getSd().getCD();
                ArrayList<MFieldSchema> arrayList = childCols = childCD == null || childCD.getCols() == null ? new ArrayList<MFieldSchema>() : new ArrayList<MFieldSchema>(childCD.getCols());
                if (childTable.getPartitionKeys() != null) {
                    childCols.addAll(childTable.getPartitionKeys());
                }
                String pkTableDB = StringUtils.normalizeIdentifier(foreignKeys.get(i).getPktable_db());
                String pkTableName = StringUtils.normalizeIdentifier(foreignKeys.get(i).getPktable_name());
                boolean bl = sameTable = fkTableDB.equals(pkTableDB) && fkTableName.equals(pkTableName);
                if (sameTable) {
                    nParentTable = nChildTable;
                    parentTable = childTable;
                    parentCD = childCD;
                    parentCols = childCols;
                    existingTablePrimaryKeys = primaryKeys;
                    existingTableUniqueConstraints = uniqueConstraints;
                } else {
                    nParentTable = this.getMTable(catName, pkTableDB, pkTableName, true);
                    parentTable = nParentTable.mtbl;
                    if (parentTable == null) {
                        throw new InvalidObjectException("Parent table not found: " + pkTableName);
                    }
                    parentCD = nParentTable.mcd;
                    ArrayList<MFieldSchema> arrayList2 = parentCols = parentCD == null || parentCD.getCols() == null ? new ArrayList<MFieldSchema>() : new ArrayList<MFieldSchema>(parentCD.getCols());
                    if (parentTable.getPartitionKeys() != null) {
                        parentCols.addAll(parentTable.getPartitionKeys());
                    }
                    existingTablePrimaryKeys = this.getPrimaryKeys(catName, pkTableDB, pkTableName);
                    existingTableUniqueConstraints = this.getUniqueConstraints(catName, pkTableDB, pkTableName);
                }
                if (existingTablePrimaryKeys.isEmpty() && existingTableUniqueConstraints.isEmpty()) {
                    throw new MetaException("Trying to define foreign key but there are no primary keys or unique keys for referenced table");
                }
                Set<String> validPKsOrUnique = ObjectStore.generateValidPKsOrUniqueSignatures(parentCols, existingTablePrimaryKeys, existingTableUniqueConstraints);
                StringBuilder fkSignature = new StringBuilder();
                StringBuilder referencedKSignature = new StringBuilder();
                while (i < foreignKeys.size()) {
                    SQLForeignKey foreignKey = foreignKeys.get(i);
                    String fkColumnName = StringUtils.normalizeIdentifier(foreignKey.getFkcolumn_name());
                    int childIntegerIndex = ObjectStore.getColumnIndexFromTableColumns(childCD.getCols(), fkColumnName);
                    if (childIntegerIndex == -1) {
                        if (childTable.getPartitionKeys() != null) {
                            childCD = null;
                            childIntegerIndex = ObjectStore.getColumnIndexFromTableColumns(childTable.getPartitionKeys(), fkColumnName);
                        }
                        if (childIntegerIndex == -1) {
                            throw new InvalidObjectException("Child column not found: " + fkColumnName);
                        }
                    }
                    String pkColumnName = StringUtils.normalizeIdentifier(foreignKey.getPkcolumn_name());
                    int parentIntegerIndex = ObjectStore.getColumnIndexFromTableColumns(parentCD.getCols(), pkColumnName);
                    if (parentIntegerIndex == -1) {
                        if (parentTable.getPartitionKeys() != null) {
                            parentCD = null;
                            parentIntegerIndex = ObjectStore.getColumnIndexFromTableColumns(parentTable.getPartitionKeys(), pkColumnName);
                        }
                        if (parentIntegerIndex == -1) {
                            throw new InvalidObjectException("Parent column not found: " + pkColumnName);
                        }
                    }
                    if (foreignKey.getFk_name() == null) {
                        if (foreignKey.getKey_seq() == 1) {
                            currentConstraintName = this.generateConstraintName(fkTableDB, fkTableName, pkTableDB, pkTableName, pkColumnName, fkColumnName, "fk");
                        }
                    } else {
                        currentConstraintName = StringUtils.normalizeIdentifier(foreignKey.getFk_name());
                        if (this.constraintNameAlreadyExists(currentConstraintName)) {
                            throw new InvalidObjectException("Constraint name already exists: " + currentConstraintName);
                        }
                    }
                    fkNames.add(currentConstraintName);
                    Integer updateRule = foreignKey.getUpdate_rule();
                    Integer deleteRule = foreignKey.getDelete_rule();
                    int enableValidateRely = (foreignKey.isEnable_cstr() ? 4 : 0) + (foreignKey.isValidate_cstr() ? 2 : 0) + (foreignKey.isRely_cstr() ? 1 : 0);
                    MConstraint mpkfk = new MConstraint(currentConstraintName, 1, foreignKey.getKey_seq(), deleteRule, updateRule, enableValidateRely, parentTable, childTable, parentCD, childCD, childIntegerIndex, parentIntegerIndex);
                    mpkfks.add(mpkfk);
                    String fkColType = ObjectStore.getColumnFromTableColumns(childCols, fkColumnName).getType();
                    fkSignature.append(ObjectStore.generateColNameTypeSignature(fkColumnName, fkColType));
                    referencedKSignature.append(ObjectStore.generateColNameTypeSignature(pkColumnName, fkColType));
                    if (i + 1 < foreignKeys.size() && foreignKeys.get(i + 1).getKey_seq() == 1) break;
                    ++i;
                }
                if (!validPKsOrUnique.contains(referenced = referencedKSignature.toString())) {
                    throw new MetaException("Foreign key references " + referenced + " but no corresponding primary key or unique key exists. Possible keys: " + validPKsOrUnique);
                }
                if (sameTable && fkSignature.toString().equals(referenced)) {
                    throw new MetaException("Cannot be both foreign key and primary/unique key on same table: " + referenced);
                }
                fkSignature = new StringBuilder();
                referencedKSignature = new StringBuilder();
            }
            this.pm.makePersistentAll(mpkfks);
        }
        return fkNames;
    }

    private static Set<String> generateValidPKsOrUniqueSignatures(List<MFieldSchema> tableCols, List<SQLPrimaryKey> refTablePrimaryKeys, List<SQLUniqueConstraint> refTableUniqueConstraints) {
        HashSet<String> validPKsOrUnique = new HashSet<String>();
        if (!refTablePrimaryKeys.isEmpty()) {
            Collections.sort(refTablePrimaryKeys, new Comparator<SQLPrimaryKey>(){

                @Override
                public int compare(SQLPrimaryKey o1, SQLPrimaryKey o2) {
                    int keyNameComp = o1.getPk_name().compareTo(o2.getPk_name());
                    if (keyNameComp == 0) {
                        return Integer.compare(o1.getKey_seq(), o2.getKey_seq());
                    }
                    return keyNameComp;
                }
            });
            StringBuilder pkSignature = new StringBuilder();
            for (SQLPrimaryKey pk : refTablePrimaryKeys) {
                pkSignature.append(ObjectStore.generateColNameTypeSignature(pk.getColumn_name(), ObjectStore.getColumnFromTableColumns(tableCols, pk.getColumn_name()).getType()));
            }
            validPKsOrUnique.add(pkSignature.toString());
        }
        if (!refTableUniqueConstraints.isEmpty()) {
            Collections.sort(refTableUniqueConstraints, new Comparator<SQLUniqueConstraint>(){

                @Override
                public int compare(SQLUniqueConstraint o1, SQLUniqueConstraint o2) {
                    int keyNameComp = o1.getUk_name().compareTo(o2.getUk_name());
                    if (keyNameComp == 0) {
                        return Integer.compare(o1.getKey_seq(), o2.getKey_seq());
                    }
                    return keyNameComp;
                }
            });
            StringBuilder ukSignature = new StringBuilder();
            for (int j = 0; j < refTableUniqueConstraints.size(); ++j) {
                SQLUniqueConstraint uk = refTableUniqueConstraints.get(j);
                ukSignature.append(ObjectStore.generateColNameTypeSignature(uk.getColumn_name(), ObjectStore.getColumnFromTableColumns(tableCols, uk.getColumn_name()).getType()));
                if (j + 1 < refTableUniqueConstraints.size()) {
                    if (refTableUniqueConstraints.get(j + 1).getUk_name().equals(refTableUniqueConstraints.get(j).getUk_name())) continue;
                    validPKsOrUnique.add(ukSignature.toString());
                    ukSignature = new StringBuilder();
                    continue;
                }
                validPKsOrUnique.add(ukSignature.toString());
            }
        }
        return validPKsOrUnique;
    }

    private static String generateColNameTypeSignature(String colName, String colType) {
        return colName + ":" + colType + ";";
    }

    @Override
    public List<String> addPrimaryKeys(List<SQLPrimaryKey> pks) throws InvalidObjectException, MetaException {
        return this.addPrimaryKeys(pks, true);
    }

    private List<String> addPrimaryKeys(List<SQLPrimaryKey> pks, boolean retrieveCD) throws InvalidObjectException, MetaException {
        ArrayList<String> pkNames = new ArrayList<String>();
        ArrayList<MConstraint> mpks = new ArrayList<MConstraint>();
        String constraintName = null;
        for (int i = 0; i < pks.size(); ++i) {
            String catName = StringUtils.normalizeIdentifier(pks.get(i).getCatName());
            String tableDB = StringUtils.normalizeIdentifier(pks.get(i).getTable_db());
            String tableName = StringUtils.normalizeIdentifier(pks.get(i).getTable_name());
            String columnName = StringUtils.normalizeIdentifier(pks.get(i).getColumn_name());
            AttachedMTableInfo nParentTable = this.getMTable(catName, tableDB, tableName, retrieveCD);
            MTable parentTable = nParentTable.mtbl;
            if (parentTable == null) {
                throw new InvalidObjectException("Parent table not found: " + tableName);
            }
            MColumnDescriptor parentCD = retrieveCD ? nParentTable.mcd : parentTable.getSd().getCD();
            int parentIntegerIndex = ObjectStore.getColumnIndexFromTableColumns(parentCD == null ? null : parentCD.getCols(), columnName);
            if (parentIntegerIndex == -1) {
                if (parentTable.getPartitionKeys() != null) {
                    parentCD = null;
                    parentIntegerIndex = ObjectStore.getColumnIndexFromTableColumns(parentTable.getPartitionKeys(), columnName);
                }
                if (parentIntegerIndex == -1) {
                    throw new InvalidObjectException("Parent column not found: " + columnName);
                }
            }
            if (this.getPrimaryKeyConstraintName(parentTable.getDatabase().getCatalogName(), parentTable.getDatabase().getName(), parentTable.getTableName()) != null) {
                throw new MetaException(" Primary key already exists for: " + Warehouse.getCatalogQualifiedTableName(catName, tableDB, tableName));
            }
            if (pks.get(i).getPk_name() == null) {
                if (pks.get(i).getKey_seq() == 1) {
                    constraintName = this.generateConstraintName(tableDB, tableName, columnName, "pk");
                }
            } else {
                constraintName = StringUtils.normalizeIdentifier(pks.get(i).getPk_name());
                if (this.constraintNameAlreadyExists(constraintName)) {
                    throw new InvalidObjectException("Constraint name already exists: " + constraintName);
                }
            }
            pkNames.add(constraintName);
            int enableValidateRely = (pks.get(i).isEnable_cstr() ? 4 : 0) + (pks.get(i).isValidate_cstr() ? 2 : 0) + (pks.get(i).isRely_cstr() ? 1 : 0);
            MConstraint mpk = new MConstraint(constraintName, 0, pks.get(i).getKey_seq(), null, null, enableValidateRely, parentTable, null, parentCD, null, null, parentIntegerIndex);
            mpks.add(mpk);
        }
        this.pm.makePersistentAll(mpks);
        return pkNames;
    }

    @Override
    public List<String> addUniqueConstraints(List<SQLUniqueConstraint> uks) throws InvalidObjectException, MetaException {
        return this.addUniqueConstraints(uks, true);
    }

    private List<String> addUniqueConstraints(List<SQLUniqueConstraint> uks, boolean retrieveCD) throws InvalidObjectException, MetaException {
        ArrayList<String> ukNames = new ArrayList<String>();
        ArrayList<MConstraint> cstrs = new ArrayList<MConstraint>();
        String constraintName = null;
        for (int i = 0; i < uks.size(); ++i) {
            String catName = StringUtils.normalizeIdentifier(uks.get(i).getCatName());
            String tableDB = StringUtils.normalizeIdentifier(uks.get(i).getTable_db());
            String tableName = StringUtils.normalizeIdentifier(uks.get(i).getTable_name());
            String columnName = StringUtils.normalizeIdentifier(uks.get(i).getColumn_name());
            AttachedMTableInfo nParentTable = this.getMTable(catName, tableDB, tableName, retrieveCD);
            MTable parentTable = nParentTable.mtbl;
            if (parentTable == null) {
                throw new InvalidObjectException("Parent table not found: " + tableName);
            }
            MColumnDescriptor parentCD = retrieveCD ? nParentTable.mcd : parentTable.getSd().getCD();
            int parentIntegerIndex = ObjectStore.getColumnIndexFromTableColumns(parentCD == null ? null : parentCD.getCols(), columnName);
            if (parentIntegerIndex == -1) {
                if (parentTable.getPartitionKeys() != null) {
                    parentCD = null;
                    parentIntegerIndex = ObjectStore.getColumnIndexFromTableColumns(parentTable.getPartitionKeys(), columnName);
                }
                if (parentIntegerIndex == -1) {
                    throw new InvalidObjectException("Parent column not found: " + columnName);
                }
            }
            if (uks.get(i).getUk_name() == null) {
                if (uks.get(i).getKey_seq() == 1) {
                    constraintName = this.generateConstraintName(tableDB, tableName, columnName, "uk");
                }
            } else {
                constraintName = StringUtils.normalizeIdentifier(uks.get(i).getUk_name());
                if (this.constraintNameAlreadyExists(constraintName)) {
                    throw new InvalidObjectException("Constraint name already exists: " + constraintName);
                }
            }
            ukNames.add(constraintName);
            int enableValidateRely = (uks.get(i).isEnable_cstr() ? 4 : 0) + (uks.get(i).isValidate_cstr() ? 2 : 0) + (uks.get(i).isRely_cstr() ? 1 : 0);
            MConstraint muk = new MConstraint(constraintName, 2, uks.get(i).getKey_seq(), null, null, enableValidateRely, parentTable, null, parentCD, null, null, parentIntegerIndex);
            cstrs.add(muk);
        }
        this.pm.makePersistentAll(cstrs);
        return ukNames;
    }

    @Override
    public List<String> addNotNullConstraints(List<SQLNotNullConstraint> nns) throws InvalidObjectException, MetaException {
        return this.addNotNullConstraints(nns, true);
    }

    @Override
    public List<String> addDefaultConstraints(List<SQLDefaultConstraint> nns) throws InvalidObjectException, MetaException {
        return this.addDefaultConstraints(nns, true);
    }

    @Override
    public List<String> addCheckConstraints(List<SQLCheckConstraint> nns) throws InvalidObjectException, MetaException {
        return this.addCheckConstraints(nns, true);
    }

    private List<String> addCheckConstraints(List<SQLCheckConstraint> cc, boolean retrieveCD) throws InvalidObjectException, MetaException {
        ArrayList<String> nnNames = new ArrayList<String>();
        ArrayList<MConstraint> cstrs = new ArrayList<MConstraint>();
        Object constraintName = null;
        for (int i = 0; i < cc.size(); ++i) {
            String catName = StringUtils.normalizeIdentifier(cc.get(i).getCatName());
            String tableDB = StringUtils.normalizeIdentifier(cc.get(i).getTable_db());
            String tableName = StringUtils.normalizeIdentifier(cc.get(i).getTable_name());
            String columnName = cc.get(i).getColumn_name() == null ? null : StringUtils.normalizeIdentifier(cc.get(i).getColumn_name());
            String ccName = cc.get(i).getDc_name();
            boolean isEnable = cc.get(i).isEnable_cstr();
            boolean isValidate = cc.get(i).isValidate_cstr();
            boolean isRely = cc.get(i).isRely_cstr();
            String constraintValue = cc.get(i).getCheck_expression();
            this.addConstraint(catName, tableDB, tableName, columnName, ccName, isEnable, isRely, isValidate, 5, constraintValue, retrieveCD, nnNames, cstrs);
        }
        this.pm.makePersistentAll(cstrs);
        return nnNames;
    }

    private void addConstraint(String catName, String tableDB, String tableName, String columnName, String ccName, boolean isEnable, boolean isRely, boolean isValidate, int constraintType, String constraintValue, boolean retrieveCD, List<String> nnNames, List<MConstraint> cstrs) throws InvalidObjectException, MetaException {
        String constraintName = null;
        AttachedMTableInfo nParentTable = this.getMTable(catName, tableDB, tableName, retrieveCD);
        MTable parentTable = nParentTable.mtbl;
        if (parentTable == null) {
            throw new InvalidObjectException("Parent table not found: " + tableName);
        }
        MColumnDescriptor parentCD = retrieveCD ? nParentTable.mcd : parentTable.getSd().getCD();
        int parentIntegerIndex = ObjectStore.getColumnIndexFromTableColumns(parentCD == null ? null : parentCD.getCols(), columnName);
        if (parentIntegerIndex == -1 && parentTable.getPartitionKeys() != null) {
            parentCD = null;
            parentIntegerIndex = ObjectStore.getColumnIndexFromTableColumns(parentTable.getPartitionKeys(), columnName);
        }
        if (ccName == null) {
            constraintName = this.generateConstraintName(tableDB, tableName, columnName, "dc");
        } else {
            constraintName = StringUtils.normalizeIdentifier(ccName);
            if (this.constraintNameAlreadyExists(constraintName)) {
                throw new InvalidObjectException("Constraint name already exists: " + constraintName);
            }
        }
        nnNames.add(constraintName);
        int enableValidateRely = (isEnable ? 4 : 0) + (isValidate ? 2 : 0) + (isRely ? 1 : 0);
        MConstraint muk = new MConstraint(constraintName, constraintType, 1, null, null, enableValidateRely, parentTable, null, parentCD, null, null, parentIntegerIndex, constraintValue);
        cstrs.add(muk);
    }

    private List<String> addDefaultConstraints(List<SQLDefaultConstraint> nns, boolean retrieveCD) throws InvalidObjectException, MetaException {
        ArrayList<String> nnNames = new ArrayList<String>();
        ArrayList<MConstraint> cstrs = new ArrayList<MConstraint>();
        Object constraintName = null;
        for (int i = 0; i < nns.size(); ++i) {
            String catName = StringUtils.normalizeIdentifier(nns.get(i).getCatName());
            String tableDB = StringUtils.normalizeIdentifier(nns.get(i).getTable_db());
            String tableName = StringUtils.normalizeIdentifier(nns.get(i).getTable_name());
            String columnName = StringUtils.normalizeIdentifier(nns.get(i).getColumn_name());
            String ccName = nns.get(i).getDc_name();
            boolean isEnable = nns.get(i).isEnable_cstr();
            boolean isValidate = nns.get(i).isValidate_cstr();
            boolean isRely = nns.get(i).isRely_cstr();
            String constraintValue = nns.get(i).getDefault_value();
            this.addConstraint(catName, tableDB, tableName, columnName, ccName, isEnable, isRely, isValidate, 4, constraintValue, retrieveCD, nnNames, cstrs);
        }
        this.pm.makePersistentAll(cstrs);
        return nnNames;
    }

    private List<String> addNotNullConstraints(List<SQLNotNullConstraint> nns, boolean retrieveCD) throws InvalidObjectException, MetaException {
        ArrayList<String> nnNames = new ArrayList<String>();
        ArrayList<MConstraint> cstrs = new ArrayList<MConstraint>();
        String constraintName = null;
        for (int i = 0; i < nns.size(); ++i) {
            String catName = StringUtils.normalizeIdentifier(nns.get(i).getCatName());
            String tableDB = StringUtils.normalizeIdentifier(nns.get(i).getTable_db());
            String tableName = StringUtils.normalizeIdentifier(nns.get(i).getTable_name());
            String columnName = StringUtils.normalizeIdentifier(nns.get(i).getColumn_name());
            AttachedMTableInfo nParentTable = this.getMTable(catName, tableDB, tableName, retrieveCD);
            MTable parentTable = nParentTable.mtbl;
            if (parentTable == null) {
                throw new InvalidObjectException("Parent table not found: " + tableName);
            }
            MColumnDescriptor parentCD = retrieveCD ? nParentTable.mcd : parentTable.getSd().getCD();
            int parentIntegerIndex = ObjectStore.getColumnIndexFromTableColumns(parentCD == null ? null : parentCD.getCols(), columnName);
            if (parentIntegerIndex == -1) {
                if (parentTable.getPartitionKeys() != null) {
                    parentCD = null;
                    parentIntegerIndex = ObjectStore.getColumnIndexFromTableColumns(parentTable.getPartitionKeys(), columnName);
                }
                if (parentIntegerIndex == -1) {
                    throw new InvalidObjectException("Parent column not found: " + columnName);
                }
            }
            if (nns.get(i).getNn_name() == null) {
                constraintName = this.generateConstraintName(tableDB, tableName, columnName, "nn");
            } else {
                constraintName = StringUtils.normalizeIdentifier(nns.get(i).getNn_name());
                if (this.constraintNameAlreadyExists(constraintName)) {
                    throw new InvalidObjectException("Constraint name already exists: " + constraintName);
                }
            }
            nnNames.add(constraintName);
            int enableValidateRely = (nns.get(i).isEnable_cstr() ? 4 : 0) + (nns.get(i).isValidate_cstr() ? 2 : 0) + (nns.get(i).isRely_cstr() ? 1 : 0);
            MConstraint muk = new MConstraint(constraintName, 3, 1, null, null, enableValidateRely, parentTable, null, parentCD, null, null, parentIntegerIndex);
            cstrs.add(muk);
        }
        this.pm.makePersistentAll(cstrs);
        return nnNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRole(String roleName, String ownerName) throws InvalidObjectException, MetaException, NoSuchObjectException {
        boolean success = false;
        boolean commited = false;
        try {
            this.openTransaction();
            MRole nameCheck = this.getMRole(roleName);
            if (nameCheck != null) {
                throw new InvalidObjectException("Role " + roleName + " already exists.");
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            MRole mRole = new MRole(roleName, now, ownerName);
            this.pm.makePersistent((Object)mRole);
            commited = this.commitTransaction();
            success = true;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grantRole(Role role, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, NoSuchObjectException, InvalidObjectException {
        boolean success = false;
        boolean commited = false;
        try {
            this.openTransaction();
            MRoleMap roleMap = null;
            try {
                roleMap = this.getMSecurityUserRoleMap(userName, principalType, role.getRoleName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (roleMap != null) {
                throw new InvalidObjectException("Principal " + userName + " already has the role " + role.getRoleName());
            }
            if (principalType == PrincipalType.ROLE) {
                this.validateRole(userName);
            }
            MRole mRole = this.getMRole(role.getRoleName());
            long now = System.currentTimeMillis() / 1000L;
            MRoleMap roleMember = new MRoleMap(userName, principalType.toString(), mRole, (int)now, grantor, grantorType.toString(), grantOption);
            this.pm.makePersistent((Object)roleMember);
            commited = this.commitTransaction();
            success = true;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    private void validateRole(String roleName) throws NoSuchObjectException {
        MRole granteeRole = this.getMRole(roleName);
        if (granteeRole == null) {
            throw new NoSuchObjectException("Role " + roleName + " does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean revokeRole(Role role, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, NoSuchObjectException {
        boolean success = false;
        try {
            this.openTransaction();
            MRoleMap roleMember = this.getMSecurityUserRoleMap(userName, principalType, role.getRoleName());
            if (grantOption) {
                if (!roleMember.getGrantOption()) throw new MetaException("User " + userName + " does not have grant option with role " + role.getRoleName());
                roleMember.setGrantOption(false);
            } else {
                this.pm.deletePersistent((Object)roleMember);
            }
            success = this.commitTransaction();
            return success;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MRoleMap getMSecurityUserRoleMap(String userName, PrincipalType principalType, String roleName) {
        MRoleMap mRoleMember = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MRoleMap.class, "principalName == t1 && principalType == t2 && role.roleName == t3");
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
            query.setUnique(true);
            mRoleMember = (MRoleMap)query.executeWithArray(new Object[]{userName, principalType.toString(), roleName});
            this.pm.retrieve((Object)mRoleMember);
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return mRoleMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeRole(String roleName) throws MetaException, NoSuchObjectException {
        boolean success = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        try {
            this.openTransaction();
            MRole mRol = this.getMRole(roleName);
            this.pm.retrieve((Object)mRol);
            if (mRol != null) {
                List<MDBPrivilege> dbGrants;
                List<MRoleMap> roleMember;
                List<MRoleMap> roleMap = this.listMRoleMembers(mRol.getRoleName());
                if (.CollectionUtils.isNotEmpty(roleMap)) {
                    this.pm.deletePersistentAll(roleMap);
                }
                if (.CollectionUtils.isNotEmpty(roleMember = this.listMSecurityPrincipalMembershipRole(mRol.getRoleName(), PrincipalType.ROLE, queryWrapper))) {
                    this.pm.deletePersistentAll(roleMember);
                }
                queryWrapper.close();
                List<MGlobalPrivilege> userGrants = this.listPrincipalMGlobalGrants(mRol.getRoleName(), PrincipalType.ROLE);
                if (.CollectionUtils.isNotEmpty(userGrants)) {
                    this.pm.deletePersistentAll(userGrants);
                }
                if (.CollectionUtils.isNotEmpty(dbGrants = this.listPrincipalAllDBGrant(mRol.getRoleName(), PrincipalType.ROLE, queryWrapper))) {
                    this.pm.deletePersistentAll(dbGrants);
                }
                queryWrapper.close();
                List<MTablePrivilege> tabPartGrants = this.listPrincipalAllTableGrants(mRol.getRoleName(), PrincipalType.ROLE, queryWrapper);
                if (.CollectionUtils.isNotEmpty(tabPartGrants)) {
                    this.pm.deletePersistentAll(tabPartGrants);
                }
                queryWrapper.close();
                List<MPartitionPrivilege> partGrants = this.listPrincipalAllPartitionGrants(mRol.getRoleName(), PrincipalType.ROLE, queryWrapper);
                if (.CollectionUtils.isNotEmpty(partGrants)) {
                    this.pm.deletePersistentAll(partGrants);
                }
                queryWrapper.close();
                List<MTableColumnPrivilege> tblColumnGrants = this.listPrincipalAllTableColumnGrants(mRol.getRoleName(), PrincipalType.ROLE, queryWrapper);
                if (.CollectionUtils.isNotEmpty(tblColumnGrants)) {
                    this.pm.deletePersistentAll(tblColumnGrants);
                }
                queryWrapper.close();
                List<MPartitionColumnPrivilege> partColumnGrants = this.listPrincipalAllPartitionColumnGrants(mRol.getRoleName(), PrincipalType.ROLE, queryWrapper);
                if (.CollectionUtils.isNotEmpty(partColumnGrants)) {
                    this.pm.deletePersistentAll(partColumnGrants);
                }
                queryWrapper.close();
                this.pm.deletePersistent((Object)mRol);
            }
            success = this.commitTransaction();
        }
        finally {
            this.rollbackAndCleanup(success, queryWrapper);
        }
        return success;
    }

    private Set<String> listAllRolesInHierarchy(String userName, List<String> groupNames) {
        ArrayList<MRoleMap> ret = new ArrayList<MRoleMap>();
        if (userName != null) {
            ret.addAll(this.listMRoles(userName, PrincipalType.USER));
        }
        if (groupNames != null) {
            for (String groupName : groupNames) {
                ret.addAll(this.listMRoles(groupName, PrincipalType.GROUP));
            }
        }
        HashSet<String> roleNames = new HashSet<String>();
        this.getAllRoleAncestors(roleNames, ret);
        return roleNames;
    }

    private void getAllRoleAncestors(Set<String> processedRoleNames, List<MRoleMap> parentRoles) {
        for (MRoleMap parentRole : parentRoles) {
            String parentRoleName = parentRole.getRole().getRoleName();
            if (processedRoleNames.contains(parentRoleName)) continue;
            List<MRoleMap> nextParentRoles = this.listMRoles(parentRoleName, PrincipalType.ROLE);
            processedRoleNames.add(parentRoleName);
            this.getAllRoleAncestors(processedRoleNames, nextParentRoles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MRoleMap> listMRoles(String principalName, PrincipalType principalType) {
        boolean success = false;
        Query query = null;
        ArrayList<MRoleMap> mRoleMember = new ArrayList<MRoleMap>();
        try {
            LOG.debug("Executing listRoles");
            this.openTransaction();
            query = this.pm.newQuery(MRoleMap.class, "principalName == t1 && principalType == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            query.setUnique(false);
            List mRoles = (List)query.executeWithArray(new Object[]{principalName, principalType.toString()});
            this.pm.retrieveAll((Collection)mRoles);
            success = this.commitTransaction();
            mRoleMember.addAll(mRoles);
            LOG.debug("Done retrieving all objects for listRoles");
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        if (principalType == PrincipalType.USER) {
            MRole publicRole = new MRole("public", 0, "public");
            mRoleMember.add(new MRoleMap(principalName, principalType.toString(), publicRole, 0, null, null, false));
        }
        return mRoleMember;
    }

    @Override
    public List<Role> listRoles(String principalName, PrincipalType principalType) {
        ArrayList<Role> result = new ArrayList<Role>();
        List<MRoleMap> roleMaps = this.listMRoles(principalName, principalType);
        if (roleMaps != null) {
            for (MRoleMap roleMap : roleMaps) {
                MRole mrole = roleMap.getRole();
                Role role = new Role(mrole.getRoleName(), mrole.getCreateTime(), mrole.getOwnerName());
                result.add(role);
            }
        }
        return result;
    }

    @Override
    public List<RolePrincipalGrant> listRolesWithGrants(String principalName, PrincipalType principalType) {
        ArrayList<RolePrincipalGrant> result = new ArrayList<RolePrincipalGrant>();
        List<MRoleMap> roleMaps = this.listMRoles(principalName, principalType);
        if (roleMaps != null) {
            for (MRoleMap roleMap : roleMaps) {
                RolePrincipalGrant rolePrinGrant = new RolePrincipalGrant(roleMap.getRole().getRoleName(), roleMap.getPrincipalName(), PrincipalType.valueOf(roleMap.getPrincipalType()), roleMap.getGrantOption(), roleMap.getAddTime(), roleMap.getGrantor(), roleMap.getGrantorType() == null ? null : PrincipalType.valueOf(roleMap.getGrantorType()));
                result.add(rolePrinGrant);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MRoleMap> listMSecurityPrincipalMembershipRole(String roleName, PrincipalType principalType, QueryWrapper queryWrapper) {
        boolean success = false;
        List mRoleMemebership = null;
        try {
            LOG.debug("Executing listMSecurityPrincipalMembershipRole");
            this.openTransaction();
            Query query = queryWrapper.query = this.pm.newQuery(MRoleMap.class, "principalName == t1 && principalType == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            mRoleMemebership = (List)query.execute((Object)roleName, (Object)principalType.toString());
            this.pm.retrieveAll((Collection)mRoleMemebership);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listMSecurityPrincipalMembershipRole");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mRoleMemebership;
    }

    @Override
    public Role getRole(String roleName) throws NoSuchObjectException {
        MRole mRole = this.getMRole(roleName);
        if (mRole == null) {
            throw new NoSuchObjectException(roleName + " role can not be found.");
        }
        Role ret = new Role(mRole.getRoleName(), mRole.getCreateTime(), mRole.getOwnerName());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MRole getMRole(String roleName) {
        MRole mrole = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MRole.class, "roleName == t1");
            query.declareParameters("java.lang.String t1");
            query.setUnique(true);
            mrole = (MRole)query.execute((Object)roleName);
            this.pm.retrieve((Object)mrole);
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return mrole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listRoleNames() {
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listAllRoleNames");
            query = this.pm.newQuery("select roleName from org.apache.hadoop.hive.metastore.model.MRole");
            query.setResult("roleName");
            Collection names = (Collection)query.execute();
            ArrayList<String> roleNames = new ArrayList<String>();
            Iterator i = names.iterator();
            while (i.hasNext()) {
                roleNames.add((String)i.next());
            }
            success = this.commitTransaction();
            ArrayList<String> arrayList = roleNames;
            this.rollbackAndCleanup(success, query);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalPrivilegeSet getUserPrivilegeSet(String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        boolean commited = false;
        PrincipalPrivilegeSet ret = new PrincipalPrivilegeSet();
        try {
            List<MGlobalPrivilege> user;
            this.openTransaction();
            if (userName != null && .CollectionUtils.isNotEmpty(user = this.listPrincipalMGlobalGrants(userName, PrincipalType.USER))) {
                HashMap<String, List<PrivilegeGrantInfo>> userPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(user.size());
                for (int i = 0; i < user.size(); ++i) {
                    MGlobalPrivilege item = user.get(i);
                    grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
                }
                userPriv.put(userName, grantInfos);
                ret.setUserPrivileges(userPriv);
            }
            if (.CollectionUtils.isNotEmpty(groupNames)) {
                HashMap<String, List<PrivilegeGrantInfo>> groupPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String groupName : groupNames) {
                    List<MGlobalPrivilege> group = this.listPrincipalMGlobalGrants(groupName, PrincipalType.GROUP);
                    if (!.CollectionUtils.isNotEmpty(group)) continue;
                    ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(group.size());
                    for (int i = 0; i < group.size(); ++i) {
                        MGlobalPrivilege item = group.get(i);
                        grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
                    }
                    groupPriv.put(groupName, grantInfos);
                }
                ret.setGroupPrivileges(groupPriv);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return ret;
    }

    private List<PrivilegeGrantInfo> getDBPrivilege(String catName, String dbName, String principalName, PrincipalType principalType) throws InvalidObjectException, MetaException {
        List<MDBPrivilege> userNameDbPriv;
        catName = StringUtils.normalizeIdentifier(catName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        if (principalName != null && .CollectionUtils.isNotEmpty(userNameDbPriv = this.listPrincipalMDBGrants(principalName, principalType, catName, dbName))) {
            ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(userNameDbPriv.size());
            for (int i = 0; i < userNameDbPriv.size(); ++i) {
                MDBPrivilege item = userNameDbPriv.get(i);
                grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
            }
            return grantInfos;
        }
        return new ArrayList<PrivilegeGrantInfo>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalPrivilegeSet getDBPrivilegeSet(String catName, String dbName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        boolean commited = false;
        catName = StringUtils.normalizeIdentifier(catName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        PrincipalPrivilegeSet ret = new PrincipalPrivilegeSet();
        try {
            Set<String> roleNames;
            this.openTransaction();
            if (userName != null) {
                HashMap<String, List<PrivilegeGrantInfo>> dbUserPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                dbUserPriv.put(userName, this.getDBPrivilege(catName, dbName, userName, PrincipalType.USER));
                ret.setUserPrivileges(dbUserPriv);
            }
            if (.CollectionUtils.isNotEmpty(groupNames)) {
                HashMap<String, List<PrivilegeGrantInfo>> dbGroupPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String groupName : groupNames) {
                    dbGroupPriv.put(groupName, this.getDBPrivilege(catName, dbName, groupName, PrincipalType.GROUP));
                }
                ret.setGroupPrivileges(dbGroupPriv);
            }
            if (.CollectionUtils.isNotEmpty(roleNames = this.listAllRolesInHierarchy(userName, groupNames))) {
                HashMap<String, List<PrivilegeGrantInfo>> dbRolePriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String roleName : roleNames) {
                    dbRolePriv.put(roleName, this.getDBPrivilege(catName, dbName, roleName, PrincipalType.ROLE));
                }
                ret.setRolePrivileges(dbRolePriv);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalPrivilegeSet getPartitionPrivilegeSet(String catName, String dbName, String tableName, String partition, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        boolean commited = false;
        PrincipalPrivilegeSet ret = new PrincipalPrivilegeSet();
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        catName = StringUtils.normalizeIdentifier(catName);
        try {
            Set<String> roleNames;
            this.openTransaction();
            if (userName != null) {
                HashMap<String, List<PrivilegeGrantInfo>> partUserPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                partUserPriv.put(userName, this.getPartitionPrivilege(catName, dbName, tableName, partition, userName, PrincipalType.USER));
                ret.setUserPrivileges(partUserPriv);
            }
            if (.CollectionUtils.isNotEmpty(groupNames)) {
                HashMap<String, List<PrivilegeGrantInfo>> partGroupPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String groupName : groupNames) {
                    partGroupPriv.put(groupName, this.getPartitionPrivilege(catName, dbName, tableName, partition, groupName, PrincipalType.GROUP));
                }
                ret.setGroupPrivileges(partGroupPriv);
            }
            if (.CollectionUtils.isNotEmpty(roleNames = this.listAllRolesInHierarchy(userName, groupNames))) {
                HashMap<String, List<PrivilegeGrantInfo>> partRolePriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String roleName : roleNames) {
                    partRolePriv.put(roleName, this.getPartitionPrivilege(catName, dbName, tableName, partition, roleName, PrincipalType.ROLE));
                }
                ret.setRolePrivileges(partRolePriv);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalPrivilegeSet getTablePrivilegeSet(String catName, String dbName, String tableName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        boolean commited = false;
        PrincipalPrivilegeSet ret = new PrincipalPrivilegeSet();
        tableName = StringUtils.normalizeIdentifier(tableName);
        catName = StringUtils.normalizeIdentifier(catName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        try {
            Set<String> roleNames;
            this.openTransaction();
            if (userName != null) {
                HashMap<String, List<PrivilegeGrantInfo>> tableUserPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                tableUserPriv.put(userName, this.getTablePrivilege(catName, dbName, tableName, userName, PrincipalType.USER));
                ret.setUserPrivileges(tableUserPriv);
            }
            if (.CollectionUtils.isNotEmpty(groupNames)) {
                HashMap<String, List<PrivilegeGrantInfo>> tableGroupPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String groupName : groupNames) {
                    tableGroupPriv.put(groupName, this.getTablePrivilege(catName, dbName, tableName, groupName, PrincipalType.GROUP));
                }
                ret.setGroupPrivileges(tableGroupPriv);
            }
            if (.CollectionUtils.isNotEmpty(roleNames = this.listAllRolesInHierarchy(userName, groupNames))) {
                HashMap<String, List<PrivilegeGrantInfo>> tableRolePriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String roleName : roleNames) {
                    tableRolePriv.put(roleName, this.getTablePrivilege(catName, dbName, tableName, roleName, PrincipalType.ROLE));
                }
                ret.setRolePrivileges(tableRolePriv);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalPrivilegeSet getColumnPrivilegeSet(String catName, String dbName, String tableName, String partitionName, String columnName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        columnName = StringUtils.normalizeIdentifier(columnName);
        catName = StringUtils.normalizeIdentifier(catName);
        boolean commited = false;
        PrincipalPrivilegeSet ret = new PrincipalPrivilegeSet();
        try {
            Set<String> roleNames;
            this.openTransaction();
            if (userName != null) {
                HashMap<String, List<PrivilegeGrantInfo>> columnUserPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                columnUserPriv.put(userName, this.getColumnPrivilege(catName, dbName, tableName, columnName, partitionName, userName, PrincipalType.USER));
                ret.setUserPrivileges(columnUserPriv);
            }
            if (.CollectionUtils.isNotEmpty(groupNames)) {
                HashMap<String, List<PrivilegeGrantInfo>> columnGroupPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String groupName : groupNames) {
                    columnGroupPriv.put(groupName, this.getColumnPrivilege(catName, dbName, tableName, columnName, partitionName, groupName, PrincipalType.GROUP));
                }
                ret.setGroupPrivileges(columnGroupPriv);
            }
            if (.CollectionUtils.isNotEmpty(roleNames = this.listAllRolesInHierarchy(userName, groupNames))) {
                HashMap<String, List<PrivilegeGrantInfo>> columnRolePriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String roleName : roleNames) {
                    columnRolePriv.put(roleName, this.getColumnPrivilege(catName, dbName, tableName, columnName, partitionName, roleName, PrincipalType.ROLE));
                }
                ret.setRolePrivileges(columnRolePriv);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return ret;
    }

    private List<PrivilegeGrantInfo> getPartitionPrivilege(String catName, String dbName, String tableName, String partName, String principalName, PrincipalType principalType) {
        List<MPartitionPrivilege> userNameTabPartPriv;
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        catName = StringUtils.normalizeIdentifier(catName);
        if (principalName != null && .CollectionUtils.isNotEmpty(userNameTabPartPriv = this.listPrincipalMPartitionGrants(principalName, principalType, catName, dbName, tableName, partName))) {
            ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(userNameTabPartPriv.size());
            for (int i = 0; i < userNameTabPartPriv.size(); ++i) {
                MPartitionPrivilege item = userNameTabPartPriv.get(i);
                grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
            }
            return grantInfos;
        }
        return new ArrayList<PrivilegeGrantInfo>(0);
    }

    private PrincipalType getPrincipalTypeFromStr(String str) {
        return str == null ? null : PrincipalType.valueOf(str);
    }

    private List<PrivilegeGrantInfo> getTablePrivilege(String catName, String dbName, String tableName, String principalName, PrincipalType principalType) {
        List<MTablePrivilege> userNameTabPartPriv;
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        catName = StringUtils.normalizeIdentifier(catName);
        if (principalName != null && .CollectionUtils.isNotEmpty(userNameTabPartPriv = this.listAllMTableGrants(principalName, principalType, catName, dbName, tableName))) {
            ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(userNameTabPartPriv.size());
            for (int i = 0; i < userNameTabPartPriv.size(); ++i) {
                MTablePrivilege item = userNameTabPartPriv.get(i);
                grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
            }
            return grantInfos;
        }
        return new ArrayList<PrivilegeGrantInfo>(0);
    }

    private List<PrivilegeGrantInfo> getColumnPrivilege(String catName, String dbName, String tableName, String columnName, String partitionName, String principalName, PrincipalType principalType) {
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        columnName = StringUtils.normalizeIdentifier(columnName);
        catName = StringUtils.normalizeIdentifier(catName);
        if (partitionName == null) {
            List<MTableColumnPrivilege> userNameColumnPriv = this.listPrincipalMTableColumnGrants(principalName, principalType, catName, dbName, tableName, columnName);
            if (.CollectionUtils.isNotEmpty(userNameColumnPriv)) {
                ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(userNameColumnPriv.size());
                for (int i = 0; i < userNameColumnPriv.size(); ++i) {
                    MTableColumnPrivilege item = userNameColumnPriv.get(i);
                    grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
                }
                return grantInfos;
            }
        } else {
            List<MPartitionColumnPrivilege> userNameColumnPriv = this.listPrincipalMPartitionColumnGrants(principalName, principalType, catName, dbName, tableName, partitionName, columnName);
            if (.CollectionUtils.isNotEmpty(userNameColumnPriv)) {
                ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(userNameColumnPriv.size());
                for (int i = 0; i < userNameColumnPriv.size(); ++i) {
                    MPartitionColumnPrivilege item = userNameColumnPriv.get(i);
                    grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
                }
                return grantInfos;
            }
        }
        return new ArrayList<PrivilegeGrantInfo>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grantPrivileges(PrivilegeBag privileges) throws InvalidObjectException, MetaException, NoSuchObjectException {
        boolean committed = false;
        int now = (int)(System.currentTimeMillis() / 1000L);
        try {
            this.openTransaction();
            ArrayList<Object> persistentObjs = new ArrayList<Object>();
            List<HiveObjectPrivilege> privilegeList = privileges.getPrivileges();
            if (.CollectionUtils.isNotEmpty(privilegeList)) {
                Iterator<HiveObjectPrivilege> privIter = privilegeList.iterator();
                HashSet<String> privSet = new HashSet<String>();
                while (privIter.hasNext()) {
                    String privilege;
                    int privilege22;
                    MTable tblObj;
                    int privilege32;
                    String catName;
                    HiveObjectPrivilege privDef = privIter.next();
                    HiveObjectRef hiveObject = privDef.getHiveObject();
                    String privilegeStr = privDef.getGrantInfo().getPrivilege();
                    String[] privs = privilegeStr.split(",");
                    String userName = privDef.getPrincipalName();
                    String authorizer = privDef.getAuthorizer();
                    PrincipalType principalType = privDef.getPrincipalType();
                    String grantor = privDef.getGrantInfo().getGrantor();
                    String grantorType = privDef.getGrantInfo().getGrantorType().toString();
                    boolean grantOption = privDef.getGrantInfo().isGrantOption();
                    privSet.clear();
                    if (principalType == PrincipalType.ROLE) {
                        this.validateRole(userName);
                    }
                    String string = catName = hiveObject.isSetCatName() ? hiveObject.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
                    if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
                        List<MGlobalPrivilege> globalPrivs = this.listPrincipalMGlobalGrants(userName, principalType, authorizer);
                        if (globalPrivs != null) {
                            for (MGlobalPrivilege priv : globalPrivs) {
                                if (!priv.getGrantor().equalsIgnoreCase(grantor)) continue;
                                privSet.add(priv.getPrivilege());
                            }
                        }
                        for (String privilege32 : privs) {
                            if (privSet.contains(privilege32)) {
                                throw new InvalidObjectException((String)privilege32 + " is already granted by " + grantor);
                            }
                            MGlobalPrivilege mGlobalPrivs = new MGlobalPrivilege(userName, principalType.toString(), privilege32, now, grantor, grantorType, grantOption, authorizer);
                            persistentObjs.add(mGlobalPrivs);
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                        MDatabase dbObj = this.getMDatabase(catName, hiveObject.getDbName());
                        if (dbObj == null) continue;
                        List<MDBPrivilege> dbPrivs = this.listPrincipalMDBGrants(userName, principalType, catName, hiveObject.getDbName(), authorizer);
                        if (dbPrivs != null) {
                            for (MDBPrivilege priv2 : dbPrivs) {
                                if (!priv2.getGrantor().equalsIgnoreCase(grantor)) continue;
                                privSet.add(priv2.getPrivilege());
                            }
                        }
                        String[] priv = privs;
                        int priv2 = priv.length;
                        for (privilege32 = 0; privilege32 < priv2; ++privilege32) {
                            String privilege4 = priv[privilege32];
                            if (privSet.contains(privilege4)) {
                                throw new InvalidObjectException(privilege4 + " is already granted on database " + hiveObject.getDbName() + " by " + grantor);
                            }
                            MDBPrivilege mDb = new MDBPrivilege(userName, principalType.toString(), dbObj, privilege4, now, grantor, grantorType, grantOption, authorizer);
                            persistentObjs.add(mDb);
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                        tblObj = this.getMTable(catName, hiveObject.getDbName(), hiveObject.getObjectName());
                        if (tblObj == null) continue;
                        List<MTablePrivilege> tablePrivs = this.listAllMTableGrants(userName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName(), authorizer);
                        if (tablePrivs != null) {
                            for (MTablePrivilege priv3 : tablePrivs) {
                                if (priv3.getGrantor() == null || !priv3.getGrantor().equalsIgnoreCase(grantor)) continue;
                                privSet.add(priv3.getPrivilege());
                            }
                        }
                        String[] priv = privs;
                        int priv3 = priv.length;
                        for (privilege32 = 0; privilege32 < priv3; ++privilege32) {
                            String privilege22 = priv[privilege32];
                            if (privSet.contains(privilege22)) {
                                throw new InvalidObjectException(privilege22 + " is already granted on table [" + hiveObject.getDbName() + "," + hiveObject.getObjectName() + "] by " + grantor);
                            }
                            MTablePrivilege mTab = new MTablePrivilege(userName, principalType.toString(), tblObj, privilege22, now, grantor, grantorType, grantOption, authorizer);
                            persistentObjs.add(mTab);
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                        MPartition partObj = this.getMPartition(catName, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues());
                        String partName = null;
                        if (partObj == null) continue;
                        partName = partObj.getPartitionName();
                        List<MPartitionPrivilege> partPrivs = this.listPrincipalMPartitionGrants(userName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName(), partObj.getPartitionName(), authorizer);
                        if (partPrivs != null) {
                            for (MPartitionPrivilege priv : partPrivs) {
                                if (!priv.getGrantor().equalsIgnoreCase(grantor)) continue;
                                privSet.add(priv.getPrivilege());
                            }
                        }
                        String[] priv3 = privs;
                        int priv = priv3.length;
                        for (privilege22 = 0; privilege22 < priv; ++privilege22) {
                            privilege = priv3[privilege22];
                            if (privSet.contains(privilege)) {
                                throw new InvalidObjectException(privilege + " is already granted on partition [" + hiveObject.getDbName() + "," + hiveObject.getObjectName() + "," + partName + "] by " + grantor);
                            }
                            MPartitionPrivilege mTab = new MPartitionPrivilege(userName, principalType.toString(), partObj, privilege, now, grantor, grantorType, grantOption, authorizer);
                            persistentObjs.add(mTab);
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() != HiveObjectType.COLUMN || (tblObj = this.getMTable(catName, hiveObject.getDbName(), hiveObject.getObjectName())) == null) continue;
                    if (hiveObject.getPartValues() != null) {
                        MPartition partObj = null;
                        List<MPartitionColumnPrivilege> colPrivs = null;
                        partObj = this.getMPartition(catName, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues());
                        if (partObj == null) continue;
                        colPrivs = this.listPrincipalMPartitionColumnGrants(userName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName(), partObj.getPartitionName(), hiveObject.getColumnName(), authorizer);
                        if (colPrivs != null) {
                            for (MPartitionColumnPrivilege priv : colPrivs) {
                                if (!priv.getGrantor().equalsIgnoreCase(grantor)) continue;
                                privSet.add(priv.getPrivilege());
                            }
                        }
                        String[] priv3 = privs;
                        int n = priv3.length;
                        for (privilege22 = 0; privilege22 < n; ++privilege22) {
                            privilege = priv3[privilege22];
                            if (privSet.contains(privilege)) {
                                throw new InvalidObjectException(privilege + " is already granted on column " + hiveObject.getColumnName() + " [" + hiveObject.getDbName() + "," + hiveObject.getObjectName() + "," + partObj.getPartitionName() + "] by " + grantor);
                            }
                            MPartitionColumnPrivilege mCol = new MPartitionColumnPrivilege(userName, principalType.toString(), partObj, hiveObject.getColumnName(), privilege, now, grantor, grantorType, grantOption, authorizer);
                            persistentObjs.add(mCol);
                        }
                        continue;
                    }
                    List<MTableColumnPrivilege> colPrivs = null;
                    colPrivs = this.listPrincipalMTableColumnGrants(userName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getColumnName(), authorizer);
                    if (colPrivs != null) {
                        for (MTableColumnPrivilege priv : colPrivs) {
                            if (!priv.getGrantor().equalsIgnoreCase(grantor)) continue;
                            privSet.add(priv.getPrivilege());
                        }
                    }
                    for (String privilege5 : privs) {
                        if (privSet.contains(privilege5)) {
                            throw new InvalidObjectException(privilege5 + " is already granted on column " + hiveObject.getColumnName() + " [" + hiveObject.getDbName() + "," + hiveObject.getObjectName() + "] by " + grantor);
                        }
                        MTableColumnPrivilege mCol = new MTableColumnPrivilege(userName, principalType.toString(), tblObj, hiveObject.getColumnName(), privilege5, now, grantor, grantorType, grantOption, authorizer);
                        persistentObjs.add(mCol);
                    }
                }
            }
            if (.CollectionUtils.isNotEmpty(persistentObjs)) {
                this.pm.makePersistentAll(persistentObjs);
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
        return committed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) throws InvalidObjectException, MetaException, NoSuchObjectException {
        boolean committed = false;
        try {
            this.openTransaction();
            ArrayList<Object> persistentObjs = new ArrayList<Object>();
            List<HiveObjectPrivilege> privilegeList = privileges.getPrivileges();
            if (.CollectionUtils.isNotEmpty(privilegeList)) {
                for (HiveObjectPrivilege privDef : privilegeList) {
                    String colPriv;
                    List<Object> mSecCol;
                    int n;
                    String privilege;
                    int n2;
                    String catName;
                    HiveObjectRef hiveObject = privDef.getHiveObject();
                    String privilegeStr = privDef.getGrantInfo().getPrivilege();
                    if (privilegeStr == null || privilegeStr.trim().equals("")) continue;
                    String[] privs = privilegeStr.split(",");
                    String userName = privDef.getPrincipalName();
                    PrincipalType principalType = privDef.getPrincipalType();
                    String string = catName = hiveObject.isSetCatName() ? hiveObject.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
                    if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
                        List<MGlobalPrivilege> mSecUser = this.listPrincipalMGlobalGrants(userName, principalType);
                        boolean found = false;
                        if (mSecUser == null) continue;
                        for (String privilege2 : privs) {
                            for (MGlobalPrivilege userGrant : mSecUser) {
                                String userGrantPrivs = userGrant.getPrivilege();
                                if (!privilege2.equals(userGrantPrivs)) continue;
                                found = true;
                                if (grantOption) {
                                    if (userGrant.getGrantOption()) {
                                        userGrant.setGrantOption(false);
                                    } else {
                                        throw new MetaException("User " + userName + " does not have grant option with privilege " + privilege2);
                                    }
                                }
                                persistentObjs.add(userGrant);
                                break;
                            }
                            if (found) continue;
                            throw new InvalidObjectException("No user grant found for privileges " + privilege2);
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                        MDatabase dbObj = this.getMDatabase(catName, hiveObject.getDbName());
                        if (dbObj == null) continue;
                        String db = hiveObject.getDbName();
                        boolean found = false;
                        List<MDBPrivilege> dbGrants = this.listPrincipalMDBGrants(userName, principalType, catName, db);
                        String[] stringArray = privs;
                        int privilege2 = stringArray.length;
                        for (n2 = 0; n2 < privilege2; ++n2) {
                            privilege = stringArray[n2];
                            for (MDBPrivilege dbGrant : dbGrants) {
                                String dbGrantPriv = dbGrant.getPrivilege();
                                if (!privilege.equals(dbGrantPriv)) continue;
                                found = true;
                                if (grantOption) {
                                    if (dbGrant.getGrantOption()) {
                                        dbGrant.setGrantOption(false);
                                    } else {
                                        throw new MetaException("User " + userName + " does not have grant option with privilege " + privilege);
                                    }
                                }
                                persistentObjs.add(dbGrant);
                                break;
                            }
                            if (found) continue;
                            throw new InvalidObjectException("No database grant found for privileges " + privilege + " on database " + db);
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                        boolean found = false;
                        List<MTablePrivilege> tableGrants = this.listAllMTableGrants(userName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName());
                        for (String privilege3 : privs) {
                            for (MTablePrivilege tabGrant : tableGrants) {
                                String tableGrantPriv = tabGrant.getPrivilege();
                                if (!privilege3.equalsIgnoreCase(tableGrantPriv)) continue;
                                found = true;
                                if (grantOption) {
                                    if (tabGrant.getGrantOption()) {
                                        tabGrant.setGrantOption(false);
                                    } else {
                                        throw new MetaException("User " + userName + " does not have grant option with privilege " + privilege3);
                                    }
                                }
                                persistentObjs.add(tabGrant);
                                break;
                            }
                            if (found) continue;
                            throw new InvalidObjectException("No grant (" + privilege3 + ") found  on table " + hiveObject.getObjectName() + ", database is " + hiveObject.getDbName());
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                        boolean found = false;
                        Table tabObj = this.getTable(catName, hiveObject.getDbName(), hiveObject.getObjectName());
                        String partName = null;
                        if (hiveObject.getPartValues() != null) {
                            partName = Warehouse.makePartName(tabObj.getPartitionKeys(), hiveObject.getPartValues());
                        }
                        List<MPartitionPrivilege> partitionGrants = this.listPrincipalMPartitionGrants(userName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName(), partName);
                        String[] stringArray = privs;
                        n = stringArray.length;
                        for (n2 = 0; n2 < n; ++n2) {
                            privilege = stringArray[n2];
                            for (MPartitionPrivilege partGrant : partitionGrants) {
                                String partPriv = partGrant.getPrivilege();
                                if (!partPriv.equalsIgnoreCase(privilege)) continue;
                                found = true;
                                if (grantOption) {
                                    if (partGrant.getGrantOption()) {
                                        partGrant.setGrantOption(false);
                                    } else {
                                        throw new MetaException("User " + userName + " does not have grant option with privilege " + privilege);
                                    }
                                }
                                persistentObjs.add(partGrant);
                                break;
                            }
                            if (found) continue;
                            throw new InvalidObjectException("No grant (" + privilege + ") found  on table " + tabObj.getTableName() + ", partition is " + partName + ", database is " + tabObj.getDbName());
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() != HiveObjectType.COLUMN) continue;
                    Table tabObj = this.getTable(catName, hiveObject.getDbName(), hiveObject.getObjectName());
                    String partName = null;
                    if (hiveObject.getPartValues() != null) {
                        partName = Warehouse.makePartName(tabObj.getPartitionKeys(), hiveObject.getPartValues());
                    }
                    if (partName != null) {
                        mSecCol = this.listPrincipalMPartitionColumnGrants(userName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName(), partName, hiveObject.getColumnName());
                        boolean found = false;
                        if (mSecCol == null) continue;
                        String[] stringArray = privs;
                        n = stringArray.length;
                        for (n2 = 0; n2 < n; ++n2) {
                            privilege = stringArray[n2];
                            for (Object col : mSecCol) {
                                colPriv = ((MPartitionColumnPrivilege)col).getPrivilege();
                                if (!colPriv.equalsIgnoreCase(privilege)) continue;
                                found = true;
                                if (grantOption) {
                                    if (((MPartitionColumnPrivilege)col).getGrantOption()) {
                                        ((MPartitionColumnPrivilege)col).setGrantOption(false);
                                    } else {
                                        throw new MetaException("User " + userName + " does not have grant option with privilege " + privilege);
                                    }
                                }
                                persistentObjs.add(col);
                                break;
                            }
                            if (found) continue;
                            throw new InvalidObjectException("No grant (" + privilege + ") found  on table " + tabObj.getTableName() + ", partition is " + partName + ", column name = " + hiveObject.getColumnName() + ", database is " + tabObj.getDbName());
                        }
                        continue;
                    }
                    mSecCol = this.listPrincipalMTableColumnGrants(userName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getColumnName());
                    boolean found = false;
                    if (mSecCol == null) continue;
                    String[] stringArray = privs;
                    n = stringArray.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        privilege = stringArray[n2];
                        for (Object col : mSecCol) {
                            colPriv = ((MTableColumnPrivilege)col).getPrivilege();
                            if (!colPriv.equalsIgnoreCase(privilege)) continue;
                            found = true;
                            if (grantOption) {
                                if (((MTableColumnPrivilege)col).getGrantOption()) {
                                    ((MTableColumnPrivilege)col).setGrantOption(false);
                                } else {
                                    throw new MetaException("User " + userName + " does not have grant option with privilege " + privilege);
                                }
                            }
                            persistentObjs.add(col);
                            break;
                        }
                        if (found) continue;
                        throw new InvalidObjectException("No grant (" + privilege + ") found  on table " + tabObj.getTableName() + ", column name = " + hiveObject.getColumnName() + ", database is " + tabObj.getDbName());
                    }
                }
            }
            if (.CollectionUtils.isNotEmpty(persistentObjs) && !grantOption) {
                this.pm.deletePersistentAll(persistentObjs);
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
        return committed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refreshPrivileges(HiveObjectRef objToRefresh, String authorizer, PrivilegeBag grantPrivileges) throws InvalidObjectException, MetaException, NoSuchObjectException {
        boolean committed = false;
        try {
            this.openTransaction();
            TreeSet<HiveObjectPrivilege> revokePrivilegeSet = new TreeSet<HiveObjectPrivilege>(new PrivilegeWithoutCreateTimeComparator());
            TreeSet<HiveObjectPrivilege> grantPrivilegeSet = new TreeSet<HiveObjectPrivilege>(new PrivilegeWithoutCreateTimeComparator());
            List<HiveObjectPrivilege> grants = null;
            String catName = objToRefresh.isSetCatName() ? objToRefresh.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            switch (objToRefresh.getObjectType()) {
                case DATABASE: {
                    grants = this.listDBGrantsAll(catName, objToRefresh.getDbName(), authorizer);
                    break;
                }
                case TABLE: {
                    grants = this.listTableGrantsAll(catName, objToRefresh.getDbName(), objToRefresh.getObjectName(), authorizer);
                    break;
                }
                case COLUMN: {
                    Preconditions.checkArgument(objToRefresh.getColumnName() == null, "columnName must be null");
                    grants = this.convertTableCols(this.listTableAllColumnGrants(catName, objToRefresh.getDbName(), objToRefresh.getObjectName(), authorizer));
                    break;
                }
                default: {
                    throw new MetaException("Unexpected object type " + (Object)((Object)objToRefresh.getObjectType()));
                }
            }
            if (grants != null) {
                for (HiveObjectPrivilege grant : grants) {
                    revokePrivilegeSet.add(grant);
                }
            }
            if (grantPrivileges.getPrivileges() != null) {
                for (HiveObjectPrivilege grantPrivilege : grantPrivileges.getPrivileges()) {
                    if (revokePrivilegeSet.contains(grantPrivilege)) {
                        revokePrivilegeSet.remove(grantPrivilege);
                        continue;
                    }
                    grantPrivilegeSet.add(grantPrivilege);
                }
            }
            if (!revokePrivilegeSet.isEmpty()) {
                PrivilegeBag remainingRevokePrivileges = new PrivilegeBag();
                for (HiveObjectPrivilege revokePrivilege : revokePrivilegeSet) {
                    remainingRevokePrivileges.addToPrivileges(revokePrivilege);
                }
                this.revokePrivileges(remainingRevokePrivileges, false);
            }
            if (!grantPrivilegeSet.isEmpty()) {
                PrivilegeBag remainingGrantPrivileges = new PrivilegeBag();
                for (HiveObjectPrivilege grantPrivilege : grantPrivilegeSet) {
                    remainingGrantPrivileges.addToPrivileges(grantPrivilege);
                }
                this.grantPrivileges(remainingGrantPrivileges);
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
        return committed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MRoleMap> listMRoleMembers(String roleName) {
        boolean success = false;
        Query query = null;
        ArrayList<MRoleMap> mRoleMemeberList = new ArrayList<MRoleMap>();
        try {
            LOG.debug("Executing listRoleMembers");
            this.openTransaction();
            query = this.pm.newQuery(MRoleMap.class, "role.roleName == t1");
            query.declareParameters("java.lang.String t1");
            query.setUnique(false);
            List mRoles = (List)query.execute((Object)roleName);
            this.pm.retrieveAll((Collection)mRoles);
            success = this.commitTransaction();
            mRoleMemeberList.addAll(mRoles);
            LOG.debug("Done retrieving all objects for listRoleMembers");
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        return mRoleMemeberList;
    }

    @Override
    public List<RolePrincipalGrant> listRoleMembers(String roleName) {
        List<MRoleMap> roleMaps = this.listMRoleMembers(roleName);
        ArrayList<RolePrincipalGrant> rolePrinGrantList = new ArrayList<RolePrincipalGrant>();
        if (roleMaps != null) {
            for (MRoleMap roleMap : roleMaps) {
                RolePrincipalGrant rolePrinGrant = new RolePrincipalGrant(roleMap.getRole().getRoleName(), roleMap.getPrincipalName(), PrincipalType.valueOf(roleMap.getPrincipalType()), roleMap.getGrantOption(), roleMap.getAddTime(), roleMap.getGrantor(), roleMap.getGrantorType() == null ? null : PrincipalType.valueOf(roleMap.getGrantorType()));
                rolePrinGrantList.add(rolePrinGrant);
            }
        }
        return rolePrinGrantList;
    }

    private List<MGlobalPrivilege> listPrincipalMGlobalGrants(String principalName, PrincipalType principalType) {
        return this.listPrincipalMGlobalGrants(principalName, principalType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MGlobalPrivilege> listPrincipalMGlobalGrants(String principalName, PrincipalType principalType, String authorizer) {
        boolean commited = false;
        Query query = null;
        ArrayList<MGlobalPrivilege> userNameDbPriv = new ArrayList<MGlobalPrivilege>();
        try {
            List mPrivs = null;
            this.openTransaction();
            if (principalName != null) {
                if (authorizer != null) {
                    query = this.pm.newQuery(MGlobalPrivilege.class, "principalName == t1 && principalType == t2 && authorizer == t3");
                    query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
                    mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), authorizer});
                } else {
                    query = this.pm.newQuery(MGlobalPrivilege.class, "principalName == t1 && principalType == t2 ");
                    query.declareParameters("java.lang.String t1, java.lang.String t2");
                    mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString()});
                }
                this.pm.retrieveAll((Collection)mPrivs);
            }
            commited = this.commitTransaction();
            if (mPrivs != null) {
                userNameDbPriv.addAll(mPrivs);
            }
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return userNameDbPriv;
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalGlobalGrants(String principalName, PrincipalType principalType) {
        List<MGlobalPrivilege> mUsers = this.listPrincipalMGlobalGrants(principalName, principalType);
        if (mUsers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (int i = 0; i < mUsers.size(); ++i) {
            MGlobalPrivilege sUsr = mUsers.get(i);
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null);
            HiveObjectPrivilege secUser = new HiveObjectPrivilege(objectRef, sUsr.getPrincipalName(), principalType, new PrivilegeGrantInfo(sUsr.getPrivilege(), sUsr.getCreateTime(), sUsr.getGrantor(), PrincipalType.valueOf(sUsr.getGrantorType()), sUsr.getGrantOption()), sUsr.getAuthorizer());
            result.add(secUser);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listGlobalGrantsAll() {
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MGlobalPrivilege.class);
            List userNameDbPriv = (List)query.execute();
            this.pm.retrieveAll((Collection)userNameDbPriv);
            commited = this.commitTransaction();
            List<HiveObjectPrivilege> list = this.convertGlobal(userNameDbPriv);
            this.rollbackAndCleanup(commited, query);
            return list;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    private List<HiveObjectPrivilege> convertGlobal(List<MGlobalPrivilege> privs) {
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (MGlobalPrivilege priv : privs) {
            String pname = priv.getPrincipalName();
            String authorizer = priv.getAuthorizer();
            PrincipalType ptype = PrincipalType.valueOf(priv.getPrincipalType());
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null);
            PrivilegeGrantInfo grantor = new PrivilegeGrantInfo(priv.getPrivilege(), priv.getCreateTime(), priv.getGrantor(), PrincipalType.valueOf(priv.getGrantorType()), priv.getGrantOption());
            result.add(new HiveObjectPrivilege(objectRef, pname, ptype, grantor, authorizer));
        }
        return result;
    }

    private List<MDBPrivilege> listPrincipalMDBGrants(String principalName, PrincipalType principalType, String catName, String dbName) {
        return this.listPrincipalMDBGrants(principalName, principalType, catName, dbName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MDBPrivilege> listPrincipalMDBGrants(String principalName, PrincipalType principalType, String catName, String dbName, String authorizer) {
        boolean success = false;
        Query query = null;
        ArrayList<MDBPrivilege> mSecurityDBList = new ArrayList<MDBPrivilege>();
        dbName = StringUtils.normalizeIdentifier(dbName);
        try {
            List mPrivs;
            LOG.debug("Executing listPrincipalDBGrants");
            this.openTransaction();
            if (authorizer != null) {
                query = this.pm.newQuery(MDBPrivilege.class, "principalName == t1 && principalType == t2 && database.name == t3 && database.catalogName == t4 && authorizer == t5");
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4, java.lang.String t5");
                mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), dbName, catName, authorizer});
            } else {
                query = this.pm.newQuery(MDBPrivilege.class, "principalName == t1 && principalType == t2 && database.name == t3 && database.catalogName == t4");
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4");
                mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), dbName, catName});
            }
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityDBList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listPrincipalDBGrants");
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        return mSecurityDBList;
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalDBGrants(String principalName, PrincipalType principalType, String catName, String dbName) {
        List<MDBPrivilege> mDbs = this.listPrincipalMDBGrants(principalName, principalType, catName, dbName);
        if (mDbs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (int i = 0; i < mDbs.size(); ++i) {
            MDBPrivilege sDB = mDbs.get(i);
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null);
            objectRef.setCatName(catName);
            HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sDB.getPrincipalName(), principalType, new PrivilegeGrantInfo(sDB.getPrivilege(), sDB.getCreateTime(), sDB.getGrantor(), PrincipalType.valueOf(sDB.getGrantorType()), sDB.getGrantOption()), sDB.getAuthorizer());
            result.add(secObj);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPrincipalDBGrantsAll(String principalName, PrincipalType principalType) {
        try (QueryWrapper queryWrapper = new QueryWrapper();){
            List<HiveObjectPrivilege> list = this.convertDB(this.listPrincipalAllDBGrant(principalName, principalType, queryWrapper));
            return list;
        }
    }

    @Override
    public List<HiveObjectPrivilege> listDBGrantsAll(String catName, String dbName) {
        return this.listDBGrantsAll(catName, dbName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HiveObjectPrivilege> listDBGrantsAll(String catName, String dbName, String authorizer) {
        try (QueryWrapper queryWrapper = new QueryWrapper();){
            List<HiveObjectPrivilege> list = this.convertDB(this.listDatabaseGrants(catName, dbName, authorizer, queryWrapper));
            return list;
        }
    }

    private List<HiveObjectPrivilege> convertDB(List<MDBPrivilege> privs) {
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (MDBPrivilege priv : privs) {
            String pname = priv.getPrincipalName();
            String authorizer = priv.getAuthorizer();
            PrincipalType ptype = PrincipalType.valueOf(priv.getPrincipalType());
            String database = priv.getDatabase().getName();
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.DATABASE, database, null, null, null);
            objectRef.setCatName(priv.getDatabase().getCatalogName());
            PrivilegeGrantInfo grantor = new PrivilegeGrantInfo(priv.getPrivilege(), priv.getCreateTime(), priv.getGrantor(), PrincipalType.valueOf(priv.getGrantorType()), priv.getGrantOption());
            result.add(new HiveObjectPrivilege(objectRef, pname, ptype, grantor, authorizer));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MDBPrivilege> listPrincipalAllDBGrant(String principalName, PrincipalType principalType, QueryWrapper queryWrapper) {
        boolean success = false;
        Query query = null;
        List mSecurityDBList = null;
        try {
            LOG.debug("Executing listPrincipalAllDBGrant");
            this.openTransaction();
            if (principalName != null && principalType != null) {
                query = queryWrapper.query = this.pm.newQuery(MDBPrivilege.class, "principalName == t1 && principalType == t2");
                query.declareParameters("java.lang.String t1, java.lang.String t2");
                mSecurityDBList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            } else {
                query = queryWrapper.query = this.pm.newQuery(MDBPrivilege.class);
                mSecurityDBList = (List)query.execute();
            }
            this.pm.retrieveAll((Collection)mSecurityDBList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllDBGrant");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityDBList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MTablePrivilege> listAllTableGrants(String catName, String dbName, String tableName) {
        boolean success = false;
        Query query = null;
        ArrayList<MTablePrivilege> mSecurityTabList = new ArrayList<MTablePrivilege>();
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        catName = StringUtils.normalizeIdentifier(catName);
        try {
            LOG.debug("Executing listAllTableGrants");
            this.openTransaction();
            String queryStr = "table.tableName == t1 && table.database.name == t2&& table.database.catalogName == t3";
            query = this.pm.newQuery(MTablePrivilege.class, queryStr);
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
            List mPrivs = (List)query.executeWithArray(new Object[]{tableName, dbName, catName});
            LOG.debug("Done executing query for listAllTableGrants");
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityTabList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listAllTableGrants");
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        return mSecurityTabList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartitionPrivilege> listTableAllPartitionGrants(String catName, String dbName, String tableName) {
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        catName = StringUtils.normalizeIdentifier(catName);
        boolean success = false;
        Query query = null;
        ArrayList<MPartitionPrivilege> mSecurityTabPartList = new ArrayList<MPartitionPrivilege>();
        try {
            LOG.debug("Executing listTableAllPartitionGrants");
            this.openTransaction();
            String queryStr = "partition.table.tableName == t1 && partition.table.database.name == t2 && partition.table.database.catalogName == t3";
            query = this.pm.newQuery(MPartitionPrivilege.class, queryStr);
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
            List mPrivs = (List)query.executeWithArray(new Object[]{tableName, dbName, catName});
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityTabPartList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listTableAllPartitionGrants");
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        return mSecurityTabPartList;
    }

    private List<MTableColumnPrivilege> listTableAllColumnGrants(String catName, String dbName, String tableName) {
        return this.listTableAllColumnGrants(catName, dbName, tableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MTableColumnPrivilege> listTableAllColumnGrants(String catName, String dbName, String tableName, String authorizer) {
        boolean success = false;
        Query query = null;
        ArrayList<MTableColumnPrivilege> mTblColPrivilegeList = new ArrayList<MTableColumnPrivilege>();
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        catName = StringUtils.normalizeIdentifier(catName);
        try {
            LOG.debug("Executing listTableAllColumnGrants");
            this.openTransaction();
            List mPrivs = null;
            if (authorizer != null) {
                String queryStr = "table.tableName == t1 && table.database.name == t2 &&table.database.catalogName == t3 && authorizer == t4";
                query = this.pm.newQuery(MTableColumnPrivilege.class, queryStr);
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4");
                mPrivs = (List)query.executeWithArray(new Object[]{tableName, dbName, catName, authorizer});
            } else {
                String queryStr = "table.tableName == t1 && table.database.name == t2 &&table.database.catalogName == t3";
                query = this.pm.newQuery(MTableColumnPrivilege.class, queryStr);
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
                mPrivs = (List)query.executeWithArray(new Object[]{tableName, dbName, catName});
            }
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mTblColPrivilegeList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listTableAllColumnGrants");
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        return mTblColPrivilegeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartitionColumnPrivilege> listTableAllPartitionColumnGrants(String catName, String dbName, String tableName) {
        boolean success = false;
        Query query = null;
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        catName = StringUtils.normalizeIdentifier(catName);
        ArrayList<MPartitionColumnPrivilege> mSecurityColList = new ArrayList<MPartitionColumnPrivilege>();
        try {
            LOG.debug("Executing listTableAllPartitionColumnGrants");
            this.openTransaction();
            String queryStr = "partition.table.tableName == t1 && partition.table.database.name == t2 && partition.table.database.catalogName == t3";
            query = this.pm.newQuery(MPartitionColumnPrivilege.class, queryStr);
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
            List mPrivs = (List)query.executeWithArray(new Object[]{tableName, dbName, catName});
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityColList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listTableAllPartitionColumnGrants");
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        return mSecurityColList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartitionColumnPrivilege> listPartitionAllColumnGrants(String catName, String dbName, String tableName, List<String> partNames) {
        boolean success = false;
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        catName = StringUtils.normalizeIdentifier(catName);
        List<MPartitionColumnPrivilege> mSecurityColList = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listPartitionAllColumnGrants");
            mSecurityColList = this.queryByPartitionNames(catName, dbName, tableName, partNames, MPartitionColumnPrivilege.class, "partition.table.tableName", "partition.table.database.name", "partition.partitionName", "partition.table.database.catalogName");
            LOG.debug("Done executing query for listPartitionAllColumnGrants");
            this.pm.retrieveAll(mSecurityColList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPartitionAllColumnGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityColList;
    }

    private void dropPartitionAllColumnGrantsNoTxn(String catName, String dbName, String tableName, List<String> partNames) {
        ObjectPair<Query, Object[]> queryWithParams = this.makeQueryByPartitionNames(catName, dbName, tableName, partNames, MPartitionColumnPrivilege.class, "partition.table.tableName", "partition.table.database.name", "partition.partitionName", "partition.table.database.catalogName");
        queryWithParams.getFirst().deletePersistentAll(queryWithParams.getSecond());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MDBPrivilege> listDatabaseGrants(String catName, String dbName, String authorizer, QueryWrapper queryWrapper) {
        dbName = StringUtils.normalizeIdentifier(dbName);
        catName = StringUtils.normalizeIdentifier(catName);
        boolean success = false;
        try {
            Query query;
            LOG.debug("Executing listDatabaseGrants");
            this.openTransaction();
            List mSecurityDBList = null;
            if (authorizer != null) {
                query = queryWrapper.query = this.pm.newQuery(MDBPrivilege.class, "database.name == t1 && database.catalogName == t2 && authorizer == t3");
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
                mSecurityDBList = (List)query.executeWithArray(new Object[]{dbName, catName, authorizer});
            } else {
                query = queryWrapper.query = this.pm.newQuery(MDBPrivilege.class, "database.name == t1 && database.catalogName == t2");
                query.declareParameters("java.lang.String t1, java.lang.String t2");
                mSecurityDBList = (List)query.executeWithArray(new Object[]{dbName, catName});
            }
            this.pm.retrieveAll((Collection)mSecurityDBList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listDatabaseGrants");
            List list = mSecurityDBList;
            return list;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartitionPrivilege> listPartitionGrants(String catName, String dbName, String tableName, List<String> partNames) {
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        boolean success = false;
        List<MPartitionPrivilege> mSecurityTabPartList = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listPartitionGrants");
            mSecurityTabPartList = this.queryByPartitionNames(catName, dbName, tableName, partNames, MPartitionPrivilege.class, "partition.table.tableName", "partition.table.database.name", "partition.partitionName", "partition.table.database.catalogName");
            LOG.debug("Done executing query for listPartitionGrants");
            this.pm.retrieveAll(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPartitionGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityTabPartList;
    }

    private void dropPartitionGrantsNoTxn(String catName, String dbName, String tableName, List<String> partNames) {
        ObjectPair<Query, Object[]> queryWithParams = this.makeQueryByPartitionNames(catName, dbName, tableName, partNames, MPartitionPrivilege.class, "partition.table.tableName", "partition.table.database.name", "partition.partitionName", "partition.table.database.catalogName");
        queryWithParams.getFirst().deletePersistentAll(queryWithParams.getSecond());
    }

    private <T> List<T> queryByPartitionNames(String catName, String dbName, String tableName, List<String> partNames, Class<T> clazz, String tbCol, String dbCol, String partCol, String catCol) {
        ObjectPair<Query, Object[]> queryAndParams = this.makeQueryByPartitionNames(catName, dbName, tableName, partNames, clazz, tbCol, dbCol, partCol, catCol);
        return (List)queryAndParams.getFirst().executeWithArray(queryAndParams.getSecond());
    }

    private ObjectPair<Query, Object[]> makeQueryByPartitionNames(String catName, String dbName, String tableName, List<String> partNames, Class<?> clazz, String tbCol, String dbCol, String partCol, String catCol) {
        String queryStr = tbCol + " == t1 && " + dbCol + " == t2 && " + catCol + " == t3";
        String paramStr = "java.lang.String t1, java.lang.String t2, java.lang.String t3";
        Object[] params = new Object[3 + partNames.size()];
        params[0] = StringUtils.normalizeIdentifier(tableName);
        params[1] = StringUtils.normalizeIdentifier(dbName);
        params[2] = StringUtils.normalizeIdentifier(catName);
        int index = 0;
        for (String partName : partNames) {
            params[index + 3] = partName;
            queryStr = queryStr + (index == 0 ? " && (" : " || ") + partCol + " == p" + index;
            paramStr = paramStr + ", java.lang.String p" + index;
            ++index;
        }
        queryStr = queryStr + ")";
        Query query = this.pm.newQuery(clazz, queryStr);
        query.declareParameters(paramStr);
        return new ObjectPair<Query, Object[]>(query, params);
    }

    private List<MTablePrivilege> listAllMTableGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName) {
        return this.listAllMTableGrants(principalName, principalType, catName, dbName, tableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MTablePrivilege> listAllMTableGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, String authorizer) {
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        catName = StringUtils.normalizeIdentifier(catName);
        boolean success = false;
        Query query = null;
        ArrayList<MTablePrivilege> mSecurityTabPartList = new ArrayList<MTablePrivilege>();
        try {
            List mPrivs;
            this.openTransaction();
            LOG.debug("Executing listAllTableGrants");
            if (authorizer != null) {
                query = this.pm.newQuery(MTablePrivilege.class, "principalName == t1 && principalType == t2 && table.tableName == t3 &&table.database.name == t4 && table.database.catalogName == t5 && authorizer == t6");
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3,java.lang.String t4, java.lang.String t5, java.lang.String t6");
                mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), tableName, dbName, catName, authorizer});
            } else {
                query = this.pm.newQuery(MTablePrivilege.class, "principalName == t1 && principalType == t2 && table.tableName == t3 &&table.database.name == t4 && table.database.catalogName == t5");
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3,java.lang.String t4, java.lang.String t5");
                mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), tableName, dbName, catName});
            }
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityTabPartList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listAllTableGrants");
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        return mSecurityTabPartList;
    }

    @Override
    public List<HiveObjectPrivilege> listAllTableGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName) {
        List<MTablePrivilege> mTbls = this.listAllMTableGrants(principalName, principalType, catName, dbName, tableName);
        if (mTbls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (int i = 0; i < mTbls.size(); ++i) {
            MTablePrivilege sTbl = mTbls.get(i);
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.TABLE, dbName, tableName, null, null);
            objectRef.setCatName(catName);
            HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sTbl.getPrincipalName(), principalType, new PrivilegeGrantInfo(sTbl.getPrivilege(), sTbl.getCreateTime(), sTbl.getGrantor(), PrincipalType.valueOf(sTbl.getGrantorType()), sTbl.getGrantOption()), sTbl.getAuthorizer());
            result.add(secObj);
        }
        return result;
    }

    private List<MPartitionPrivilege> listPrincipalMPartitionGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, String partName) {
        return this.listPrincipalMPartitionGrants(principalName, principalType, catName, dbName, tableName, partName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartitionPrivilege> listPrincipalMPartitionGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, String partName, String authorizer) {
        boolean success = false;
        Query query = null;
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        catName = StringUtils.normalizeIdentifier(catName);
        ArrayList<MPartitionPrivilege> mSecurityTabPartList = new ArrayList<MPartitionPrivilege>();
        try {
            List mPrivs;
            LOG.debug("Executing listPrincipalPartitionGrants");
            this.openTransaction();
            if (authorizer != null) {
                query = this.pm.newQuery(MPartitionPrivilege.class, "principalName == t1 && principalType == t2 && partition.table.tableName == t3 && partition.table.database.name == t4 && partition.table.database.catalogName == t5&& partition.partitionName == t6 && authorizer == t7");
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4, java.lang.String t5, java.lang.String t6, java.lang.String t7");
                mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), tableName, dbName, catName, partName, authorizer});
            } else {
                query = this.pm.newQuery(MPartitionPrivilege.class, "principalName == t1 && principalType == t2 && partition.table.tableName == t3 && partition.table.database.name == t4 && partition.table.database.catalogName == t5&& partition.partitionName == t6");
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4, java.lang.String t5, java.lang.String t6");
                mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), tableName, dbName, catName, partName});
            }
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityTabPartList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listPrincipalPartitionGrants");
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        return mSecurityTabPartList;
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, List<String> partValues, String partName) {
        List<MPartitionPrivilege> mParts = this.listPrincipalMPartitionGrants(principalName, principalType, catName, dbName, tableName, partName);
        if (mParts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (int i = 0; i < mParts.size(); ++i) {
            MPartitionPrivilege sPart = mParts.get(i);
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.PARTITION, dbName, tableName, partValues, null);
            objectRef.setCatName(catName);
            HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sPart.getPrincipalName(), principalType, new PrivilegeGrantInfo(sPart.getPrivilege(), sPart.getCreateTime(), sPart.getGrantor(), PrincipalType.valueOf(sPart.getGrantorType()), sPart.getGrantOption()), sPart.getAuthorizer());
            result.add(secObj);
        }
        return result;
    }

    private List<MTableColumnPrivilege> listPrincipalMTableColumnGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, String columnName) {
        return this.listPrincipalMTableColumnGrants(principalName, principalType, catName, dbName, tableName, columnName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MTableColumnPrivilege> listPrincipalMTableColumnGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, String columnName, String authorizer) {
        boolean success = false;
        Query query = null;
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        columnName = StringUtils.normalizeIdentifier(columnName);
        ArrayList<MTableColumnPrivilege> mSecurityColList = new ArrayList<MTableColumnPrivilege>();
        try {
            List mPrivs;
            LOG.debug("Executing listPrincipalTableColumnGrants");
            this.openTransaction();
            if (authorizer != null) {
                String queryStr = "principalName == t1 && principalType == t2 && table.tableName == t3 && table.database.name == t4 &&  table.database.catalogName == t5 && columnName == t6 && authorizer == t7";
                query = this.pm.newQuery(MTableColumnPrivilege.class, queryStr);
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4, java.lang.String t5, java.lang.String t6, java.lang.String t7");
                mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), tableName, dbName, catName, columnName, authorizer});
            } else {
                String queryStr = "principalName == t1 && principalType == t2 && table.tableName == t3 && table.database.name == t4 &&  table.database.catalogName == t5 && columnName == t6 ";
                query = this.pm.newQuery(MTableColumnPrivilege.class, queryStr);
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4, java.lang.String t5, java.lang.String t6");
                mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), tableName, dbName, catName, columnName});
            }
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityColList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listPrincipalTableColumnGrants");
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        return mSecurityColList;
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalTableColumnGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, String columnName) {
        List<MTableColumnPrivilege> mTableCols = this.listPrincipalMTableColumnGrants(principalName, principalType, catName, dbName, tableName, columnName);
        if (mTableCols.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (int i = 0; i < mTableCols.size(); ++i) {
            MTableColumnPrivilege sCol = mTableCols.get(i);
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, dbName, tableName, null, sCol.getColumnName());
            objectRef.setCatName(catName);
            HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sCol.getPrincipalName(), principalType, new PrivilegeGrantInfo(sCol.getPrivilege(), sCol.getCreateTime(), sCol.getGrantor(), PrincipalType.valueOf(sCol.getGrantorType()), sCol.getGrantOption()), sCol.getAuthorizer());
            result.add(secObj);
        }
        return result;
    }

    private List<MPartitionColumnPrivilege> listPrincipalMPartitionColumnGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, String partitionName, String columnName) {
        return this.listPrincipalMPartitionColumnGrants(principalName, principalType, catName, dbName, tableName, partitionName, columnName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartitionColumnPrivilege> listPrincipalMPartitionColumnGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, String partitionName, String columnName, String authorizer) {
        boolean success = false;
        Query query = null;
        tableName = StringUtils.normalizeIdentifier(tableName);
        dbName = StringUtils.normalizeIdentifier(dbName);
        columnName = StringUtils.normalizeIdentifier(columnName);
        catName = StringUtils.normalizeIdentifier(catName);
        ArrayList<MPartitionColumnPrivilege> mSecurityColList = new ArrayList<MPartitionColumnPrivilege>();
        try {
            List mPrivs;
            LOG.debug("Executing listPrincipalPartitionColumnGrants");
            this.openTransaction();
            if (authorizer != null) {
                query = this.pm.newQuery(MPartitionColumnPrivilege.class, "principalName == t1 && principalType == t2 && partition.table.tableName == t3 && partition.table.database.name == t4 && partition.table.database.catalogName == t5 && partition.partitionName == t6 && columnName == t7 && authorizer == t8");
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4, java.lang.String t5, java.lang.String t6, java.lang.String t7, java.lang.String t8");
                mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), tableName, dbName, catName, partitionName, columnName, authorizer});
            } else {
                query = this.pm.newQuery(MPartitionColumnPrivilege.class, "principalName == t1 && principalType == t2 && partition.table.tableName == t3 && partition.table.database.name == t4 && partition.table.database.catalogName == t5 && partition.partitionName == t6 && columnName == t7");
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4, java.lang.String t5, java.lang.String t6, java.lang.String t7");
                mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), tableName, dbName, catName, partitionName, columnName});
            }
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityColList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listPrincipalPartitionColumnGrants");
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        return mSecurityColList;
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, List<String> partValues, String partitionName, String columnName) {
        List<MPartitionColumnPrivilege> mPartitionCols = this.listPrincipalMPartitionColumnGrants(principalName, principalType, catName, dbName, tableName, partitionName, columnName);
        if (mPartitionCols.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (int i = 0; i < mPartitionCols.size(); ++i) {
            MPartitionColumnPrivilege sCol = mPartitionCols.get(i);
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, dbName, tableName, partValues, sCol.getColumnName());
            objectRef.setCatName(catName);
            HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sCol.getPrincipalName(), principalType, new PrivilegeGrantInfo(sCol.getPrivilege(), sCol.getCreateTime(), sCol.getGrantor(), PrincipalType.valueOf(sCol.getGrantorType()), sCol.getGrantOption()), sCol.getAuthorizer());
            result.add(secObj);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrantsAll(String principalName, PrincipalType principalType) {
        boolean success = false;
        Query query = null;
        try {
            List mSecurityTabPartList;
            this.openTransaction();
            LOG.debug("Executing listPrincipalPartitionColumnGrantsAll");
            if (principalName != null && principalType != null) {
                query = this.pm.newQuery(MPartitionColumnPrivilege.class, "principalName == t1 && principalType == t2");
                query.declareParameters("java.lang.String t1, java.lang.String t2");
                mSecurityTabPartList = (List)query.executeWithArray(new Object[]{principalName, principalType.toString()});
            } else {
                query = this.pm.newQuery(MPartitionColumnPrivilege.class);
                mSecurityTabPartList = (List)query.execute();
            }
            LOG.debug("Done executing query for listPrincipalPartitionColumnGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertPartCols(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalPartitionColumnGrantsAll");
            List<HiveObjectPrivilege> list = result;
            this.rollbackAndCleanup(success, query);
            return list;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPartitionColumnGrantsAll(String catName, String dbName, String tableName, String partitionName, String columnName) {
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listPartitionColumnGrantsAll");
            query = this.pm.newQuery(MPartitionColumnPrivilege.class, "partition.table.tableName == t3 && partition.table.database.name == t4 && partition.table.database.name == t5 && partition.partitionName == t6 && columnName == t7");
            query.declareParameters("java.lang.String t3, java.lang.String t4, java.lang.String t5,java.lang.String t6, java.lang.String t7");
            List mSecurityTabPartList = (List)query.executeWithArray(new Object[]{tableName, dbName, catName, partitionName, columnName});
            LOG.debug("Done executing query for listPartitionColumnGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertPartCols(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPartitionColumnGrantsAll");
            List<HiveObjectPrivilege> list = result;
            this.rollbackAndCleanup(success, query);
            return list;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
    }

    private List<HiveObjectPrivilege> convertPartCols(List<MPartitionColumnPrivilege> privs) {
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (MPartitionColumnPrivilege priv : privs) {
            String pname = priv.getPrincipalName();
            String authorizer = priv.getAuthorizer();
            PrincipalType ptype = PrincipalType.valueOf(priv.getPrincipalType());
            MPartition mpartition = priv.getPartition();
            MTable mtable = mpartition.getTable();
            MDatabase mdatabase = mtable.getDatabase();
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, mdatabase.getName(), mtable.getTableName(), mpartition.getValues(), priv.getColumnName());
            objectRef.setCatName(mdatabase.getCatalogName());
            PrivilegeGrantInfo grantor = new PrivilegeGrantInfo(priv.getPrivilege(), priv.getCreateTime(), priv.getGrantor(), PrincipalType.valueOf(priv.getGrantorType()), priv.getGrantOption());
            result.add(new HiveObjectPrivilege(objectRef, pname, ptype, grantor, authorizer));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MTablePrivilege> listPrincipalAllTableGrants(String principalName, PrincipalType principalType, QueryWrapper queryWrapper) {
        boolean success = false;
        List mSecurityTabPartList = null;
        try {
            LOG.debug("Executing listPrincipalAllTableGrants");
            this.openTransaction();
            Query query = queryWrapper.query = this.pm.newQuery(MTablePrivilege.class, "principalName == t1 && principalType == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            mSecurityTabPartList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllTableGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityTabPartList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPrincipalTableGrantsAll(String principalName, PrincipalType principalType) {
        boolean success = false;
        Query query = null;
        try {
            List mSecurityTabPartList;
            this.openTransaction();
            LOG.debug("Executing listPrincipalAllTableGrants");
            if (principalName != null && principalType != null) {
                query = this.pm.newQuery(MTablePrivilege.class, "principalName == t1 && principalType == t2");
                query.declareParameters("java.lang.String t1, java.lang.String t2");
                mSecurityTabPartList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            } else {
                query = this.pm.newQuery(MTablePrivilege.class);
                mSecurityTabPartList = (List)query.execute();
            }
            LOG.debug("Done executing query for listPrincipalAllTableGrants");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertTable(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllTableGrants");
            List<HiveObjectPrivilege> list = result;
            this.rollbackAndCleanup(success, query);
            return list;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
    }

    @Override
    public List<HiveObjectPrivilege> listTableGrantsAll(String catName, String dbName, String tableName) {
        return this.listTableGrantsAll(catName, dbName, tableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HiveObjectPrivilege> listTableGrantsAll(String catName, String dbName, String tableName, String authorizer) {
        boolean success = false;
        Query query = null;
        dbName = StringUtils.normalizeIdentifier(dbName);
        tableName = StringUtils.normalizeIdentifier(tableName);
        try {
            this.openTransaction();
            LOG.debug("Executing listTableGrantsAll");
            List mSecurityTabPartList = null;
            if (authorizer != null) {
                query = this.pm.newQuery(MTablePrivilege.class, "table.tableName == t1 && table.database.name == t2 && table.database.catalogName == t3 && authorizer == t4");
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4");
                mSecurityTabPartList = (List)query.executeWithArray(new Object[]{tableName, dbName, catName, authorizer});
            } else {
                query = this.pm.newQuery(MTablePrivilege.class, "table.tableName == t1 && table.database.name == t2 && table.database.catalogName == t3");
                query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
                mSecurityTabPartList = (List)query.executeWithArray(new Object[]{tableName, dbName, catName});
            }
            LOG.debug("Done executing query for listTableGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertTable(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllTableGrants");
            List<HiveObjectPrivilege> list = result;
            this.rollbackAndCleanup(success, query);
            return list;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
    }

    private List<HiveObjectPrivilege> convertTable(List<MTablePrivilege> privs) {
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (MTablePrivilege priv : privs) {
            String pname = priv.getPrincipalName();
            String authorizer = priv.getAuthorizer();
            PrincipalType ptype = PrincipalType.valueOf(priv.getPrincipalType());
            String table = priv.getTable().getTableName();
            String database = priv.getTable().getDatabase().getName();
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.TABLE, database, table, null, null);
            objectRef.setCatName(priv.getTable().getDatabase().getCatalogName());
            PrivilegeGrantInfo grantor = new PrivilegeGrantInfo(priv.getPrivilege(), priv.getCreateTime(), priv.getGrantor(), PrincipalType.valueOf(priv.getGrantorType()), priv.getGrantOption());
            result.add(new HiveObjectPrivilege(objectRef, pname, ptype, grantor, authorizer));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartitionPrivilege> listPrincipalAllPartitionGrants(String principalName, PrincipalType principalType, QueryWrapper queryWrapper) {
        boolean success = false;
        List mSecurityTabPartList = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listPrincipalAllPartitionGrants");
            Query query = queryWrapper.query = this.pm.newQuery(MPartitionPrivilege.class, "principalName == t1 && principalType == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            mSecurityTabPartList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllPartitionGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityTabPartList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionGrantsAll(String principalName, PrincipalType principalType) {
        boolean success = false;
        Query query = null;
        try {
            List mSecurityTabPartList;
            this.openTransaction();
            LOG.debug("Executing listPrincipalPartitionGrantsAll");
            if (principalName != null && principalType != null) {
                query = this.pm.newQuery(MPartitionPrivilege.class, "principalName == t1 && principalType == t2");
                query.declareParameters("java.lang.String t1, java.lang.String t2");
                mSecurityTabPartList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            } else {
                query = this.pm.newQuery(MPartitionPrivilege.class);
                mSecurityTabPartList = (List)query.execute();
            }
            LOG.debug("Done executing query for listPrincipalPartitionGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertPartition(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalPartitionGrantsAll");
            List<HiveObjectPrivilege> list = result;
            this.rollbackAndCleanup(success, query);
            return list;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPartitionGrantsAll(String catName, String dbName, String tableName, String partitionName) {
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listPrincipalPartitionGrantsAll");
            query = this.pm.newQuery(MPartitionPrivilege.class, "partition.table.tableName == t3 && partition.table.database.name == t4 && partition.table.database.catalogName == t5 && partition.partitionName == t6");
            query.declareParameters("java.lang.String t3, java.lang.String t4, java.lang.String t5, java.lang.String t6");
            List mSecurityTabPartList = (List)query.executeWithArray(new Object[]{tableName, dbName, catName, partitionName});
            LOG.debug("Done executing query for listPrincipalPartitionGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertPartition(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalPartitionGrantsAll");
            List<HiveObjectPrivilege> list = result;
            this.rollbackAndCleanup(success, query);
            return list;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
    }

    private List<HiveObjectPrivilege> convertPartition(List<MPartitionPrivilege> privs) {
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (MPartitionPrivilege priv : privs) {
            String pname = priv.getPrincipalName();
            String authorizer = priv.getAuthorizer();
            PrincipalType ptype = PrincipalType.valueOf(priv.getPrincipalType());
            MPartition mpartition = priv.getPartition();
            MTable mtable = mpartition.getTable();
            MDatabase mdatabase = mtable.getDatabase();
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.PARTITION, mdatabase.getName(), mtable.getTableName(), mpartition.getValues(), null);
            objectRef.setCatName(mdatabase.getCatalogName());
            PrivilegeGrantInfo grantor = new PrivilegeGrantInfo(priv.getPrivilege(), priv.getCreateTime(), priv.getGrantor(), PrincipalType.valueOf(priv.getGrantorType()), priv.getGrantOption());
            result.add(new HiveObjectPrivilege(objectRef, pname, ptype, grantor, authorizer));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MTableColumnPrivilege> listPrincipalAllTableColumnGrants(String principalName, PrincipalType principalType, QueryWrapper queryWrapper) {
        boolean success = false;
        List mSecurityColumnList = null;
        try {
            LOG.debug("Executing listPrincipalAllTableColumnGrants");
            this.openTransaction();
            Query query = queryWrapper.query = this.pm.newQuery(MTableColumnPrivilege.class, "principalName == t1 && principalType == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            mSecurityColumnList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            this.pm.retrieveAll((Collection)mSecurityColumnList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllTableColumnGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityColumnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPrincipalTableColumnGrantsAll(String principalName, PrincipalType principalType) {
        boolean success = false;
        Query query = null;
        try {
            List mSecurityTabPartList;
            this.openTransaction();
            LOG.debug("Executing listPrincipalTableColumnGrantsAll");
            if (principalName != null && principalType != null) {
                query = this.pm.newQuery(MTableColumnPrivilege.class, "principalName == t1 && principalType == t2");
                query.declareParameters("java.lang.String t1, java.lang.String t2");
                mSecurityTabPartList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            } else {
                query = this.pm.newQuery(MTableColumnPrivilege.class);
                mSecurityTabPartList = (List)query.execute();
            }
            LOG.debug("Done executing query for listPrincipalTableColumnGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertTableCols(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalTableColumnGrantsAll");
            List<HiveObjectPrivilege> list = result;
            this.rollbackAndCleanup(success, query);
            return list;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listTableColumnGrantsAll(String catName, String dbName, String tableName, String columnName) {
        boolean success = false;
        Query query = null;
        dbName = StringUtils.normalizeIdentifier(dbName);
        tableName = StringUtils.normalizeIdentifier(tableName);
        try {
            this.openTransaction();
            LOG.debug("Executing listPrincipalTableColumnGrantsAll");
            query = this.pm.newQuery(MTableColumnPrivilege.class, "table.tableName == t3 && table.database.name == t4 && table.database.catalogName == t5 && columnName == t6");
            query.declareParameters("java.lang.String t3, java.lang.String t4, java.lang.String t5, java.lang.String t6");
            List mSecurityTabPartList = (List)query.executeWithArray(new Object[]{tableName, dbName, catName, columnName});
            LOG.debug("Done executing query for listPrincipalTableColumnGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertTableCols(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalTableColumnGrantsAll");
            List<HiveObjectPrivilege> list = result;
            this.rollbackAndCleanup(success, query);
            return list;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
    }

    private List<HiveObjectPrivilege> convertTableCols(List<MTableColumnPrivilege> privs) {
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (MTableColumnPrivilege priv : privs) {
            String pname = priv.getPrincipalName();
            String authorizer = priv.getAuthorizer();
            PrincipalType ptype = PrincipalType.valueOf(priv.getPrincipalType());
            MTable mtable = priv.getTable();
            MDatabase mdatabase = mtable.getDatabase();
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, mdatabase.getName(), mtable.getTableName(), null, priv.getColumnName());
            objectRef.setCatName(mdatabase.getCatalogName());
            PrivilegeGrantInfo grantor = new PrivilegeGrantInfo(priv.getPrivilege(), priv.getCreateTime(), priv.getGrantor(), PrincipalType.valueOf(priv.getGrantorType()), priv.getGrantOption());
            result.add(new HiveObjectPrivilege(objectRef, pname, ptype, grantor, authorizer));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartitionColumnPrivilege> listPrincipalAllPartitionColumnGrants(String principalName, PrincipalType principalType, QueryWrapper queryWrapper) {
        boolean success = false;
        List mSecurityColumnList = null;
        try {
            LOG.debug("Executing listPrincipalAllTableColumnGrants");
            this.openTransaction();
            Query query = queryWrapper.query = this.pm.newQuery(MPartitionColumnPrivilege.class, "principalName == t1 && principalType == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            mSecurityColumnList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            this.pm.retrieveAll((Collection)mSecurityColumnList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllTableColumnGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityColumnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPartitionMarkedForEvent(String catName, String dbName, String tblName, Map<String, String> partName, PartitionEventType evtType) throws UnknownTableException, MetaException, InvalidPartitionException, UnknownPartitionException {
        boolean success = false;
        Query query = null;
        try {
            LOG.debug("Begin Executing isPartitionMarkedForEvent");
            this.openTransaction();
            query = this.pm.newQuery(MPartitionEvent.class, "dbName == t1 && tblName == t2 && partName == t3 && eventType == t4 && catalogName == t5");
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, int t4,java.lang.String t5");
            Table tbl = this.getTable(catName, dbName, tblName);
            if (null == tbl) {
                throw new UnknownTableException("Table: " + tblName + " is not found.");
            }
            Collection partEvents = (Collection)query.executeWithArray(new Object[]{dbName, tblName, this.getPartitionStr(tbl, partName), evtType.getValue(), catName});
            this.pm.retrieveAll(partEvents);
            success = this.commitTransaction();
            LOG.debug("Done executing isPartitionMarkedForEvent");
            boolean bl = partEvents != null && !partEvents.isEmpty();
            this.rollbackAndCleanup(success, query);
            return bl;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table markPartitionForEvent(String catName, String dbName, String tblName, Map<String, String> partName, PartitionEventType evtType) throws MetaException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
        LOG.debug("Begin executing markPartitionForEvent");
        boolean success = false;
        Table tbl = null;
        try {
            this.openTransaction();
            tbl = this.getTable(catName, dbName, tblName);
            if (null == tbl) {
                throw new UnknownTableException("Table: " + tblName + " is not found.");
            }
            this.pm.makePersistent((Object)new MPartitionEvent(catName, dbName, tblName, this.getPartitionStr(tbl, partName), evtType.getValue()));
            success = this.commitTransaction();
            LOG.debug("Done executing markPartitionForEvent");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return tbl;
    }

    private String getPartitionStr(Table tbl, Map<String, String> partName) throws InvalidPartitionException {
        if (tbl.getPartitionKeysSize() != partName.size()) {
            throw new InvalidPartitionException("Number of partition columns in table: " + tbl.getPartitionKeysSize() + " doesn't match with number of supplied partition values: " + partName.size());
        }
        ArrayList<String> storedVals = new ArrayList<String>(tbl.getPartitionKeysSize());
        for (FieldSchema partKey : tbl.getPartitionKeys()) {
            String partVal = partName.get(partKey.getName());
            if (null == partVal) {
                throw new InvalidPartitionException("No value found for partition column: " + partKey.getName());
            }
            storedVals.add(partVal);
        }
        return io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.join(storedVals, ',');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<?> executeJDOQLSelect(String queryStr, QueryWrapper queryWrapper) {
        boolean committed = false;
        Collection result = null;
        try {
            this.openTransaction();
            Query query = queryWrapper.query = this.pm.newQuery(queryStr);
            result = (Collection)query.execute();
            committed = this.commitTransaction();
            if (committed) {
                Collection collection = result;
                return collection;
            }
            Collection<?> collection = null;
            return collection;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeJDOQLUpdate(String queryStr) {
        Query query;
        boolean committed;
        block3: {
            committed = false;
            long numUpdated = 0L;
            query = null;
            try {
                this.openTransaction();
                query = this.pm.newQuery(queryStr);
                numUpdated = (Long)query.execute();
                committed = this.commitTransaction();
                if (!committed) break block3;
                long l = numUpdated;
                this.rollbackAndCleanup(committed, query);
                return l;
            }
            catch (Throwable throwable) {
                this.rollbackAndCleanup(committed, query);
                throw throwable;
            }
        }
        long l = -1L;
        this.rollbackAndCleanup(committed, query);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listFSRoots() {
        Object object;
        Query query;
        boolean committed;
        block4: {
            committed = false;
            query = null;
            HashSet<String> fsRoots = new HashSet<String>();
            try {
                this.openTransaction();
                query = this.pm.newQuery(MDatabase.class);
                List mDBs = (List)query.execute();
                this.pm.retrieveAll((Collection)mDBs);
                for (MDatabase mDB : mDBs) {
                    fsRoots.add(mDB.getLocationUri());
                }
                committed = this.commitTransaction();
                if (!committed) break block4;
                object = fsRoots;
                this.rollbackAndCleanup(committed, query);
                return object;
            }
            catch (Throwable throwable) {
                this.rollbackAndCleanup(committed, query);
                throw throwable;
            }
        }
        object = null;
        this.rollbackAndCleanup(committed, query);
        return object;
    }

    private boolean shouldUpdateURI(URI onDiskUri, URI inputUri) {
        String onDiskHost = onDiskUri.getHost();
        String inputHost = inputUri.getHost();
        int onDiskPort = onDiskUri.getPort();
        int inputPort = inputUri.getPort();
        String onDiskScheme = onDiskUri.getScheme();
        String inputScheme = inputUri.getScheme();
        if (inputPort != -1 && inputPort != onDiskPort) {
            return false;
        }
        if (inputScheme != null) {
            if (onDiskScheme == null) {
                return false;
            }
            if (!inputScheme.equalsIgnoreCase(onDiskScheme)) {
                return false;
            }
        }
        if (onDiskHost != null) {
            return inputHost.equalsIgnoreCase(onDiskHost);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMDatabaseURIRetVal updateMDatabaseURI(URI oldLoc, URI newLoc, boolean dryRun) {
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        UpdateMDatabaseURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MDatabase.class);
            List mDBs = (List)query.execute();
            this.pm.retrieveAll((Collection)mDBs);
            for (MDatabase mDB : mDBs) {
                URI locationURI = null;
                String location = mDB.getLocationUri();
                try {
                    locationURI = new Path(location).toUri();
                }
                catch (IllegalArgumentException e) {
                    badRecords.add(location);
                }
                if (locationURI == null) {
                    badRecords.add(location);
                    continue;
                }
                if (!this.shouldUpdateURI(locationURI, oldLoc)) continue;
                String dbLoc = mDB.getLocationUri().replaceAll(oldLoc.toString(), newLoc.toString());
                updateLocations.put(locationURI.toString(), dbLoc);
                if (dryRun) continue;
                mDB.setLocationUri(dbLoc);
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdateMDatabaseURIRetVal(badRecords, updateLocations);
            }
            Iterator iterator = retVal;
            this.rollbackAndCleanup(committed, query);
            return iterator;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
    }

    private void updatePropURIHelper(URI oldLoc, URI newLoc, String tblPropKey, boolean isDryRun, List<String> badRecords, Map<String, String> updateLocations, Map<String, String> parameters) {
        URI tablePropLocationURI = null;
        if (parameters.containsKey(tblPropKey)) {
            String tablePropLocation = parameters.get(tblPropKey);
            try {
                tablePropLocationURI = new Path(tablePropLocation).toUri();
            }
            catch (IllegalArgumentException e) {
                badRecords.add(tablePropLocation);
            }
            if (tablePropLocationURI == null) {
                badRecords.add(tablePropLocation);
            } else if (this.shouldUpdateURI(tablePropLocationURI, oldLoc)) {
                String tblPropLoc = parameters.get(tblPropKey).replaceAll(oldLoc.toString(), newLoc.toString());
                updateLocations.put(tablePropLocationURI.toString(), tblPropLoc);
                if (!isDryRun) {
                    parameters.put(tblPropKey, tblPropLoc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdatePropURIRetVal updateTblPropURI(URI oldLoc, URI newLoc, String tblPropKey, boolean isDryRun) {
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        UpdatePropURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MTable.class);
            List mTbls = (List)query.execute();
            this.pm.retrieveAll((Collection)mTbls);
            for (MTable mTbl : mTbls) {
                this.updatePropURIHelper(oldLoc, newLoc, tblPropKey, isDryRun, badRecords, updateLocations, mTbl.getParameters());
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdatePropURIRetVal(badRecords, updateLocations);
            }
            Iterator iterator = retVal;
            this.rollbackAndCleanup(committed, query);
            return iterator;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public UpdatePropURIRetVal updateMStorageDescriptorTblPropURI(URI oldLoc, URI newLoc, String tblPropKey, boolean isDryRun) {
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        UpdatePropURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MStorageDescriptor.class);
            List mSDSs = (List)query.execute();
            this.pm.retrieveAll((Collection)mSDSs);
            for (MStorageDescriptor mSDS : mSDSs) {
                this.updatePropURIHelper(oldLoc, newLoc, tblPropKey, isDryRun, badRecords, updateLocations, mSDS.getParameters());
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdatePropURIRetVal(badRecords, updateLocations);
            }
            Iterator iterator = retVal;
            this.rollbackAndCleanup(committed, query);
            return iterator;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMStorageDescriptorTblURIRetVal updateMStorageDescriptorTblURI(URI oldLoc, URI newLoc, boolean isDryRun) {
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        int numNullRecords = 0;
        UpdateMStorageDescriptorTblURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MStorageDescriptor.class);
            List mSDSs = (List)query.execute();
            this.pm.retrieveAll((Collection)mSDSs);
            for (MStorageDescriptor mSDS : mSDSs) {
                URI locationURI = null;
                String location = mSDS.getLocation();
                if (location == null) {
                    ++numNullRecords;
                    continue;
                }
                try {
                    locationURI = new Path(location).toUri();
                }
                catch (IllegalArgumentException e) {
                    badRecords.add(location);
                }
                if (locationURI == null) {
                    badRecords.add(location);
                    continue;
                }
                if (!this.shouldUpdateURI(locationURI, oldLoc)) continue;
                String tblLoc = mSDS.getLocation().replaceAll(oldLoc.toString(), newLoc.toString());
                updateLocations.put(locationURI.toString(), tblLoc);
                if (isDryRun) continue;
                mSDS.setLocation(tblLoc);
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdateMStorageDescriptorTblURIRetVal(badRecords, updateLocations, numNullRecords);
            }
            Iterator iterator = retVal;
            this.rollbackAndCleanup(committed, query);
            return iterator;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateSerdeURIRetVal updateSerdeURI(URI oldLoc, URI newLoc, String serdeProp, boolean isDryRun) {
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        UpdateSerdeURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MSerDeInfo.class);
            List mSerdes = (List)query.execute();
            this.pm.retrieveAll((Collection)mSerdes);
            for (MSerDeInfo mSerde : mSerdes) {
                if (!mSerde.getParameters().containsKey(serdeProp)) continue;
                String schemaLoc = mSerde.getParameters().get(serdeProp);
                URI schemaLocURI = null;
                try {
                    schemaLocURI = new Path(schemaLoc).toUri();
                }
                catch (IllegalArgumentException e) {
                    badRecords.add(schemaLoc);
                }
                if (schemaLocURI == null) {
                    badRecords.add(schemaLoc);
                    continue;
                }
                if (!this.shouldUpdateURI(schemaLocURI, oldLoc)) continue;
                String newSchemaLoc = schemaLoc.replaceAll(oldLoc.toString(), newLoc.toString());
                updateLocations.put(schemaLocURI.toString(), newSchemaLoc);
                if (isDryRun) continue;
                mSerde.getParameters().put(serdeProp, newSchemaLoc);
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdateSerdeURIRetVal(badRecords, updateLocations);
            }
            Iterator iterator = retVal;
            this.rollbackAndCleanup(committed, query);
            return iterator;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMTableColumnStatistics(Table table, MTableColumnStatistics mStatsObj, MTableColumnStatistics oldStats) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        String colName = mStatsObj.getColName();
        try (QueryWrapper queryWrapper = new QueryWrapper();){
            LOG.info("Updating table level column statistics for table={} colName={}", (Object)Warehouse.getCatalogQualifiedTableName(table), (Object)colName);
            this.validateTableCols(table, Lists.newArrayList(colName));
            if (oldStats != null) {
                StatObjectConverter.setFieldsIntoOldStats(mStatsObj, oldStats);
            } else {
                if (this.sqlGenerator.getDbProduct().equals((Object)DatabaseProduct.POSTGRES) && mStatsObj.getBitVector() == null) {
                    mStatsObj.setBitVector(new byte[]{72, 76});
                }
                this.pm.makePersistent((Object)mStatsObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMPartitionColumnStatistics(Table table, Partition partition, MPartitionColumnStatistics mStatsObj, MPartitionColumnStatistics oldStats) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        String catName = mStatsObj.getCatName();
        String dbName = mStatsObj.getDbName();
        String tableName = mStatsObj.getTableName();
        String partName = mStatsObj.getPartitionName();
        String colName = mStatsObj.getColName();
        LOG.info("Updating partition level column statistics for table=" + Warehouse.getCatalogQualifiedTableName(catName, dbName, tableName) + " partName=" + partName + " colName=" + colName);
        boolean foundCol = false;
        List<FieldSchema> colList = partition.getSd().getCols();
        for (FieldSchema col : colList) {
            if (!col.getName().equals(mStatsObj.getColName())) continue;
            foundCol = true;
            break;
        }
        if (!foundCol) {
            LOG.warn("Column " + colName + " for which stats gathering is requested doesn't exist.");
        }
        try (QueryWrapper queryWrapper = new QueryWrapper();){
            if (oldStats != null) {
                StatObjectConverter.setFieldsIntoOldStats(mStatsObj, oldStats);
            } else {
                if (this.sqlGenerator.getDbProduct().equals((Object)DatabaseProduct.POSTGRES) && mStatsObj.getBitVector() == null) {
                    mStatsObj.setBitVector(new byte[]{72, 76});
                }
                this.pm.makePersistent((Object)mStatsObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, MTableColumnStatistics> getPartitionColStats(Table table, List<String> colNames) throws NoSuchObjectException, MetaException {
        HashMap<String, MTableColumnStatistics> statsMap = Maps.newHashMap();
        try (QueryWrapper queryWrapper = new QueryWrapper();){
            List<MTableColumnStatistics> stats = this.getMTableColumnStatistics(table, colNames, queryWrapper);
            for (MTableColumnStatistics cStat : stats) {
                statsMap.put(cStat.getColName(), cStat);
            }
        }
        return statsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateTableColumnStatistics(ColumnStatistics colStats) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        boolean committed = false;
        this.openTransaction();
        try {
            List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
            ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
            String catName = statsDesc.isSetCatName() ? statsDesc.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            Table table = this.ensureGetTable(catName, statsDesc.getDbName(), statsDesc.getTableName());
            ArrayList<String> colNames = new ArrayList<String>();
            for (ColumnStatisticsObj columnStatisticsObj : statsObjs) {
                colNames.add(columnStatisticsObj.getColName());
            }
            Map<String, MTableColumnStatistics> oldStats = this.getPartitionColStats(table, colNames);
            for (ColumnStatisticsObj statsObj : statsObjs) {
                MTableColumnStatistics mStatsObj = StatObjectConverter.convertToMTableColumnStatistics(this.ensureGetMTable(catName, statsDesc.getDbName(), statsDesc.getTableName()), statsDesc, statsObj);
                this.writeMTableColumnStatistics(table, mStatsObj, oldStats.get(statsObj.getColName()));
            }
            String string = table.getDbName();
            String name = table.getTableName();
            MTable oldt = this.getMTable(catName, string, name);
            Map<String, String> parameters = table.getParameters();
            StatsSetupConst.setColumnStatsState(parameters, colNames);
            oldt.setParameters(parameters);
            boolean bl = committed = this.commitTransaction();
            return bl;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, MPartitionColumnStatistics> getPartitionColStats(Table table, String partitionName, List<String> colNames) throws NoSuchObjectException, MetaException {
        HashMap<String, MPartitionColumnStatistics> statsMap = Maps.newHashMap();
        try (QueryWrapper queryWrapper = new QueryWrapper();){
            List<MPartitionColumnStatistics> stats = this.getMPartitionColumnStatistics(table, Lists.newArrayList(partitionName), colNames, queryWrapper);
            for (MPartitionColumnStatistics cStat : stats) {
                statsMap.put(cStat.getColName(), cStat);
            }
        }
        return statsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePartitionColumnStatistics(ColumnStatistics colStats, List<String> partVals) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        boolean committed = false;
        try {
            this.openTransaction();
            List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
            ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
            String catName = statsDesc.isSetCatName() ? statsDesc.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            Table table = this.ensureGetTable(catName, statsDesc.getDbName(), statsDesc.getTableName());
            Partition partition = this.convertToPart(this.getMPartition(catName, statsDesc.getDbName(), statsDesc.getTableName(), partVals));
            ArrayList<String> colNames = new ArrayList<String>();
            for (ColumnStatisticsObj statsObj : statsObjs) {
                colNames.add(statsObj.getColName());
            }
            Map<String, MPartitionColumnStatistics> oldStats = this.getPartitionColStats(table, statsDesc.getPartName(), colNames);
            MPartition mPartition = this.getMPartition(catName, statsDesc.getDbName(), statsDesc.getTableName(), partVals);
            if (partition == null) {
                throw new NoSuchObjectException("Partition for which stats is gathered doesn't exist.");
            }
            for (ColumnStatisticsObj statsObj : statsObjs) {
                MPartitionColumnStatistics mStatsObj = StatObjectConverter.convertToMPartitionColumnStatistics(mPartition, statsDesc, statsObj);
                this.writeMPartitionColumnStatistics(table, partition, mStatsObj, oldStats.get(statsObj.getColName()));
            }
            Map<String, String> parameters = mPartition.getParameters();
            StatsSetupConst.setColumnStatsState(parameters, colNames);
            mPartition.setParameters(parameters);
            boolean bl = committed = this.commitTransaction();
            return bl;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    private List<MTableColumnStatistics> getMTableColumnStatistics(Table table, List<String> colNames, QueryWrapper queryWrapper) throws MetaException {
        if (colNames == null || colNames.isEmpty()) {
            return Collections.emptyList();
        }
        boolean committed = false;
        try {
            this.openTransaction();
            List result = null;
            this.validateTableCols(table, colNames);
            Query query = queryWrapper.query = this.pm.newQuery(MTableColumnStatistics.class);
            String filter = "tableName == t1 && dbName == t2 && catName == t3 && (";
            String paramStr = "java.lang.String t1, java.lang.String t2, java.lang.String t3";
            Object[] params = new Object[colNames.size() + 3];
            params[0] = table.getTableName();
            params[1] = table.getDbName();
            params[2] = table.getCatName();
            for (int i = 0; i < colNames.size(); ++i) {
                filter = filter + (i == 0 ? "" : " || ") + "colName == c" + i;
                paramStr = paramStr + ", java.lang.String c" + i;
                params[i + 3] = colNames.get(i);
            }
            filter = filter + ")";
            query.setFilter(filter);
            query.declareParameters(paramStr);
            result = (List)query.executeWithArray(params);
            this.pm.retrieveAll((Collection)result);
            if (result.size() > colNames.size()) {
                throw new MetaException("Unexpected " + result.size() + " statistics for " + colNames.size() + " columns");
            }
            committed = this.commitTransaction();
            List list = result;
            return list;
        }
        catch (Exception ex) {
            LOG.error("Error retrieving statistics via jdo", ex);
            if (ex instanceof MetaException) {
                throw (MetaException)((Object)ex);
            }
            throw new MetaException(ex.getMessage());
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    @.VisibleForTesting
    public void validateTableCols(Table table, List<String> colNames) throws MetaException {
        List<FieldSchema> colList = table.getSd().getCols();
        for (String colName : colNames) {
            boolean foundCol = false;
            for (FieldSchema mCol : colList) {
                if (!mCol.getName().equals(colName)) continue;
                foundCol = true;
                break;
            }
            if (foundCol) continue;
            throw new MetaException("Column " + colName + " doesn't exist in table " + table.getTableName() + " in database " + table.getDbName());
        }
    }

    @Override
    public ColumnStatistics getTableColumnStatistics(String catName, String dbName, String tableName, List<String> colNames) throws MetaException, NoSuchObjectException {
        return this.getTableColumnStatisticsInternal(catName, dbName, tableName, colNames, true, true);
    }

    protected ColumnStatistics getTableColumnStatisticsInternal(String catName, String dbName, String tableName, final List<String> colNames, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        final boolean enableBitVector = MetastoreConf.getBoolVar(this.getConf(), MetastoreConf.ConfVars.STATS_FETCH_BITVECTOR);
        return (ColumnStatistics)new GetStatHelper(StringUtils.normalizeIdentifier(catName), StringUtils.normalizeIdentifier(dbName), StringUtils.normalizeIdentifier(tableName), allowSql, allowJdo){

            @Override
            protected ColumnStatistics getSqlResult(GetHelper<ColumnStatistics> ctx) throws MetaException {
                return ObjectStore.this.directSql.getTableStats(this.catName, this.dbName, this.tblName, colNames, enableBitVector);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected ColumnStatistics getJdoResult(GetHelper<ColumnStatistics> ctx) throws MetaException {
                try (QueryWrapper queryWrapper = new QueryWrapper();){
                    List mStats = ObjectStore.this.getMTableColumnStatistics(this.getTable(), colNames, queryWrapper);
                    if (mStats.isEmpty()) {
                        ColumnStatistics columnStatistics = null;
                        return columnStatistics;
                    }
                    ColumnStatisticsDesc desc = StatObjectConverter.getTableColumnStatisticsDesc((MTableColumnStatistics)mStats.get(0));
                    ArrayList<ColumnStatisticsObj> statObjs = new ArrayList<ColumnStatisticsObj>(mStats.size());
                    for (MTableColumnStatistics mStat : mStats) {
                        if (desc.getLastAnalyzed() > mStat.getLastAnalyzed()) {
                            desc.setLastAnalyzed(mStat.getLastAnalyzed());
                        }
                        statObjs.add(StatObjectConverter.getTableColumnStatisticsObj(mStat, enableBitVector));
                        Deadline.checkTimeout();
                    }
                    ColumnStatistics columnStatistics = new ColumnStatistics(desc, statObjs);
                    return columnStatistics;
                }
            }
        }.run(true);
    }

    @Override
    public List<ColumnStatistics> getPartitionColumnStatistics(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames) throws MetaException, NoSuchObjectException {
        return this.getPartitionColumnStatisticsInternal(catName, dbName, tableName, partNames, colNames, true, true);
    }

    protected List<ColumnStatistics> getPartitionColumnStatisticsInternal(String catName, String dbName, String tableName, final List<String> partNames, final List<String> colNames, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        final boolean enableBitVector = MetastoreConf.getBoolVar(this.getConf(), MetastoreConf.ConfVars.STATS_FETCH_BITVECTOR);
        return (List)new GetListHelper<ColumnStatistics>(catName, dbName, tableName, allowSql, allowJdo){

            @Override
            protected List<ColumnStatistics> getSqlResult(GetHelper<List<ColumnStatistics>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getPartitionStats(this.catName, this.dbName, this.tblName, partNames, colNames, enableBitVector);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected List<ColumnStatistics> getJdoResult(GetHelper<List<ColumnStatistics>> ctx) throws MetaException, NoSuchObjectException {
                try (QueryWrapper queryWrapper = new QueryWrapper();){
                    List mStats = ObjectStore.this.getMPartitionColumnStatistics(this.getTable(), partNames, colNames, queryWrapper);
                    ArrayList<ColumnStatistics> result = new ArrayList<ColumnStatistics>(Math.min(mStats.size(), partNames.size()));
                    String lastPartName = null;
                    ArrayList<ColumnStatisticsObj> curList = null;
                    ColumnStatisticsDesc csd = null;
                    for (int i = 0; i <= mStats.size(); ++i) {
                        String partName;
                        boolean isLast = i == mStats.size();
                        MPartitionColumnStatistics mStatsObj = isLast ? null : (MPartitionColumnStatistics)mStats.get(i);
                        String string = partName = isLast ? null : mStatsObj.getPartitionName();
                        if (isLast || !partName.equals(lastPartName)) {
                            if (i != 0) {
                                result.add(new ColumnStatistics(csd, curList));
                            }
                            if (isLast) continue;
                            csd = StatObjectConverter.getPartitionColumnStatisticsDesc(mStatsObj);
                            curList = new ArrayList<ColumnStatisticsObj>(colNames.size());
                        }
                        curList.add(StatObjectConverter.getPartitionColumnStatisticsObj(mStatsObj, enableBitVector));
                        lastPartName = partName;
                        Deadline.checkTimeout();
                    }
                    ArrayList<ColumnStatistics> arrayList = result;
                    return arrayList;
                }
            }
        }.run(true);
    }

    @Override
    public AggrStats get_aggr_stats_for(String catName, String dbName, String tblName, final List<String> partNames, final List<String> colNames) throws MetaException, NoSuchObjectException {
        final boolean useDensityFunctionForNDVEstimation = MetastoreConf.getBoolVar(this.getConf(), MetastoreConf.ConfVars.STATS_NDV_DENSITY_FUNCTION);
        final double ndvTuner = MetastoreConf.getDoubleVar(this.getConf(), MetastoreConf.ConfVars.STATS_NDV_TUNER);
        final boolean enableBitVector = MetastoreConf.getBoolVar(this.getConf(), MetastoreConf.ConfVars.STATS_FETCH_BITVECTOR);
        return (AggrStats)new GetHelper<AggrStats>(catName, dbName, tblName, true, false){

            @Override
            protected AggrStats getSqlResult(GetHelper<AggrStats> ctx) throws MetaException {
                return ObjectStore.this.directSql.aggrColStatsForPartitions(this.catName, this.dbName, this.tblName, partNames, colNames, useDensityFunctionForNDVEstimation, ndvTuner, enableBitVector);
            }

            @Override
            protected AggrStats getJdoResult(GetHelper<AggrStats> ctx) throws MetaException, NoSuchObjectException {
                throw new MetaException("Jdo path is not implemented for stats aggr.");
            }

            @Override
            protected String describeResult() {
                return null;
            }
        }.run(true);
    }

    @Override
    public List<MetaStoreUtils.ColStatsObjWithSourceInfo> getPartitionColStatsForDatabase(String catName, String dbName) throws MetaException, NoSuchObjectException {
        final boolean enableBitVector = MetastoreConf.getBoolVar(this.getConf(), MetastoreConf.ConfVars.STATS_FETCH_BITVECTOR);
        return (List)new GetHelper<List<MetaStoreUtils.ColStatsObjWithSourceInfo>>(catName, dbName, null, true, false){

            @Override
            protected List<MetaStoreUtils.ColStatsObjWithSourceInfo> getSqlResult(GetHelper<List<MetaStoreUtils.ColStatsObjWithSourceInfo>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getColStatsForAllTablePartitions(this.catName, this.dbName, enableBitVector);
            }

            @Override
            protected List<MetaStoreUtils.ColStatsObjWithSourceInfo> getJdoResult(GetHelper<List<MetaStoreUtils.ColStatsObjWithSourceInfo>> ctx) throws MetaException, NoSuchObjectException {
                throw new MetaException("Jdo path is not implemented for getPartitionColStatsForDatabase.");
            }

            @Override
            protected String describeResult() {
                return null;
            }
        }.run(true);
    }

    @Override
    public void flushCache() {
    }

    private List<MPartitionColumnStatistics> getMPartitionColumnStatistics(Table table, List<String> partNames, List<String> colNames, QueryWrapper queryWrapper) throws NoSuchObjectException, MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            try {
                this.validateTableCols(table, colNames);
            }
            catch (MetaException me) {
                LOG.warn("The table does not have the same column definition as its partition.");
            }
            Query query = queryWrapper.query = this.pm.newQuery(MPartitionColumnStatistics.class);
            String paramStr = "java.lang.String t1, java.lang.String t2, java.lang.String t3";
            String filter = "tableName == t1 && dbName == t2 && catName == t3 && (";
            Object[] params = new Object[colNames.size() + partNames.size() + 3];
            int i = 0;
            params[i++] = table.getTableName();
            params[i++] = table.getDbName();
            params[i++] = table.isSetCatName() ? table.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            int firstI = i;
            for (String s : partNames) {
                filter = filter + (i == firstI ? "" : " || ") + "partitionName == p" + i;
                paramStr = paramStr + ", java.lang.String p" + i;
                params[i++] = s;
            }
            filter = filter + ") && (";
            firstI = i;
            for (String s : colNames) {
                filter = filter + (i == firstI ? "" : " || ") + "colName == c" + i;
                paramStr = paramStr + ", java.lang.String c" + i;
                params[i++] = s;
            }
            filter = filter + ")";
            query.setFilter(filter);
            query.declareParameters(paramStr);
            query.setOrdering("partitionName ascending");
            List result = (List)query.executeWithArray(params);
            this.pm.retrieveAll((Collection)result);
            committed = this.commitTransaction();
            List list = result;
            return list;
        }
        catch (Exception ex) {
            LOG.error("Error retrieving statistics via jdo", ex);
            if (ex instanceof MetaException) {
                throw (MetaException)((Object)ex);
            }
            throw new MetaException(ex.getMessage());
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
                return Lists.newArrayList();
            }
        }
    }

    private void dropPartitionColumnStatisticsNoTxn(String catName, String dbName, String tableName, List<String> partNames) throws MetaException {
        ObjectPair<Query, Object[]> queryWithParams = this.makeQueryByPartitionNames(catName, dbName, tableName, partNames, MPartitionColumnStatistics.class, "tableName", "dbName", "partition.partitionName", "catName");
        queryWithParams.getFirst().deletePersistentAll(queryWithParams.getSecond());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deletePartitionColumnStatistics(String catName, String dbName, String tableName, String partName, List<String> partVals, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        boolean ret = false;
        Query query = null;
        dbName = io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.defaultString(dbName, "default");
        catName = StringUtils.normalizeIdentifier(catName);
        if (tableName == null) {
            throw new InvalidInputException("Table name is null.");
        }
        try {
            String parameters;
            String filter;
            this.openTransaction();
            MTable mTable = this.getMTable(catName, dbName, tableName);
            if (mTable == null) {
                throw new NoSuchObjectException("Table " + tableName + "  for which stats deletion is requested doesn't exist");
            }
            MPartition mPartition = this.getMPartition(catName, dbName, tableName, partVals);
            if (mPartition == null) {
                throw new NoSuchObjectException("Partition " + partName + " for which stats deletion is requested doesn't exist");
            }
            query = this.pm.newQuery(MPartitionColumnStatistics.class);
            if (colName != null) {
                filter = "partition.partitionName == t1 && dbName == t2 && tableName == t3 && colName == t4 && catName == t5";
                parameters = "java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4, java.lang.String t5";
            } else {
                filter = "partition.partitionName == t1 && dbName == t2 && tableName == t3 && catName == t4";
                parameters = "java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4";
            }
            query.setFilter(filter);
            query.declareParameters(parameters);
            if (colName != null) {
                query.setUnique(true);
                MPartitionColumnStatistics mStatsObj = (MPartitionColumnStatistics)query.executeWithArray(new Object[]{partName.trim(), StringUtils.normalizeIdentifier(dbName), StringUtils.normalizeIdentifier(tableName), StringUtils.normalizeIdentifier(colName), StringUtils.normalizeIdentifier(catName)});
                this.pm.retrieve((Object)mStatsObj);
                if (mStatsObj == null) throw new NoSuchObjectException("Column stats doesn't exist for table=" + Warehouse.getCatalogQualifiedTableName(catName, dbName, tableName) + " partition=" + partName + " col=" + colName);
                this.pm.deletePersistent((Object)mStatsObj);
            } else {
                List mStatsObjColl = (List)query.executeWithArray(new Object[]{partName.trim(), StringUtils.normalizeIdentifier(dbName), StringUtils.normalizeIdentifier(tableName), StringUtils.normalizeIdentifier(catName)});
                this.pm.retrieveAll((Collection)mStatsObjColl);
                if (mStatsObjColl == null) throw new NoSuchObjectException("Column stats don't exist for table=" + Warehouse.getCatalogQualifiedTableName(catName, dbName, tableName) + " partition" + partName);
                this.pm.deletePersistentAll((Collection)mStatsObjColl);
            }
            ret = this.commitTransaction();
            this.rollbackAndCleanup(ret, query);
            return ret;
        }
        catch (NoSuchObjectException e) {
            try {
                this.rollbackTransaction();
                throw e;
            }
            catch (Throwable throwable) {
                this.rollbackAndCleanup(ret, query);
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deleteTableColumnStatistics(String catName, String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        boolean ret = false;
        Query query = null;
        dbName = io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.defaultString(dbName, "default");
        if (tableName == null) {
            throw new InvalidInputException("Table name is null.");
        }
        try {
            String parameters;
            String filter;
            this.openTransaction();
            MTable mTable = this.getMTable(catName, dbName, tableName);
            if (mTable == null) {
                throw new NoSuchObjectException("Table " + Warehouse.getCatalogQualifiedTableName(catName, dbName, tableName) + "  for which stats deletion is requested doesn't exist");
            }
            query = this.pm.newQuery(MTableColumnStatistics.class);
            if (colName != null) {
                filter = "table.tableName == t1 && dbName == t2 && catName == t3 && colName == t4";
                parameters = "java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4";
            } else {
                filter = "table.tableName == t1 && dbName == t2 && catName == t3";
                parameters = "java.lang.String t1, java.lang.String t2, java.lang.String t3";
            }
            query.setFilter(filter);
            query.declareParameters(parameters);
            if (colName != null) {
                query.setUnique(true);
                MTableColumnStatistics mStatsObj = (MTableColumnStatistics)query.executeWithArray(new Object[]{StringUtils.normalizeIdentifier(tableName), StringUtils.normalizeIdentifier(dbName), StringUtils.normalizeIdentifier(catName), StringUtils.normalizeIdentifier(colName)});
                this.pm.retrieve((Object)mStatsObj);
                if (mStatsObj == null) throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " table=" + tableName + " col=" + colName);
                this.pm.deletePersistent((Object)mStatsObj);
            } else {
                List mStatsObjColl = (List)query.execute((Object)StringUtils.normalizeIdentifier(tableName), (Object)StringUtils.normalizeIdentifier(dbName), (Object)StringUtils.normalizeIdentifier(catName));
                this.pm.retrieveAll((Collection)mStatsObjColl);
                if (mStatsObjColl == null) throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " table=" + tableName);
                this.pm.deletePersistentAll((Collection)mStatsObjColl);
            }
            ret = this.commitTransaction();
            this.rollbackAndCleanup(ret, query);
            return ret;
        }
        catch (NoSuchObjectException e) {
            try {
                this.rollbackTransaction();
                throw e;
            }
            catch (Throwable throwable) {
                this.rollbackAndCleanup(ret, query);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long cleanupEvents() {
        long delCnt;
        boolean commited = false;
        Query query = null;
        LOG.debug("Begin executing cleanupEvents");
        Long expiryTime = MetastoreConf.getTimeVar(this.getConf(), MetastoreConf.ConfVars.EVENT_EXPIRY_DURATION, TimeUnit.MILLISECONDS);
        Long curTime = System.currentTimeMillis();
        try {
            this.openTransaction();
            query = this.pm.newQuery(MPartitionEvent.class, "curTime - eventTime > expiryTime");
            query.declareParameters("java.lang.Long curTime, java.lang.Long expiryTime");
            delCnt = query.deletePersistentAll(new Object[]{curTime, expiryTime});
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
            LOG.debug("Done executing cleanupEvents");
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            LOG.debug("Done executing cleanupEvents");
            throw throwable;
        }
        return delCnt;
    }

    private MDelegationToken getTokenFrom(String tokenId) {
        Query query = this.pm.newQuery(MDelegationToken.class, "tokenIdentifier == tokenId");
        query.declareParameters("java.lang.String tokenId");
        query.setUnique(true);
        MDelegationToken delegationToken = (MDelegationToken)query.execute((Object)tokenId);
        if (query != null) {
            query.closeAll();
        }
        return delegationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addToken(String tokenId, String delegationToken) {
        MDelegationToken token;
        LOG.debug("Begin executing addToken");
        boolean committed = false;
        try {
            this.openTransaction();
            token = this.getTokenFrom(tokenId);
            if (token == null) {
                this.pm.makePersistent((Object)new MDelegationToken(tokenId, delegationToken));
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
        LOG.debug("Done executing addToken with status : {}", (Object)committed);
        return committed && token == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeToken(String tokenId) {
        MDelegationToken token;
        LOG.debug("Begin executing removeToken");
        boolean committed = false;
        try {
            this.openTransaction();
            token = this.getTokenFrom(tokenId);
            if (null != token) {
                this.pm.deletePersistent((Object)token);
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
        LOG.debug("Done executing removeToken with status : {}", (Object)committed);
        return committed && token != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToken(String tokenId) {
        MDelegationToken token;
        LOG.debug("Begin executing getToken");
        boolean committed = false;
        try {
            this.openTransaction();
            token = this.getTokenFrom(tokenId);
            if (null != token) {
                this.pm.retrieve((Object)token);
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
        LOG.debug("Done executing getToken with status : {}", (Object)committed);
        return null == token ? null : token.getTokenStr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllTokenIdentifiers() {
        LOG.debug("Begin executing getAllTokenIdentifiers");
        boolean committed = false;
        Query query = null;
        ArrayList<String> tokenIdents = new ArrayList<String>();
        try {
            this.openTransaction();
            query = this.pm.newQuery(MDelegationToken.class);
            List tokens = (List)query.execute();
            this.pm.retrieveAll((Collection)tokens);
            committed = this.commitTransaction();
            for (MDelegationToken token : tokens) {
                tokenIdents.add(token.getTokenIdentifier());
            }
            ArrayList<String> arrayList = tokenIdents;
            return arrayList;
        }
        finally {
            LOG.debug("Done executing getAllTokenIdentifers with status : {}", (Object)committed);
            this.rollbackAndCleanup(committed, query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addMasterKey(String key) throws MetaException {
        LOG.debug("Begin executing addMasterKey");
        boolean committed = false;
        MMasterKey masterKey = new MMasterKey(key);
        try {
            this.openTransaction();
            this.pm.makePersistent((Object)masterKey);
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
        LOG.debug("Done executing addMasterKey with status : {}", (Object)committed);
        if (committed) {
            return ((IntIdentity)this.pm.getObjectId((Object)masterKey)).getKey();
        }
        throw new MetaException("Failed to add master key.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMasterKey(Integer id, String key) throws NoSuchObjectException, MetaException {
        MMasterKey masterKey;
        LOG.debug("Begin executing updateMasterKey");
        boolean committed = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MMasterKey.class, "keyId == id");
            query.declareParameters("java.lang.Integer id");
            query.setUnique(true);
            masterKey = (MMasterKey)query.execute((Object)id);
            if (null != masterKey) {
                masterKey.setMasterKey(key);
            }
            committed = this.commitTransaction();
            this.rollbackAndCleanup(committed, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
        LOG.debug("Done executing updateMasterKey with status : {}", (Object)committed);
        if (null == masterKey) {
            throw new NoSuchObjectException("No key found with keyId: " + id);
        }
        if (!committed) {
            throw new MetaException("Though key is found, failed to update it. " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeMasterKey(Integer id) {
        MMasterKey masterKey;
        LOG.debug("Begin executing removeMasterKey");
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MMasterKey.class, "keyId == id");
            query.declareParameters("java.lang.Integer id");
            query.setUnique(true);
            masterKey = (MMasterKey)query.execute((Object)id);
            if (null != masterKey) {
                this.pm.deletePersistent((Object)masterKey);
            }
            success = this.commitTransaction();
            this.rollbackAndCleanup(success, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(success, query);
            throw throwable;
        }
        LOG.debug("Done executing removeMasterKey with status : {}", (Object)success);
        return null != masterKey && success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getMasterKeys() {
        LOG.debug("Begin executing getMasterKeys");
        boolean committed = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MMasterKey.class);
            List keys = (List)query.execute();
            this.pm.retrieveAll((Collection)keys);
            committed = this.commitTransaction();
            String[] masterKeys = new String[keys.size()];
            for (int i = 0; i < keys.size(); ++i) {
                masterKeys[i] = ((MMasterKey)keys.get(i)).getMasterKey();
            }
            String[] stringArray = masterKeys;
            return stringArray;
        }
        finally {
            LOG.debug("Done executing getMasterKeys with status : {}", (Object)committed);
            this.rollbackAndCleanup(committed, query);
        }
    }

    @Override
    public void verifySchema() throws MetaException {
        if (isSchemaVerified.get()) {
            return;
        }
        this.checkSchema();
    }

    public static void setSchemaVerified(boolean val) {
        isSchemaVerified.set(val);
    }

    private synchronized void checkSchema() throws MetaException {
        if (isSchemaVerified.get()) {
            return;
        }
        boolean strictValidation = MetastoreConf.getBoolVar(this.getConf(), MetastoreConf.ConfVars.SCHEMA_VERIFICATION);
        String dbSchemaVer = this.getMetaStoreSchemaVersion();
        IMetaStoreSchemaInfo metastoreSchemaInfo = MetaStoreSchemaInfoFactory.get(this.getConf());
        String hiveSchemaVer = metastoreSchemaInfo.getHiveSchemaVersion();
        if (dbSchemaVer == null) {
            if (strictValidation) {
                throw new MetaException("Version information not found in metastore.");
            }
            LOG.warn("Version information not found in metastore. {} is not enabled so recording the schema version {}", (Object)MetastoreConf.ConfVars.SCHEMA_VERIFICATION, (Object)hiveSchemaVer);
            this.setMetaStoreSchemaVersion(hiveSchemaVer, "Set by MetaStore " + USER + "@" + HOSTNAME);
        } else if (metastoreSchemaInfo.isVersionCompatible(hiveSchemaVer, dbSchemaVer)) {
            LOG.debug("Found expected HMS version of {}", (Object)dbSchemaVer);
        } else {
            if (strictValidation) {
                throw new MetaException("Hive Schema version " + hiveSchemaVer + " does not match metastore's schema version " + dbSchemaVer + " Metastore is not upgraded or corrupt");
            }
            LOG.error("Version information found in metastore differs {} from expected schema version {}. Schema verification is disabled {}", new Object[]{dbSchemaVer, hiveSchemaVer, MetastoreConf.ConfVars.SCHEMA_VERIFICATION});
            this.setMetaStoreSchemaVersion(hiveSchemaVer, "Set by MetaStore " + USER + "@" + HOSTNAME);
        }
        isSchemaVerified.set(true);
    }

    @Override
    public String getMetaStoreSchemaVersion() throws MetaException {
        MVersionTable mSchemaVer;
        try {
            mSchemaVer = this.getMSchemaVersion();
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        return mSchemaVer.getSchemaVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MVersionTable getMSchemaVersion() throws NoSuchObjectException, MetaException {
        boolean committed = false;
        Query query = null;
        List mVerTables = new ArrayList();
        try {
            this.openTransaction();
            query = this.pm.newQuery(MVersionTable.class);
            try {
                mVerTables = (List)query.execute();
                this.pm.retrieveAll(mVerTables);
            }
            catch (JDODataStoreException e) {
                if (e.getCause() instanceof MissingTableException) {
                    throw new MetaException("Version table not found. The metastore is not upgraded to " + MetaStoreSchemaInfoFactory.get(this.getConf()).getHiveSchemaVersion());
                }
                throw e;
            }
            committed = this.commitTransaction();
            if (mVerTables.isEmpty()) {
                throw new NoSuchObjectException("No matching version found");
            }
            if (mVerTables.size() > 1) {
                String msg = "Metastore contains multiple versions (" + mVerTables.size() + ") ";
                for (MVersionTable version : mVerTables) {
                    msg = msg + "[ version = " + version.getSchemaVersion() + ", comment = " + version.getVersionComment() + " ] ";
                }
                throw new MetaException(msg.trim());
            }
            MVersionTable mVersionTable = (MVersionTable)mVerTables.get(0);
            this.rollbackAndCleanup(committed, query);
            return mVersionTable;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMetaStoreSchemaVersion(String schemaVersion, String comment) throws MetaException {
        MVersionTable mSchemaVer;
        boolean commited = false;
        boolean recordVersion = MetastoreConf.getBoolVar(this.getConf(), MetastoreConf.ConfVars.SCHEMA_VERIFICATION_RECORD_VERSION);
        if (!recordVersion) {
            LOG.warn("setMetaStoreSchemaVersion called but recording version is disabled: version = {}, comment = {}", (Object)schemaVersion, (Object)comment);
            return;
        }
        LOG.warn("Setting metastore schema version in db to {}", (Object)schemaVersion);
        try {
            mSchemaVer = this.getMSchemaVersion();
        }
        catch (NoSuchObjectException e) {
            mSchemaVer = new MVersionTable();
        }
        mSchemaVer.setSchemaVersion(schemaVersion);
        mSchemaVer.setVersionComment(comment);
        try {
            this.openTransaction();
            this.pm.makePersistent((Object)mSchemaVer);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
    }

    @Override
    public boolean doesPartitionExist(String catName, String dbName, String tableName, List<String> partVals) throws MetaException {
        try {
            return this.getPartition(catName, dbName, tableName, partVals) != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    private void debugLog(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {}", (Object)message, (Object)this.getCallStack());
        }
    }

    private String getCallStack() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int thislimit = Math.min(3, stackTrace.length);
        StringBuilder sb = new StringBuilder();
        sb.append(" at:");
        for (int i = 4; i < thislimit + 4; ++i) {
            sb.append("\n\t");
            sb.append(stackTrace[i].toString());
        }
        return sb.toString();
    }

    private Function convertToFunction(MFunction mfunc) {
        if (mfunc == null) {
            return null;
        }
        Function func = new Function(mfunc.getFunctionName(), mfunc.getDatabase().getName(), mfunc.getClassName(), mfunc.getOwnerName(), PrincipalType.valueOf(mfunc.getOwnerType()), mfunc.getCreateTime(), FunctionType.findByValue(mfunc.getFunctionType()), this.convertToResourceUriList(mfunc.getResourceUris()));
        func.setCatName(mfunc.getDatabase().getCatalogName());
        return func;
    }

    private List<Function> convertToFunctions(List<MFunction> mfuncs) {
        if (mfuncs == null) {
            return null;
        }
        ArrayList<Function> functions = new ArrayList<Function>();
        for (MFunction mfunc : mfuncs) {
            functions.add(this.convertToFunction(mfunc));
        }
        return functions;
    }

    private MFunction convertToMFunction(Function func) throws InvalidObjectException {
        if (func == null) {
            return null;
        }
        MDatabase mdb = null;
        String catName = func.isSetCatName() ? func.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
        try {
            mdb = this.getMDatabase(catName, func.getDbName());
        }
        catch (NoSuchObjectException e) {
            LOG.error("Database does not exist", (Throwable)((Object)e));
            throw new InvalidObjectException("Database " + func.getDbName() + " doesn't exist.");
        }
        MFunction mfunc = new MFunction(func.getFunctionName(), mdb, func.getClassName(), func.getOwnerName(), func.getOwnerType().name(), func.getCreateTime(), func.getFunctionType().getValue(), this.convertToMResourceUriList(func.getResourceUris()));
        return mfunc;
    }

    private List<ResourceUri> convertToResourceUriList(List<MResourceUri> mresourceUriList) {
        ArrayList<ResourceUri> resourceUriList = null;
        if (mresourceUriList != null) {
            resourceUriList = new ArrayList<ResourceUri>(mresourceUriList.size());
            for (MResourceUri mres : mresourceUriList) {
                resourceUriList.add(new ResourceUri(ResourceType.findByValue(mres.getResourceType()), mres.getUri()));
            }
        }
        return resourceUriList;
    }

    private List<MResourceUri> convertToMResourceUriList(List<ResourceUri> resourceUriList) {
        ArrayList<MResourceUri> mresourceUriList = null;
        if (resourceUriList != null) {
            mresourceUriList = new ArrayList<MResourceUri>(resourceUriList.size());
            for (ResourceUri res : resourceUriList) {
                mresourceUriList.add(new MResourceUri(res.getResourceType().getValue(), res.getUri()));
            }
        }
        return mresourceUriList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFunction(Function func) throws InvalidObjectException, MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            MFunction mfunc = this.convertToMFunction(func);
            this.pm.makePersistent((Object)mfunc);
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterFunction(String catName, String dbName, String funcName, Function newFunction) throws InvalidObjectException, MetaException {
        boolean success = false;
        try {
            String newFuncCat;
            String string = newFuncCat = newFunction.isSetCatName() ? newFunction.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            if (!newFuncCat.equalsIgnoreCase(catName)) {
                throw new InvalidObjectException("You cannot move a function between catalogs");
            }
            this.openTransaction();
            catName = StringUtils.normalizeIdentifier(catName);
            funcName = StringUtils.normalizeIdentifier(funcName);
            dbName = StringUtils.normalizeIdentifier(dbName);
            MFunction newf = this.convertToMFunction(newFunction);
            if (newf == null) {
                throw new InvalidObjectException("new function is invalid");
            }
            MFunction oldf = this.getMFunction(catName, dbName, funcName);
            if (oldf == null) {
                throw new MetaException("function " + funcName + " doesn't exist");
            }
            oldf.setFunctionName(StringUtils.normalizeIdentifier(newf.getFunctionName()));
            oldf.setDatabase(newf.getDatabase());
            oldf.setOwnerName(newf.getOwnerName());
            oldf.setOwnerType(newf.getOwnerType());
            oldf.setClassName(newf.getClassName());
            oldf.setFunctionType(newf.getFunctionType());
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropFunction(String catName, String dbName, String funcName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        boolean success = false;
        try {
            this.openTransaction();
            MFunction mfunc = this.getMFunction(catName, dbName, funcName);
            this.pm.retrieve((Object)mfunc);
            if (mfunc != null) {
                this.pm.deletePersistentAll(new Object[]{mfunc});
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MFunction getMFunction(String catName, String db, String function) {
        MFunction mfunc = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            catName = StringUtils.normalizeIdentifier(catName);
            db = StringUtils.normalizeIdentifier(db);
            function = StringUtils.normalizeIdentifier(function);
            query = this.pm.newQuery(MFunction.class, "functionName == function && database.name == db && database.catalogName == catName");
            query.declareParameters("java.lang.String function, java.lang.String db, java.lang.String catName");
            query.setUnique(true);
            mfunc = (MFunction)query.execute((Object)function, (Object)db, (Object)catName);
            this.pm.retrieve((Object)mfunc);
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return mfunc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function getFunction(String catName, String dbName, String funcName) throws MetaException {
        boolean commited = false;
        Function func = null;
        Query query = null;
        try {
            this.openTransaction();
            func = this.convertToFunction(this.getMFunction(catName, dbName, funcName));
            commited = this.commitTransaction();
        }
        finally {
            this.rollbackAndCleanup(commited, query);
        }
        return func;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Function> getAllFunctions(String catName) throws MetaException {
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            catName = StringUtils.normalizeIdentifier(catName);
            query = this.pm.newQuery(MFunction.class, "database.catalogName == catName");
            query.declareParameters("java.lang.String catName");
            List allFunctions = (List)query.execute((Object)catName);
            this.pm.retrieveAll((Collection)allFunctions);
            commited = this.commitTransaction();
            List<Function> list = this.convertToFunctions(allFunctions);
            this.rollbackAndCleanup(commited, query);
            return list;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFunctions(String catName, String dbName, String pattern) throws MetaException {
        boolean commited = false;
        Query query = null;
        ArrayList<String> funcs = null;
        try {
            this.openTransaction();
            dbName = StringUtils.normalizeIdentifier(dbName);
            ArrayList<String> parameterVals = new ArrayList<String>();
            StringBuilder filterBuilder = new StringBuilder();
            this.appendSimpleCondition(filterBuilder, "database.name", new String[]{dbName}, parameterVals);
            this.appendSimpleCondition(filterBuilder, "database.catalogName", new String[]{catName}, parameterVals);
            if (pattern != null) {
                this.appendPatternCondition(filterBuilder, "functionName", pattern, parameterVals);
            }
            query = this.pm.newQuery(MFunction.class, filterBuilder.toString());
            query.setResult("functionName");
            query.setOrdering("functionName ascending");
            Collection names = (Collection)query.executeWithArray((Object[])parameterVals.toArray(new String[parameterVals.size()]));
            funcs = new ArrayList<String>();
            Iterator i = names.iterator();
            while (i.hasNext()) {
                funcs.add((String)i.next());
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return funcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationEventResponse getNextNotification(NotificationEventRequest rqst) {
        Collection events;
        NotificationEventResponse result;
        Query query;
        boolean commited;
        block4: {
            commited = false;
            query = null;
            result = new NotificationEventResponse();
            result.setEvents(new ArrayList<NotificationEvent>());
            this.openTransaction();
            long lastEvent = rqst.getLastEvent();
            int maxEvents = rqst.getMaxEvents() > 0 ? rqst.getMaxEvents() : Integer.MAX_VALUE;
            query = this.pm.newQuery(MNotificationLog.class, "eventId > lastEvent");
            query.declareParameters("java.lang.Long lastEvent");
            query.setOrdering("eventId ascending");
            query.setRange(0L, (long)maxEvents);
            events = (Collection)query.execute((Object)lastEvent);
            commited = this.commitTransaction();
            if (events != null) break block4;
            NotificationEventResponse notificationEventResponse = result;
            this.rollbackAndCleanup(commited, query);
            return notificationEventResponse;
        }
        try {
            Iterator i = events.iterator();
            while (i.hasNext()) {
                result.addToEvents(this.translateDbToThrift((MNotificationLog)i.next()));
            }
            NotificationEventResponse notificationEventResponse = result;
            this.rollbackAndCleanup(commited, query);
            return notificationEventResponse;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    private void prepareQuotes() throws SQLException {
        if (this.dbType == DatabaseProduct.MYSQL) {
            assert (this.pm.currentTransaction().isActive());
            JDOConnection jdoConn = this.pm.getDataStoreConnection();
            Statement statement = null;
            try {
                statement = ((Connection)jdoConn.getNativeConnection()).createStatement();
                statement.execute("SET @@session.sql_mode=ANSI_QUOTES");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                jdoConn.close();
            }
        }
    }

    private void lockForUpdate() throws MetaException {
        String selectQuery = "select \"NEXT_EVENT_ID\" from \"NOTIFICATION_SEQUENCE\"";
        String selectForUpdateQuery = this.sqlGenerator.addForUpdateClause(selectQuery);
        new RetryingExecutor(this.conf, () -> {
            this.prepareQuotes();
            Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)selectForUpdateQuery);
            query.setUnique(true);
            query.execute();
            query.closeAll();
        }).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationEvent(NotificationEvent entry) {
        boolean commited = false;
        Query query = null;
        try {
            boolean needToPersistId;
            this.openTransaction();
            this.lockForUpdate();
            query = this.pm.newQuery(MNotificationNextId.class);
            Collection ids = (Collection)query.execute();
            MNotificationNextId mNotificationNextId = null;
            if (.CollectionUtils.isEmpty((Collection)ids)) {
                mNotificationNextId = new MNotificationNextId(1L);
                needToPersistId = true;
            } else {
                mNotificationNextId = (MNotificationNextId)ids.iterator().next();
                needToPersistId = false;
            }
            entry.setEventId(mNotificationNextId.getNextEventId());
            mNotificationNextId.incrementEventId();
            if (needToPersistId) {
                this.pm.makePersistent((Object)mNotificationNextId);
            }
            this.pm.makePersistent((Object)this.translateThriftToDb(entry));
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Exception e) {
            try {
                LOG.error("couldnot get lock for update", e);
                this.rollbackAndCleanup(commited, query);
            }
            catch (Throwable throwable) {
                this.rollbackAndCleanup(commited, query);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanNotificationEvents(int olderThan) {
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            long tmp = System.currentTimeMillis() / 1000L - (long)olderThan;
            int tooOld = tmp > Integer.MAX_VALUE ? 0 : (int)tmp;
            query = this.pm.newQuery(MNotificationLog.class, "eventTime < tooOld");
            query.declareParameters("java.lang.Integer tooOld");
            Collection toBeRemoved = (Collection)query.execute((Object)tooOld);
            if (.CollectionUtils.isNotEmpty((Collection)toBeRemoved)) {
                this.pm.deletePersistentAll(toBeRemoved);
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CurrentNotificationEventId getCurrentNotificationEventId() {
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MNotificationNextId.class);
            Collection ids = (Collection)query.execute();
            long id = 0L;
            if (.CollectionUtils.isNotEmpty((Collection)ids)) {
                id = ((MNotificationNextId)ids.iterator().next()).getNextEventId() - 1L;
            }
            commited = this.commitTransaction();
            CurrentNotificationEventId currentNotificationEventId = new CurrentNotificationEventId(id);
            this.rollbackAndCleanup(commited, query);
            return currentNotificationEventId;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationEventsCountResponse getNotificationEventsCount(NotificationEventsCountRequest rqst) {
        Long result = 0L;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            long fromEventId = rqst.getFromEventId();
            String inputDbName = rqst.getDbName();
            String catName = rqst.isSetCatName() ? rqst.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            String queryStr = "select count(eventId) from " + MNotificationLog.class.getName() + " where eventId > fromEventId && dbName == inputDbName && catalogName == catName";
            query = this.pm.newQuery(queryStr);
            query.declareParameters("java.lang.Long fromEventId, java.lang.String inputDbName, java.lang.String catName");
            result = (Long)query.execute((Object)fromEventId, (Object)inputDbName, (Object)catName);
            commited = this.commitTransaction();
            NotificationEventsCountResponse notificationEventsCountResponse = new NotificationEventsCountResponse(result);
            this.rollbackAndCleanup(commited, query);
            return notificationEventsCountResponse;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    private MNotificationLog translateThriftToDb(NotificationEvent entry) {
        MNotificationLog dbEntry = new MNotificationLog();
        dbEntry.setEventId(entry.getEventId());
        dbEntry.setEventTime(entry.getEventTime());
        dbEntry.setEventType(entry.getEventType());
        dbEntry.setCatalogName(entry.isSetCatName() ? entry.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf));
        dbEntry.setDbName(entry.getDbName());
        dbEntry.setTableName(entry.getTableName());
        dbEntry.setMessage(entry.getMessage());
        dbEntry.setMessageFormat(entry.getMessageFormat());
        return dbEntry;
    }

    private NotificationEvent translateDbToThrift(MNotificationLog dbEvent) {
        NotificationEvent event = new NotificationEvent();
        event.setEventId(dbEvent.getEventId());
        event.setEventTime(dbEvent.getEventTime());
        event.setEventType(dbEvent.getEventType());
        event.setCatName(dbEvent.getCatalogName());
        event.setDbName(dbEvent.getDbName());
        event.setTableName(dbEvent.getTableName());
        event.setMessage(dbEvent.getMessage());
        event.setMessageFormat(dbEvent.getMessageFormat());
        return event;
    }

    @Override
    public boolean isFileMetadataSupported() {
        return false;
    }

    @Override
    public ByteBuffer[] getFileMetadata(List<Long> fileIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata, FileMetadataExprType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getFileMetadataByExpr(List<Long> fileIds, FileMetadataExprType type, byte[] expr, ByteBuffer[] metadatas, ByteBuffer[] stripeBitsets, boolean[] eliminated) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileMetadataHandler getFileMetadataHandler(FileMetadataExprType type) {
        throw new UnsupportedOperationException();
    }

    public static void unCacheDataNucleusClassLoaders() {
        PersistenceManagerFactory pmf = ObjectStore.getPMF();
        ObjectStore.clearOutPmfClassLoaderCache(pmf);
    }

    private static void clearOutPmfClassLoaderCache(PersistenceManagerFactory pmf) {
        if (pmf == null || !(pmf instanceof JDOPersistenceManagerFactory)) {
            return;
        }
        JDOPersistenceManagerFactory jdoPmf = (JDOPersistenceManagerFactory)pmf;
        PersistenceNucleusContext nc = jdoPmf.getNucleusContext();
        try {
            Field pmCache = pmf.getClass().getDeclaredField("pmCache");
            pmCache.setAccessible(true);
            Set pmSet = (Set)pmCache.get(pmf);
            for (JDOPersistenceManager pm : pmSet) {
                ExecutionContext ec = pm.getExecutionContext();
                if (!(ec instanceof ExecutionContextThreadedImpl)) continue;
                ClassLoaderResolver clr = ((ExecutionContextThreadedImpl)ec).getClassLoaderResolver();
                ObjectStore.clearClr(clr);
            }
            PluginManager pluginManager = jdoPmf.getNucleusContext().getPluginManager();
            Field registryField = pluginManager.getClass().getDeclaredField("registry");
            registryField.setAccessible(true);
            PluginRegistry registry = (PluginRegistry)registryField.get(pluginManager);
            if (registry instanceof NonManagedPluginRegistry) {
                NonManagedPluginRegistry nRegistry = (NonManagedPluginRegistry)registry;
                Field clrField = nRegistry.getClass().getDeclaredField("clr");
                clrField.setAccessible(true);
                ClassLoaderResolver clr = (ClassLoaderResolver)clrField.get(nRegistry);
                ObjectStore.clearClr(clr);
            }
            if (nc instanceof PersistenceNucleusContextImpl) {
                PersistenceNucleusContextImpl pnc = (PersistenceNucleusContextImpl)nc;
                TypeManagerImpl tm = (TypeManagerImpl)pnc.getTypeManager();
                Field clrField = tm.getClass().getDeclaredField("clr");
                clrField.setAccessible(true);
                ClassLoaderResolver clr = (ClassLoaderResolver)clrField.get(tm);
                ObjectStore.clearClr(clr);
                Field storeMgrField = pnc.getClass().getDeclaredField("storeMgr");
                storeMgrField.setAccessible(true);
                RDBMSStoreManager storeMgr = (RDBMSStoreManager)storeMgrField.get(pnc);
                Field backingStoreField = storeMgr.getClass().getDeclaredField("backingStoreByMemberName");
                backingStoreField.setAccessible(true);
                Map backingStoreByMemberName = (Map)backingStoreField.get(storeMgr);
                for (Store store : backingStoreByMemberName.values()) {
                    BaseContainerStore baseStore = (BaseContainerStore)store;
                    clrField = BaseContainerStore.class.getDeclaredField("clr");
                    clrField.setAccessible(true);
                    clr = (ClassLoaderResolver)clrField.get(baseStore);
                    ObjectStore.clearClr(clr);
                }
            }
            Field classLoaderResolverMap = AbstractNucleusContext.class.getDeclaredField("classLoaderResolverMap");
            classLoaderResolverMap.setAccessible(true);
            Map loaderMap = (Map)classLoaderResolverMap.get(nc);
            for (ClassLoaderResolver clr : loaderMap.values()) {
                ObjectStore.clearClr(clr);
            }
            classLoaderResolverMap.set(nc, new HashMap());
            LOG.debug("Removed cached classloaders from DataNucleus NucleusContext");
        }
        catch (Exception e) {
            LOG.warn("Failed to remove cached classloaders from DataNucleus NucleusContext", e);
        }
    }

    private static void clearClr(ClassLoaderResolver clr) throws Exception {
        if (clr != null && clr instanceof ClassLoaderResolverImpl) {
            ClassLoaderResolverImpl clri = (ClassLoaderResolverImpl)clr;
            long resourcesCleared = ObjectStore.clearFieldMap(clri, "resources");
            long loadedClassesCleared = ObjectStore.clearFieldMap(clri, "loadedClasses");
            long unloadedClassesCleared = ObjectStore.clearFieldMap(clri, "unloadedClasses");
            LOG.debug("Cleared ClassLoaderResolverImpl: {}, {}, {}", resourcesCleared, loadedClassesCleared, unloadedClassesCleared);
        }
    }

    private static long clearFieldMap(ClassLoaderResolverImpl clri, String mapFieldName) throws Exception {
        Field mapField = ClassLoaderResolverImpl.class.getDeclaredField(mapFieldName);
        mapField.setAccessible(true);
        Map map = (Map)mapField.get(clri);
        long sz = map.size();
        mapField.set(clri, Collections.synchronizedMap(new WeakValueMap()));
        return sz;
    }

    @Override
    public List<SQLPrimaryKey> getPrimaryKeys(String catName, String db_name, String tbl_name) throws MetaException {
        try {
            return this.getPrimaryKeysInternal(catName, db_name, tbl_name);
        }
        catch (NoSuchObjectException e) {
            throw new MetaException(ExceptionUtils.getStackTrace((Throwable)((Object)e)));
        }
    }

    private List<SQLPrimaryKey> getPrimaryKeysInternal(String catName, String db_name_input, String tbl_name_input) throws MetaException, NoSuchObjectException {
        final String db_name = StringUtils.normalizeIdentifier(db_name_input);
        final String tbl_name = StringUtils.normalizeIdentifier(tbl_name_input);
        return (List)new GetListHelper<SQLPrimaryKey>(catName, db_name, tbl_name, true, true){

            @Override
            protected List<SQLPrimaryKey> getSqlResult(GetHelper<List<SQLPrimaryKey>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getPrimaryKeys(this.catName, db_name, tbl_name);
            }

            @Override
            protected List<SQLPrimaryKey> getJdoResult(GetHelper<List<SQLPrimaryKey>> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getPrimaryKeysViaJdo(this.catName, db_name, tbl_name);
            }
        }.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SQLPrimaryKey> getPrimaryKeysViaJdo(String catName, String db_name, String tbl_name) throws MetaException {
        boolean commited = false;
        ArrayList<SQLPrimaryKey> primaryKeys = null;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MConstraint.class, "parentTable.tableName == tbl_name && parentTable.database.name == db_name && parentTable.database.catalogName == cat_name && constraintType == MConstraint.PRIMARY_KEY_CONSTRAINT");
            query.declareParameters("java.lang.String tbl_name, java.lang.String db_name, java.lang.String cat_name");
            Collection constraints = (Collection)query.execute((Object)tbl_name, (Object)db_name, (Object)catName);
            this.pm.retrieveAll(constraints);
            primaryKeys = new ArrayList<SQLPrimaryKey>();
            for (MConstraint currPK : constraints) {
                List<MFieldSchema> cols = currPK.getParentColumn() != null ? currPK.getParentColumn().getCols() : currPK.getParentTable().getPartitionKeys();
                int enableValidateRely = currPK.getEnableValidateRely();
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                SQLPrimaryKey keyCol = new SQLPrimaryKey(db_name, tbl_name, cols.get(currPK.getParentIntegerIndex()).getName(), currPK.getPosition(), currPK.getConstraintName(), enable, validate, rely);
                keyCol.setCatName(catName);
                primaryKeys.add(keyCol);
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return primaryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPrimaryKeyConstraintName(String catName, String db_name, String tbl_name) throws MetaException {
        boolean commited = false;
        String ret = null;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MConstraint.class, "parentTable.tableName == tbl_name && parentTable.database.name == db_name && parentTable.database.catalogName == catName && constraintType == MConstraint.PRIMARY_KEY_CONSTRAINT");
            query.declareParameters("java.lang.String tbl_name, java.lang.String db_name, java.lang.String catName");
            Collection constraints = (Collection)query.execute((Object)tbl_name, (Object)db_name, (Object)catName);
            this.pm.retrieveAll(constraints);
            Iterator i = constraints.iterator();
            if (i.hasNext()) {
                MConstraint currPK = (MConstraint)i.next();
                ret = currPK.getConstraintName();
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return ret;
    }

    @Override
    public List<SQLForeignKey> getForeignKeys(String catName, String parent_db_name, String parent_tbl_name, String foreign_db_name, String foreign_tbl_name) throws MetaException {
        try {
            return this.getForeignKeysInternal(catName, parent_db_name, parent_tbl_name, foreign_db_name, foreign_tbl_name, true, true);
        }
        catch (NoSuchObjectException e) {
            throw new MetaException(ExceptionUtils.getStackTrace((Throwable)((Object)e)));
        }
    }

    private List<SQLForeignKey> getForeignKeysInternal(String catName, String parent_db_name_input, String parent_tbl_name_input, String foreign_db_name_input, String foreign_tbl_name_input, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        String tbl_name;
        String db_name;
        String foreign_tbl_name;
        final String parent_db_name = parent_db_name_input != null ? StringUtils.normalizeIdentifier(parent_db_name_input) : null;
        final String parent_tbl_name = parent_tbl_name_input != null ? StringUtils.normalizeIdentifier(parent_tbl_name_input) : null;
        final String foreign_db_name = foreign_db_name_input != null ? StringUtils.normalizeIdentifier(foreign_db_name_input) : null;
        String string = foreign_tbl_name = foreign_tbl_name_input != null ? StringUtils.normalizeIdentifier(foreign_tbl_name_input) : null;
        if (foreign_tbl_name == null) {
            db_name = parent_db_name;
            tbl_name = parent_tbl_name;
        } else {
            db_name = foreign_db_name;
            tbl_name = foreign_tbl_name;
        }
        return (List)new GetListHelper<SQLForeignKey>(catName, db_name, tbl_name, allowSql, allowJdo){

            @Override
            protected List<SQLForeignKey> getSqlResult(GetHelper<List<SQLForeignKey>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getForeignKeys(this.catName, parent_db_name, parent_tbl_name, foreign_db_name, foreign_tbl_name);
            }

            @Override
            protected List<SQLForeignKey> getJdoResult(GetHelper<List<SQLForeignKey>> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getForeignKeysViaJdo(this.catName, parent_db_name, parent_tbl_name, foreign_db_name, foreign_tbl_name);
            }
        }.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SQLForeignKey> getForeignKeysViaJdo(String catName, String parent_db_name, String parent_tbl_name, String foreign_db_name, String foreign_tbl_name) throws MetaException {
        boolean commited = false;
        ArrayList<SQLForeignKey> foreignKeys = null;
        Collection constraints = null;
        Query query = null;
        HashMap<String, String> tblToConstraint = new HashMap<String, String>();
        try {
            this.openTransaction();
            String queryText = " parentTable.database.catalogName == catName1 &&childTable.database.catalogName == catName2 && " + (parent_tbl_name != null ? "parentTable.tableName == parent_tbl_name && " : "") + (parent_db_name != null ? " parentTable.database.name == parent_db_name && " : "") + (foreign_tbl_name != null ? " childTable.tableName == foreign_tbl_name && " : "") + (foreign_db_name != null ? " childTable.database.name == foreign_db_name && " : "") + " constraintType == MConstraint.FOREIGN_KEY_CONSTRAINT";
            queryText = queryText.trim();
            query = this.pm.newQuery(MConstraint.class, queryText);
            String paramText = "java.lang.String catName1, java.lang.String catName2" + (parent_tbl_name == null ? "" : ", java.lang.String parent_tbl_name") + (parent_db_name == null ? "" : " , java.lang.String parent_db_name") + (foreign_tbl_name == null ? "" : ", java.lang.String foreign_tbl_name") + (foreign_db_name == null ? "" : " , java.lang.String foreign_db_name");
            query.declareParameters(paramText);
            ArrayList<String> params = new ArrayList<String>();
            params.add(catName);
            params.add(catName);
            if (parent_tbl_name != null) {
                params.add(parent_tbl_name);
            }
            if (parent_db_name != null) {
                params.add(parent_db_name);
            }
            if (foreign_tbl_name != null) {
                params.add(foreign_tbl_name);
            }
            if (foreign_db_name != null) {
                params.add(foreign_db_name);
            }
            constraints = (Collection)query.executeWithArray((Object[])params.toArray(new String[params.size()]));
            this.pm.retrieveAll(constraints);
            foreignKeys = new ArrayList<SQLForeignKey>();
            for (MConstraint currPKFK : constraints) {
                String pkName;
                List<MFieldSchema> parentCols = currPKFK.getParentColumn() != null ? currPKFK.getParentColumn().getCols() : currPKFK.getParentTable().getPartitionKeys();
                List<MFieldSchema> childCols = currPKFK.getChildColumn() != null ? currPKFK.getChildColumn().getCols() : currPKFK.getChildTable().getPartitionKeys();
                int enableValidateRely = currPKFK.getEnableValidateRely();
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                String consolidatedtblName = currPKFK.getParentTable().getDatabase().getName() + "." + currPKFK.getParentTable().getTableName();
                if (tblToConstraint.containsKey(consolidatedtblName)) {
                    pkName = (String)tblToConstraint.get(consolidatedtblName);
                } else {
                    pkName = this.getPrimaryKeyConstraintName(currPKFK.getParentTable().getDatabase().getCatalogName(), currPKFK.getParentTable().getDatabase().getName(), currPKFK.getParentTable().getTableName());
                    tblToConstraint.put(consolidatedtblName, pkName);
                }
                SQLForeignKey fk = new SQLForeignKey(currPKFK.getParentTable().getDatabase().getName(), currPKFK.getParentTable().getTableName(), parentCols.get(currPKFK.getParentIntegerIndex()).getName(), currPKFK.getChildTable().getDatabase().getName(), currPKFK.getChildTable().getTableName(), childCols.get(currPKFK.getChildIntegerIndex()).getName(), currPKFK.getPosition(), currPKFK.getUpdateRule(), currPKFK.getDeleteRule(), currPKFK.getConstraintName(), pkName, enable, validate, rely);
                fk.setCatName(catName);
                foreignKeys.add(fk);
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return foreignKeys;
    }

    @Override
    public List<SQLUniqueConstraint> getUniqueConstraints(String catName, String db_name, String tbl_name) throws MetaException {
        try {
            return this.getUniqueConstraintsInternal(catName, db_name, tbl_name, true, true);
        }
        catch (NoSuchObjectException e) {
            throw new MetaException(ExceptionUtils.getStackTrace((Throwable)((Object)e)));
        }
    }

    private List<SQLUniqueConstraint> getUniqueConstraintsInternal(String catNameInput, String db_name_input, String tbl_name_input, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        String catName = StringUtils.normalizeIdentifier(catNameInput);
        final String db_name = StringUtils.normalizeIdentifier(db_name_input);
        final String tbl_name = StringUtils.normalizeIdentifier(tbl_name_input);
        return (List)new GetListHelper<SQLUniqueConstraint>(catName, db_name, tbl_name, allowSql, allowJdo){

            @Override
            protected List<SQLUniqueConstraint> getSqlResult(GetHelper<List<SQLUniqueConstraint>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getUniqueConstraints(this.catName, db_name, tbl_name);
            }

            @Override
            protected List<SQLUniqueConstraint> getJdoResult(GetHelper<List<SQLUniqueConstraint>> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getUniqueConstraintsViaJdo(this.catName, db_name, tbl_name);
            }
        }.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SQLUniqueConstraint> getUniqueConstraintsViaJdo(String catName, String db_name, String tbl_name) throws MetaException {
        boolean commited = false;
        ArrayList<SQLUniqueConstraint> uniqueConstraints = null;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MConstraint.class, "parentTable.tableName == tbl_name && parentTable.database.name == db_name && parentTable.database.catalogName == catName && constraintType == MConstraint.UNIQUE_CONSTRAINT");
            query.declareParameters("java.lang.String tbl_name, java.lang.String db_name, java.lang.String catName");
            Collection constraints = (Collection)query.execute((Object)tbl_name, (Object)db_name, (Object)catName);
            this.pm.retrieveAll(constraints);
            uniqueConstraints = new ArrayList<SQLUniqueConstraint>();
            for (MConstraint currConstraint : constraints) {
                List<MFieldSchema> cols = currConstraint.getParentColumn() != null ? currConstraint.getParentColumn().getCols() : currConstraint.getParentTable().getPartitionKeys();
                int enableValidateRely = currConstraint.getEnableValidateRely();
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                uniqueConstraints.add(new SQLUniqueConstraint(catName, db_name, tbl_name, cols.get(currConstraint.getParentIntegerIndex()).getName(), currConstraint.getPosition(), currConstraint.getConstraintName(), enable, validate, rely));
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return uniqueConstraints;
    }

    @Override
    public List<SQLNotNullConstraint> getNotNullConstraints(String catName, String db_name, String tbl_name) throws MetaException {
        try {
            return this.getNotNullConstraintsInternal(catName, db_name, tbl_name, true, true);
        }
        catch (NoSuchObjectException e) {
            throw new MetaException(ExceptionUtils.getStackTrace((Throwable)((Object)e)));
        }
    }

    @Override
    public List<SQLDefaultConstraint> getDefaultConstraints(String catName, String db_name, String tbl_name) throws MetaException {
        try {
            return this.getDefaultConstraintsInternal(catName, db_name, tbl_name, true, true);
        }
        catch (NoSuchObjectException e) {
            throw new MetaException(ExceptionUtils.getStackTrace((Throwable)((Object)e)));
        }
    }

    @Override
    public List<SQLCheckConstraint> getCheckConstraints(String catName, String db_name, String tbl_name) throws MetaException {
        try {
            return this.getCheckConstraintsInternal(catName, db_name, tbl_name, true, true);
        }
        catch (NoSuchObjectException e) {
            throw new MetaException(ExceptionUtils.getStackTrace((Throwable)((Object)e)));
        }
    }

    private List<SQLDefaultConstraint> getDefaultConstraintsInternal(String catName, String db_name_input, String tbl_name_input, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        catName = StringUtils.normalizeIdentifier(catName);
        final String db_name = StringUtils.normalizeIdentifier(db_name_input);
        final String tbl_name = StringUtils.normalizeIdentifier(tbl_name_input);
        return (List)new GetListHelper<SQLDefaultConstraint>(catName, db_name, tbl_name, allowSql, allowJdo){

            @Override
            protected List<SQLDefaultConstraint> getSqlResult(GetHelper<List<SQLDefaultConstraint>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getDefaultConstraints(this.catName, db_name, tbl_name);
            }

            @Override
            protected List<SQLDefaultConstraint> getJdoResult(GetHelper<List<SQLDefaultConstraint>> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getDefaultConstraintsViaJdo(this.catName, db_name, tbl_name);
            }
        }.run(false);
    }

    protected List<SQLCheckConstraint> getCheckConstraintsInternal(String catName, String db_name_input, String tbl_name_input, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        final String db_name = StringUtils.normalizeIdentifier(db_name_input);
        final String tbl_name = StringUtils.normalizeIdentifier(tbl_name_input);
        return (List)new GetListHelper<SQLCheckConstraint>(StringUtils.normalizeIdentifier(catName), db_name, tbl_name, allowSql, allowJdo){

            @Override
            protected List<SQLCheckConstraint> getSqlResult(GetHelper<List<SQLCheckConstraint>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getCheckConstraints(this.catName, db_name, tbl_name);
            }

            @Override
            protected List<SQLCheckConstraint> getJdoResult(GetHelper<List<SQLCheckConstraint>> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getCheckConstraintsViaJdo(this.catName, db_name, tbl_name);
            }
        }.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SQLCheckConstraint> getCheckConstraintsViaJdo(String catName, String db_name, String tbl_name) throws MetaException {
        boolean commited = false;
        ArrayList<SQLCheckConstraint> checkConstraints = null;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MConstraint.class, "parentTable.tableName == tbl_name && parentTable.database.name == db_name && parentTable.database.catalogName == catName && constraintType == MConstraint.CHECK_CONSTRAINT");
            query.declareParameters("java.lang.String tbl_name, java.lang.String db_name, java.lang.String catName");
            Collection constraints = (Collection)query.execute((Object)tbl_name, (Object)db_name, (Object)catName);
            this.pm.retrieveAll(constraints);
            checkConstraints = new ArrayList<SQLCheckConstraint>();
            for (MConstraint currConstraint : constraints) {
                List<MFieldSchema> cols = currConstraint.getParentColumn() != null ? currConstraint.getParentColumn().getCols() : currConstraint.getParentTable().getPartitionKeys();
                int enableValidateRely = currConstraint.getEnableValidateRely();
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                checkConstraints.add(new SQLCheckConstraint(catName, db_name, tbl_name, cols.get(currConstraint.getParentIntegerIndex()).getName(), currConstraint.getDefaultOrCheckValue(), currConstraint.getConstraintName(), enable, validate, rely));
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return checkConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SQLDefaultConstraint> getDefaultConstraintsViaJdo(String catName, String db_name, String tbl_name) throws MetaException {
        boolean commited = false;
        ArrayList<SQLDefaultConstraint> defaultConstraints = null;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MConstraint.class, "parentTable.tableName == tbl_name && parentTable.database.name == db_name && parentTable.database.catalogName == catName && constraintType == MConstraint.DEFAULT_CONSTRAINT");
            query.declareParameters("java.lang.String tbl_name, java.lang.String db_name, java.lang.String catName");
            Collection constraints = (Collection)query.execute((Object)tbl_name, (Object)db_name, (Object)catName);
            this.pm.retrieveAll(constraints);
            defaultConstraints = new ArrayList<SQLDefaultConstraint>();
            for (MConstraint currConstraint : constraints) {
                List<MFieldSchema> cols = currConstraint.getParentColumn() != null ? currConstraint.getParentColumn().getCols() : currConstraint.getParentTable().getPartitionKeys();
                int enableValidateRely = currConstraint.getEnableValidateRely();
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                defaultConstraints.add(new SQLDefaultConstraint(catName, db_name, tbl_name, cols.get(currConstraint.getParentIntegerIndex()).getName(), currConstraint.getDefaultOrCheckValue(), currConstraint.getConstraintName(), enable, validate, rely));
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return defaultConstraints;
    }

    protected List<SQLNotNullConstraint> getNotNullConstraintsInternal(String catName, String db_name_input, String tbl_name_input, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        catName = StringUtils.normalizeIdentifier(catName);
        final String db_name = StringUtils.normalizeIdentifier(db_name_input);
        final String tbl_name = StringUtils.normalizeIdentifier(tbl_name_input);
        return (List)new GetListHelper<SQLNotNullConstraint>(catName, db_name, tbl_name, allowSql, allowJdo){

            @Override
            protected List<SQLNotNullConstraint> getSqlResult(GetHelper<List<SQLNotNullConstraint>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getNotNullConstraints(this.catName, db_name, tbl_name);
            }

            @Override
            protected List<SQLNotNullConstraint> getJdoResult(GetHelper<List<SQLNotNullConstraint>> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getNotNullConstraintsViaJdo(this.catName, db_name, tbl_name);
            }
        }.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SQLNotNullConstraint> getNotNullConstraintsViaJdo(String catName, String db_name, String tbl_name) throws MetaException {
        boolean commited = false;
        ArrayList<SQLNotNullConstraint> notNullConstraints = null;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MConstraint.class, "parentTable.tableName == tbl_name && parentTable.database.name == db_name && parentTable.database.catalogName == catName && constraintType == MConstraint.NOT_NULL_CONSTRAINT");
            query.declareParameters("java.lang.String tbl_name, java.lang.String db_name, java.lang.String catName");
            Collection constraints = (Collection)query.execute((Object)tbl_name, (Object)db_name, (Object)catName);
            this.pm.retrieveAll(constraints);
            notNullConstraints = new ArrayList<SQLNotNullConstraint>();
            for (MConstraint currConstraint : constraints) {
                List<MFieldSchema> cols = currConstraint.getParentColumn() != null ? currConstraint.getParentColumn().getCols() : currConstraint.getParentTable().getPartitionKeys();
                int enableValidateRely = currConstraint.getEnableValidateRely();
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                notNullConstraints.add(new SQLNotNullConstraint(catName, db_name, tbl_name, cols.get(currConstraint.getParentIntegerIndex()).getName(), currConstraint.getConstraintName(), enable, validate, rely));
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return notNullConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropConstraint(String catName, String dbName, String tableName, String constraintName, boolean missingOk) throws NoSuchObjectException {
        boolean success = false;
        try {
            this.openTransaction();
            List<MConstraint> tabConstraints = this.listAllTableConstraintsWithOptionalConstraintName(catName, dbName, tableName, constraintName);
            if (.CollectionUtils.isNotEmpty(tabConstraints)) {
                this.pm.deletePersistentAll(tabConstraints);
            } else if (!missingOk) {
                throw new NoSuchObjectException("The constraint: " + constraintName + " does not exist for the associated table: " + dbName + "." + tableName);
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createISchema(ISchema schema) throws AlreadyExistsException, MetaException, NoSuchObjectException {
        boolean committed = false;
        MISchema mSchema = this.convertToMISchema(schema);
        try {
            this.openTransaction();
            if (this.getMISchema(schema.getCatName(), schema.getDbName(), schema.getName()) != null) {
                throw new AlreadyExistsException("Schema with name " + schema.getDbName() + "." + schema.getName() + " already exists");
            }
            this.pm.makePersistent((Object)mSchema);
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterISchema(ISchemaName schemaName, ISchema newSchema) throws NoSuchObjectException, MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            MISchema oldMSchema = this.getMISchema(schemaName.getCatName(), schemaName.getDbName(), schemaName.getSchemaName());
            if (oldMSchema == null) {
                throw new NoSuchObjectException("Schema " + schemaName + " does not exist");
            }
            oldMSchema.setCompatibility(newSchema.getCompatibility().getValue());
            oldMSchema.setValidationLevel(newSchema.getValidationLevel().getValue());
            oldMSchema.setCanEvolve(newSchema.isCanEvolve());
            if (newSchema.isSetSchemaGroup()) {
                oldMSchema.setSchemaGroup(newSchema.getSchemaGroup());
            }
            if (newSchema.isSetDescription()) {
                oldMSchema.setDescription(newSchema.getDescription());
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISchema getISchema(ISchemaName schemaName) throws MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            ISchema schema = this.convertToISchema(this.getMISchema(schemaName.getCatName(), schemaName.getDbName(), schemaName.getSchemaName()));
            committed = this.commitTransaction();
            ISchema iSchema = schema;
            return iSchema;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MISchema getMISchema(String catName, String dbName, String name) {
        Query query = null;
        try {
            name = StringUtils.normalizeIdentifier(name);
            dbName = StringUtils.normalizeIdentifier(dbName);
            catName = StringUtils.normalizeIdentifier(catName);
            query = this.pm.newQuery(MISchema.class, "name == schemaName && db.name == dbname && db.catalogName == cat");
            query.declareParameters("java.lang.String schemaName, java.lang.String dbname, java.lang.String cat");
            query.setUnique(true);
            MISchema mSchema = (MISchema)query.execute((Object)name, (Object)dbName, (Object)catName);
            this.pm.retrieve((Object)mSchema);
            MISchema mISchema = mSchema;
            return mISchema;
        }
        finally {
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropISchema(ISchemaName schemaName) throws NoSuchObjectException, MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            MISchema mSchema = this.getMISchema(schemaName.getCatName(), schemaName.getDbName(), schemaName.getSchemaName());
            if (mSchema == null) {
                throw new NoSuchObjectException("Schema " + schemaName + " does not exist");
            }
            this.pm.deletePersistentAll(new Object[]{mSchema});
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSchemaVersion(SchemaVersion schemaVersion) throws AlreadyExistsException, NoSuchObjectException, MetaException {
        boolean committed = false;
        MSchemaVersion mSchemaVersion = this.convertToMSchemaVersion(schemaVersion);
        try {
            this.openTransaction();
            if (this.getMSchemaVersion(schemaVersion.getSchema().getCatName(), schemaVersion.getSchema().getDbName(), schemaVersion.getSchema().getSchemaName(), schemaVersion.getVersion()) != null) {
                throw new AlreadyExistsException("Schema name " + schemaVersion.getSchema() + " version " + schemaVersion.getVersion() + " already exists");
            }
            if (this.getMISchema(schemaVersion.getSchema().getCatName(), schemaVersion.getSchema().getDbName(), schemaVersion.getSchema().getSchemaName()) == null) {
                throw new NoSuchObjectException("Schema " + schemaVersion.getSchema() + " does not exist");
            }
            this.pm.makePersistent((Object)mSchemaVersion);
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterSchemaVersion(SchemaVersionDescriptor version, SchemaVersion newVersion) throws NoSuchObjectException, MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            MSchemaVersion oldMSchemaVersion = this.getMSchemaVersion(version.getSchema().getCatName(), version.getSchema().getDbName(), version.getSchema().getSchemaName(), version.getVersion());
            if (oldMSchemaVersion == null) {
                throw new NoSuchObjectException("No schema version " + version + " exists");
            }
            if (newVersion.isSetSerDe()) {
                oldMSchemaVersion.setSerDe(this.convertToMSerDeInfo(newVersion.getSerDe()));
            }
            if (newVersion.isSetState()) {
                oldMSchemaVersion.setState(newVersion.getState().getValue());
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.commitTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchemaVersion getSchemaVersion(SchemaVersionDescriptor version) throws MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            SchemaVersion schemaVersion = this.convertToSchemaVersion(this.getMSchemaVersion(version.getSchema().getCatName(), version.getSchema().getDbName(), version.getSchema().getSchemaName(), version.getVersion()));
            committed = this.commitTransaction();
            SchemaVersion schemaVersion2 = schemaVersion;
            return schemaVersion2;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MSchemaVersion getMSchemaVersion(String catName, String dbName, String schemaName, int version) {
        Query query = null;
        try {
            dbName = StringUtils.normalizeIdentifier(dbName);
            schemaName = StringUtils.normalizeIdentifier(schemaName);
            query = this.pm.newQuery(MSchemaVersion.class, "iSchema.name == schemaName && iSchema.db.name == dbName &&iSchema.db.catalogName == cat && version == schemaVersion");
            query.declareParameters("java.lang.String schemaName, java.lang.String dbName,java.lang.String cat, java.lang.Integer schemaVersion");
            query.setUnique(true);
            MSchemaVersion mSchemaVersion = (MSchemaVersion)query.executeWithArray(new Object[]{schemaName, dbName, catName, version});
            this.pm.retrieve((Object)mSchemaVersion);
            if (mSchemaVersion != null) {
                this.pm.retrieveAll(new Object[]{mSchemaVersion.getCols()});
                if (mSchemaVersion.getSerDe() != null) {
                    this.pm.retrieve((Object)mSchemaVersion.getSerDe());
                }
            }
            MSchemaVersion mSchemaVersion2 = mSchemaVersion;
            return mSchemaVersion2;
        }
        finally {
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchemaVersion getLatestSchemaVersion(ISchemaName schemaName) throws MetaException {
        boolean committed = false;
        Query query = null;
        try {
            this.openTransaction();
            String name = StringUtils.normalizeIdentifier(schemaName.getSchemaName());
            String dbName = StringUtils.normalizeIdentifier(schemaName.getDbName());
            String catName = StringUtils.normalizeIdentifier(schemaName.getCatName());
            query = this.pm.newQuery(MSchemaVersion.class, "iSchema.name == schemaName && iSchema.db.name == dbName && iSchema.db.catalogName == cat");
            query.declareParameters("java.lang.String schemaName, java.lang.String dbName, java.lang.String cat");
            query.setUnique(true);
            query.setOrdering("version descending");
            query.setRange(0L, 1L);
            MSchemaVersion mSchemaVersion = (MSchemaVersion)query.execute((Object)name, (Object)dbName, (Object)catName);
            this.pm.retrieve((Object)mSchemaVersion);
            if (mSchemaVersion != null) {
                this.pm.retrieveAll(new Object[]{mSchemaVersion.getCols()});
                if (mSchemaVersion.getSerDe() != null) {
                    this.pm.retrieve((Object)mSchemaVersion.getSerDe());
                }
            }
            SchemaVersion version = mSchemaVersion == null ? null : this.convertToSchemaVersion(mSchemaVersion);
            committed = this.commitTransaction();
            SchemaVersion schemaVersion = version;
            this.rollbackAndCleanup(committed, query);
            return schemaVersion;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchemaVersion> getAllSchemaVersion(ISchemaName schemaName) throws MetaException {
        List mSchemaVersions;
        Query query;
        boolean committed;
        block5: {
            committed = false;
            query = null;
            this.openTransaction();
            String name = StringUtils.normalizeIdentifier(schemaName.getSchemaName());
            String dbName = StringUtils.normalizeIdentifier(schemaName.getDbName());
            String catName = StringUtils.normalizeIdentifier(schemaName.getCatName());
            query = this.pm.newQuery(MSchemaVersion.class, "iSchema.name == schemaName &&iSchema.db.name == dbName && iSchema.db.catalogName == cat");
            query.declareParameters("java.lang.String schemaName, java.lang.String dbName, java.lang.String cat");
            query.setOrdering("version descending");
            mSchemaVersions = query.setParameters(new Object[]{name, dbName, catName}).executeList();
            this.pm.retrieveAll((Collection)mSchemaVersions);
            if (mSchemaVersions != null && !mSchemaVersions.isEmpty()) break block5;
            List<SchemaVersion> list = null;
            this.rollbackAndCleanup(committed, query);
            return list;
        }
        try {
            ArrayList<SchemaVersion> schemaVersions = new ArrayList<SchemaVersion>(mSchemaVersions.size());
            for (MSchemaVersion mSchemaVersion : mSchemaVersions) {
                this.pm.retrieveAll(new Object[]{mSchemaVersion.getCols()});
                if (mSchemaVersion.getSerDe() != null) {
                    this.pm.retrieve((Object)mSchemaVersion.getSerDe());
                }
                schemaVersions.add(this.convertToSchemaVersion(mSchemaVersion));
            }
            committed = this.commitTransaction();
            ArrayList<SchemaVersion> arrayList = schemaVersions;
            this.rollbackAndCleanup(committed, query);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchemaVersion> getSchemaVersionsByColumns(String colName, String colNamespace, String type) throws MetaException {
        List mSchemaVersions;
        Query query;
        boolean committed;
        block13: {
            if (colName == null && colNamespace == null) {
                throw new MetaException("You must specify column name or column namespace, else your query may be too large");
            }
            committed = false;
            query = null;
            this.openTransaction();
            if (colName != null) {
                colName = StringUtils.normalizeIdentifier(colName);
            }
            if (type != null) {
                type = StringUtils.normalizeIdentifier(type);
            }
            HashMap<String, String> parameters = new HashMap<String, String>(3);
            StringBuilder sql = new StringBuilder("select SCHEMA_VERSION_ID from SCHEMA_VERSION, COLUMNS_V2 where SCHEMA_VERSION.CD_ID = COLUMNS_V2.CD_ID ");
            if (colName != null) {
                sql.append("and COLUMNS_V2.COLUMN_NAME = :colName ");
                parameters.put("colName", colName);
            }
            if (colNamespace != null) {
                sql.append("and COLUMNS_V2.COMMENT = :colComment ");
                parameters.put("colComment", colNamespace);
            }
            if (type != null) {
                sql.append("and COLUMNS_V2.TYPE_NAME = :colType ");
                parameters.put("colType", type);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getSchemaVersionsByColumns going to execute query " + sql.toString());
                LOG.debug("With parameters");
                for (Map.Entry entry : parameters.entrySet()) {
                    LOG.debug((String)entry.getKey() + " : " + (String)entry.getValue());
                }
            }
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            query.setClass(MSchemaVersion.class);
            mSchemaVersions = query.setNamedParameters(parameters).executeList();
            if (mSchemaVersions != null && !mSchemaVersions.isEmpty()) break block13;
            List<SchemaVersion> list = Collections.emptyList();
            this.rollbackAndCleanup(committed, query);
            return list;
        }
        try {
            this.pm.retrieveAll((Collection)mSchemaVersions);
            ArrayList<SchemaVersion> arrayList = new ArrayList<SchemaVersion>(mSchemaVersions.size());
            for (MSchemaVersion mSchemaVersion : mSchemaVersions) {
                this.pm.retrieveAll(new Object[]{mSchemaVersion.getCols()});
                if (mSchemaVersion.getSerDe() != null) {
                    this.pm.retrieve((Object)mSchemaVersion.getSerDe());
                }
                arrayList.add(this.convertToSchemaVersion(mSchemaVersion));
            }
            committed = this.commitTransaction();
            ArrayList<SchemaVersion> arrayList2 = arrayList;
            this.rollbackAndCleanup(committed, query);
            return arrayList2;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(committed, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropSchemaVersion(SchemaVersionDescriptor version) throws NoSuchObjectException, MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            MSchemaVersion mSchemaVersion = this.getMSchemaVersion(version.getSchema().getCatName(), version.getSchema().getDbName(), version.getSchema().getSchemaName(), version.getVersion());
            if (mSchemaVersion == null) {
                throw new NoSuchObjectException("Schema version " + version + "does not exist");
            }
            this.pm.deletePersistentAll(new Object[]{mSchemaVersion});
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SerDeInfo getSerDeInfo(String serDeName) throws NoSuchObjectException, MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            MSerDeInfo mSerDeInfo = this.getMSerDeInfo(serDeName);
            if (mSerDeInfo == null) {
                throw new NoSuchObjectException("No SerDe named " + serDeName);
            }
            SerDeInfo serde = this.convertToSerDeInfo(mSerDeInfo);
            committed = this.commitTransaction();
            SerDeInfo serDeInfo = serde;
            return serDeInfo;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MSerDeInfo getMSerDeInfo(String serDeName) throws MetaException {
        Query query = null;
        try {
            query = this.pm.newQuery(MSerDeInfo.class, "name == serDeName");
            query.declareParameters("java.lang.String serDeName");
            query.setUnique(true);
            MSerDeInfo mSerDeInfo = (MSerDeInfo)query.execute((Object)serDeName);
            this.pm.retrieve((Object)mSerDeInfo);
            MSerDeInfo mSerDeInfo2 = mSerDeInfo;
            return mSerDeInfo2;
        }
        finally {
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSerde(SerDeInfo serde) throws AlreadyExistsException, MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            if (this.getMSerDeInfo(serde.getName()) != null) {
                throw new AlreadyExistsException("Serde with name " + serde.getName() + " already exists");
            }
            MSerDeInfo mSerde = this.convertToMSerDeInfo(serde);
            this.pm.makePersistent((Object)mSerde);
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    private MISchema convertToMISchema(ISchema schema) throws NoSuchObjectException {
        return new MISchema(schema.getSchemaType().getValue(), StringUtils.normalizeIdentifier(schema.getName()), this.getMDatabase(schema.getCatName(), schema.getDbName()), schema.getCompatibility().getValue(), schema.getValidationLevel().getValue(), schema.isCanEvolve(), schema.isSetSchemaGroup() ? schema.getSchemaGroup() : null, schema.isSetDescription() ? schema.getDescription() : null);
    }

    private ISchema convertToISchema(MISchema mSchema) {
        if (mSchema == null) {
            return null;
        }
        ISchema schema = new ISchema(SchemaType.findByValue(mSchema.getSchemaType()), mSchema.getName(), mSchema.getDb().getCatalogName(), mSchema.getDb().getName(), SchemaCompatibility.findByValue(mSchema.getCompatibility()), SchemaValidation.findByValue(mSchema.getValidationLevel()), mSchema.getCanEvolve());
        if (mSchema.getDescription() != null) {
            schema.setDescription(mSchema.getDescription());
        }
        if (mSchema.getSchemaGroup() != null) {
            schema.setSchemaGroup(mSchema.getSchemaGroup());
        }
        return schema;
    }

    private MSchemaVersion convertToMSchemaVersion(SchemaVersion schemaVersion) throws MetaException {
        return new MSchemaVersion(this.getMISchema(StringUtils.normalizeIdentifier(schemaVersion.getSchema().getCatName()), StringUtils.normalizeIdentifier(schemaVersion.getSchema().getDbName()), StringUtils.normalizeIdentifier(schemaVersion.getSchema().getSchemaName())), schemaVersion.getVersion(), schemaVersion.getCreatedAt(), this.createNewMColumnDescriptor(this.convertToMFieldSchemas(schemaVersion.getCols())), schemaVersion.isSetState() ? schemaVersion.getState().getValue() : 0, schemaVersion.isSetDescription() ? schemaVersion.getDescription() : null, schemaVersion.isSetSchemaText() ? schemaVersion.getSchemaText() : null, schemaVersion.isSetFingerprint() ? schemaVersion.getFingerprint() : null, schemaVersion.isSetName() ? schemaVersion.getName() : null, schemaVersion.isSetSerDe() ? this.convertToMSerDeInfo(schemaVersion.getSerDe()) : null);
    }

    private SchemaVersion convertToSchemaVersion(MSchemaVersion mSchemaVersion) throws MetaException {
        if (mSchemaVersion == null) {
            return null;
        }
        SchemaVersion schemaVersion = new SchemaVersion(new ISchemaName(mSchemaVersion.getiSchema().getDb().getCatalogName(), mSchemaVersion.getiSchema().getDb().getName(), mSchemaVersion.getiSchema().getName()), mSchemaVersion.getVersion(), mSchemaVersion.getCreatedAt(), this.convertToFieldSchemas(mSchemaVersion.getCols().getCols()));
        if (mSchemaVersion.getState() > 0) {
            schemaVersion.setState(SchemaVersionState.findByValue(mSchemaVersion.getState()));
        }
        if (mSchemaVersion.getDescription() != null) {
            schemaVersion.setDescription(mSchemaVersion.getDescription());
        }
        if (mSchemaVersion.getSchemaText() != null) {
            schemaVersion.setSchemaText(mSchemaVersion.getSchemaText());
        }
        if (mSchemaVersion.getFingerprint() != null) {
            schemaVersion.setFingerprint(mSchemaVersion.getFingerprint());
        }
        if (mSchemaVersion.getName() != null) {
            schemaVersion.setName(mSchemaVersion.getName());
        }
        if (mSchemaVersion.getSerDe() != null) {
            schemaVersion.setSerDe(this.convertToSerDeInfo(mSchemaVersion.getSerDe()));
        }
        return schemaVersion;
    }

    @.VisibleForTesting
    void rollbackAndCleanup(boolean success, Query query) {
        try {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        finally {
            if (query != null) {
                query.closeAll();
            }
        }
    }

    @.VisibleForTesting
    void rollbackAndCleanup(boolean success, QueryWrapper queryWrapper) {
        try {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        finally {
            if (queryWrapper != null) {
                queryWrapper.close();
            }
        }
    }

    @.VisibleForTesting
    public static void setTwoMetastoreTesting(boolean twoMetastoreTesting) {
        forTwoMetastoreTesting = twoMetastoreTesting;
    }

    @.VisibleForTesting
    Properties getProp() {
        return prop;
    }

    private void checkForConstraintException(Exception e, String msg) throws AlreadyExistsException {
        if (this.getConstraintException(e) != null) {
            LOG.error(msg, e);
            throw new AlreadyExistsException(msg);
        }
    }

    private Throwable getConstraintException(Throwable t) {
        while (t != null) {
            if (t instanceof SQLIntegrityConstraintViolationException) {
                return t;
            }
            t = t.getCause();
        }
        return null;
    }

    @Override
    public void createResourcePlan(WMResourcePlan resourcePlan, String copyFromName, int defaultPoolSize) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException {
        boolean commited = false;
        String rpName = StringUtils.normalizeIdentifier(resourcePlan.getName());
        if (rpName.isEmpty()) {
            throw new InvalidObjectException("Resource name cannot be empty.");
        }
        MWMResourcePlan rp = null;
        if (copyFromName == null) {
            Integer queryParallelism = null;
            if (resourcePlan.isSetQueryParallelism() && (queryParallelism = Integer.valueOf(resourcePlan.getQueryParallelism())) <= 0) {
                throw new InvalidObjectException("Query parallelism should be positive.");
            }
            rp = new MWMResourcePlan(rpName, queryParallelism, MWMResourcePlan.Status.DISABLED);
        } else {
            rp = new MWMResourcePlan(rpName, null, MWMResourcePlan.Status.DISABLED);
        }
        try {
            this.openTransaction();
            this.pm.makePersistent((Object)rp);
            if (copyFromName != null) {
                MWMResourcePlan copyFrom = this.getMWMResourcePlan(copyFromName, false);
                if (copyFrom == null) {
                    throw new NoSuchObjectException(copyFromName);
                }
                this.copyRpContents(rp, copyFrom);
            } else if (defaultPoolSize > 0) {
                MWMPool defaultPool = new MWMPool(rp, "default", 1.0, defaultPoolSize, null);
                this.pm.makePersistent((Object)defaultPool);
                rp.setPools(Sets.newHashSet(defaultPool));
                rp.setDefaultPool(defaultPool);
            }
            commited = this.commitTransaction();
        }
        catch (InvalidOperationException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        catch (Exception e) {
            this.checkForConstraintException(e, "Resource plan already exists: ");
            throw e;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
    }

    private void copyRpContents(MWMResourcePlan dest, MWMResourcePlan src) {
        dest.setQueryParallelism(src.getQueryParallelism());
        HashMap<String, MWMPool> pools = new HashMap<String, MWMPool>();
        HashMap<String, HashSet<MWMPool>> triggersToPools = new HashMap<String, HashSet<MWMPool>>();
        for (MWMPool mWMPool : src.getPools()) {
            MWMPool pool = new MWMPool(dest, mWMPool.getPath(), mWMPool.getAllocFraction(), mWMPool.getQueryParallelism(), mWMPool.getSchedulingPolicy());
            this.pm.makePersistent((Object)pool);
            pools.put(mWMPool.getPath(), pool);
            if (mWMPool.getTriggers() == null) continue;
            for (MWMTrigger trigger : mWMPool.getTriggers()) {
                HashSet<MWMPool> p2t = (HashSet<MWMPool>)triggersToPools.get(trigger.getName());
                if (p2t == null) {
                    p2t = new HashSet<MWMPool>();
                    triggersToPools.put(trigger.getName(), p2t);
                }
                p2t.add(pool);
                pool.setTriggers(new HashSet<MWMTrigger>());
            }
        }
        dest.setPools(new HashSet<MWMPool>(pools.values()));
        if (src.getDefaultPool() != null) {
            dest.setDefaultPool((MWMPool)pools.get(src.getDefaultPool().getPath()));
        }
        HashSet<MWMMapping> mappings = new HashSet<MWMMapping>();
        for (MWMMapping copyMapping : src.getMappings()) {
            MWMPool pool = null;
            if (copyMapping.getPool() != null) {
                pool = (MWMPool)pools.get(copyMapping.getPool().getPath());
            }
            MWMMapping mapping = new MWMMapping(dest, copyMapping.getEntityType(), copyMapping.getEntityName(), pool, copyMapping.getOrdering());
            this.pm.makePersistent((Object)mapping);
            mappings.add(mapping);
        }
        dest.setMappings(mappings);
        HashSet<MWMTrigger> hashSet = new HashSet<MWMTrigger>();
        for (MWMTrigger copyTrigger : src.getTriggers()) {
            HashSet<MWMPool> p2t = (HashSet<MWMPool>)triggersToPools.get(copyTrigger.getName());
            if (p2t == null) {
                p2t = new HashSet<MWMPool>();
            }
            MWMTrigger trigger = new MWMTrigger(dest, copyTrigger.getName(), copyTrigger.getTriggerExpression(), copyTrigger.getActionExpression(), p2t, copyTrigger.getIsInUnmanaged());
            this.pm.makePersistent((Object)trigger);
            for (MWMPool pool : p2t) {
                pool.getTriggers().add(trigger);
            }
            hashSet.add(trigger);
        }
        dest.setTriggers(hashSet);
    }

    private WMResourcePlan fromMResourcePlan(MWMResourcePlan mplan) {
        if (mplan == null) {
            return null;
        }
        WMResourcePlan rp = new WMResourcePlan();
        rp.setName(mplan.getName());
        rp.setStatus(WMResourcePlanStatus.valueOf(mplan.getStatus().name()));
        if (mplan.getQueryParallelism() != null) {
            rp.setQueryParallelism(mplan.getQueryParallelism());
        }
        if (mplan.getDefaultPool() != null) {
            rp.setDefaultPoolPath(mplan.getDefaultPool().getPath());
        }
        return rp;
    }

    private WMFullResourcePlan fullFromMResourcePlan(MWMResourcePlan mplan) {
        if (mplan == null) {
            return null;
        }
        WMFullResourcePlan rp = new WMFullResourcePlan();
        rp.setPlan(this.fromMResourcePlan(mplan));
        for (MWMPool mPool : mplan.getPools()) {
            rp.addToPools(this.fromMPool(mPool, mplan.getName()));
            for (MWMTrigger mTrigger : mPool.getTriggers()) {
                rp.addToPoolTriggers(new WMPoolTrigger(mPool.getPath(), mTrigger.getName()));
            }
        }
        for (MWMTrigger mTrigger : mplan.getTriggers()) {
            rp.addToTriggers(this.fromMWMTrigger(mTrigger, mplan.getName()));
        }
        for (MWMMapping mMapping : mplan.getMappings()) {
            rp.addToMappings(this.fromMMapping(mMapping, mplan.getName()));
        }
        return rp;
    }

    private WMPool fromMPool(MWMPool mPool, String rpName) {
        WMPool result = new WMPool(rpName, mPool.getPath());
        assert (mPool.getAllocFraction() != null);
        result.setAllocFraction(mPool.getAllocFraction());
        assert (mPool.getQueryParallelism() != null);
        result.setQueryParallelism(mPool.getQueryParallelism());
        result.setSchedulingPolicy(mPool.getSchedulingPolicy());
        return result;
    }

    private WMMapping fromMMapping(MWMMapping mMapping, String rpName) {
        WMMapping result = new WMMapping(rpName, mMapping.getEntityType().toString(), mMapping.getEntityName());
        if (mMapping.getPool() != null) {
            result.setPoolPath(mMapping.getPool().getPath());
        }
        if (mMapping.getOrdering() != null) {
            result.setOrdering(mMapping.getOrdering());
        }
        return result;
    }

    @Override
    public WMFullResourcePlan getResourcePlan(String name) throws NoSuchObjectException {
        boolean commited = false;
        try {
            this.openTransaction();
            WMFullResourcePlan fullRp = this.fullFromMResourcePlan(this.getMWMResourcePlan(name, false));
            commited = this.commitTransaction();
            WMFullResourcePlan wMFullResourcePlan = fullRp;
            return wMFullResourcePlan;
        }
        catch (InvalidOperationException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        finally {
            this.rollbackAndCleanup(commited, (Query)null);
        }
    }

    private MWMResourcePlan getMWMResourcePlan(String name, boolean editCheck) throws NoSuchObjectException, InvalidOperationException {
        return this.getMWMResourcePlan(name, editCheck, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MWMResourcePlan getMWMResourcePlan(String name, boolean editCheck, boolean mustExist) throws NoSuchObjectException, InvalidOperationException {
        MWMResourcePlan resourcePlan;
        boolean commited = false;
        Query query = null;
        name = StringUtils.normalizeIdentifier(name);
        try {
            this.openTransaction();
            query = this.pm.newQuery(MWMResourcePlan.class, "name == rpname");
            query.declareParameters("java.lang.String rpname");
            query.setUnique(true);
            resourcePlan = (MWMResourcePlan)query.execute((Object)name);
            this.pm.retrieve((Object)resourcePlan);
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        if (mustExist && resourcePlan == null) {
            throw new NoSuchObjectException("There is no resource plan named: " + name);
        }
        if (editCheck && resourcePlan != null && resourcePlan.getStatus() != MWMResourcePlan.Status.DISABLED) {
            throw new InvalidOperationException("Resource plan must be disabled to edit it.");
        }
        return resourcePlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WMResourcePlan> getAllResourcePlans() throws MetaException {
        ArrayList<WMResourcePlan> resourcePlans = new ArrayList<WMResourcePlan>();
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MWMResourcePlan.class);
            List mplans = (List)query.execute();
            this.pm.retrieveAll((Collection)mplans);
            commited = this.commitTransaction();
            if (mplans != null) {
                for (MWMResourcePlan mplan : mplans) {
                    resourcePlans.add(this.fromMResourcePlan(mplan));
                }
            }
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return resourcePlans;
    }

    @Override
    public WMFullResourcePlan alterResourcePlan(String name, WMNullableResourcePlan changes, boolean canActivateDisabled, boolean canDeactivate, boolean isReplace) throws AlreadyExistsException, NoSuchObjectException, InvalidOperationException, MetaException {
        String string = name = name == null ? null : StringUtils.normalizeIdentifier(name);
        if (isReplace && name == null) {
            throw new InvalidOperationException("Cannot replace without specifying the source plan");
        }
        boolean commited = false;
        Query query = null;
        WMFullResourcePlan result = null;
        try {
            this.openTransaction();
            result = isReplace ? this.handleAlterReplace(name, changes) : this.handleSimpleAlter(name, changes, canActivateDisabled, canDeactivate);
            commited = this.commitTransaction();
            WMFullResourcePlan wMFullResourcePlan = result;
            return wMFullResourcePlan;
        }
        catch (Exception e) {
            this.checkForConstraintException(e, "Resource plan name should be unique: ");
            throw e;
        }
        finally {
            this.rollbackAndCleanup(commited, query);
        }
    }

    private WMFullResourcePlan handleSimpleAlter(String name, WMNullableResourcePlan changes, boolean canActivateDisabled, boolean canDeactivate) throws InvalidOperationException, NoSuchObjectException, MetaException {
        boolean hasNameChange;
        MWMResourcePlan plan = name == null ? this.getActiveMWMResourcePlan() : this.getMWMResourcePlan(name, !changes.isSetStatus());
        boolean bl = hasNameChange = changes.isSetName() && !changes.getName().equals(name);
        if (changes.isSetIsSetQueryParallelism() || changes.isSetIsSetDefaultPoolPath() || hasNameChange) {
            if (changes.isSetStatus()) {
                throw new InvalidOperationException("Cannot change values during status switch.");
            }
            if (plan.getStatus() != MWMResourcePlan.Status.DISABLED) {
                throw new InvalidOperationException("Resource plan must be disabled to edit it.");
            }
        }
        if (changes.isSetName()) {
            String newName = StringUtils.normalizeIdentifier(changes.getName());
            if (newName.isEmpty()) {
                throw new InvalidOperationException("Cannot rename to empty value.");
            }
            if (!newName.equals(plan.getName())) {
                plan.setName(newName);
            }
        }
        if (changes.isSetIsSetQueryParallelism() && changes.isIsSetQueryParallelism()) {
            if (changes.isSetQueryParallelism()) {
                if (changes.getQueryParallelism() <= 0) {
                    throw new InvalidOperationException("queryParallelism should be positive.");
                }
                plan.setQueryParallelism(changes.getQueryParallelism());
            } else {
                plan.setQueryParallelism(null);
            }
        }
        if (changes.isSetIsSetDefaultPoolPath() && changes.isIsSetDefaultPoolPath()) {
            if (changes.isSetDefaultPoolPath()) {
                MWMPool pool = this.getPool(plan, changes.getDefaultPoolPath());
                plan.setDefaultPool(pool);
            } else {
                plan.setDefaultPool(null);
            }
        }
        if (changes.isSetStatus()) {
            return this.switchStatus(name, plan, changes.getStatus().name(), canActivateDisabled, canDeactivate);
        }
        return null;
    }

    private WMFullResourcePlan handleAlterReplace(String name, WMNullableResourcePlan changes) throws InvalidOperationException, NoSuchObjectException, MetaException {
        MWMResourcePlan dup;
        boolean isReplacingActive;
        if (changes.isSetQueryParallelism() || changes.isSetDefaultPoolPath()) {
            throw new InvalidOperationException("Cannot change values during replace.");
        }
        boolean isReplacingSpecific = changes.isSetName();
        boolean bl = isReplacingActive = changes.isSetStatus() && changes.getStatus() == WMResourcePlanStatus.ACTIVE;
        if (isReplacingActive == isReplacingSpecific) {
            throw new InvalidOperationException("Must specify a name, or the active plan; received " + changes.getName() + ", " + (Object)((Object)(changes.isSetStatus() ? changes.getStatus() : null)));
        }
        if (name == null) {
            throw new InvalidOperationException("Invalid replace - no name specified");
        }
        MWMResourcePlan replacedPlan = isReplacingSpecific ? this.getMWMResourcePlan(changes.getName(), false) : this.getActiveMWMResourcePlan();
        MWMResourcePlan plan = this.getMWMResourcePlan(name, false);
        if (replacedPlan.getName().equals(plan.getName())) {
            throw new InvalidOperationException("A plan cannot replace itself");
        }
        String newName = replacedPlan.getName();
        int i = 0;
        String copyName = this.generateOldPlanName(newName, i);
        while ((dup = this.getMWMResourcePlan(copyName, false, false)) != null) {
            copyName = this.generateOldPlanName(newName, ++i);
        }
        replacedPlan.setName(copyName);
        plan.setName(newName);
        plan.setStatus(replacedPlan.getStatus());
        replacedPlan.setStatus(MWMResourcePlan.Status.DISABLED);
        return plan.getStatus() == MWMResourcePlan.Status.ACTIVE ? this.fullFromMResourcePlan(plan) : null;
    }

    private String generateOldPlanName(String newName, int i) {
        if (MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEST)) {
            return newName + "_old_" + i;
        }
        return newName + "_old_" + LocalDateTime.now().format(YMDHMS_FORMAT) + (i == 0 ? "" : "_" + i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WMFullResourcePlan getActiveResourcePlan() throws MetaException {
        boolean commited = false;
        Query query = null;
        WMFullResourcePlan result = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MWMResourcePlan.class, "status == activeStatus");
            query.declareParameters("java.lang.String activeStatus");
            query.setUnique(true);
            MWMResourcePlan mResourcePlan = (MWMResourcePlan)query.execute((Object)MWMResourcePlan.Status.ACTIVE.toString());
            if (mResourcePlan != null) {
                result = this.fullFromMResourcePlan(mResourcePlan);
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MWMResourcePlan getActiveMWMResourcePlan() throws MetaException {
        boolean commited = false;
        Query query = null;
        MWMResourcePlan result = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MWMResourcePlan.class, "status == activeStatus");
            query.declareParameters("java.lang.String activeStatus");
            query.setUnique(true);
            result = (MWMResourcePlan)query.execute((Object)MWMResourcePlan.Status.ACTIVE.toString());
            this.pm.retrieve((Object)result);
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return result;
    }

    private WMFullResourcePlan switchStatus(String name, MWMResourcePlan mResourcePlan, String status, boolean canActivateDisabled, boolean canDeactivate) throws InvalidOperationException {
        WMValidateResourcePlanResponse response;
        MWMResourcePlan.Status currentStatus = mResourcePlan.getStatus();
        MWMResourcePlan.Status newStatus = null;
        try {
            newStatus = MWMResourcePlan.Status.valueOf(status);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidOperationException("Invalid status: " + status);
        }
        if (newStatus == currentStatus) {
            return null;
        }
        boolean doActivate = false;
        boolean doValidate = false;
        switch (currentStatus) {
            case ACTIVE: {
                if (canDeactivate) break;
                throw new InvalidOperationException("Resource plan " + name + " is active; activate another plan first, or disable workload management.");
            }
            case DISABLED: {
                assert (newStatus == MWMResourcePlan.Status.ACTIVE || newStatus == MWMResourcePlan.Status.ENABLED);
                doValidate = true;
                boolean bl = doActivate = newStatus == MWMResourcePlan.Status.ACTIVE;
                if (!doActivate || canActivateDisabled) break;
                throw new InvalidOperationException("Resource plan " + name + " is disabled and should be enabled before activation (or in the same command)");
            }
            case ENABLED: {
                if (newStatus == MWMResourcePlan.Status.DISABLED) {
                    mResourcePlan.setStatus(newStatus);
                    return null;
                }
                assert (newStatus == MWMResourcePlan.Status.ACTIVE);
                doActivate = true;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected status " + (Object)((Object)currentStatus)));
            }
        }
        if (doValidate && !(response = this.getResourcePlanErrors(mResourcePlan)).getErrors().isEmpty()) {
            throw new InvalidOperationException("ResourcePlan: " + name + " is invalid: " + response.getErrors());
        }
        if (doActivate) {
            this.deactivateActiveResourcePlan();
            mResourcePlan.setStatus(newStatus);
            return this.fullFromMResourcePlan(mResourcePlan);
        }
        mResourcePlan.setStatus(newStatus);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateActiveResourcePlan() {
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MWMResourcePlan.class, "status == \"ACTIVE\"");
            query.setUnique(true);
            MWMResourcePlan mResourcePlan = (MWMResourcePlan)query.execute();
            if (mResourcePlan != null) {
                mResourcePlan.setStatus(MWMResourcePlan.Status.ENABLED);
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    private PoolData getPoolData(Map<String, PoolData> poolInfo, String poolPath) {
        PoolData poolData = poolInfo.get(poolPath);
        if (poolData == null) {
            poolData = new PoolData();
            poolInfo.put(poolPath, poolData);
        }
        return poolData;
    }

    private WMValidateResourcePlanResponse getResourcePlanErrors(MWMResourcePlan mResourcePlan) {
        WMValidateResourcePlanResponse response = new WMValidateResourcePlanResponse();
        response.setErrors(new ArrayList<String>());
        response.setWarnings(new ArrayList<String>());
        Integer rpParallelism = mResourcePlan.getQueryParallelism();
        if (rpParallelism != null && rpParallelism < 1) {
            response.addToErrors("Query parallelism should for resource plan be positive. Got: " + rpParallelism);
        }
        int totalQueryParallelism = 0;
        HashMap<String, PoolData> poolInfo = new HashMap<String, PoolData>();
        for (MWMPool mWMPool : mResourcePlan.getPools()) {
            PoolData currentPoolData = this.getPoolData(poolInfo, mWMPool.getPath());
            currentPoolData.found = true;
            String parent = this.getParentPath(mWMPool.getPath(), "");
            PoolData parentPoolData = this.getPoolData(poolInfo, parent);
            parentPoolData.hasChildren = true;
            parentPoolData.totalChildrenAllocFraction += mWMPool.getAllocFraction().doubleValue();
            if (mWMPool.getQueryParallelism() != null && mWMPool.getQueryParallelism() < 1) {
                response.addToErrors("Invalid query parallelism for pool: " + mWMPool.getPath());
            } else {
                totalQueryParallelism += mWMPool.getQueryParallelism().intValue();
            }
            if (MetaStoreUtils.isValidSchedulingPolicy(mWMPool.getSchedulingPolicy())) continue;
            response.addToErrors("Invalid scheduling policy " + mWMPool.getSchedulingPolicy() + " for pool: " + mWMPool.getPath());
        }
        if (rpParallelism != null) {
            if (rpParallelism < totalQueryParallelism) {
                response.addToErrors("Sum of all pools' query parallelism: " + totalQueryParallelism + " exceeds resource plan query parallelism: " + rpParallelism);
            } else if (rpParallelism != totalQueryParallelism) {
                response.addToWarnings("Sum of all pools' query parallelism: " + totalQueryParallelism + " is less than resource plan query parallelism: " + rpParallelism);
            }
        }
        for (Map.Entry entry : poolInfo.entrySet()) {
            PoolData poolData = (PoolData)entry.getValue();
            boolean isRoot = ((String)entry.getKey()).isEmpty();
            if (isRoot) {
                poolData.found = true;
                if (!poolData.hasChildren) {
                    response.addToErrors("Root has no children");
                } else if (Math.abs(1.0 - poolData.totalChildrenAllocFraction) > 0.001) {
                    response.addToErrors("Sum of root children pools' alloc fraction should be 1.0 got: " + poolData.totalChildrenAllocFraction + " for pool: " + (String)entry.getKey());
                }
            }
            if (!poolData.found) {
                response.addToErrors("Pool does not exists but has children: " + (String)entry.getKey());
            }
            if (!poolData.hasChildren || isRoot || !(1.0 <= poolData.totalChildrenAllocFraction)) continue;
            response.addToErrors("Sum of children pools' alloc fraction should be less than 1 got: " + poolData.totalChildrenAllocFraction + " for pool: " + (String)entry.getKey());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WMValidateResourcePlanResponse validateResourcePlan(String name) throws NoSuchObjectException, InvalidObjectException, MetaException {
        name = StringUtils.normalizeIdentifier(name);
        Query query = null;
        try {
            query = this.pm.newQuery(MWMResourcePlan.class, "name == rpName");
            query.declareParameters("java.lang.String rpName");
            query.setUnique(true);
            MWMResourcePlan mResourcePlan = (MWMResourcePlan)query.execute((Object)name);
            if (mResourcePlan == null) {
                throw new NoSuchObjectException("Cannot find resourcePlan: " + name);
            }
            WMValidateResourcePlanResponse wMValidateResourcePlanResponse = this.getResourcePlanErrors(mResourcePlan);
            return wMValidateResourcePlanResponse;
        }
        finally {
            this.rollbackAndCleanup(true, query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropResourcePlan(String name) throws NoSuchObjectException, MetaException {
        name = StringUtils.normalizeIdentifier(name);
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MWMResourcePlan.class, "name == rpname");
            query.declareParameters("java.lang.String rpname");
            query.setUnique(true);
            MWMResourcePlan resourcePlan = (MWMResourcePlan)query.execute((Object)name);
            this.pm.retrieve((Object)resourcePlan);
            if (resourcePlan == null) {
                throw new NoSuchObjectException("There is no resource plan named: " + name);
            }
            if (resourcePlan.getStatus() == MWMResourcePlan.Status.ACTIVE) {
                throw new MetaException("Cannot drop an active resource plan");
            }
            resourcePlan.setDefaultPool(null);
            this.pm.deletePersistentAll(resourcePlan.getTriggers());
            this.pm.deletePersistentAll(resourcePlan.getMappings());
            this.pm.deletePersistentAll(resourcePlan.getPools());
            this.pm.deletePersistent((Object)resourcePlan);
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    @Override
    public void createWMTrigger(WMTrigger trigger) throws AlreadyExistsException, NoSuchObjectException, InvalidOperationException, MetaException {
        boolean commited = false;
        try {
            this.openTransaction();
            MWMResourcePlan resourcePlan = this.getMWMResourcePlan(trigger.getResourcePlanName(), true);
            MWMTrigger mTrigger = new MWMTrigger(resourcePlan, StringUtils.normalizeIdentifier(trigger.getTriggerName()), trigger.getTriggerExpression(), trigger.getActionExpression(), null, trigger.isSetIsInUnmanaged() && trigger.isIsInUnmanaged());
            this.pm.makePersistent((Object)mTrigger);
            commited = this.commitTransaction();
        }
        catch (Exception e) {
            this.checkForConstraintException(e, "Trigger already exists, use alter: ");
            throw e;
        }
        finally {
            this.rollbackAndCleanup(commited, (Query)null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterWMTrigger(WMTrigger trigger) throws NoSuchObjectException, InvalidOperationException, MetaException {
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            MWMResourcePlan resourcePlan = this.getMWMResourcePlan(trigger.getResourcePlanName(), true);
            MWMTrigger mTrigger = this.getTrigger(resourcePlan, trigger.getTriggerName());
            if (trigger.isSetTriggerExpression()) {
                mTrigger.setTriggerExpression(trigger.getTriggerExpression());
            }
            if (trigger.isSetActionExpression()) {
                mTrigger.setActionExpression(trigger.getActionExpression());
            }
            if (trigger.isSetIsInUnmanaged()) {
                mTrigger.setIsInUnmanaged(trigger.isIsInUnmanaged());
            }
            commited = this.commitTransaction();
        }
        finally {
            this.rollbackAndCleanup(commited, query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MWMTrigger getTrigger(MWMResourcePlan resourcePlan, String triggerName) throws NoSuchObjectException {
        triggerName = StringUtils.normalizeIdentifier(triggerName);
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MWMTrigger.class, "resourcePlan == rp && name == triggerName");
            query.declareParameters("MWMResourcePlan rp, java.lang.String triggerName");
            query.setUnique(true);
            MWMTrigger mTrigger = (MWMTrigger)query.execute((Object)resourcePlan, (Object)triggerName);
            if (mTrigger == null) {
                throw new NoSuchObjectException("Cannot find trigger with name: " + triggerName);
            }
            this.pm.retrieve((Object)mTrigger);
            commited = this.commitTransaction();
            MWMTrigger mWMTrigger = mTrigger;
            this.rollbackAndCleanup(commited, query);
            return mWMTrigger;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropWMTrigger(String resourcePlanName, String triggerName) throws NoSuchObjectException, InvalidOperationException, MetaException {
        resourcePlanName = StringUtils.normalizeIdentifier(resourcePlanName);
        triggerName = StringUtils.normalizeIdentifier(triggerName);
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            MWMResourcePlan resourcePlan = this.getMWMResourcePlan(resourcePlanName, true);
            query = this.pm.newQuery(MWMTrigger.class, "resourcePlan == rp && name == triggerName");
            query.declareParameters("MWMResourcePlan rp, java.lang.String triggerName");
            if (query.deletePersistentAll(new Object[]{resourcePlan, triggerName}) != 1L) {
                throw new NoSuchObjectException("Cannot delete trigger: " + triggerName);
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WMTrigger> getTriggersForResourcePlan(String resourcePlanName) throws NoSuchObjectException, MetaException {
        ArrayList<WMTrigger> triggers = new ArrayList<WMTrigger>();
        boolean commited = false;
        Query query = null;
        try {
            MWMResourcePlan resourcePlan;
            this.openTransaction();
            try {
                resourcePlan = this.getMWMResourcePlan(resourcePlanName, false);
            }
            catch (InvalidOperationException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
            query = this.pm.newQuery(MWMTrigger.class, "resourcePlan == rp");
            query.declareParameters("MWMResourcePlan rp");
            List mTriggers = (List)query.execute((Object)resourcePlan);
            this.pm.retrieveAll((Collection)mTriggers);
            commited = this.commitTransaction();
            if (mTriggers != null) {
                for (MWMTrigger trigger : mTriggers) {
                    triggers.add(this.fromMWMTrigger(trigger, resourcePlanName));
                }
            }
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
        return triggers;
    }

    private WMTrigger fromMWMTrigger(MWMTrigger mTrigger, String resourcePlanName) {
        WMTrigger trigger = new WMTrigger();
        trigger.setResourcePlanName(resourcePlanName);
        trigger.setTriggerName(mTrigger.getName());
        trigger.setTriggerExpression(mTrigger.getTriggerExpression());
        trigger.setActionExpression(mTrigger.getActionExpression());
        trigger.setIsInUnmanaged(mTrigger.getIsInUnmanaged());
        return trigger;
    }

    @Override
    public void createPool(WMPool pool) throws AlreadyExistsException, NoSuchObjectException, InvalidOperationException, MetaException {
        boolean commited = false;
        try {
            this.openTransaction();
            MWMResourcePlan resourcePlan = this.getMWMResourcePlan(pool.getResourcePlanName(), true);
            if (!this.poolParentExists(resourcePlan, pool.getPoolPath())) {
                throw new NoSuchObjectException("Pool path is invalid, the parent does not exist");
            }
            String policy = pool.getSchedulingPolicy();
            if (!MetaStoreUtils.isValidSchedulingPolicy(policy)) {
                throw new InvalidOperationException("Invalid scheduling policy " + policy);
            }
            MWMPool mPool = new MWMPool(resourcePlan, pool.getPoolPath(), pool.getAllocFraction(), pool.getQueryParallelism(), policy);
            this.pm.makePersistent((Object)mPool);
            commited = this.commitTransaction();
        }
        catch (Exception e) {
            this.checkForConstraintException(e, "Pool already exists: ");
            throw e;
        }
        finally {
            this.rollbackAndCleanup(commited, (Query)null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPool(WMNullablePool pool, String poolPath) throws AlreadyExistsException, NoSuchObjectException, InvalidOperationException, MetaException {
        boolean commited = false;
        try {
            this.openTransaction();
            MWMResourcePlan resourcePlan = this.getMWMResourcePlan(pool.getResourcePlanName(), true);
            MWMPool mPool = this.getPool(resourcePlan, poolPath);
            this.pm.retrieve((Object)mPool);
            if (pool.isSetAllocFraction()) {
                mPool.setAllocFraction(pool.getAllocFraction());
            }
            if (pool.isSetQueryParallelism()) {
                mPool.setQueryParallelism(pool.getQueryParallelism());
            }
            if (pool.isSetIsSetSchedulingPolicy() && pool.isIsSetSchedulingPolicy()) {
                if (pool.isSetSchedulingPolicy()) {
                    String policy = pool.getSchedulingPolicy();
                    if (!MetaStoreUtils.isValidSchedulingPolicy(policy)) {
                        throw new InvalidOperationException("Invalid scheduling policy " + policy);
                    }
                    mPool.setSchedulingPolicy(pool.getSchedulingPolicy());
                } else {
                    mPool.setSchedulingPolicy(null);
                }
            }
            if (pool.isSetPoolPath() && !pool.getPoolPath().equals(mPool.getPath())) {
                this.moveDescendents(resourcePlan, mPool.getPath(), pool.getPoolPath());
                mPool.setPath(pool.getPoolPath());
            }
            commited = this.commitTransaction();
        }
        finally {
            this.rollbackAndCleanup(commited, (Query)null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MWMPool getPool(MWMResourcePlan resourcePlan, String poolPath) throws NoSuchObjectException {
        poolPath = StringUtils.normalizeIdentifier(poolPath);
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MWMPool.class, "resourcePlan == rp && path == poolPath");
            query.declareParameters("MWMResourcePlan rp, java.lang.String poolPath");
            query.setUnique(true);
            MWMPool mPool = (MWMPool)query.execute((Object)resourcePlan, (Object)poolPath);
            commited = this.commitTransaction();
            if (mPool == null) {
                throw new NoSuchObjectException("Cannot find pool: " + poolPath);
            }
            this.pm.retrieve((Object)mPool);
            MWMPool mWMPool = mPool;
            this.rollbackAndCleanup(commited, query);
            return mWMPool;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveDescendents(MWMResourcePlan resourcePlan, String path, String newPoolPath) throws NoSuchObjectException {
        if (!this.poolParentExists(resourcePlan, newPoolPath)) {
            throw new NoSuchObjectException("Pool path is invalid, the parent does not exist");
        }
        boolean commited = false;
        Query query = null;
        this.openTransaction();
        try {
            query = this.pm.newQuery(MWMPool.class, "resourcePlan == rp && path.startsWith(poolPath)");
            query.declareParameters("MWMResourcePlan rp, java.lang.String poolPath");
            List descPools = (List)query.execute((Object)resourcePlan, (Object)(path + "."));
            this.pm.retrieveAll((Collection)descPools);
            for (MWMPool pool : descPools) {
                pool.setPath(newPoolPath + pool.getPath().substring(path.length()));
            }
            commited = this.commitTransaction();
        }
        finally {
            this.rollbackAndCleanup(commited, query);
        }
    }

    private String getParentPath(String poolPath, String defValue) {
        int idx = poolPath.lastIndexOf(46);
        if (idx == -1) {
            return defValue;
        }
        return poolPath.substring(0, idx);
    }

    private boolean poolParentExists(MWMResourcePlan resourcePlan, String poolPath) {
        String parent = this.getParentPath(poolPath, null);
        if (parent == null) {
            return true;
        }
        try {
            this.getPool(resourcePlan, parent);
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    @Override
    public void dropWMPool(String resourcePlanName, String poolPath) throws NoSuchObjectException, InvalidOperationException, MetaException {
        poolPath = StringUtils.normalizeIdentifier(poolPath);
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            MWMResourcePlan resourcePlan = this.getMWMResourcePlan(resourcePlanName, true);
            if (resourcePlan.getDefaultPool() != null && resourcePlan.getDefaultPool().getPath().equals(poolPath)) {
                throw new InvalidOperationException("Cannot drop default pool of a resource plan");
            }
            if (this.poolHasChildren(resourcePlan, poolPath)) {
                throw new InvalidOperationException("Pool has children cannot drop.");
            }
            query = this.pm.newQuery(MWMPool.class, "resourcePlan == rp && path.startsWith(poolPath)");
            query.declareParameters("MWMResourcePlan rp, java.lang.String poolPath");
            if (query.deletePersistentAll(new Object[]{resourcePlan, poolPath}) != 1L) {
                throw new NoSuchObjectException("Cannot delete pool: " + poolPath);
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Exception e) {
            try {
                if (this.getConstraintException(e) != null) {
                    throw new InvalidOperationException("Please remove all mappings for this pool.");
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.rollbackAndCleanup(commited, query);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean poolHasChildren(MWMResourcePlan resourcePlan, String poolPath) {
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MWMPool.class, "resourcePlan == rp && path.startsWith(poolPath)");
            query.declareParameters("MWMResourcePlan rp, java.lang.String poolPath");
            query.setResult("count(this)");
            query.setUnique(true);
            Long count = (Long)query.execute((Object)resourcePlan, (Object)(poolPath + "."));
            commited = this.commitTransaction();
            boolean bl = count != null && count > 0L;
            this.rollbackAndCleanup(commited, query);
            return bl;
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createOrUpdateWMMapping(WMMapping mapping, boolean update) throws AlreadyExistsException, NoSuchObjectException, InvalidOperationException, MetaException {
        MWMMapping.EntityType entityType = MWMMapping.EntityType.valueOf(mapping.getEntityType().trim().toUpperCase());
        String entityName = StringUtils.normalizeIdentifier(mapping.getEntityName());
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            MWMResourcePlan resourcePlan = this.getMWMResourcePlan(mapping.getResourcePlanName(), true);
            MWMPool pool = null;
            if (mapping.isSetPoolPath()) {
                pool = this.getPool(resourcePlan, mapping.getPoolPath());
            }
            if (!update) {
                MWMMapping mMapping = new MWMMapping(resourcePlan, entityType, entityName, pool, mapping.getOrdering());
                this.pm.makePersistent((Object)mMapping);
            } else {
                query = this.pm.newQuery(MWMMapping.class, "resourcePlan == rp && entityType == type && entityName == name");
                query.declareParameters("MWMResourcePlan rp, java.lang.String type, java.lang.String name");
                query.setUnique(true);
                MWMMapping mMapping = (MWMMapping)query.execute((Object)resourcePlan, (Object)entityType.toString(), (Object)entityName);
                mMapping.setPool(pool);
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropWMMapping(WMMapping mapping) throws NoSuchObjectException, InvalidOperationException, MetaException {
        String entityType = mapping.getEntityType().trim().toUpperCase();
        String entityName = StringUtils.normalizeIdentifier(mapping.getEntityName());
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            MWMResourcePlan resourcePlan = this.getMWMResourcePlan(mapping.getResourcePlanName(), true);
            query = this.pm.newQuery(MWMMapping.class, "resourcePlan == rp && entityType == type && entityName == name");
            query.declareParameters("MWMResourcePlan rp, java.lang.String type, java.lang.String name");
            if (query.deletePersistentAll(new Object[]{resourcePlan, entityType, entityName}) != 1L) {
                throw new NoSuchObjectException("Cannot delete mapping.");
            }
            commited = this.commitTransaction();
            this.rollbackAndCleanup(commited, query);
        }
        catch (Throwable throwable) {
            this.rollbackAndCleanup(commited, query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createWMTriggerToPoolMapping(String resourcePlanName, String triggerName, String poolPath) throws AlreadyExistsException, NoSuchObjectException, InvalidOperationException, MetaException {
        boolean commited = false;
        try {
            this.openTransaction();
            MWMResourcePlan resourcePlan = this.getMWMResourcePlan(resourcePlanName, true);
            MWMPool pool = this.getPool(resourcePlan, poolPath);
            MWMTrigger trigger = this.getTrigger(resourcePlan, triggerName);
            pool.getTriggers().add(trigger);
            trigger.getPools().add(pool);
            this.pm.makePersistent((Object)pool);
            this.pm.makePersistent((Object)trigger);
            commited = this.commitTransaction();
        }
        finally {
            this.rollbackAndCleanup(commited, (Query)null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropWMTriggerToPoolMapping(String resourcePlanName, String triggerName, String poolPath) throws NoSuchObjectException, InvalidOperationException, MetaException {
        boolean commited = false;
        try {
            this.openTransaction();
            MWMResourcePlan resourcePlan = this.getMWMResourcePlan(resourcePlanName, true);
            MWMPool pool = this.getPool(resourcePlan, poolPath);
            MWMTrigger trigger = this.getTrigger(resourcePlan, triggerName);
            pool.getTriggers().remove(trigger);
            trigger.getPools().remove(pool);
            this.pm.makePersistent((Object)pool);
            this.pm.makePersistent((Object)trigger);
            commited = this.commitTransaction();
        }
        finally {
            this.rollbackAndCleanup(commited, (Query)null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRuntimeStat(RuntimeStat stat) throws MetaException {
        LOG.debug("runtimeStat: " + stat);
        MRuntimeStat mStat = MRuntimeStat.fromThrift(stat);
        boolean committed = false;
        this.openTransaction();
        try {
            this.pm.makePersistent((Object)mStat);
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteRuntimeStats(int maxRetainSecs) throws MetaException {
        if (maxRetainSecs < 0) {
            LOG.warn("runtime stats retention is disabled");
            return 0;
        }
        boolean committed = false;
        try {
            this.openTransaction();
            int maxCreateTime = (int)(System.currentTimeMillis() / 1000L) - maxRetainSecs;
            Query q = this.pm.newQuery(MRuntimeStat.class);
            q.setFilter("createTime <= maxCreateTime");
            q.declareParameters("int maxCreateTime");
            long deleted = q.deletePersistentAll(new Object[]{maxCreateTime});
            committed = this.commitTransaction();
            int n = (int)deleted;
            return n;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RuntimeStat> getRuntimeStats(int maxEntries, int maxCreateTime) throws MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            List<RuntimeStat> stats = this.getMRuntimeStats(maxEntries, maxCreateTime);
            committed = this.commitTransaction();
            List<RuntimeStat> list = stats;
            return list;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    private List<RuntimeStat> getMRuntimeStats(int maxEntries, int maxCreateTime) {
        Query query = this.pm.newQuery(MRuntimeStat.class);
        query.setOrdering("createTime descending");
        if (maxCreateTime > 0) {
            query.setFilter("createTime < " + maxCreateTime);
        }
        if (maxEntries < 0) {
            maxEntries = Integer.MAX_VALUE;
        }
        ArrayList<RuntimeStat> ret = new ArrayList<RuntimeStat>();
        List res = (List)query.execute();
        int totalEntries = 0;
        for (MRuntimeStat mRuntimeStat : res) {
            this.pm.retrieve((Object)mRuntimeStat);
            ret.add(MRuntimeStat.toThrift(mRuntimeStat));
            if ((totalEntries += mRuntimeStat.getWeight()) < maxEntries) continue;
            break;
        }
        return ret;
    }

    static {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put("table", MTable.class);
        map.put("storagedescriptor", MStorageDescriptor.class);
        map.put("serdeinfo", MSerDeInfo.class);
        map.put("partition", MPartition.class);
        map.put("database", MDatabase.class);
        map.put("type", MType.class);
        map.put("fieldschema", MFieldSchema.class);
        map.put("order", MOrder.class);
        PINCLASSMAP = Collections.unmodifiableMap(map);
        String hostname = "UNKNOWN";
        try {
            InetAddress clientAddr = InetAddress.getLocalHost();
            hostname = clientAddr.getHostAddress();
        }
        catch (IOException clientAddr) {
            // empty catch block
        }
        HOSTNAME = hostname;
        String user = System.getenv("USER");
        USER = io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils.defaultString(user, "UNKNOWN");
        retriableExceptionClasses = new HashSet<Class>(Arrays.asList(JDOCanRetryException.class));
    }

    private static class PoolData {
        double totalChildrenAllocFraction = 0.0;
        boolean found = false;
        boolean hasChildren = false;

        private PoolData() {
        }
    }

    static class RetryingExecutor {
        private static Logger LOG = LoggerFactory.getLogger(RetryingExecutor.class);
        private final int maxRetries;
        private final long sleepInterval;
        private int currentRetries = 0;
        private final Command command;

        RetryingExecutor(Configuration config, Command command) {
            this.maxRetries = MetastoreConf.getIntVar(config, MetastoreConf.ConfVars.NOTIFICATION_SEQUENCE_LOCK_MAX_RETRIES);
            this.sleepInterval = MetastoreConf.getTimeVar(config, MetastoreConf.ConfVars.NOTIFICATION_SEQUENCE_LOCK_RETRY_SLEEP_INTERVAL, TimeUnit.MILLISECONDS);
            this.command = command;
        }

        public void run() throws MetaException {
            while (true) {
                try {
                    this.command.process();
                    break;
                }
                catch (Exception e) {
                    LOG.info("Attempting to acquire the DB log notification lock: {} out of {} retries", this.currentRetries, this.maxRetries, e);
                    if (this.currentRetries >= this.maxRetries) {
                        String message = "Couldn't acquire the DB log notification lock because we reached the maximum # of retries: " + this.maxRetries + " retries. If this happens too often, then is recommended to increase the maximum number of retries on the hive.notification.sequence.lock.max.retries configuration";
                        LOG.error(message, e);
                        throw new MetaException(message + " :: " + e.getMessage());
                    }
                    ++this.currentRetries;
                    try {
                        Thread.sleep(this.sleepInterval);
                    }
                    catch (InterruptedException e1) {
                        String msg = "Couldn't acquire the DB notification log lock on " + this.currentRetries + " retry, because the following error: ";
                        LOG.error(msg, e1);
                        throw new MetaException(msg + e1.getMessage());
                    }
                }
            }
        }

        public long getSleepInterval() {
            return this.sleepInterval;
        }

        static interface Command {
            public void process() throws Exception;
        }
    }

    public class UpdateSerdeURIRetVal {
        private List<String> badRecords;
        private Map<String, String> updateLocations;

        UpdateSerdeURIRetVal(List<String> badRecords, Map<String, String> updateLocations) {
            this.badRecords = badRecords;
            this.updateLocations = updateLocations;
        }

        public List<String> getBadRecords() {
            return this.badRecords;
        }

        public void setBadRecords(List<String> badRecords) {
            this.badRecords = badRecords;
        }

        public Map<String, String> getUpdateLocations() {
            return this.updateLocations;
        }

        public void setUpdateLocations(Map<String, String> updateLocations) {
            this.updateLocations = updateLocations;
        }
    }

    public class UpdateMStorageDescriptorTblURIRetVal {
        private List<String> badRecords;
        private Map<String, String> updateLocations;
        private int numNullRecords;

        UpdateMStorageDescriptorTblURIRetVal(List<String> badRecords, Map<String, String> updateLocations, int numNullRecords) {
            this.badRecords = badRecords;
            this.updateLocations = updateLocations;
            this.numNullRecords = numNullRecords;
        }

        public List<String> getBadRecords() {
            return this.badRecords;
        }

        public void setBadRecords(List<String> badRecords) {
            this.badRecords = badRecords;
        }

        public Map<String, String> getUpdateLocations() {
            return this.updateLocations;
        }

        public void setUpdateLocations(Map<String, String> updateLocations) {
            this.updateLocations = updateLocations;
        }

        public int getNumNullRecords() {
            return this.numNullRecords;
        }

        public void setNumNullRecords(int numNullRecords) {
            this.numNullRecords = numNullRecords;
        }
    }

    public class UpdatePropURIRetVal {
        private List<String> badRecords;
        private Map<String, String> updateLocations;

        UpdatePropURIRetVal(List<String> badRecords, Map<String, String> updateLocations) {
            this.badRecords = badRecords;
            this.updateLocations = updateLocations;
        }

        public List<String> getBadRecords() {
            return this.badRecords;
        }

        public void setBadRecords(List<String> badRecords) {
            this.badRecords = badRecords;
        }

        public Map<String, String> getUpdateLocations() {
            return this.updateLocations;
        }

        public void setUpdateLocations(Map<String, String> updateLocations) {
            this.updateLocations = updateLocations;
        }
    }

    public class UpdateMDatabaseURIRetVal {
        private List<String> badRecords;
        private Map<String, String> updateLocations;

        UpdateMDatabaseURIRetVal(List<String> badRecords, Map<String, String> updateLocations) {
            this.badRecords = badRecords;
            this.updateLocations = updateLocations;
        }

        public List<String> getBadRecords() {
            return this.badRecords;
        }

        public void setBadRecords(List<String> badRecords) {
            this.badRecords = badRecords;
        }

        public Map<String, String> getUpdateLocations() {
            return this.updateLocations;
        }

        public void setUpdateLocations(Map<String, String> updateLocations) {
            this.updateLocations = updateLocations;
        }
    }

    class PrivilegeWithoutCreateTimeComparator
    implements Comparator<HiveObjectPrivilege> {
        PrivilegeWithoutCreateTimeComparator() {
        }

        @Override
        public int compare(HiveObjectPrivilege o1, HiveObjectPrivilege o2) {
            int createTime1 = o1.getGrantInfo().getCreateTime();
            int createTime2 = o2.getGrantInfo().getCreateTime();
            o1.getGrantInfo().setCreateTime(0);
            o2.getGrantInfo().setCreateTime(0);
            int result = o1.compareTo(o2);
            o1.getGrantInfo().setCreateTime(createTime1);
            o2.getGrantInfo().setCreateTime(createTime2);
            return result;
        }
    }

    private abstract class GetStatHelper
    extends GetHelper<ColumnStatistics> {
        public GetStatHelper(String catalogName, String dbName, String tblName, boolean allowSql, boolean allowJdo) throws MetaException {
            super(catalogName, dbName, tblName, allowSql, allowJdo);
        }

        @Override
        protected String describeResult() {
            return "statistics for " + (this.results == null ? 0 : ((ColumnStatistics)this.results).getStatsObjSize()) + " columns";
        }
    }

    @.VisibleForTesting
    public abstract class GetDbHelper
    extends GetHelper<Database> {
        public GetDbHelper(String catalogName, String dbName, boolean allowSql, boolean allowJdo) throws MetaException {
            super(catalogName, dbName, null, allowSql, allowJdo);
        }

        @Override
        protected String describeResult() {
            return "db details for db ".concat(this.dbName);
        }
    }

    private abstract class GetListHelper<T>
    extends GetHelper<List<T>> {
        public GetListHelper(String catName, String dbName, String tblName, boolean allowSql, boolean allowJdo) throws MetaException {
            super(catName, dbName, tblName, allowSql, allowJdo);
        }

        @Override
        protected String describeResult() {
            return ((List)this.results).size() + " entries";
        }
    }

    @.VisibleForTesting
    public abstract class GetHelper<T> {
        private final boolean isInTxn;
        private final boolean doTrace;
        private final boolean allowJdo;
        private boolean doUseDirectSql;
        private long start;
        private Table table;
        protected final String catName;
        protected final String dbName;
        protected final String tblName;
        private boolean success = false;
        protected T results = null;

        public GetHelper(String catalogName, String dbName, String tblName, boolean allowSql, boolean allowJdo) throws MetaException {
            boolean isConfigEnabled;
            assert (allowSql || allowJdo);
            this.allowJdo = allowJdo;
            this.catName = catalogName != null ? StringUtils.normalizeIdentifier(catalogName) : null;
            String string = this.dbName = dbName != null ? StringUtils.normalizeIdentifier(dbName) : null;
            if (tblName != null) {
                this.tblName = StringUtils.normalizeIdentifier(tblName);
            } else {
                this.tblName = null;
                this.table = null;
            }
            this.doTrace = LOG.isDebugEnabled();
            this.isInTxn = ObjectStore.this.isActiveTransaction();
            boolean bl = isConfigEnabled = MetastoreConf.getBoolVar(ObjectStore.this.getConf(), MetastoreConf.ConfVars.TRY_DIRECT_SQL) && (MetastoreConf.getBoolVar(ObjectStore.this.getConf(), MetastoreConf.ConfVars.TRY_DIRECT_SQL_DDL) || !this.isInTxn);
            if (isConfigEnabled && ObjectStore.this.directSql == null) {
                ObjectStore.this.dbType = ObjectStore.this.determineDatabaseProduct();
                ObjectStore.this.directSql = new MetaStoreDirectSql(ObjectStore.this.pm, ObjectStore.this.getConf(), "");
            }
            if (!allowJdo && isConfigEnabled && !ObjectStore.this.directSql.isCompatibleDatastore()) {
                throw new MetaException("SQL is not operational");
            }
            this.doUseDirectSql = allowSql && isConfigEnabled && ObjectStore.this.directSql.isCompatibleDatastore();
        }

        protected boolean canUseDirectSql(GetHelper<T> ctx) throws MetaException {
            return true;
        }

        protected abstract String describeResult();

        protected abstract T getSqlResult(GetHelper<T> var1) throws MetaException;

        protected abstract T getJdoResult(GetHelper<T> var1) throws MetaException, NoSuchObjectException;

        public T run(boolean initTable) throws MetaException, NoSuchObjectException {
            try {
                this.start(initTable);
                if (this.doUseDirectSql) {
                    try {
                        ObjectStore.this.directSql.prepareTxn();
                        this.results = this.getSqlResult(this);
                    }
                    catch (Exception ex) {
                        this.handleDirectSqlError(ex);
                    }
                }
                if (!this.doUseDirectSql) {
                    this.results = this.getJdoResult(this);
                }
                T ex = this.commit();
                return ex;
            }
            catch (NoSuchObjectException ex) {
                throw ex;
            }
            catch (MetaException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOG.error("", ex);
                throw new MetaException(ex.getMessage());
            }
            finally {
                this.close();
            }
        }

        private void start(boolean initTable) throws MetaException, NoSuchObjectException {
            this.start = this.doTrace ? System.nanoTime() : 0L;
            ObjectStore.this.openTransaction();
            if (initTable && this.tblName != null) {
                this.table = ObjectStore.this.ensureGetTable(this.catName, this.dbName, this.tblName);
            }
            this.doUseDirectSql = this.doUseDirectSql && this.canUseDirectSql(this);
        }

        private void handleDirectSqlError(Exception ex) throws MetaException, NoSuchObjectException {
            String message = null;
            try {
                message = this.generateShorterMessage(ex);
            }
            catch (Throwable t) {
                message = ex.toString() + "; error building a better message: " + t.getMessage();
            }
            LOG.warn(message);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Full DirectSQL callstack for debugging (note: this is not an error)", ex);
            }
            if (!this.allowJdo) {
                if (ex instanceof MetaException) {
                    throw (MetaException)((Object)ex);
                }
                throw new MetaException(ex.getMessage());
            }
            if (!this.isInTxn) {
                JDOException rollbackEx = null;
                try {
                    ObjectStore.this.rollbackTransaction();
                }
                catch (JDOException jex) {
                    rollbackEx = jex;
                }
                if (rollbackEx != null) {
                    if (ObjectStore.this.currentTransaction != null && ObjectStore.this.currentTransaction.isActive()) {
                        throw rollbackEx;
                    }
                    LOG.info("Ignoring exception, rollback succeeded: " + rollbackEx.getMessage());
                }
                this.start = this.doTrace ? System.nanoTime() : 0L;
                ObjectStore.this.openTransaction();
                if (this.table != null) {
                    this.table = ObjectStore.this.ensureGetTable(this.catName, this.dbName, this.tblName);
                }
            } else {
                long l = this.start = this.doTrace ? System.nanoTime() : 0L;
            }
            if (ObjectStore.this.directSqlErrors != null) {
                ObjectStore.this.directSqlErrors.inc();
            }
            this.doUseDirectSql = false;
        }

        private String generateShorterMessage(Exception ex) {
            StringBuilder message = new StringBuilder("Falling back to ORM path due to direct SQL failure (this is not an error): ");
            Throwable t = ex;
            StackTraceElement[] prevStack = null;
            while (t != null) {
                message.append(t.getMessage());
                StackTraceElement[] stack = t.getStackTrace();
                int uniqueFrames = stack.length - 1;
                if (prevStack != null) {
                    for (int n = prevStack.length - 1; uniqueFrames >= 0 && n >= 0 && stack[uniqueFrames].equals(prevStack[n]); --uniqueFrames, --n) {
                    }
                }
                for (int i = 0; i <= uniqueFrames; ++i) {
                    StackTraceElement ste = stack[i];
                    message.append(" at ").append(ste);
                    if (ste.getMethodName() != null && ste.getMethodName().contains("getSqlResult") && (ste.getFileName() == null || ste.getFileName().contains("ObjectStore"))) break;
                }
                prevStack = stack;
                if ((t = t.getCause()) == null) continue;
                message.append(";\n Caused by: ");
            }
            return message.toString();
        }

        private T commit() {
            this.success = ObjectStore.this.commitTransaction();
            if (this.doTrace) {
                double time = (double)(System.nanoTime() - this.start) / 1000000.0;
                String result = this.describeResult();
                String retrieveType = this.doUseDirectSql ? "SQL" : "ORM";
                LOG.debug("{} retrieved using {} in {}ms", result, retrieveType, time);
            }
            return this.results;
        }

        private void close() {
            if (!this.success) {
                ObjectStore.this.rollbackTransaction();
            }
        }

        public Table getTable() {
            return this.table;
        }
    }

    class AttachedMTableInfo {
        MTable mtbl;
        MColumnDescriptor mcd;

        public AttachedMTableInfo() {
        }

        public AttachedMTableInfo(MTable mtbl, MColumnDescriptor mcd) {
            this.mtbl = mtbl;
            this.mcd = mcd;
        }
    }

    public static class QueryWrapper
    implements AutoCloseable {
        public Query query;

        @Override
        public void close() {
            if (this.query != null) {
                this.query.closeAll();
                this.query = null;
            }
        }
    }

    private static enum TXN_STATUS {
        NO_STATE,
        OPEN,
        COMMITED,
        ROLLBACK;

    }
}

