/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import io.prestosql.hive.;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.messaging.AddNotNullConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.thrift.TException;

public class JSONAddNotNullConstraintMessage
extends AddNotNullConstraintMessage {
    @.JsonProperty
    String server;
    @.JsonProperty
    String servicePrincipal;
    @.JsonProperty
    Long timestamp;
    @.JsonProperty
    List<String> notNullConstraintListJson;

    public JSONAddNotNullConstraintMessage() {
    }

    public JSONAddNotNullConstraintMessage(String server, String servicePrincipal, List<SQLNotNullConstraint> nns, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.timestamp = timestamp;
        this.notNullConstraintListJson = new ArrayList<String>();
        try {
            for (SQLNotNullConstraint nn : nns) {
                this.notNullConstraintListJson.add(JSONMessageFactory.createNotNullConstraintObjJson(nn));
            }
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return null;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public List<SQLNotNullConstraint> getNotNullConstraints() throws Exception {
        ArrayList<SQLNotNullConstraint> nns = new ArrayList<SQLNotNullConstraint>();
        for (String nnJson : this.notNullConstraintListJson) {
            nns.add((SQLNotNullConstraint)JSONMessageFactory.getTObj(nnJson, SQLNotNullConstraint.class));
        }
        return nns;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString(this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

