/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.security;

import io.prestosql.hive.$internal.org.apache.commons.codec.binary.Base64;
import io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.security.DelegationTokenIdentifier;
import org.apache.hadoop.hive.metastore.security.DelegationTokenStore;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.security.TokenStoreDelegationTokenSecretManager;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.MetastoreDelegationTokenSupport;

public class DBTokenStore
implements DelegationTokenStore {
    private static final Logger LOG = LoggerFactory.getLogger(DBTokenStore.class);
    private Configuration conf;
    private Object handler;
    private HadoopThriftAuthBridge.Server.ServerMode serverMode;

    @Override
    public int addMasterKey(String s) throws DelegationTokenStore.TokenStoreException {
        LOG.trace("addMasterKey: s = {}", (Object)s);
        return (Integer)this.invokeOnTokenStore("addMasterKey", new Object[]{s}, String.class);
    }

    @Override
    public void updateMasterKey(int keySeq, String s) throws DelegationTokenStore.TokenStoreException {
        LOG.trace("updateMasterKey: s = {}, keySeq = {}", (Object)s, (Object)keySeq);
        this.invokeOnTokenStore("updateMasterKey", new Object[]{keySeq, s}, Integer.class, String.class);
    }

    @Override
    public boolean removeMasterKey(int keySeq) {
        return (Boolean)this.invokeOnTokenStore("removeMasterKey", new Object[]{keySeq}, Integer.class);
    }

    @Override
    public String[] getMasterKeys() throws DelegationTokenStore.TokenStoreException {
        return (String[])this.invokeOnTokenStore("getMasterKeys", new Object[0], new Class[0]);
    }

    @Override
    public boolean addToken(DelegationTokenIdentifier tokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation token) throws DelegationTokenStore.TokenStoreException {
        try {
            String identifier = TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)tokenIdentifier);
            String tokenStr = Base64.encodeBase64URLSafeString(MetastoreDelegationTokenSupport.encodeDelegationTokenInformation(token));
            boolean result = (Boolean)this.invokeOnTokenStore("addToken", new Object[]{identifier, tokenStr}, String.class, String.class);
            LOG.trace("addToken: tokenIdentifier = {}, added = {}", (Object)tokenIdentifier, (Object)result);
            return result;
        }
        catch (IOException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
    }

    @Override
    public AbstractDelegationTokenSecretManager.DelegationTokenInformation getToken(DelegationTokenIdentifier tokenIdentifier) throws DelegationTokenStore.TokenStoreException {
        try {
            String tokenStr = (String)this.invokeOnTokenStore("getToken", new Object[]{TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)tokenIdentifier)}, String.class);
            AbstractDelegationTokenSecretManager.DelegationTokenInformation result = null;
            if (StringUtils.isNotEmpty(tokenStr)) {
                result = MetastoreDelegationTokenSupport.decodeDelegationTokenInformation(Base64.decodeBase64(tokenStr));
            }
            LOG.trace("getToken: tokenIdentifier = {}, result = {}", (Object)tokenIdentifier, (Object)result);
            return result;
        }
        catch (IOException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
    }

    @Override
    public boolean removeToken(DelegationTokenIdentifier tokenIdentifier) throws DelegationTokenStore.TokenStoreException {
        try {
            boolean result = (Boolean)this.invokeOnTokenStore("removeToken", new Object[]{TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)tokenIdentifier)}, String.class);
            LOG.trace("removeToken: tokenIdentifier = {}, removed = {}", (Object)tokenIdentifier, (Object)result);
            return result;
        }
        catch (IOException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
    }

    @Override
    public List<DelegationTokenIdentifier> getAllDelegationTokenIdentifiers() throws DelegationTokenStore.TokenStoreException {
        List tokenIdents = (List)this.invokeOnTokenStore("getAllTokenIdentifiers", new Object[0], new Class[0]);
        ArrayList<DelegationTokenIdentifier> delTokenIdents = new ArrayList<DelegationTokenIdentifier>(tokenIdents.size());
        for (String tokenIdent : tokenIdents) {
            DelegationTokenIdentifier delToken = new DelegationTokenIdentifier();
            try {
                TokenStoreDelegationTokenSecretManager.decodeWritable((Writable)delToken, tokenIdent);
            }
            catch (IOException e) {
                throw new DelegationTokenStore.TokenStoreException(e);
            }
            delTokenIdents.add(delToken);
        }
        return delTokenIdents;
    }

    @Override
    public void init(Object handler, HadoopThriftAuthBridge.Server.ServerMode serverMode) throws DelegationTokenStore.TokenStoreException {
        this.handler = handler;
        this.serverMode = serverMode;
    }

    private Object invokeOnTokenStore(String methName, Object[] params, Class<?> ... paramTypes) throws DelegationTokenStore.TokenStoreException {
        try {
            Object tokenStore;
            switch (this.serverMode) {
                case METASTORE: {
                    tokenStore = this.handler.getClass().getMethod("getMS", new Class[0]).invoke(this.handler, new Object[0]);
                    break;
                }
                case HIVESERVER2: {
                    Object hiveObject = ((Class)this.handler).getMethod("get", new Class[0]).invoke(this.handler, null);
                    tokenStore = ((Class)this.handler).getMethod("getMSC", new Class[0]).invoke(hiveObject, new Object[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value of Server mode " + (Object)((Object)this.serverMode));
                }
            }
            return tokenStore.getClass().getMethod(methName, paramTypes).invoke(tokenStore, params);
        }
        catch (IllegalArgumentException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
        catch (SecurityException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
        catch (IllegalAccessException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
        catch (InvocationTargetException e) {
            throw new DelegationTokenStore.TokenStoreException(e.getCause());
        }
        catch (NoSuchMethodException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void close() throws IOException {
    }
}

