/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import io.prestosql.hive.$internal.com.google.common.collect.HashMultimap;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.CreateFunctionDesc;
import org.apache.hadoop.hive.ql.plan.CreateMacroDesc;
import org.apache.hadoop.hive.ql.plan.DropFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DropMacroDesc;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.util.ResourceDownloader;
import org.apache.hadoop.util.StringUtils;

public class FunctionTask
extends Task<FunctionWork> {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(FunctionTask.class);

    @Override
    public void initialize(QueryState queryState, QueryPlan queryPlan, DriverContext ctx, CompilationOpContext opContext) {
        super.initialize(queryState, queryPlan, ctx, opContext);
    }

    @Override
    public int execute(DriverContext driverContext) {
        CreateMacroDesc createMacroDesc;
        CreateFunctionDesc createFunctionDesc = ((FunctionWork)this.work).getCreateFunctionDesc();
        if (createFunctionDesc != null) {
            if (createFunctionDesc.isTemp()) {
                return this.createTemporaryFunction(createFunctionDesc);
            }
            try {
                if (createFunctionDesc.getReplicationSpec().isInReplicationScope()) {
                    String[] qualifiedNameParts = FunctionUtils.getQualifiedFunctionNameParts(createFunctionDesc.getFunctionName());
                    String dbName = qualifiedNameParts[0];
                    String funcName = qualifiedNameParts[1];
                    Map<String, String> dbProps = Hive.get().getDatabase(dbName).getParameters();
                    if (!createFunctionDesc.getReplicationSpec().allowEventReplacementInto(dbProps)) {
                        LOG.debug("FunctionTask: Create Function {} is skipped as database {} is newer than update", (Object)funcName, (Object)dbName);
                        return 0;
                    }
                }
                return this.createPermanentFunction(Hive.get(this.conf), createFunctionDesc);
            }
            catch (Exception e) {
                this.setException(e);
                LOG.error("Failed to create function", e);
                return 1;
            }
        }
        DropFunctionDesc dropFunctionDesc = ((FunctionWork)this.work).getDropFunctionDesc();
        if (dropFunctionDesc != null) {
            if (dropFunctionDesc.isTemp()) {
                return this.dropTemporaryFunction(dropFunctionDesc);
            }
            try {
                if (dropFunctionDesc.getReplicationSpec().isInReplicationScope()) {
                    String[] qualifiedNameParts = FunctionUtils.getQualifiedFunctionNameParts(dropFunctionDesc.getFunctionName());
                    String dbName = qualifiedNameParts[0];
                    String funcName = qualifiedNameParts[1];
                    Map<String, String> dbProps = Hive.get().getDatabase(dbName).getParameters();
                    if (!dropFunctionDesc.getReplicationSpec().allowEventReplacementInto(dbProps)) {
                        LOG.debug("FunctionTask: Drop Function {} is skipped as database {} is newer than update", (Object)funcName, (Object)dbName);
                        return 0;
                    }
                }
                return this.dropPermanentFunction(Hive.get(this.conf), dropFunctionDesc);
            }
            catch (Exception e) {
                this.setException(e);
                LOG.error("Failed to drop function", e);
                return 1;
            }
        }
        if (((FunctionWork)this.work).getReloadFunctionDesc() != null) {
            try {
                Hive.get().reloadFunctions();
            }
            catch (Exception e) {
                this.setException(e);
                LOG.error("Failed to reload functions", e);
                return 1;
            }
        }
        if ((createMacroDesc = ((FunctionWork)this.work).getCreateMacroDesc()) != null) {
            return this.createMacro(createMacroDesc);
        }
        DropMacroDesc dropMacroDesc = ((FunctionWork)this.work).getDropMacroDesc();
        if (dropMacroDesc != null) {
            return this.dropMacro(dropMacroDesc);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createPermanentFunction(Hive db, CreateFunctionDesc createFunctionDesc) throws HiveException, IOException {
        String[] qualifiedNameParts = FunctionUtils.getQualifiedFunctionNameParts(createFunctionDesc.getFunctionName());
        String dbName = qualifiedNameParts[0];
        String funcName = qualifiedNameParts[1];
        String registeredName = FunctionUtils.qualifyFunctionName(funcName, dbName);
        String className = createFunctionDesc.getClassName();
        List<ResourceUri> resources = createFunctionDesc.getResources();
        this.checkLocalFunctionResources(db, createFunctionDesc.getResources());
        FunctionInfo registered = null;
        HiveConf oldConf = SessionState.get().getConf();
        try {
            SessionState.get().setConf(this.conf);
            registered = FunctionRegistry.registerPermanentFunction(registeredName, className, true, FunctionTask.toFunctionResource(resources));
        }
        catch (RuntimeException ex) {
            Throwable t = ex;
            while (t.getCause() != null) {
                t = t.getCause();
            }
        }
        finally {
            SessionState.get().setConf(oldConf);
        }
        if (registered == null) {
            this.console.printError("Failed to register " + registeredName + " using class " + createFunctionDesc.getClassName());
            return 1;
        }
        Function func = new Function(funcName, dbName, className, SessionState.get().getUserName(), PrincipalType.USER, (int)(System.currentTimeMillis() / 1000L), FunctionType.JAVA, resources);
        db.createFunction(func);
        return 0;
    }

    private int createTemporaryFunction(CreateFunctionDesc createFunctionDesc) {
        try {
            FunctionInfo.FunctionResource[] resources = FunctionTask.toFunctionResource(createFunctionDesc.getResources());
            FunctionTask.addFunctionResources(resources);
            Class<?> udfClass = this.getUdfClass(createFunctionDesc);
            FunctionInfo registered = FunctionRegistry.registerTemporaryUDF(createFunctionDesc.getFunctionName(), udfClass, resources);
            if (registered != null) {
                return 0;
            }
            this.console.printError("FAILED: Class " + createFunctionDesc.getClassName() + " does not implement UDF, GenericUDF, or UDAF");
            return 1;
        }
        catch (HiveException e) {
            this.console.printError("FAILED: " + e.toString());
            LOG.info("create function: ", e);
            return 1;
        }
        catch (ClassNotFoundException e) {
            this.console.printError("FAILED: Class " + createFunctionDesc.getClassName() + " not found");
            LOG.info("create function: ", e);
            return 1;
        }
    }

    private int createMacro(CreateMacroDesc createMacroDesc) {
        FunctionRegistry.registerTemporaryMacro(createMacroDesc.getMacroName(), createMacroDesc.getBody(), createMacroDesc.getColNames(), createMacroDesc.getColTypes());
        return 0;
    }

    private int dropMacro(DropMacroDesc dropMacroDesc) {
        try {
            FunctionRegistry.unregisterTemporaryUDF(dropMacroDesc.getMacroName());
            return 0;
        }
        catch (HiveException e) {
            LOG.info("drop macro: ", e);
            return 1;
        }
    }

    private int dropPermanentFunction(Hive db, DropFunctionDesc dropFunctionDesc) {
        try {
            String[] qualifiedNameParts = FunctionUtils.getQualifiedFunctionNameParts(dropFunctionDesc.getFunctionName());
            String dbName = qualifiedNameParts[0];
            String funcName = qualifiedNameParts[1];
            String registeredName = FunctionUtils.qualifyFunctionName(funcName, dbName);
            FunctionRegistry.unregisterPermanentFunction(registeredName);
            db.dropFunction(dbName, funcName);
            return 0;
        }
        catch (Exception e) {
            LOG.info("drop function: ", e);
            this.console.printError("FAILED: error during drop function: " + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
    }

    private int dropTemporaryFunction(DropFunctionDesc dropFunctionDesc) {
        try {
            FunctionRegistry.unregisterTemporaryUDF(dropFunctionDesc.getFunctionName());
            return 0;
        }
        catch (HiveException e) {
            LOG.info("drop function: ", e);
            return 1;
        }
    }

    private void checkLocalFunctionResources(Hive db, List<ResourceUri> resources) throws HiveException {
        if (resources != null && resources.size() > 0) {
            try {
                String localFsScheme = FileSystem.getLocal((Configuration)db.getConf()).getUri().getScheme();
                String configuredFsScheme = FileSystem.get((Configuration)db.getConf()).getUri().getScheme();
                if (configuredFsScheme.equals(localFsScheme)) {
                    return;
                }
                for (ResourceUri res : resources) {
                    String resUri = res.getUri();
                    if (!ResourceDownloader.isFileUri(resUri)) continue;
                    throw new HiveException("Hive warehouse is non-local, but " + res.getUri() + " specifies file on local filesystem. Resources on non-local warehouse should specify a non-local scheme/path");
                }
            }
            catch (HiveException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Exception caught in checkLocalFunctionResources", e);
                throw new HiveException(e);
            }
        }
    }

    public static FunctionInfo.FunctionResource[] toFunctionResource(List<ResourceUri> resources) throws HiveException {
        if (resources == null) {
            return null;
        }
        FunctionInfo.FunctionResource[] converted = new FunctionInfo.FunctionResource[resources.size()];
        for (int i = 0; i < converted.length; ++i) {
            ResourceUri resource = resources.get(i);
            SessionState.ResourceType type = FunctionTask.getResourceType(resource.getResourceType());
            converted[i] = new FunctionInfo.FunctionResource(type, resource.getUri());
        }
        return converted;
    }

    public static SessionState.ResourceType getResourceType(ResourceType rt) {
        switch (rt) {
            case JAR: {
                return SessionState.ResourceType.JAR;
            }
            case FILE: {
                return SessionState.ResourceType.FILE;
            }
            case ARCHIVE: {
                return SessionState.ResourceType.ARCHIVE;
            }
        }
        throw new AssertionError((Object)("Unexpected resource type " + (Object)((Object)rt)));
    }

    public static void addFunctionResources(FunctionInfo.FunctionResource[] resources) throws HiveException {
        if (resources != null) {
            HashMultimap<SessionState.ResourceType, String> mappings = HashMultimap.create();
            for (FunctionInfo.FunctionResource res : resources) {
                mappings.put(res.getResourceType(), res.getResourceURI());
            }
            for (SessionState.ResourceType type : mappings.keys()) {
                SessionState.get().add_resources(type, mappings.get(type));
            }
        }
    }

    private Class<?> getUdfClass(CreateFunctionDesc desc) throws ClassNotFoundException {
        ClassLoader classLoader = Utilities.getSessionSpecifiedClassLoader();
        return Class.forName(desc.getClassName(), true, classLoader);
    }

    @Override
    public StageType getType() {
        return StageType.FUNC;
    }

    @Override
    public String getName() {
        return "FUNCTION";
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }
}

