/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import io.prestosql.hive.$internal.com.google.common.primitives.Ints;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.Serializable;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Replication Dump Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ReplDumpWork
implements Serializable {
    final String dbNameOrPattern;
    final String tableNameOrPattern;
    final String astRepresentationForErrorMsg;
    final String resultTempPath;
    final Long eventFrom;
    Long eventTo;
    private Integer maxEventLimit;
    static String testInjectDumpDir = null;

    public static void injectNextDumpDirForTest(String dumpDir) {
        testInjectDumpDir = dumpDir;
    }

    public ReplDumpWork(String dbNameOrPattern, String tableNameOrPattern, Long eventFrom, Long eventTo, String astRepresentationForErrorMsg, Integer maxEventLimit, String resultTempPath) {
        this.dbNameOrPattern = dbNameOrPattern;
        this.tableNameOrPattern = tableNameOrPattern;
        this.eventFrom = eventFrom;
        this.eventTo = eventTo;
        this.astRepresentationForErrorMsg = astRepresentationForErrorMsg;
        this.maxEventLimit = maxEventLimit;
        this.resultTempPath = resultTempPath;
    }

    boolean isBootStrapDump() {
        return this.eventFrom == null;
    }

    int maxEventLimit() throws Exception {
        if (this.eventTo < this.eventFrom) {
            throw new Exception("Invalid event ID input received in TO clause");
        }
        Integer maxRange = Ints.checkedCast(this.eventTo - this.eventFrom + 1L);
        if (this.maxEventLimit == null || this.maxEventLimit > maxRange) {
            this.maxEventLimit = maxRange;
        }
        return this.maxEventLimit;
    }

    void overrideEventTo(Hive fromDb) throws Exception {
        if (this.eventTo == null) {
            this.eventTo = fromDb.getMSC().getCurrentNotificationEventId().getEventId();
            LoggerFactory.getLogger(this.getClass()).debug("eventTo not specified, using current event id : {}", (Object)this.eventTo);
        }
    }
}

