/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import io.prestosql.hive.$internal.com.google.common.base.Preconditions;
import io.prestosql.hive.$internal.com.google.common.collect.Lists;
import io.prestosql.hive.$internal.com.google.common.collect.Multimap;
import io.prestosql.hive.$internal.com.google.protobuf.ByteString;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.DynamicPartitionPruner;
import org.apache.hadoop.hive.ql.exec.tez.HiveInputCounters;
import org.apache.hadoop.hive.ql.exec.tez.SplitGrouper;
import org.apache.hadoop.hive.ql.exec.tez.Utils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputInitializer;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputInitializerEvent;

public class HiveSplitGenerator
extends InputInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSplitGenerator.class);
    private final DynamicPartitionPruner pruner;
    private final Configuration conf;
    private final JobConf jobConf;
    private final MRRuntimeProtos.MRInputUserPayloadProto userPayloadProto;
    private final MapWork work;
    private final SplitGrouper splitGrouper = new SplitGrouper();
    private final SplitLocationProvider splitLocationProvider;
    private boolean generateSingleSplit;

    public HiveSplitGenerator(Configuration conf, MapWork work, boolean generateSingleSplit) throws IOException {
        super(null);
        this.conf = conf;
        this.work = work;
        this.jobConf = new JobConf(conf);
        this.generateSingleSplit = generateSingleSplit;
        this.userPayloadProto = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder().setGroupingEnabled(true).build();
        this.splitLocationProvider = Utils.getSplitLocationProvider(conf, work.getCacheAffinity(), LOG);
        LOG.info("SplitLocationProvider: " + this.splitLocationProvider);
        ShimLoader.getHadoopShims().getMergedCredentials(this.jobConf);
        this.pruner = null;
    }

    public HiveSplitGenerator(InputInitializerContext initializerContext) throws IOException, SerDeException {
        super(initializerContext);
        Preconditions.checkNotNull(initializerContext);
        this.userPayloadProto = MRInputHelpers.parseMRInputPayload((UserPayload)initializerContext.getInputUserPayload());
        this.conf = TezUtils.createConfFromByteString((ByteString)this.userPayloadProto.getConfigurationBytes());
        this.jobConf = new JobConf(this.conf);
        ShimLoader.getHadoopShims().getMergedCredentials(this.jobConf);
        this.work = Utilities.getMapWork((Configuration)this.jobConf);
        this.splitLocationProvider = Utils.getSplitLocationProvider(this.conf, this.work.getCacheAffinity(), LOG);
        LOG.info("SplitLocationProvider: " + this.splitLocationProvider);
        this.pruner = new DynamicPartitionPruner(initializerContext, this.work, this.jobConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Event> initialize() throws Exception {
        Utilities.setMapWork((Configuration)this.jobConf, this.work);
        try {
            InputSplit[] flatSplits;
            boolean sendSerializedEvents = this.conf.getBoolean("mapreduce.tez.input.initializer.serialize.event.payload", true);
            if (this.pruner != null) {
                this.pruner.prune();
            }
            InputSplitInfoMem inputSplitInfo = null;
            boolean generateConsistentSplits = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_TEZ_GENERATE_CONSISTENT_SPLITS);
            LOG.info("GenerateConsistentSplitsInHive=" + generateConsistentSplits);
            String realInputFormatName = this.conf.get("mapred.input.format.class");
            boolean groupingEnabled = this.userPayloadProto.getGroupingEnabled();
            if (groupingEnabled) {
                String counterName;
                InputSplit[] splits;
                InputFormat inputFormat = (InputFormat)ReflectionUtils.newInstance((Class)JavaUtils.loadClass(realInputFormatName), (Configuration)this.jobConf);
                int totalResource = 0;
                int taskResource = 0;
                int availableSlots = 0;
                if (this.getContext() == null) {
                    availableSlots = 1;
                }
                if (this.getContext() != null) {
                    totalResource = this.getContext().getTotalAvailableResource().getMemory();
                    taskResource = this.getContext().getVertexTaskResource().getMemory();
                    availableSlots = totalResource / taskResource;
                }
                if (HiveConf.getLongVar(this.conf, HiveConf.ConfVars.MAPREDMINSPLITSIZE, 1L) <= 1L) {
                    long blockSize = this.conf.getLong("dfs.blocksize", 0x8000000L);
                    long minGrouping = this.conf.getLong("tez.grouping.min-size", 0x3200000L);
                    long preferredSplitSize = Math.min(blockSize / 2L, minGrouping);
                    HiveConf.setLongVar((Configuration)this.jobConf, HiveConf.ConfVars.MAPREDMINSPLITSIZE, preferredSplitSize);
                    LOG.info("The preferred split size is " + preferredSplitSize);
                }
                float waves = this.conf.getFloat("tez.grouping.split-waves", 1.7f);
                if (this.generateSingleSplit && this.conf.get(HiveConf.ConfVars.HIVETEZINPUTFORMAT.varname).equals(HiveInputFormat.class.getName())) {
                    MapWork mapWork = Utilities.getMapWork((Configuration)this.jobConf);
                    List<Path> paths = Utilities.getInputPathsTez(this.jobConf, mapWork);
                    FileSystem fs = paths.get(0).getFileSystem((Configuration)this.jobConf);
                    FileStatus[] fileStatuses = fs.listStatus(paths.get(0));
                    if (fileStatuses.length == 0) {
                        splits = new InputSplit[]{};
                    } else {
                        Preconditions.checkState(paths.size() == 1 && fileStatuses.length == 1 && mapWork.getAliasToPartnInfo().size() == 1, "Requested to generate single split. Paths and fileStatuses are expected to be 1. Got paths: " + paths.size() + " fileStatuses: " + fileStatuses.length);
                        splits = new InputSplit[1];
                        FileStatus fileStatus = fileStatuses[0];
                        BlockLocation[] locations = fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
                        HashSet<String> hostsSet = new HashSet<String>();
                        for (BlockLocation blockLocation : locations) {
                            hostsSet.addAll(Lists.newArrayList(blockLocation.getHosts()));
                        }
                        String[] hosts = hostsSet.toArray(new String[0]);
                        FileSplit fileSplit = new FileSplit(fileStatus.getPath(), 0L, fileStatus.getLen(), hosts);
                        String alias = mapWork.getAliases().get(0);
                        PartitionDesc partitionDesc = mapWork.getAliasToPartnInfo().get(alias);
                        String partIF = partitionDesc.getInputFileFormatClassName();
                        splits[0] = new HiveInputFormat.HiveInputSplit((InputSplit)fileSplit, partIF);
                    }
                } else {
                    splits = inputFormat.getSplits(this.jobConf, (int)((float)availableSlots * waves));
                }
                Arrays.sort(splits, new InputSplitComparator());
                LOG.info("Number of input splits: " + splits.length + ". " + availableSlots + " available slots, " + waves + " waves. Input format is: " + realInputFormatName);
                InputInitializerContext inputInitializerContext = this.getContext();
                TezCounters tezCounters = null;
                String groupName = null;
                String vertexName = null;
                if (inputInitializerContext != null) {
                    tezCounters = new TezCounters();
                    groupName = HiveInputCounters.class.getName();
                    vertexName = this.jobConf.get("__hive.context.name", "");
                    counterName = Utilities.getVertexCounterName(HiveInputCounters.RAW_INPUT_SPLITS.name(), vertexName);
                    tezCounters.findCounter(groupName, counterName).increment((long)splits.length);
                    List<Path> paths = Utilities.getInputPathsTez(this.jobConf, this.work);
                    counterName = Utilities.getVertexCounterName(HiveInputCounters.INPUT_DIRECTORIES.name(), vertexName);
                    tezCounters.findCounter(groupName, counterName).increment((long)paths.size());
                    HashSet<String> files = new HashSet<String>();
                    for (String string : splits) {
                        FileSplit fileSplit;
                        Path path;
                        String fileStr;
                        if (!(string instanceof FileSplit) || files.contains(fileStr = (path = (fileSplit = (FileSplit)string).getPath()).toString())) continue;
                        files.add(fileStr);
                    }
                    counterName = Utilities.getVertexCounterName(HiveInputCounters.INPUT_FILES.name(), vertexName);
                    tezCounters.findCounter(groupName, counterName).increment((long)files.size());
                }
                if (this.work.getIncludedBuckets() != null) {
                    splits = this.pruneBuckets(this.work, splits);
                }
                Multimap<Integer, InputSplit> groupedSplits = this.splitGrouper.generateGroupedSplits(this.jobConf, this.conf, splits, waves, availableSlots, this.splitLocationProvider);
                flatSplits = groupedSplits.values().toArray(new InputSplit[0]);
                LOG.info("Number of split groups: " + flatSplits.length);
                if (inputInitializerContext != null) {
                    counterName = Utilities.getVertexCounterName(HiveInputCounters.GROUPED_INPUT_SPLITS.name(), vertexName);
                    tezCounters.findCounter(groupName, counterName).setValue((long)flatSplits.length);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Published tez counters: " + tezCounters);
                    }
                    inputInitializerContext.addCounters(tezCounters);
                }
            } else {
                throw new RuntimeException("HiveInputFormat does not support non-grouped splits, InputFormatName is: " + realInputFormatName);
            }
            List<TaskLocationHint> locationHints = this.splitGrouper.createTaskLocationHints(flatSplits, generateConsistentSplits);
            inputSplitInfo = new InputSplitInfoMem(flatSplits, locationHints, flatSplits.length, null, (Configuration)this.jobConf);
            List<Event> list = this.createEventList(sendSerializedEvents, inputSplitInfo);
            return list;
        }
        finally {
            Utilities.clearWork((Configuration)this.jobConf);
        }
    }

    private InputSplit[] pruneBuckets(MapWork work, InputSplit[] splits) {
        BitSet buckets = work.getIncludedBuckets();
        String bucketIn = buckets.toString();
        ArrayList<InputSplit> filteredSplits = new ArrayList<InputSplit>(splits.length / 2);
        for (InputSplit split : splits) {
            int bucket = Utilities.parseSplitBucket(split);
            if (bucket < 0 || buckets.get(bucket)) {
                filteredSplits.add(split);
                continue;
            }
            LOG.info("Pruning with IN ({}) - removing {}", (Object)bucketIn, (Object)split);
        }
        if (filteredSplits.size() < splits.length) {
            splits = filteredSplits.toArray(new InputSplit[filteredSplits.size()]);
        }
        return splits;
    }

    private List<Event> createEventList(boolean sendSerializedEvents, InputSplitInfoMem inputSplitInfo) {
        ArrayList<Event> events = Lists.newArrayListWithCapacity(inputSplitInfo.getNumTasks() + 1);
        InputConfigureVertexTasksEvent configureVertexEvent = InputConfigureVertexTasksEvent.create((int)inputSplitInfo.getNumTasks(), (VertexLocationHint)VertexLocationHint.create((List)inputSplitInfo.getTaskLocationHints()), (InputSpecUpdate)InputSpecUpdate.getDefaultSinglePhysicalInputSpecUpdate());
        events.add((Event)configureVertexEvent);
        if (sendSerializedEvents) {
            MRRuntimeProtos.MRSplitsProto splitsProto = inputSplitInfo.getSplitsProto();
            int count = 0;
            for (MRRuntimeProtos.MRSplitProto mrSplit : splitsProto.getSplitsList()) {
                InputDataInformationEvent diEvent = InputDataInformationEvent.createWithSerializedPayload((int)count++, (ByteBuffer)mrSplit.toByteString().asReadOnlyByteBuffer());
                events.add((Event)diEvent);
            }
        } else {
            int count = 0;
            for (InputSplit split : inputSplitInfo.getOldFormatSplits()) {
                InputDataInformationEvent diEvent = InputDataInformationEvent.createWithObjectPayload((int)count++, (Object)split);
                events.add((Event)diEvent);
            }
        }
        return events;
    }

    public void onVertexStateUpdated(VertexStateUpdate stateUpdate) {
        this.pruner.processVertex(stateUpdate.getVertexName());
    }

    public void handleInputInitializerEvent(List<InputInitializerEvent> events) throws Exception {
        for (InputInitializerEvent e : events) {
            this.pruner.addEvent(e);
        }
    }

    static class InputSplitComparator
    implements Comparator<InputSplit> {
        InputSplitComparator() {
        }

        @Override
        public int compare(InputSplit o1, InputSplit o2) {
            try {
                long len1 = o1.getLength();
                long len2 = o2.getLength();
                if (len1 < len2) {
                    return 1;
                }
                if (len1 == len2) {
                    if (o1 instanceof FileSplit && o2 instanceof FileSplit) {
                        FileSplit fs1 = (FileSplit)o1;
                        FileSplit fs2 = (FileSplit)o2;
                        if (fs1.getPath() != null && fs2.getPath() != null) {
                            int pathComp = fs1.getPath().compareTo((Object)fs2.getPath());
                            if (pathComp == 0) {
                                long startPos2;
                                long startPos1 = fs1.getStart();
                                if (startPos1 > (startPos2 = fs2.getStart())) {
                                    return 1;
                                }
                                if (startPos1 < startPos2) {
                                    return -1;
                                }
                                return 0;
                            }
                            return pathComp;
                        }
                    }
                    return 0;
                }
                return -1;
            }
            catch (IOException e) {
                throw new RuntimeException("Problem getting input split size", e);
            }
        }
    }
}

