/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMap;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;

public class VectorMapJoinOuterLongOperator
extends VectorMapJoinOuterGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorMapJoinOuterLongOperator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(CLASS_NAME);
    private transient VectorMapJoinLongHashMap hashMap;
    private transient boolean useMinMax;
    private transient long min;
    private transient long max;
    private transient int singleJoinColumn;

    @Override
    protected String getLoggingPrefix() {
        return super.getLoggingPrefix(CLASS_NAME);
    }

    protected VectorMapJoinOuterLongOperator() {
    }

    public VectorMapJoinOuterLongOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinOuterLongOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.singleJoinColumn = this.bigTableKeyColumnMap[0];
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashMap = (VectorMapJoinLongHashMap)this.vectorMapJoinHashTable;
                this.useMinMax = this.hashMap.useMinMax();
                if (this.useMinMax) {
                    this.min = this.hashMap.min();
                    this.max = this.hashMap.max();
                }
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " empty");
                }
                return;
            }
            this.outerPerBatchSetup(batch);
            boolean inputSelectedInUse = batch.selectedInUse;
            if (inputSelectedInUse) {
                System.arraycopy(batch.selected, 0, this.inputSelected, 0, inputLogicalSize);
            }
            boolean someRowsFilteredOut = false;
            if (this.bigTableFilterExpressions.length > 0) {
                for (VectorExpression ve : this.bigTableFilterExpressions) {
                    ve.evaluate(batch);
                }
                boolean bl = someRowsFilteredOut = batch.size != inputLogicalSize;
                if (LOG.isDebugEnabled() && batch.selectedInUse) {
                    if (inputSelectedInUse) {
                        LOG.debug(CLASS_NAME + " inputSelected " + VectorMapJoinOuterLongOperator.intArrayToRangesString(this.inputSelected, inputLogicalSize) + " filtered batch.selected " + VectorMapJoinOuterLongOperator.intArrayToRangesString(batch.selected, batch.size));
                    } else {
                        LOG.debug(CLASS_NAME + " inputLogicalSize " + inputLogicalSize + " filtered batch.selected " + VectorMapJoinOuterLongOperator.intArrayToRangesString(batch.selected, batch.size));
                    }
                }
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            LongColumnVector joinColVector = (LongColumnVector)batch.cols[this.singleJoinColumn];
            long[] vector = joinColVector.vector;
            boolean allKeyInputColumnsRepeating = joinColVector.isRepeating;
            if (allKeyInputColumnsRepeating) {
                JoinUtil.JoinResult joinResult;
                if (batch.size == 0) {
                    joinResult = JoinUtil.JoinResult.NOMATCH;
                } else if (!joinColVector.noNulls && joinColVector.isNull[0]) {
                    joinResult = JoinUtil.JoinResult.NOMATCH;
                } else {
                    long key = vector[0];
                    joinResult = this.useMinMax && (key < this.min || key > this.max) ? JoinUtil.JoinResult.NOMATCH : this.hashMap.lookup(key, this.hashMapResults[0]);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name());
                }
                this.finishOuterRepeated(batch, joinResult, this.hashMapResults[0], someRowsFilteredOut, inputSelectedInUse, inputLogicalSize);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated");
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashMapResultCount = 0;
                int allMatchCount = 0;
                int equalKeySeriesCount = 0;
                int spillCount = 0;
                boolean atLeastOneNonMatch = someRowsFilteredOut;
                long saveKey = 0L;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block22: for (int logical = 0; logical < batch.size; ++logical) {
                    boolean isNull;
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    boolean bl = isNull = !joinColVector.noNulls && joinColVector.isNull[batchIndex];
                    if (isNull) {
                        atLeastOneNonMatch = true;
                        continue;
                    }
                    long currentKey = vector[batchIndex];
                    if (!haveSaveKey || currentKey != saveKey) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    ++hashMapResultCount;
                                    ++equalKeySeriesCount;
                                    break;
                                }
                                case SPILL: {
                                    ++hashMapResultCount;
                                    break;
                                }
                            }
                        }
                        haveSaveKey = true;
                        saveKey = currentKey;
                        saveJoinResult = this.useMinMax && (currentKey < this.min || currentKey > this.max) ? JoinUtil.JoinResult.NOMATCH : this.hashMap.lookup(currentKey, this.hashMapResults[hashMapResultCount]);
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.equalKeySeriesHashMapResultIndices[equalKeySeriesCount] = hashMapResultCount;
                                this.equalKeySeriesAllMatchIndices[equalKeySeriesCount] = allMatchCount;
                                this.equalKeySeriesIsSingleValue[equalKeySeriesCount] = this.hashMapResults[hashMapResultCount].isSingleRow();
                                this.equalKeySeriesDuplicateCounts[equalKeySeriesCount] = 1;
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                                ++spillCount;
                                break;
                            }
                            case NOMATCH: {
                                atLeastOneNonMatch = true;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            int n = equalKeySeriesCount;
                            this.equalKeySeriesDuplicateCounts[n] = this.equalKeySeriesDuplicateCounts[n] + 1;
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block22;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                            ++spillCount;
                            continue block22;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            ++hashMapResultCount;
                            ++equalKeySeriesCount;
                            break;
                        }
                        case SPILL: {
                            ++hashMapResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " allMatchs " + VectorMapJoinOuterLongOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " equalKeySeriesHashMapResultIndices " + VectorMapJoinOuterLongOperator.intArrayToRangesString(this.equalKeySeriesHashMapResultIndices, equalKeySeriesCount) + " equalKeySeriesAllMatchIndices " + VectorMapJoinOuterLongOperator.intArrayToRangesString(this.equalKeySeriesAllMatchIndices, equalKeySeriesCount) + " equalKeySeriesIsSingleValue " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesIsSingleValue, 0, equalKeySeriesCount)) + " equalKeySeriesDuplicateCounts " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesDuplicateCounts, 0, equalKeySeriesCount)) + " atLeastOneNonMatch " + atLeastOneNonMatch + " inputSelectedInUse " + inputSelectedInUse + " inputLogicalSize " + inputLogicalSize + " spills " + VectorMapJoinOuterLongOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinOuterLongOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashMapResults, 0, hashMapResultCount)));
                }
                this.finishOuter(batch, allMatchCount, equalKeySeriesCount, atLeastOneNonMatch, inputSelectedInUse, inputLogicalSize, spillCount, hashMapResultCount);
            }
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

