/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMap;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;

public class VectorMapJoinOuterMultiKeyOperator
extends VectorMapJoinOuterGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorMapJoinOuterMultiKeyOperator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(CLASS_NAME);
    private transient VectorMapJoinBytesHashMap hashMap;
    private transient VectorSerializeRow keyVectorSerializeWrite;
    private transient ByteStream.Output currentKeyOutput;
    private transient ByteStream.Output saveKeyOutput;

    @Override
    protected String getLoggingPrefix() {
        return super.getLoggingPrefix(CLASS_NAME);
    }

    protected VectorMapJoinOuterMultiKeyOperator() {
    }

    public VectorMapJoinOuterMultiKeyOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinOuterMultiKeyOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            boolean allKeyInputColumnsRepeating;
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.keyVectorSerializeWrite = new VectorSerializeRow<BinarySortableSerializeWrite>(new BinarySortableSerializeWrite(this.bigTableKeyColumnMap.length));
                this.keyVectorSerializeWrite.init(this.bigTableKeyTypeInfos, this.bigTableKeyColumnMap);
                this.currentKeyOutput = new ByteStream.Output();
                this.saveKeyOutput = new ByteStream.Output();
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashMap = (VectorMapJoinBytesHashMap)this.vectorMapJoinHashTable;
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " empty");
                }
                return;
            }
            this.outerPerBatchSetup(batch);
            boolean inputSelectedInUse = batch.selectedInUse;
            if (inputSelectedInUse) {
                System.arraycopy(batch.selected, 0, this.inputSelected, 0, inputLogicalSize);
            }
            boolean someRowsFilteredOut = false;
            if (this.bigTableFilterExpressions.length > 0) {
                for (VectorExpression ve : this.bigTableFilterExpressions) {
                    ve.evaluate(batch);
                }
                boolean bl = someRowsFilteredOut = batch.size != inputLogicalSize;
                if (LOG.isDebugEnabled() && batch.selectedInUse) {
                    if (inputSelectedInUse) {
                        LOG.debug(CLASS_NAME + " inputSelected " + VectorMapJoinOuterMultiKeyOperator.intArrayToRangesString(this.inputSelected, inputLogicalSize) + " filtered batch.selected " + VectorMapJoinOuterMultiKeyOperator.intArrayToRangesString(batch.selected, batch.size));
                    } else {
                        LOG.debug(CLASS_NAME + " inputLogicalSize " + inputLogicalSize + " filtered batch.selected " + VectorMapJoinOuterMultiKeyOperator.intArrayToRangesString(batch.selected, batch.size));
                    }
                }
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            boolean someKeyInputColumnIsNull = false;
            if (this.bigTableKeyColumnMap.length == 0) {
                allKeyInputColumnsRepeating = false;
            } else {
                allKeyInputColumnsRepeating = true;
                for (int i = 0; i < this.bigTableKeyColumnMap.length; ++i) {
                    ColumnVector colVector = batch.cols[this.bigTableKeyColumnMap[i]];
                    if (!colVector.isRepeating) {
                        allKeyInputColumnsRepeating = false;
                        break;
                    }
                    if (colVector.noNulls || !colVector.isNull[0]) continue;
                    someKeyInputColumnIsNull = true;
                }
            }
            if (allKeyInputColumnsRepeating) {
                JoinUtil.JoinResult joinResult;
                if (batch.size == 0) {
                    joinResult = JoinUtil.JoinResult.NOMATCH;
                } else if (someKeyInputColumnIsNull) {
                    joinResult = JoinUtil.JoinResult.NOMATCH;
                } else {
                    this.keyVectorSerializeWrite.setOutput(this.currentKeyOutput);
                    this.keyVectorSerializeWrite.serializeWrite(batch, 0);
                    byte[] keyBytes = this.currentKeyOutput.getData();
                    int keyLength = this.currentKeyOutput.getLength();
                    joinResult = this.hashMap.lookup(keyBytes, 0, keyLength, this.hashMapResults[0]);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name());
                }
                this.finishOuterRepeated(batch, joinResult, this.hashMapResults[0], someRowsFilteredOut, inputSelectedInUse, inputLogicalSize);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated");
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashMapResultCount = 0;
                int allMatchCount = 0;
                int equalKeySeriesCount = 0;
                int spillCount = 0;
                boolean atLeastOneNonMatch = someRowsFilteredOut;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block23: for (int logical = 0; logical < batch.size; ++logical) {
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    this.keyVectorSerializeWrite.setOutput(this.currentKeyOutput);
                    this.keyVectorSerializeWrite.serializeWrite(batch, batchIndex);
                    if (this.keyVectorSerializeWrite.getHasAnyNulls()) {
                        atLeastOneNonMatch = true;
                        continue;
                    }
                    if (!haveSaveKey || !this.saveKeyOutput.arraysEquals(this.currentKeyOutput)) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    ++hashMapResultCount;
                                    ++equalKeySeriesCount;
                                    break;
                                }
                                case SPILL: {
                                    ++hashMapResultCount;
                                    break;
                                }
                            }
                        }
                        haveSaveKey = true;
                        ByteStream.Output temp = this.saveKeyOutput;
                        this.saveKeyOutput = this.currentKeyOutput;
                        this.currentKeyOutput = temp;
                        byte[] keyBytes = this.saveKeyOutput.getData();
                        int keyLength = this.saveKeyOutput.getLength();
                        saveJoinResult = this.hashMap.lookup(keyBytes, 0, keyLength, this.hashMapResults[hashMapResultCount]);
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.equalKeySeriesHashMapResultIndices[equalKeySeriesCount] = hashMapResultCount;
                                this.equalKeySeriesAllMatchIndices[equalKeySeriesCount] = allMatchCount;
                                this.equalKeySeriesIsSingleValue[equalKeySeriesCount] = this.hashMapResults[hashMapResultCount].isSingleRow();
                                this.equalKeySeriesDuplicateCounts[equalKeySeriesCount] = 1;
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                                ++spillCount;
                                break;
                            }
                            case NOMATCH: {
                                atLeastOneNonMatch = true;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            int n = equalKeySeriesCount;
                            this.equalKeySeriesDuplicateCounts[n] = this.equalKeySeriesDuplicateCounts[n] + 1;
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block23;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                            ++spillCount;
                            continue block23;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            ++hashMapResultCount;
                            ++equalKeySeriesCount;
                            break;
                        }
                        case SPILL: {
                            ++hashMapResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " allMatchs " + VectorMapJoinOuterMultiKeyOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " equalKeySeriesHashMapResultIndices " + VectorMapJoinOuterMultiKeyOperator.intArrayToRangesString(this.equalKeySeriesHashMapResultIndices, equalKeySeriesCount) + " equalKeySeriesAllMatchIndices " + VectorMapJoinOuterMultiKeyOperator.intArrayToRangesString(this.equalKeySeriesAllMatchIndices, equalKeySeriesCount) + " equalKeySeriesIsSingleValue " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesIsSingleValue, 0, equalKeySeriesCount)) + " equalKeySeriesDuplicateCounts " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesDuplicateCounts, 0, equalKeySeriesCount)) + " atLeastOneNonMatch " + atLeastOneNonMatch + " inputSelectedInUse " + inputSelectedInUse + " inputLogicalSize " + inputLogicalSize + " spills " + VectorMapJoinOuterMultiKeyOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinOuterMultiKeyOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashMapResults, 0, hashMapResultCount)));
                }
                this.finishOuter(batch, allMatchCount, equalKeySeriesCount, atLeastOneNonMatch, inputSelectedInUse, inputLogicalSize, spillCount, hashMapResultCount);
            }
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

