/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import io.prestosql.hive.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.$internal.org.apache.commons.logging.LogFactory;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFGroupBatches;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorPTFDesc;
import org.apache.hadoop.hive.ql.plan.VectorPTFInfo;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class VectorPTFOperator
extends Operator<PTFDesc>
implements VectorizationOperator,
VectorizationContextRegion {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFOperator.class.getName();
    private static final Log LOG = LogFactory.getLog(CLASS_NAME);
    private VectorizationContext vContext;
    private VectorPTFDesc vectorDesc;
    private VectorPTFInfo vectorPTFInfo;
    protected VectorizationContext vOutContext;
    private boolean isPartitionOrderBy;
    private TypeInfo[] reducerBatchTypeInfos;
    private int[] outputProjectionColumnMap;
    private String[] outputColumnNames;
    private TypeInfo[] outputTypeInfos;
    private int evaluatorCount;
    private String[] evaluatorFunctionNames;
    private WindowFrameDef[] evaluatorWindowFrameDefs;
    private VectorExpression[] evaluatorInputExpressions;
    private ColumnVector.Type[] evaluatorInputColumnVectorTypes;
    private ExprNodeDesc[] orderExprNodeDescs;
    private int[] orderColumnMap;
    private ColumnVector.Type[] orderColumnVectorTypes;
    private VectorExpression[] orderExpressions;
    private ExprNodeDesc[] partitionExprNodeDescs;
    private int[] partitionColumnMap;
    private ColumnVector.Type[] partitionColumnVectorTypes;
    private VectorExpression[] partitionExpressions;
    private int[] keyInputColumnMap;
    private int[] nonKeyInputColumnMap;
    private transient boolean isLastGroupBatch;
    private transient VectorizedRowBatch overflowBatch;
    private transient VectorPTFGroupBatches groupBatches;
    private transient VectorPTFEvaluatorBase[] evaluators;
    private transient int[] streamingEvaluatorNums;
    private transient boolean allEvaluatorsAreStreaming;
    private transient boolean isFirstPartition;
    private transient boolean[] currentPartitionIsNull;
    private transient long[] currentPartitionLongs;
    private transient double[] currentPartitionDoubles;
    private transient byte[][] currentPartitionByteArrays;
    private transient int[] currentPartitionByteLengths;
    private transient HiveDecimalWritable[] currentPartitionDecimals;
    private transient Timestamp[] currentPartitionTimestamps;
    private transient HiveIntervalDayTime[] currentPartitionIntervalDayTimes;
    private transient String taskName;
    private transient long batchCounter;

    protected VectorPTFOperator() {
    }

    public VectorPTFOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorPTFOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        this(ctx);
        LOG.info("VectorPTF constructor");
        PTFDesc desc = (PTFDesc)conf;
        this.conf = desc;
        this.vectorDesc = (VectorPTFDesc)vectorDesc;
        this.vectorPTFInfo = this.vectorDesc.getVectorPTFInfo();
        this.vContext = vContext;
        this.reducerBatchTypeInfos = this.vectorDesc.getReducerBatchTypeInfos();
        this.isPartitionOrderBy = this.vectorDesc.getIsPartitionOrderBy();
        this.outputColumnNames = this.vectorDesc.getOutputColumnNames();
        this.outputTypeInfos = this.vectorDesc.getOutputTypeInfos();
        this.outputProjectionColumnMap = this.vectorPTFInfo.getOutputColumnMap();
        this.vOutContext = new VectorizationContext(this.getName(), this.vContext);
        this.setupVOutContext();
        this.evaluatorFunctionNames = this.vectorDesc.getEvaluatorFunctionNames();
        this.evaluatorCount = this.evaluatorFunctionNames.length;
        this.evaluatorWindowFrameDefs = this.vectorDesc.getEvaluatorWindowFrameDefs();
        this.evaluatorInputExpressions = this.vectorPTFInfo.getEvaluatorInputExpressions();
        this.evaluatorInputColumnVectorTypes = this.vectorPTFInfo.getEvaluatorInputColumnVectorTypes();
        this.orderExprNodeDescs = this.vectorDesc.getOrderExprNodeDescs();
        this.orderColumnMap = this.vectorPTFInfo.getOrderColumnMap();
        this.orderColumnVectorTypes = this.vectorPTFInfo.getOrderColumnVectorTypes();
        this.orderExpressions = this.vectorPTFInfo.getOrderExpressions();
        this.partitionExprNodeDescs = this.vectorDesc.getPartitionExprNodeDescs();
        this.partitionColumnMap = this.vectorPTFInfo.getPartitionColumnMap();
        this.partitionColumnVectorTypes = this.vectorPTFInfo.getPartitionColumnVectorTypes();
        this.partitionExpressions = this.vectorPTFInfo.getPartitionExpressions();
        this.keyInputColumnMap = this.vectorPTFInfo.getKeyInputColumnMap();
        this.nonKeyInputColumnMap = this.vectorPTFInfo.getNonKeyInputColumnMap();
    }

    protected void setupVOutContext() {
        this.vOutContext.resetProjectionColumns();
        int count = this.outputColumnNames.length;
        for (int i = 0; i < count; ++i) {
            String columnName = this.outputColumnNames[i];
            int outputColumn = this.outputProjectionColumnMap[i];
            this.vOutContext.addProjectionColumn(columnName, outputColumn);
        }
    }

    private void allocateOverflowBatchColumnVector(VectorizedRowBatch overflowBatch, int outputColumn, String typeName) throws HiveException {
        if (overflowBatch.cols[outputColumn] == null) {
            typeName = VectorizationContext.mapTypeNameSynonyms(typeName);
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(typeName);
            overflowBatch.cols[outputColumn] = VectorizedBatchUtil.createColumnVector(typeInfo);
        }
    }

    protected VectorizedRowBatch setupOverflowBatch() throws HiveException {
        int initialColumnCount = this.vContext.firstOutputColumnIndex();
        int totalNumColumns = initialColumnCount + this.vOutContext.getScratchColumnTypeNames().length;
        VectorizedRowBatch overflowBatch = new VectorizedRowBatch(totalNumColumns);
        for (int i = 0; i < this.outputProjectionColumnMap.length; ++i) {
            int outputColumn = this.outputProjectionColumnMap[i];
            String typeName = this.outputTypeInfos[i].getTypeName();
            this.allocateOverflowBatchColumnVector(overflowBatch, outputColumn, typeName);
        }
        int outputColumn = initialColumnCount;
        for (String typeName : this.vOutContext.getScratchColumnTypeNames()) {
            this.allocateOverflowBatchColumnVector(overflowBatch, outputColumn++, typeName);
        }
        overflowBatch.projectedColumns = this.outputProjectionColumnMap;
        overflowBatch.projectionSize = this.outputProjectionColumnMap.length;
        overflowBatch.reset();
        return overflowBatch;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        if (LOG.isDebugEnabled()) {
            BaseWork work = Utilities.getMapWork(hconf);
            if (work == null) {
                work = Utilities.getReduceWork(hconf);
            }
            this.taskName = work.getName();
        }
        if (!this.isPartitionOrderBy) {
            this.currentPartitionIsNull = null;
            this.currentPartitionLongs = null;
            this.currentPartitionDoubles = null;
            this.currentPartitionByteArrays = null;
            this.currentPartitionByteLengths = null;
            this.currentPartitionDecimals = null;
            this.currentPartitionTimestamps = null;
            this.currentPartitionIntervalDayTimes = null;
        } else {
            int partitionKeyCount = this.vectorDesc.getPartitionExprNodeDescs().length;
            this.currentPartitionIsNull = new boolean[partitionKeyCount];
            this.currentPartitionLongs = new long[partitionKeyCount];
            this.currentPartitionDoubles = new double[partitionKeyCount];
            this.currentPartitionByteArrays = new byte[partitionKeyCount][];
            this.currentPartitionByteLengths = new int[partitionKeyCount];
            this.currentPartitionDecimals = new HiveDecimalWritable[partitionKeyCount];
            this.currentPartitionTimestamps = new Timestamp[partitionKeyCount];
            this.currentPartitionIntervalDayTimes = new HiveIntervalDayTime[partitionKeyCount];
        }
        this.evaluators = VectorPTFDesc.getEvaluators(this.vectorDesc, this.vectorPTFInfo);
        this.streamingEvaluatorNums = VectorPTFDesc.getStreamingEvaluatorNums(this.evaluators);
        this.allEvaluatorsAreStreaming = this.streamingEvaluatorNums.length == this.evaluatorCount;
        this.overflowBatch = this.setupOverflowBatch();
        this.groupBatches = new VectorPTFGroupBatches(hconf, this.vectorDesc.getVectorizedPTFMaxMemoryBufferingBatchCount());
        this.groupBatches.init(this.reducerBatchTypeInfos, this.evaluators, this.outputProjectionColumnMap, this.outputTypeInfos, this.keyInputColumnMap, this.nonKeyInputColumnMap, this.streamingEvaluatorNums, this.overflowBatch);
        this.isFirstPartition = true;
        this.batchCounter = 0L;
    }

    @Override
    public void setNextVectorBatchGroupStatus(boolean isLastGroupBatch) throws HiveException {
        this.isLastGroupBatch = isLastGroupBatch;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)row;
        for (VectorExpression orderExpression : this.orderExpressions) {
            orderExpression.evaluate(batch);
        }
        if (this.partitionExpressions != null) {
            for (VectorExpression partitionExpression : this.partitionExpressions) {
                partitionExpression.evaluate(batch);
            }
        }
        if (this.isPartitionOrderBy) {
            if (this.isFirstPartition) {
                this.isFirstPartition = false;
                this.setCurrentPartition(batch);
            } else if (this.isPartitionChanged(batch)) {
                this.setCurrentPartition(batch);
                this.groupBatches.resetEvaluators();
            }
        }
        if (this.allEvaluatorsAreStreaming) {
            this.groupBatches.evaluateStreamingGroupBatch(batch, this.isLastGroupBatch);
            this.forward(batch, null);
        } else {
            this.groupBatches.evaluateGroupBatch(batch, this.isLastGroupBatch);
            if (!this.isLastGroupBatch) {
                this.groupBatches.bufferGroupBatch(batch);
                return;
            }
            this.groupBatches.fillGroupResultsAndForward(this, batch);
        }
        if (!this.isPartitionOrderBy) {
            this.groupBatches.resetEvaluators();
        }
    }

    private boolean isPartitionChanged(VectorizedRowBatch batch) {
        int count = this.partitionColumnMap.length;
        block8: for (int i = 0; i < count; ++i) {
            boolean currentIsNull;
            ColumnVector colVector = batch.cols[this.partitionColumnMap[i]];
            boolean isNull = !colVector.noNulls && colVector.isNull[0];
            if (isNull != (currentIsNull = this.currentPartitionIsNull[i])) {
                return true;
            }
            if (isNull) continue;
            switch (this.partitionColumnVectorTypes[i]) {
                case LONG: {
                    if (this.currentPartitionLongs[i] == ((LongColumnVector)colVector).vector[0]) continue block8;
                    return true;
                }
                case DOUBLE: {
                    if (this.currentPartitionDoubles[i] == ((DoubleColumnVector)colVector).vector[0]) continue block8;
                    return true;
                }
                case BYTES: {
                    BytesColumnVector byteColVector = (BytesColumnVector)colVector;
                    byte[] bytes = byteColVector.vector[0];
                    int start = byteColVector.start[0];
                    int length = byteColVector.length[0];
                    if (StringExpr.equal(bytes, start, length, this.currentPartitionByteArrays[i], 0, this.currentPartitionByteLengths[i])) continue block8;
                    return true;
                }
                case DECIMAL: {
                    if (this.currentPartitionDecimals[i].equals(((DecimalColumnVector)colVector).vector[0])) continue block8;
                    return true;
                }
                case TIMESTAMP: {
                    if (((TimestampColumnVector)colVector).compareTo(0, this.currentPartitionTimestamps[i]) == 0) continue block8;
                    return true;
                }
                case INTERVAL_DAY_TIME: {
                    if (((IntervalDayTimeColumnVector)colVector).compareTo(0, this.currentPartitionIntervalDayTimes[i]) == 0) continue block8;
                    return true;
                }
                default: {
                    throw new RuntimeException("Unexpected column vector type " + (Object)((Object)this.partitionColumnVectorTypes[i]));
                }
            }
        }
        return false;
    }

    private void setCurrentPartition(VectorizedRowBatch batch) {
        int count = this.partitionColumnMap.length;
        block8: for (int i = 0; i < count; ++i) {
            boolean isNull;
            ColumnVector colVector = batch.cols[this.partitionColumnMap[i]];
            this.currentPartitionIsNull[i] = isNull = !colVector.noNulls && colVector.isNull[0];
            if (isNull) continue;
            switch (this.partitionColumnVectorTypes[i]) {
                case LONG: {
                    this.currentPartitionLongs[i] = ((LongColumnVector)colVector).vector[0];
                    continue block8;
                }
                case DOUBLE: {
                    this.currentPartitionDoubles[i] = ((DoubleColumnVector)colVector).vector[0];
                    continue block8;
                }
                case BYTES: {
                    BytesColumnVector byteColVector = (BytesColumnVector)colVector;
                    byte[] bytes = byteColVector.vector[0];
                    int start = byteColVector.start[0];
                    int length = byteColVector.length[0];
                    if (this.currentPartitionByteArrays[i] == null || this.currentPartitionByteLengths[i] < length) {
                        this.currentPartitionByteArrays[i] = Arrays.copyOfRange(bytes, start, start + length);
                    } else {
                        System.arraycopy(bytes, start, this.currentPartitionByteArrays[i], 0, length);
                    }
                    this.currentPartitionByteLengths[i] = length;
                    continue block8;
                }
                case DECIMAL: {
                    if (this.currentPartitionDecimals[i] == null) {
                        this.currentPartitionDecimals[i] = new HiveDecimalWritable();
                    }
                    this.currentPartitionDecimals[i].set(((DecimalColumnVector)colVector).vector[0]);
                    continue block8;
                }
                case TIMESTAMP: {
                    if (this.currentPartitionTimestamps[i] == null) {
                        this.currentPartitionTimestamps[i] = new Timestamp(0L);
                    }
                    ((TimestampColumnVector)colVector).timestampUpdate(this.currentPartitionTimestamps[i], 0);
                    continue block8;
                }
                case INTERVAL_DAY_TIME: {
                    if (this.currentPartitionIntervalDayTimes[i] == null) {
                        this.currentPartitionIntervalDayTimes[i] = new HiveIntervalDayTime();
                    }
                    ((IntervalDayTimeColumnVector)colVector).intervalDayTimeUpdate(this.currentPartitionIntervalDayTimes[i], 0);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Unexpected column vector type " + (Object)((Object)this.partitionColumnVectorTypes[i]));
                }
            }
        }
    }

    @Override
    public void forward(Object row, ObjectInspector rowInspector) throws HiveException {
        super.forward(row, rowInspector);
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return VectorPTFOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "PTF";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.PTF;
    }

    @Override
    public VectorizationContext getOutputVectorizationContext() {
        return this.vOutContext;
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }
}

