/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.io.parquet.FilterPredicateLeafBuilder;
import org.apache.hadoop.hive.ql.io.parquet.LeafFilterFactory;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class ParquetFilterPredicateConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetFilterPredicateConverter.class);

    public static FilterPredicate toFilterPredicate(SearchArgument sarg, MessageType schema) {
        HashSet<String> columns = null;
        if (schema != null) {
            columns = new HashSet<String>();
            for (Type field : schema.getFields()) {
                columns.add(field.getName());
            }
        }
        try {
            return ParquetFilterPredicateConverter.translate(sarg.getExpression(), sarg.getLeaves(), columns, schema);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static FilterPredicate translate(ExpressionTree root, List<PredicateLeaf> leaves, Set<String> columns, MessageType schema) throws Exception {
        FilterPredicate p = null;
        switch (root.getOperator()) {
            case OR: {
                for (ExpressionTree child : root.getChildren()) {
                    FilterPredicate childPredicate = ParquetFilterPredicateConverter.translate(child, leaves, columns, schema);
                    if (childPredicate == null) {
                        return null;
                    }
                    if (p == null) {
                        p = childPredicate;
                        continue;
                    }
                    p = FilterApi.or(p, childPredicate);
                }
                return p;
            }
            case AND: {
                for (ExpressionTree child : root.getChildren()) {
                    if (p == null) {
                        p = ParquetFilterPredicateConverter.translate(child, leaves, columns, schema);
                        continue;
                    }
                    FilterPredicate right = ParquetFilterPredicateConverter.translate(child, leaves, columns, schema);
                    if (right == null) continue;
                    p = FilterApi.and(p, right);
                }
                return p;
            }
            case NOT: {
                FilterPredicate op = ParquetFilterPredicateConverter.translate(root.getChildren().get(0), leaves, columns, schema);
                if (op != null) {
                    return FilterApi.not(op);
                }
                return null;
            }
            case LEAF: {
                PredicateLeaf leaf = leaves.get(root.getLeaf());
                if (columns.contains(leaf.getColumnName())) {
                    Type parquetType = schema.getType(leaf.getColumnName());
                    return ParquetFilterPredicateConverter.buildFilterPredicateFromPredicateLeaf(leaf, parquetType);
                }
                return null;
            }
            case CONSTANT: {
                return null;
            }
        }
        throw new IllegalStateException("Unknown operator: " + (Object)((Object)root.getOperator()));
    }

    private static FilterPredicate buildFilterPredicateFromPredicateLeaf(PredicateLeaf leaf, Type parquetType) throws Exception {
        LeafFilterFactory leafFilterFactory = new LeafFilterFactory();
        try {
            FilterPredicateLeafBuilder builder = leafFilterFactory.getLeafFilterBuilderByType(leaf.getType(), parquetType);
            if (ParquetFilterPredicateConverter.isMultiLiteralsOperator(leaf.getOperator())) {
                return builder.buildPredicate(leaf.getOperator(), leaf.getLiteralList(), leaf.getColumnName());
            }
            return builder.buildPredict(leaf.getOperator(), leaf.getLiteral(), leaf.getColumnName());
        }
        catch (Exception e) {
            LOG.error("fail to build predicate filter leaf with errors" + e, e);
            throw e;
        }
    }

    private static boolean isMultiLiteralsOperator(PredicateLeaf.Operator op) {
        return op == PredicateLeaf.Operator.IN || op == PredicateLeaf.Operator.BETWEEN;
    }
}

