/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.OptimizeSparkProcContext;
import org.apache.hadoop.hive.ql.parse.spark.SparkPartitionPruningSinkOperator;

public class SparkRemoveDynamicPruning
implements NodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SparkRemoveDynamicPruning.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        OptimizeSparkProcContext context = (OptimizeSparkProcContext)procContext;
        boolean remove = false;
        SparkPartitionPruningSinkOperator op = (SparkPartitionPruningSinkOperator)nd;
        SparkPartitionPruningSinkDesc desc = (SparkPartitionPruningSinkDesc)op.getConf();
        if (context.getConf().isSparkDPPOnlyMapjoin() && !op.isWithMapjoin()) {
            LOG.info("Disabling dynamic partition pruning based on: " + desc.getTableScanNames() + ". This is not part of a map join.");
            remove = true;
        } else if (desc.getStatistics().getDataSize() > context.getConf().getLongVar(HiveConf.ConfVars.SPARK_DYNAMIC_PARTITION_PRUNING_MAX_DATA_SIZE)) {
            LOG.info("Disabling dynamic partition pruning based on: " + desc.getTableScanNames() + ". Expected data size is too big: " + desc.getStatistics().getDataSize());
            remove = true;
        }
        if (remove) {
            OperatorUtils.removeBranch(op);
        }
        return false;
    }
}

