/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.cost;

import io.prestosql.hive.$internal.com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdPercentageOriginalRows;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;

public class HiveRelMdCost
implements MetadataHandler<BuiltInMetadata.NonCumulativeCost> {
    private final HiveCostModel hiveCostModel;

    public HiveRelMdCost(HiveCostModel hiveCostModel) {
        this.hiveCostModel = hiveCostModel;
    }

    public RelMetadataProvider getMetadataProvider() {
        return ChainedRelMetadataProvider.of(ImmutableList.of(ReflectiveRelMetadataProvider.reflectiveSource((MetadataHandler)this, (Method[])new Method[]{BuiltInMethod.NON_CUMULATIVE_COST.method}), RelMdPercentageOriginalRows.SOURCE));
    }

    public MetadataDef<BuiltInMetadata.NonCumulativeCost> getDef() {
        return BuiltInMetadata.NonCumulativeCost.DEF;
    }

    public RelOptCost getNonCumulativeCost(HiveAggregate aggregate, RelMetadataQuery mq) {
        return this.hiveCostModel.getAggregateCost(aggregate);
    }

    public RelOptCost getNonCumulativeCost(HiveJoin join, RelMetadataQuery mq) {
        return this.hiveCostModel.getJoinCost(join);
    }

    public RelOptCost getNonCumulativeCost(HiveTableScan ts, RelMetadataQuery mq) {
        return this.hiveCostModel.getScanCost(ts, mq);
    }

    public RelOptCost getNonCumulativeCost(RelNode rel, RelMetadataQuery mq) {
        return this.hiveCostModel.getDefaultCost();
    }
}

