/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.List;
import org.antlr.runtime.TokenRewriteStream;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.MaskAndFilterInfo;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;

public class TableMask {
    protected final Logger LOG = LoggerFactory.getLogger(TableMask.class);
    HiveAuthorizer authorizer;
    private UnparseTranslator translator;
    private boolean enable;
    private boolean needsRewrite;
    private HiveAuthzContext queryContext;
    private HiveConf conf;

    public TableMask(SemanticAnalyzer analyzer, HiveConf conf, boolean skipTableMasking) throws SemanticException {
        try {
            this.authorizer = SessionState.get().getAuthorizerV2();
            this.conf = conf;
            String cmdString = analyzer.ctx.getCmd();
            SessionState ss = SessionState.get();
            HiveAuthzContext.Builder ctxBuilder = new HiveAuthzContext.Builder();
            ctxBuilder.setCommandString(cmdString);
            ctxBuilder.setUserIpAddress(ss.getUserIpAddress());
            ctxBuilder.setForwardedAddresses(ss.getForwardedAddresses());
            this.queryContext = ctxBuilder.build();
            if (this.authorizer != null && this.needTransform() && !skipTableMasking) {
                this.enable = true;
                this.translator = new UnparseTranslator(conf);
                this.translator.enable();
            }
        }
        catch (Exception e) {
            this.LOG.warn("Failed to initialize masking policy");
            throw new SemanticException(e);
        }
    }

    public List<HivePrivilegeObject> applyRowFilterAndColumnMasking(List<HivePrivilegeObject> privObjs) throws SemanticException {
        return this.authorizer.applyRowFilterAndColumnMasking(this.queryContext, privObjs);
    }

    public boolean isEnabled() throws SemanticException {
        return this.enable;
    }

    public boolean needTransform() throws SemanticException {
        return this.authorizer.needTransform();
    }

    public String create(HivePrivilegeObject privObject, MaskAndFilterInfo maskAndFilterInfo) throws SemanticException {
        boolean doColumnMasking = false;
        boolean doRowFiltering = false;
        StringBuilder sb = new StringBuilder();
        sb.append("(SELECT ");
        boolean firstOne = true;
        List<String> exprs = privObject.getCellValueTransformers();
        if (exprs != null) {
            if (exprs.size() != privObject.getColumns().size()) {
                throw new SemanticException("Expect " + privObject.getColumns().size() + " columns in " + privObject.getObjectName() + ", but only find " + exprs.size());
            }
            List<String> colTypes = maskAndFilterInfo.colTypes;
            for (int index = 0; index < exprs.size(); ++index) {
                String expr = exprs.get(index);
                if (expr == null) {
                    throw new SemanticException("Expect string type CellValueTransformer in " + privObject.getObjectName() + ", but only find null");
                }
                if (!firstOne) {
                    sb.append(", ");
                } else {
                    firstOne = false;
                }
                String colName = privObject.getColumns().get(index);
                if (!expr.equals(colName)) {
                    sb.append("CAST(" + expr + " AS " + colTypes.get(index) + ") AS " + HiveUtils.unparseIdentifier(colName, this.conf));
                    doColumnMasking = true;
                    continue;
                }
                sb.append(HiveUtils.unparseIdentifier(colName, this.conf));
            }
        }
        if (!doColumnMasking) {
            sb = new StringBuilder();
            sb.append("(SELECT *");
        }
        if (!maskAndFilterInfo.isView && !maskAndFilterInfo.isNonNative) {
            for (VirtualColumn vc : VirtualColumn.getRegistry(this.conf)) {
                sb.append(", " + vc.getName());
            }
        }
        sb.append(" FROM ");
        sb.append(HiveUtils.unparseIdentifier(privObject.getDbname(), this.conf));
        sb.append(".");
        sb.append(HiveUtils.unparseIdentifier(privObject.getObjectName(), this.conf));
        sb.append(" " + maskAndFilterInfo.additionalTabInfo);
        String filter = privObject.getRowFilterExpression();
        if (filter != null) {
            sb.append(" WHERE " + filter);
            doRowFiltering = true;
        }
        sb.append(")" + HiveUtils.unparseIdentifier(maskAndFilterInfo.alias, this.conf));
        if (!doColumnMasking && !doRowFiltering) {
            return null;
        }
        this.LOG.debug("TableMask creates `" + sb.toString() + "`");
        return sb.toString();
    }

    void addTranslation(ASTNode node, String replacementText) throws SemanticException {
        this.translator.addTranslation(node, replacementText);
    }

    void applyTranslations(TokenRewriteStream tokenRewriteStream) throws SemanticException {
        this.translator.applyTranslations(tokenRewriteStream);
    }

    public boolean needsRewrite() {
        return this.needsRewrite;
    }

    public void setNeedsRewrite(boolean needsRewrite) {
        this.needsRewrite = needsRewrite;
    }
}

