/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump;

import io.prestosql.hive.$internal.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.repl.dump.TableExport;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.FileOperations;
import org.apache.hadoop.hive.ql.plan.ExportWork;
import org.apache.hadoop.hive.ql.session.SessionState;

class PartitionExport {
    private final TableExport.Paths paths;
    private final PartitionIterable partitionIterable;
    private final String distCpDoAsUser;
    private final HiveConf hiveConf;
    private final int nThreads;
    private final SessionState callersSession;
    private final ExportWork.MmContext mmCtx;
    private static final Logger LOG = LoggerFactory.getLogger(PartitionExport.class);
    private BlockingQueue<Partition> queue;

    PartitionExport(TableExport.Paths paths, PartitionIterable partitionIterable, String distCpDoAsUser, HiveConf hiveConf, ExportWork.MmContext mmCtx) {
        this.paths = paths;
        this.partitionIterable = partitionIterable;
        this.distCpDoAsUser = distCpDoAsUser;
        this.hiveConf = hiveConf;
        this.mmCtx = mmCtx;
        this.nThreads = hiveConf.getIntVar(HiveConf.ConfVars.REPL_PARTITIONS_DUMP_PARALLELISM);
        this.queue = new ArrayBlockingQueue<Partition>(2 * this.nThreads);
        this.callersSession = SessionState.get();
    }

    void write(ReplicationSpec forReplicationSpec) throws InterruptedException {
        ExecutorService producer = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("partition-submitter-thread-%d").build());
        producer.submit(() -> {
            SessionState.setCurrentSessionState(this.callersSession);
            for (Partition partition : this.partitionIterable) {
                try {
                    this.queue.put(partition);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Error while queuing up the partitions for export of data files", e);
                }
            }
        });
        producer.shutdown();
        ThreadFactory namingThreadFactory = new ThreadFactoryBuilder().setNameFormat("partition-dump-thread-%d").build();
        ExecutorService consumer = Executors.newFixedThreadPool(this.nThreads, namingThreadFactory);
        while (!producer.isTerminated() || !this.queue.isEmpty()) {
            Partition partition = this.queue.poll(1L, TimeUnit.SECONDS);
            if (partition == null) continue;
            LOG.debug("scheduling partition dump {}", (Object)partition.getName());
            consumer.submit(() -> {
                String partitionName = partition.getName();
                String threadName = Thread.currentThread().getName();
                LOG.debug("Thread: {}, start partition dump {}", (Object)threadName, (Object)partitionName);
                try {
                    List<Path> dataPathList = Utils.getDataPathList(partition.getDataLocation(), forReplicationSpec, this.hiveConf);
                    Path rootDataDumpDir = this.paths.partitionExportDir(partitionName);
                    new FileOperations(dataPathList, rootDataDumpDir, this.distCpDoAsUser, this.hiveConf, this.mmCtx).export(forReplicationSpec);
                    LOG.debug("Thread: {}, finish partition dump {}", (Object)threadName, (Object)partitionName);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while export of data files", e);
                }
            });
        }
        consumer.shutdown();
        consumer.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
    }
}

