/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.optimizer.signature.Signature;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkInfo;
import org.apache.hadoop.hive.ql.plan.VectorizationCondition;

@Explain(displayName="Reduce Output Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ReduceSinkDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private ArrayList<ExprNodeDesc> keyCols;
    private ArrayList<String> outputKeyColumnNames;
    private List<List<Integer>> distinctColumnIndices;
    private ArrayList<ExprNodeDesc> valueCols;
    private ArrayList<String> outputValueColumnNames;
    private TableDesc keySerializeInfo;
    private TableDesc valueSerializeInfo;
    private int tag;
    private int numDistributionKeys;
    private String outputName;
    private ArrayList<ExprNodeDesc> partitionCols;
    private int numReducers;
    private int numBuckets;
    private List<ExprNodeDesc> bucketCols;
    private int topN = -1;
    private float topNMemoryUsage = -1.0f;
    private boolean mapGroupBy;
    private boolean isPTFReduceSink = false;
    private boolean skipTag;
    private boolean forwarding;
    private EnumSet<ReducerTraits> reduceTraits = EnumSet.of(ReducerTraits.UNSET);
    private transient boolean isDeduplicated = false;
    private transient boolean hasOrderBy = false;
    private static transient Logger LOG = LoggerFactory.getLogger(ReduceSinkDesc.class);
    private AcidUtils.Operation writeType;
    private static final Set<String> vectorizableReduceSinkNativeEngines = new LinkedHashSet<String>(Arrays.asList("tez", "spark"));

    public ReduceSinkDesc() {
    }

    public ReduceSinkDesc(ArrayList<ExprNodeDesc> keyCols, int numDistributionKeys, ArrayList<ExprNodeDesc> valueCols, ArrayList<String> outputKeyColumnNames, List<List<Integer>> distinctColumnIndices, ArrayList<String> outputValueColumnNames, int tag, ArrayList<ExprNodeDesc> partitionCols, int numReducers, TableDesc keySerializeInfo, TableDesc valueSerializeInfo, AcidUtils.Operation writeType) {
        this.keyCols = keyCols;
        this.numDistributionKeys = numDistributionKeys;
        this.valueCols = valueCols;
        this.outputKeyColumnNames = outputKeyColumnNames;
        this.outputValueColumnNames = outputValueColumnNames;
        this.tag = tag;
        this.numReducers = numReducers;
        this.partitionCols = partitionCols;
        this.keySerializeInfo = keySerializeInfo;
        this.valueSerializeInfo = valueSerializeInfo;
        this.distinctColumnIndices = distinctColumnIndices;
        this.setNumBuckets(-1);
        this.setBucketCols(null);
        this.writeType = writeType;
    }

    @Override
    public Object clone() {
        ReduceSinkDesc desc = new ReduceSinkDesc();
        desc.setKeyCols((ArrayList)this.getKeyCols().clone());
        desc.setValueCols((ArrayList)this.getValueCols().clone());
        desc.setOutputKeyColumnNames((ArrayList)this.getOutputKeyColumnNames().clone());
        ArrayList<List<Integer>> distinctColumnIndicesClone = new ArrayList<List<Integer>>();
        for (List<Integer> distinctColumnIndex : this.getDistinctColumnIndices()) {
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            tmp.addAll(distinctColumnIndex);
            distinctColumnIndicesClone.add(tmp);
        }
        desc.setDistinctColumnIndices(distinctColumnIndicesClone);
        desc.setOutputValueColumnNames((ArrayList)this.getOutputValueColumnNames().clone());
        desc.setNumDistributionKeys(this.getNumDistributionKeys());
        desc.setTag(this.getTag());
        desc.setNumReducers(this.getNumReducers());
        desc.setPartitionCols((ArrayList)this.getPartitionCols().clone());
        desc.setKeySerializeInfo((TableDesc)this.getKeySerializeInfo().clone());
        desc.setValueSerializeInfo((TableDesc)this.getValueSerializeInfo().clone());
        desc.setNumBuckets(this.numBuckets);
        desc.setBucketCols(this.bucketCols);
        desc.setStatistics(this.getStatistics());
        desc.setSkipTag(this.skipTag);
        desc.reduceTraits = this.reduceTraits.clone();
        desc.setDeduplicated(this.isDeduplicated);
        desc.setHasOrderBy(this.hasOrderBy);
        desc.outputName = this.outputName;
        return desc;
    }

    public ArrayList<String> getOutputKeyColumnNames() {
        return this.outputKeyColumnNames;
    }

    public void setOutputKeyColumnNames(ArrayList<String> outputKeyColumnNames) {
        this.outputKeyColumnNames = outputKeyColumnNames;
    }

    public ArrayList<String> getOutputValueColumnNames() {
        return this.outputValueColumnNames;
    }

    public void setOutputValueColumnNames(ArrayList<String> outputValueColumnNames) {
        this.outputValueColumnNames = outputValueColumnNames;
    }

    @Explain(displayName="key expressions")
    @Signature
    public String getKeyColString() {
        return PlanUtils.getExprListString(this.keyCols);
    }

    public ArrayList<ExprNodeDesc> getKeyCols() {
        return this.keyCols;
    }

    public void setKeyCols(ArrayList<ExprNodeDesc> keyCols) {
        this.keyCols = keyCols;
    }

    public int getNumDistributionKeys() {
        return this.numDistributionKeys;
    }

    public void setNumDistributionKeys(int numKeys) {
        this.numDistributionKeys = numKeys;
    }

    @Explain(displayName="value expressions")
    @Signature
    public String getValueColsString() {
        return PlanUtils.getExprListString(this.valueCols);
    }

    public ArrayList<ExprNodeDesc> getValueCols() {
        return this.valueCols;
    }

    public void setValueCols(ArrayList<ExprNodeDesc> valueCols) {
        this.valueCols = valueCols;
    }

    @Explain(displayName="Map-reduce partition columns")
    public String getParitionColsString() {
        return PlanUtils.getExprListString(this.partitionCols);
    }

    @Explain(displayName="PartitionCols", explainLevels={Explain.Level.USER})
    @Signature
    public String getUserLevelExplainParitionColsString() {
        return PlanUtils.getExprListString(this.partitionCols, true);
    }

    public ArrayList<ExprNodeDesc> getPartitionCols() {
        return this.partitionCols;
    }

    public void setPartitionCols(ArrayList<ExprNodeDesc> partitionCols) {
        this.partitionCols = partitionCols;
    }

    public boolean isPartitioning() {
        return this.partitionCols != null && !this.partitionCols.isEmpty();
    }

    @Signature
    @Explain(displayName="tag", explainLevels={Explain.Level.EXTENDED})
    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    @Signature
    public int getTopN() {
        return this.topN;
    }

    public void setTopN(int topN) {
        this.topN = topN;
    }

    @Explain(displayName="TopN", explainLevels={Explain.Level.EXTENDED})
    public Integer getTopNExplain() {
        return this.topN > 0 ? Integer.valueOf(this.topN) : null;
    }

    public float getTopNMemoryUsage() {
        return this.topNMemoryUsage;
    }

    public void setTopNMemoryUsage(float topNMemoryUsage) {
        this.topNMemoryUsage = topNMemoryUsage;
    }

    @Explain(displayName="TopN Hash Memory Usage")
    public Float getTopNMemoryUsageExplain() {
        return this.topN > 0 && this.topNMemoryUsage > 0.0f ? Float.valueOf(this.topNMemoryUsage) : null;
    }

    public boolean isMapGroupBy() {
        return this.mapGroupBy;
    }

    public void setMapGroupBy(boolean mapGroupBy) {
        this.mapGroupBy = mapGroupBy;
    }

    public boolean isPTFReduceSink() {
        return this.isPTFReduceSink;
    }

    public void setPTFReduceSink(boolean isPTFReduceSink) {
        this.isPTFReduceSink = isPTFReduceSink;
    }

    public int getNumReducers() {
        return this.numReducers;
    }

    public void setNumReducers(int numReducers) {
        this.numReducers = numReducers;
    }

    public TableDesc getKeySerializeInfo() {
        return this.keySerializeInfo;
    }

    public void setKeySerializeInfo(TableDesc keySerializeInfo) {
        this.keySerializeInfo = keySerializeInfo;
    }

    public TableDesc getValueSerializeInfo() {
        return this.valueSerializeInfo;
    }

    public void setValueSerializeInfo(TableDesc valueSerializeInfo) {
        this.valueSerializeInfo = valueSerializeInfo;
    }

    @Signature
    @Explain(displayName="sort order")
    public String getOrder() {
        return this.keySerializeInfo.getProperties().getProperty("serialization.sort.order");
    }

    public void setOrder(String orderStr) {
        this.keySerializeInfo.getProperties().setProperty("serialization.sort.order", orderStr);
    }

    public boolean isOrdering() {
        return this.getOrder() != null && !this.getOrder().isEmpty();
    }

    @Explain(displayName="null sort order", explainLevels={Explain.Level.EXTENDED})
    public String getNullOrder() {
        return this.keySerializeInfo.getProperties().getProperty("serialization.sort.order.null");
    }

    public void setNullOrder(String nullOrderStr) {
        this.keySerializeInfo.getProperties().setProperty("serialization.sort.order.null", nullOrderStr);
    }

    public List<List<Integer>> getDistinctColumnIndices() {
        return this.distinctColumnIndices;
    }

    public void setDistinctColumnIndices(List<List<Integer>> distinctColumnIndices) {
        this.distinctColumnIndices = distinctColumnIndices;
    }

    @Explain(displayName="outputname", explainLevels={Explain.Level.USER})
    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    public List<ExprNodeDesc> getBucketCols() {
        return this.bucketCols;
    }

    public void setBucketCols(List<ExprNodeDesc> bucketCols) {
        this.bucketCols = bucketCols;
    }

    public void setSkipTag(boolean value) {
        this.skipTag = value;
    }

    public boolean getSkipTag() {
        return this.skipTag;
    }

    public void setForwarding(boolean forwarding) {
        this.forwarding = forwarding;
    }

    public boolean isForwarding() {
        return this.forwarding;
    }

    @Explain(displayName="auto parallelism", explainLevels={Explain.Level.EXTENDED})
    public final boolean isAutoParallel() {
        return this.reduceTraits.contains((Object)ReducerTraits.AUTOPARALLEL);
    }

    public final boolean isSlowStart() {
        return !this.reduceTraits.contains((Object)ReducerTraits.QUICKSTART);
    }

    @Explain(displayName="quick start", displayOnlyOnTrue=true, explainLevels={Explain.Level.EXTENDED})
    public final boolean isQuickStart() {
        return !this.isSlowStart();
    }

    public final EnumSet<ReducerTraits> getReducerTraits() {
        return this.reduceTraits;
    }

    public final void setReducerTraits(EnumSet<ReducerTraits> traits) {
        boolean wasUnset = this.reduceTraits.remove((Object)ReducerTraits.UNSET);
        if (this.reduceTraits.contains((Object)ReducerTraits.FIXED)) {
            return;
        }
        if (traits.contains((Object)ReducerTraits.FIXED)) {
            this.reduceTraits.removeAll(EnumSet.of(ReducerTraits.AUTOPARALLEL, ReducerTraits.UNIFORM));
            this.reduceTraits.addAll(traits);
        } else {
            this.reduceTraits.addAll(traits);
        }
    }

    public boolean isDeduplicated() {
        return this.isDeduplicated;
    }

    public void setDeduplicated(boolean isDeduplicated) {
        this.isDeduplicated = isDeduplicated;
    }

    public boolean hasOrderBy() {
        return this.hasOrderBy;
    }

    public void setHasOrderBy(boolean hasOrderBy) {
        this.hasOrderBy = hasOrderBy;
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="Reduce Sink Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public ReduceSinkOperatorExplainVectorization getReduceSinkVectorization() {
        VectorReduceSinkDesc vectorReduceSinkDesc = (VectorReduceSinkDesc)this.getVectorDesc();
        if (vectorReduceSinkDesc == null) {
            return null;
        }
        return new ReduceSinkOperatorExplainVectorization(this, vectorReduceSinkDesc);
    }

    @Override
    public boolean isSame(OperatorDesc other) {
        if (this.getClass().getName().equals(other.getClass().getName())) {
            ReduceSinkDesc otherDesc = (ReduceSinkDesc)other;
            return ExprNodeDescUtils.isSame(this.getKeyCols(), otherDesc.getKeyCols()) && ExprNodeDescUtils.isSame(this.getValueCols(), otherDesc.getValueCols()) && ExprNodeDescUtils.isSame(this.getPartitionCols(), otherDesc.getPartitionCols()) && this.getTag() == otherDesc.getTag() && Objects.equals(this.getOrder(), otherDesc.getOrder()) && this.getTopN() == otherDesc.getTopN() && this.isAutoParallel() == otherDesc.isAutoParallel();
        }
        return false;
    }

    public AcidUtils.Operation getWriteType() {
        return this.writeType;
    }

    public class ReduceSinkOperatorExplainVectorization
    extends OperatorExplainVectorization {
        private final ReduceSinkDesc reduceSinkDesc;
        private final VectorReduceSinkDesc vectorReduceSinkDesc;
        private final VectorReduceSinkInfo vectorReduceSinkInfo;
        private VectorizationCondition[] nativeConditions;

        public ReduceSinkOperatorExplainVectorization(ReduceSinkDesc reduceSinkDesc, VectorReduceSinkDesc vectorReduceSinkDesc) {
            super(vectorReduceSinkDesc, vectorReduceSinkDesc.reduceSinkKeyType() != VectorReduceSinkDesc.ReduceSinkKeyType.NONE);
            this.reduceSinkDesc = reduceSinkDesc;
            this.vectorReduceSinkDesc = vectorReduceSinkDesc;
            this.vectorReduceSinkInfo = vectorReduceSinkDesc.getVectorReduceSinkInfo();
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="keyExpressions", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getKeyExpression() {
            if (!this.isNative) {
                return null;
            }
            return this.vectorExpressionsToStringList(this.vectorReduceSinkInfo.getReduceSinkKeyExpressions());
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="valueExpressions", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getValueExpression() {
            if (!this.isNative) {
                return null;
            }
            return this.vectorExpressionsToStringList(this.vectorReduceSinkInfo.getReduceSinkValueExpressions());
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="keyColumnNums", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getKeyColumnNums() {
            if (!this.isNative) {
                return null;
            }
            int[] keyColumnMap = this.vectorReduceSinkInfo.getReduceSinkKeyColumnMap();
            if (keyColumnMap == null) {
                keyColumnMap = new int[]{};
            }
            return Arrays.toString(keyColumnMap);
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="valueColumnNums", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getValueColumnNums() {
            if (!this.isNative) {
                return null;
            }
            int[] valueColumnMap = this.vectorReduceSinkInfo.getReduceSinkValueColumnMap();
            if (valueColumnMap == null) {
                valueColumnMap = new int[]{};
            }
            return Arrays.toString(valueColumnMap);
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="bucketColumnNums", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getBucketColumnNums() {
            if (!this.isNative) {
                return null;
            }
            int[] bucketColumnMap = this.vectorReduceSinkInfo.getReduceSinkBucketColumnMap();
            if (bucketColumnMap == null || bucketColumnMap.length == 0) {
                return null;
            }
            return Arrays.toString(bucketColumnMap);
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="partitionColumnNums", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getPartitionColumnNums() {
            if (!this.isNative) {
                return null;
            }
            int[] partitionColumnMap = this.vectorReduceSinkInfo.getReduceSinkPartitionColumnMap();
            if (partitionColumnMap == null || partitionColumnMap.length == 0) {
                return null;
            }
            return Arrays.toString(partitionColumnMap);
        }

        private VectorizationCondition[] createNativeConditions() {
            boolean enabled = this.vectorReduceSinkDesc.getIsVectorizationReduceSinkNativeEnabled();
            String engine = this.vectorReduceSinkDesc.getEngine();
            String engineInSupportedCondName = HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname + " " + engine + " IN " + vectorizableReduceSinkNativeEngines;
            boolean engineInSupported = vectorizableReduceSinkNativeEngines.contains(engine);
            VectorizationCondition[] conditions = new VectorizationCondition[]{new VectorizationCondition(enabled, HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCESINK_NEW_ENABLED.varname), new VectorizationCondition(engineInSupported, engineInSupportedCondName), new VectorizationCondition(!this.vectorReduceSinkDesc.getHasPTFTopN(), "No PTF TopN"), new VectorizationCondition(!this.vectorReduceSinkDesc.getHasDistinctColumns(), "No DISTINCT columns"), new VectorizationCondition(this.vectorReduceSinkDesc.getIsKeyBinarySortable(), "BinarySortableSerDe for keys"), new VectorizationCondition(this.vectorReduceSinkDesc.getIsValueLazyBinary(), "LazyBinarySerDe for values")};
            if (this.vectorReduceSinkDesc.getIsUnexpectedCondition()) {
                VectorizationCondition[] newConditions = new VectorizationCondition[conditions.length + 1];
                System.arraycopy(conditions, 0, newConditions, 0, conditions.length);
                newConditions[conditions.length] = new VectorizationCondition(false, "NOT UnexpectedCondition");
                conditions = newConditions;
            }
            return conditions;
        }

        @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="nativeConditionsMet", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getNativeConditionsMet() {
            if (this.nativeConditions == null) {
                this.nativeConditions = this.createNativeConditions();
            }
            return VectorizationCondition.getConditionsMet(this.nativeConditions);
        }

        @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="nativeConditionsNotMet", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getNativeConditionsNotMet() {
            if (this.nativeConditions == null) {
                this.nativeConditions = this.createNativeConditions();
            }
            return VectorizationCondition.getConditionsNotMet(this.nativeConditions);
        }
    }

    public static enum ReducerTraits {
        UNSET(0),
        FIXED(1),
        AUTOPARALLEL(2),
        UNIFORM(3),
        QUICKSTART(4);

        private final int trait;

        private ReducerTraits(int trait) {
            this.trait = trait;
        }
    }
}

