/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.mapper;

import io.prestosql.hive.$internal.com.google.common.base.Charsets;
import io.prestosql.hive.$internal.org.apache.commons.lang3.concurrent.BasicThreadFactory;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.optimizer.signature.RuntimeStatsMap;
import org.apache.hadoop.hive.ql.optimizer.signature.RuntimeStatsPersister;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.stats.OperatorStats;
import org.apache.thrift.TException;

class MetastoreStatsConnector
implements StatsSource {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoreStatsConnector.class);
    private final StatsSource ss;
    private ExecutorService executor;

    MetastoreStatsConnector(int cacheSize, int batchSize, StatsSource ss) {
        this.ss = ss;
        this.executor = Executors.newSingleThreadExecutor(new BasicThreadFactory.Builder().namingPattern("Metastore-RuntimeStats-Loader-%d").daemon(true).build());
        this.executor.submit(new RuntimeStatsLoader(cacheSize, batchSize));
    }

    @Override
    public boolean canProvideStatsFor(Class<?> clazz) {
        return this.ss.canProvideStatsFor(clazz);
    }

    @Override
    public Optional<OperatorStats> lookup(OpTreeSignature treeSig) {
        return this.ss.lookup(treeSig);
    }

    @Override
    public void putAll(Map<OpTreeSignature, OperatorStats> map) {
        if (map.size() == 0) {
            return;
        }
        this.ss.putAll(map);
        this.executor.submit(new RuntimeStatsSubmitter(map));
    }

    private RuntimeStat encode(Map<OpTreeSignature, OperatorStats> map) throws IOException {
        String payload = RuntimeStatsPersister.INSTANCE.encode(new RuntimeStatsMap(map));
        RuntimeStat rs = new RuntimeStat();
        rs.setWeight(map.size());
        rs.setPayload(ByteBuffer.wrap(payload.getBytes(Charsets.UTF_8)));
        return rs;
    }

    private Map<OpTreeSignature, OperatorStats> decode(RuntimeStat rs) throws IOException {
        RuntimeStatsMap rsm = RuntimeStatsPersister.INSTANCE.decode(rs.getPayload(), RuntimeStatsMap.class);
        return rsm.toMap();
    }

    public void destroy() {
        this.executor.shutdown();
    }

    static void logException(String msg, Exception e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(msg, e);
        } else {
            LOG.info(msg + ": " + e.getMessage());
        }
    }

    class RuntimeStatsSubmitter
    implements Runnable {
        private Map<OpTreeSignature, OperatorStats> map;

        public RuntimeStatsSubmitter(Map<OpTreeSignature, OperatorStats> map) {
            this.map = map;
        }

        @Override
        public void run() {
            try {
                RuntimeStat rec = MetastoreStatsConnector.this.encode(this.map);
                Hive.get().getMSC().addRuntimeStat(rec);
            }
            catch (IOException | HiveException | TException e) {
                MetastoreStatsConnector.logException("Exception while persisting runtime stat", (Exception)e);
            }
        }
    }

    private class RuntimeStatsLoader
    implements Runnable {
        private int maxEntriesToLoad;
        private int batchSize;

        public RuntimeStatsLoader(int maxEntriesToLoad, int batchSize) {
            this.maxEntriesToLoad = maxEntriesToLoad;
            this.batchSize = batchSize <= 0 ? -1 : batchSize;
        }

        @Override
        public void run() {
            int lastCreateTime = Integer.MAX_VALUE;
            int loadedEntries = 0;
            try {
                List<RuntimeStat> rs;
                while ((rs = Hive.get().getMSC().getRuntimeStats(this.batchSize, lastCreateTime)).size() != 0) {
                    for (RuntimeStat thriftStat : rs) {
                        loadedEntries += thriftStat.getWeight();
                        lastCreateTime = Math.min(lastCreateTime, thriftStat.getCreateTime() - 1);
                        try {
                            MetastoreStatsConnector.this.ss.putAll(MetastoreStatsConnector.this.decode(thriftStat));
                        }
                        catch (IOException e) {
                            MetastoreStatsConnector.logException("Exception while loading runtime stats", e);
                        }
                    }
                    if (this.batchSize > 0 && loadedEntries < this.maxEntriesToLoad) continue;
                    break;
                }
            }
            catch (HiveException | TException e) {
                MetastoreStatsConnector.logException("Exception while reading metastore runtime stats", (Exception)e);
            }
        }
    }
}

