/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.HCatRecordReader;
import org.apache.hive.hcatalog.mapreduce.HCatSplit;
import org.apache.hive.hcatalog.mapreduce.InputJobInfo;
import org.apache.hive.hcatalog.mapreduce.InternalUtil;
import org.apache.hive.hcatalog.mapreduce.PartInfo;

public abstract class HCatBaseInputFormat
extends InputFormat<WritableComparable, HCatRecord> {
    private Class<? extends InputFormat> inputFileFormatClass;

    private static HCatSchema getOutputSchema(Configuration conf) throws IOException {
        String os = conf.get("mapreduce.lib.hcat.output.schema");
        if (os == null) {
            return HCatBaseInputFormat.getTableSchema(conf);
        }
        return (HCatSchema)HCatUtil.deserialize(os);
    }

    public static void setOutputSchema(Job job, HCatSchema hcatSchema) throws IOException {
        job.getConfiguration().set("mapreduce.lib.hcat.output.schema", HCatUtil.serialize(hcatSchema));
    }

    protected static org.apache.hadoop.mapred.InputFormat<WritableComparable, Writable> getMapRedInputFormat(JobConf job, Class inputFormatClass) throws IOException {
        return (org.apache.hadoop.mapred.InputFormat)ReflectionUtils.newInstance((Class)inputFormatClass, (Configuration)job);
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        InputJobInfo inputJobInfo;
        Configuration conf = jobContext.getConfiguration();
        conf.setBoolean("mapred.input.dir.recursive", true);
        try {
            inputJobInfo = HCatBaseInputFormat.getJobInfo(conf);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        List<PartInfo> partitionInfoList = inputJobInfo.getPartitions();
        if (partitionInfoList == null) {
            return splits;
        }
        Map<String, String> hiveProps = null;
        for (PartInfo partitionInfo : partitionInfoList) {
            org.apache.hadoop.mapred.InputSplit[] baseSplits;
            List<String> setInputPath;
            JobConf jobConf = HCatUtil.getJobConfFromContext(jobContext);
            if (hiveProps == null) {
                hiveProps = HCatUtil.getHCatKeyHiveConf(jobConf);
            }
            if ((setInputPath = this.setInputPath(jobConf, partitionInfo.getLocation())).isEmpty()) continue;
            Map<String, String> jobProperties = partitionInfo.getJobProperties();
            HCatUtil.copyJobPropertiesToJobConf(hiveProps, jobConf);
            HCatUtil.copyJobPropertiesToJobConf(jobProperties, jobConf);
            HiveStorageHandler storageHandler = HCatUtil.getStorageHandler((Configuration)jobConf, partitionInfo);
            Class<? extends org.apache.hadoop.mapred.InputFormat> inputFormatClass = storageHandler.getInputFormatClass();
            org.apache.hadoop.mapred.InputFormat<WritableComparable, Writable> inputFormat = HCatBaseInputFormat.getMapRedInputFormat(jobConf, inputFormatClass);
            int desiredNumSplits = conf.getInt("hcat.desired.partition.num.splits", 0);
            for (org.apache.hadoop.mapred.InputSplit split : baseSplits = inputFormat.getSplits(jobConf, desiredNumSplits)) {
                splits.add(new HCatSplit(partitionInfo, split));
            }
        }
        return splits;
    }

    public RecordReader<WritableComparable, HCatRecord> createRecordReader(InputSplit split, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        HCatSplit hcatSplit = InternalUtil.castToHCatSplit(split);
        PartInfo partitionInfo = hcatSplit.getPartitionInfo();
        if (partitionInfo.getTableInfo() == null) {
            partitionInfo.setTableInfo(((InputJobInfo)HCatUtil.deserialize(taskContext.getConfiguration().get("mapreduce.lib.hcat.job.info"))).getTableInfo());
        }
        TaskAttemptContext jobContext = taskContext;
        Configuration conf = jobContext.getConfiguration();
        HiveStorageHandler storageHandler = HCatUtil.getStorageHandler(conf, partitionInfo);
        JobConf jobConf = HCatUtil.getJobConfFromContext((JobContext)jobContext);
        Map<String, String> jobProperties = partitionInfo.getJobProperties();
        HCatUtil.copyJobPropertiesToJobConf(jobProperties, jobConf);
        Map<String, Object> valuesNotInDataCols = HCatBaseInputFormat.getColValsNotInDataColumns(HCatBaseInputFormat.getOutputSchema(conf), partitionInfo);
        return new HCatRecordReader(storageHandler, valuesNotInDataCols);
    }

    private static Map<String, Object> getColValsNotInDataColumns(HCatSchema outputSchema, PartInfo partInfo) throws HCatException {
        HCatSchema dataSchema = partInfo.getPartitionSchema();
        HashMap<String, Object> vals = new HashMap<String, Object>();
        for (String fieldName : outputSchema.getFieldNames()) {
            if (dataSchema.getPosition(fieldName) != null) continue;
            if (partInfo.getPartitionValues().containsKey(fieldName)) {
                HCatFieldSchema fschema = outputSchema.get(fieldName);
                ObjectInspector oi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(fschema.getTypeInfo());
                Object objVal = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, oi).convert(partInfo.getPartitionValues().get(fieldName));
                vals.put(fieldName, objVal);
                continue;
            }
            vals.put(fieldName, null);
        }
        return vals;
    }

    public static HCatSchema getTableSchema(Configuration conf) throws IOException {
        InputJobInfo inputJobInfo = HCatBaseInputFormat.getJobInfo(conf);
        HCatSchema allCols = new HCatSchema(new LinkedList<HCatFieldSchema>());
        for (HCatFieldSchema field : inputJobInfo.getTableInfo().getDataColumns().getFields()) {
            allCols.append(field);
        }
        for (HCatFieldSchema field : inputJobInfo.getTableInfo().getPartitionColumns().getFields()) {
            allCols.append(field);
        }
        return allCols;
    }

    private static InputJobInfo getJobInfo(Configuration conf) throws IOException {
        String jobString = conf.get("mapreduce.lib.hcat.job.info");
        if (jobString == null) {
            throw new IOException("job information not found in JobContext. HCatInputFormat.setInput() not called?");
        }
        return (InputJobInfo)HCatUtil.deserialize(jobString);
    }

    private List<String> setInputPath(JobConf jobConf, String location) throws IOException {
        int length = location.length();
        int curlyOpen = 0;
        int pathStart = 0;
        boolean globPattern = false;
        ArrayList<String> pathStrings = new ArrayList<String>();
        block5: for (int i = 0; i < length; ++i) {
            char ch = location.charAt(i);
            switch (ch) {
                case '{': {
                    ++curlyOpen;
                    if (globPattern) continue block5;
                    globPattern = true;
                    continue block5;
                }
                case '}': {
                    if (--curlyOpen != 0 || !globPattern) continue block5;
                    globPattern = false;
                    continue block5;
                }
                case ',': {
                    if (globPattern) continue block5;
                    pathStrings.add(location.substring(pathStart, i));
                    pathStart = i + 1;
                }
            }
        }
        pathStrings.add(location.substring(pathStart, length));
        String separator = "";
        StringBuilder str = new StringBuilder();
        boolean ignoreInvalidPath = jobConf.getBoolean("hcat.input.ignore.invalid.path", false);
        Iterator pathIterator = pathStrings.iterator();
        while (pathIterator.hasNext()) {
            String pathString = (String)pathIterator.next();
            if (ignoreInvalidPath && StringUtils.isBlank(pathString)) continue;
            Path path = new Path(pathString);
            FileSystem fs = path.getFileSystem((Configuration)jobConf);
            if (ignoreInvalidPath && !fs.exists(path)) {
                pathIterator.remove();
                continue;
            }
            String qualifiedPath = fs.makeQualified(path).toString();
            str.append(separator).append(org.apache.hadoop.util.StringUtils.escapeString((String)qualifiedPath));
            separator = ",";
        }
        if (!ignoreInvalidPath || !pathStrings.isEmpty()) {
            jobConf.set("mapred.input.dir", str.toString());
        }
        return pathStrings;
    }
}

