/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hive.hcatalog.common.ErrorType;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.HCatInputFormat;
import org.apache.hive.hcatalog.mapreduce.HCatTableInfo;
import org.apache.hive.hcatalog.mapreduce.InputJobInfo;
import org.apache.hive.hcatalog.mapreduce.InternalUtil;
import org.apache.hive.hcatalog.mapreduce.PartInfo;
import org.apache.hive.hcatalog.mapreduce.StorerInfo;

class InitializeInput {
    private static final Logger LOG = LoggerFactory.getLogger(InitializeInput.class);

    InitializeInput() {
    }

    public static void setInput(Job job, InputJobInfo theirInputJobInfo) throws Exception {
        InitializeInput.setInput(job.getConfiguration(), theirInputJobInfo);
    }

    public static void setInput(Configuration conf, InputJobInfo theirInputJobInfo) throws Exception {
        InputJobInfo inputJobInfo = InputJobInfo.create(theirInputJobInfo.getDatabaseName(), theirInputJobInfo.getTableName(), theirInputJobInfo.getFilter(), theirInputJobInfo.getProperties());
        conf.set("mapreduce.lib.hcat.job.info", HCatUtil.serialize(InitializeInput.getInputJobInfo(conf, inputJobInfo, null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputJobInfo getInputJobInfo(Configuration conf, InputJobInfo inputJobInfo, String locationFilter) throws Exception {
        InputJobInfo inputJobInfo2;
        IMetaStoreClient client = null;
        HiveConf hiveConf = null;
        try {
            hiveConf = conf != null ? HCatUtil.getHiveConf(conf) : new HiveConf(HCatInputFormat.class);
            client = HCatUtil.getHiveMetastoreClient(hiveConf);
            Table table = HCatUtil.getTable(client, inputJobInfo.getDatabaseName(), inputJobInfo.getTableName());
            ArrayList<PartInfo> partInfoList = new ArrayList<PartInfo>();
            inputJobInfo.setTableInfo(HCatTableInfo.valueOf(table.getTTable()));
            if (table.getPartitionKeys().size() != 0) {
                List<org.apache.hadoop.hive.metastore.api.Partition> parts = client.listPartitionsByFilter(inputJobInfo.getDatabaseName(), inputJobInfo.getTableName(), inputJobInfo.getFilter(), (short)-1);
                int maxPart = hiveConf.getInt("hcat.metastore.maxpartitions", 100000);
                if (parts != null && parts.size() > maxPart) {
                    throw new HCatException(ErrorType.ERROR_EXCEED_MAXPART, "total number of partitions is " + parts.size());
                }
                for (org.apache.hadoop.hive.metastore.api.Partition ptn : parts) {
                    HCatSchema schema = HCatUtil.extractSchema(new Partition(table, ptn));
                    PartInfo partInfo = InitializeInput.extractPartInfo(schema, ptn.getSd(), ptn.getParameters(), conf, inputJobInfo);
                    partInfo.setPartitionValues(InternalUtil.createPtnKeyValueMap(table, ptn));
                    partInfoList.add(partInfo);
                }
            } else {
                HCatSchema schema = HCatUtil.extractSchema(table);
                PartInfo partInfo = InitializeInput.extractPartInfo(schema, table.getTTable().getSd(), table.getParameters(), conf, inputJobInfo);
                partInfo.setPartitionValues(new HashMap<String, String>());
                partInfoList.add(partInfo);
            }
            inputJobInfo.setPartitions(partInfoList);
            inputJobInfo2 = inputJobInfo;
        }
        catch (Throwable throwable) {
            HCatUtil.closeHiveClientQuietly(client);
            throw throwable;
        }
        HCatUtil.closeHiveClientQuietly(client);
        return inputJobInfo2;
    }

    private static PartInfo extractPartInfo(HCatSchema schema, StorageDescriptor sd, Map<String, String> parameters, Configuration conf, InputJobInfo inputJobInfo) throws IOException {
        StorerInfo storerInfo = InternalUtil.extractStorerInfo(sd, parameters);
        Properties hcatProperties = new Properties();
        HiveStorageHandler storageHandler = HCatUtil.getStorageHandler(conf, storerInfo);
        Map<String, String> jobProperties = HCatUtil.getInputJobProperties(storageHandler, inputJobInfo);
        for (String key : parameters.keySet()) {
            hcatProperties.put(key, parameters.get(key));
        }
        return new PartInfo(schema, storageHandler, sd.getLocation(), hcatProperties, jobProperties, inputJobInfo.getTableInfo());
    }
}

