/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.HCatTableInfo;

public class PartInfo
implements Serializable {
    private static Logger LOG = LoggerFactory.getLogger(PartInfo.class);
    private static final long serialVersionUID = 1L;
    private HCatSchema partitionSchema;
    private String storageHandlerClassName;
    private String inputFormatClassName;
    private String outputFormatClassName;
    private String serdeClassName;
    private final Properties hcatProperties;
    private final String location;
    private Map<String, String> partitionValues;
    Map<String, String> jobProperties;
    transient HCatTableInfo tableInfo;

    public PartInfo(HCatSchema partitionSchema, HiveStorageHandler storageHandler, String location, Properties hcatProperties, Map<String, String> jobProperties, HCatTableInfo tableInfo) {
        this.partitionSchema = partitionSchema;
        this.location = location;
        this.hcatProperties = hcatProperties;
        this.jobProperties = jobProperties;
        this.tableInfo = tableInfo;
        this.storageHandlerClassName = storageHandler.getClass().getName();
        this.inputFormatClassName = storageHandler.getInputFormatClass().getName();
        this.serdeClassName = storageHandler.getSerDeClass().getName();
        this.outputFormatClassName = storageHandler.getOutputFormatClass().getName();
    }

    public HCatSchema getPartitionSchema() {
        return this.partitionSchema;
    }

    public String getStorageHandlerClassName() {
        return this.storageHandlerClassName;
    }

    public String getInputFormatClassName() {
        return this.inputFormatClassName;
    }

    public String getOutputFormatClassName() {
        return this.outputFormatClassName;
    }

    public String getSerdeClassName() {
        return this.serdeClassName;
    }

    public Properties getInputStorageHandlerProperties() {
        return this.hcatProperties;
    }

    public String getLocation() {
        return this.location;
    }

    public void setPartitionValues(Map<String, String> partitionValues) {
        this.partitionValues = partitionValues;
    }

    public Map<String, String> getPartitionValues() {
        return this.partitionValues;
    }

    public Map<String, String> getJobProperties() {
        return this.jobProperties;
    }

    public HCatTableInfo getTableInfo() {
        return this.tableInfo;
    }

    void setTableInfo(HCatTableInfo thatTableInfo) {
        this.tableInfo = thatTableInfo;
        this.restoreLocalInfoFromTableInfo();
    }

    private void restoreLocalInfoFromTableInfo() {
        assert (this.tableInfo != null) : "TableInfo can't be null at this point.";
        if (this.partitionSchema == null) {
            this.partitionSchema = this.tableInfo.getDataColumns();
        }
        if (this.storageHandlerClassName == null) {
            this.storageHandlerClassName = this.tableInfo.getStorerInfo().getStorageHandlerClass();
        }
        if (this.inputFormatClassName == null) {
            this.inputFormatClassName = this.tableInfo.getStorerInfo().getIfClass();
        }
        if (this.outputFormatClassName == null) {
            this.outputFormatClassName = this.tableInfo.getStorerInfo().getOfClass();
        }
        if (this.serdeClassName == null) {
            this.serdeClassName = this.tableInfo.getStorerInfo().getSerdeClass();
        }
    }

    private void dedupWithTableInfo() {
        assert (this.tableInfo != null) : "TableInfo can't be null at this point.";
        if (this.partitionSchema != null) {
            if (this.partitionSchema.equals(this.tableInfo.getDataColumns())) {
                this.partitionSchema = null;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Can't suppress data-schema. Partition-schema and table-schema seem to differ!  partitionSchema: " + this.partitionSchema.getFields() + " tableSchema: " + this.tableInfo.getDataColumns());
            }
        }
        if (this.storageHandlerClassName != null) {
            if (this.storageHandlerClassName.equals(this.tableInfo.getStorerInfo().getStorageHandlerClass())) {
                this.storageHandlerClassName = null;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Partition's storageHandler (" + this.storageHandlerClassName + ") differs from table's storageHandler (" + this.tableInfo.getStorerInfo().getStorageHandlerClass() + ").");
            }
        }
        if (this.inputFormatClassName != null) {
            if (this.inputFormatClassName.equals(this.tableInfo.getStorerInfo().getIfClass())) {
                this.inputFormatClassName = null;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Partition's InputFormat (" + this.inputFormatClassName + ") differs from table's InputFormat (" + this.tableInfo.getStorerInfo().getIfClass() + ").");
            }
        }
        if (this.outputFormatClassName != null) {
            if (this.outputFormatClassName.equals(this.tableInfo.getStorerInfo().getOfClass())) {
                this.outputFormatClassName = null;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Partition's OutputFormat (" + this.outputFormatClassName + ") differs from table's OutputFormat (" + this.tableInfo.getStorerInfo().getOfClass() + ").");
            }
        }
        if (this.serdeClassName != null) {
            if (this.serdeClassName.equals(this.tableInfo.getStorerInfo().getSerdeClass())) {
                this.serdeClassName = null;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Partition's SerDe (" + this.serdeClassName + ") differs from table's SerDe (" + this.tableInfo.getStorerInfo().getSerdeClass() + ").");
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.dedupWithTableInfo();
        oos.defaultWriteObject();
        this.restoreLocalInfoFromTableInfo();
    }
}

