/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.plain;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.bitpacking.ByteBitPackingValuesReader;
import org.apache.parquet.column.values.bitpacking.Packer;

public class BooleanPlainValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(BooleanPlainValuesReader.class);
    private ByteBitPackingValuesReader in = new ByteBitPackingValuesReader(1, Packer.LITTLE_ENDIAN);

    @Override
    public boolean readBoolean() {
        return this.in.readInteger() != 0;
    }

    @Override
    public void skip() {
        this.in.readInteger();
    }

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream stream) throws IOException {
        LOG.debug("init from page at offset {} for length {}", (Object)stream.position(), (Object)stream.available());
        this.in.initFromPage(valueCount, stream);
    }

    @Override
    @Deprecated
    public int getNextOffset() {
        return this.in.getNextOffset();
    }
}

