/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import io.airlift.testing.Closeables;
import io.prestosql.Session;
import io.prestosql.plugin.jdbc.JdbcPlugin;
import io.prestosql.plugin.jdbc.TestingH2JdbcModule;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.spi.Plugin;
import io.prestosql.testing.DistributedQueryRunner;
import io.prestosql.testing.QueryAssertions;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingSession;
import io.prestosql.tpch.TpchTable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public final class H2QueryRunner {
    private static final String TPCH_SCHEMA = "tpch";

    private H2QueryRunner() {
    }

    public static DistributedQueryRunner createH2QueryRunner(TpchTable<?> ... tables) throws Exception {
        return H2QueryRunner.createH2QueryRunner(ImmutableList.copyOf((Object[])tables));
    }

    public static DistributedQueryRunner createH2QueryRunner(Iterable<TpchTable<?>> tables) throws Exception {
        return H2QueryRunner.createH2QueryRunner(tables, TestingH2JdbcModule.createProperties());
    }

    public static DistributedQueryRunner createH2QueryRunner(Iterable<TpchTable<?>> tables, Map<String, String> properties) throws Exception {
        DistributedQueryRunner queryRunner = null;
        try {
            queryRunner = DistributedQueryRunner.builder((Session)H2QueryRunner.createSession()).build();
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog(TPCH_SCHEMA, TPCH_SCHEMA);
            H2QueryRunner.createSchema(properties, TPCH_SCHEMA);
            queryRunner.installPlugin((Plugin)new JdbcPlugin("base-jdbc", (Module)new TestingH2JdbcModule()));
            queryRunner.createCatalog("jdbc", "base-jdbc", properties);
            QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)TPCH_SCHEMA, (String)"tiny", (Session)H2QueryRunner.createSession(), tables);
            return queryRunner;
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
    }

    private static void createSchema(Map<String, String> properties, String schema) throws SQLException {
        try (Connection connection = DriverManager.getConnection(properties.get("connection-url"));
             Statement statement = connection.createStatement();){
            statement.execute("CREATE SCHEMA " + schema);
        }
    }

    public static Session createSession() {
        return TestingSession.testSessionBuilder().setCatalog("jdbc").setSchema(TPCH_SCHEMA).build();
    }
}

