/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcOutputTableHandle;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Locale;
import java.util.Map;
import javax.inject.Provider;
import org.testng.Assert;

final class MetadataUtil {
    public static final JsonCodec<JdbcColumnHandle> COLUMN_CODEC;
    public static final JsonCodec<JdbcTableHandle> TABLE_CODEC;
    public static final JsonCodec<JdbcOutputTableHandle> OUTPUT_TABLE_CODEC;

    private MetadataUtil() {
    }

    public static <T> void assertJsonRoundTrip(JsonCodec<T> codec, T object) {
        String json = codec.toJson(object);
        Object copy = codec.fromJson(json);
        Assert.assertEquals((Object)copy, object);
    }

    static {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new TestingTypeDeserializer())));
        JsonCodecFactory codecFactory = new JsonCodecFactory((Provider)provider);
        COLUMN_CODEC = codecFactory.jsonCodec(JdbcColumnHandle.class);
        TABLE_CODEC = codecFactory.jsonCodec(JdbcTableHandle.class);
        OUTPUT_TABLE_CODEC = codecFactory.jsonCodec(JdbcOutputTableHandle.class);
    }

    public static final class TestingTypeDeserializer
    extends FromStringDeserializer<Type> {
        private final Map<String, Type> types = ImmutableMap.of((Object)"bigint", (Object)BigintType.BIGINT, (Object)"varchar", (Object)VarcharType.VARCHAR);

        public TestingTypeDeserializer() {
            super(Type.class);
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            Type type = this.types.get(value.toLowerCase(Locale.ENGLISH));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type %s", (Object)value);
            return type;
        }
    }
}

