/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBaseJdbcConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((BaseJdbcConfig)ConfigAssertions.recordDefaults(BaseJdbcConfig.class)).setConnectionUrl(null).setCaseInsensitiveNameMatching(false).setCaseInsensitiveNameMatchingCacheTtl(new Duration(1.0, TimeUnit.MINUTES)).setJdbcTypesMappedToVarchar("").setMetadataCacheTtl(Duration.valueOf((String)"0m")).setCacheMissing(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"connection-url", (Object)"jdbc:h2:mem:config").put((Object)"case-insensitive-name-matching", (Object)"true").put((Object)"case-insensitive-name-matching.cache-ttl", (Object)"1s").put((Object)"jdbc-types-mapped-to-varchar", (Object)"mytype,struct_type1").put((Object)"metadata.cache-ttl", (Object)"1s").put((Object)"metadata.cache-missing", (Object)"true").build();
        BaseJdbcConfig expected = new BaseJdbcConfig().setConnectionUrl("jdbc:h2:mem:config").setCaseInsensitiveNameMatching(true).setCaseInsensitiveNameMatchingCacheTtl(new Duration(1.0, TimeUnit.SECONDS)).setJdbcTypesMappedToVarchar("mytype, struct_type1").setMetadataCacheTtl(Duration.valueOf((String)"1s")).setCacheMissing(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
        Assert.assertEquals((Set)expected.getJdbcTypesMappedToVarchar(), (Set)ImmutableSet.of((Object)"mytype", (Object)"struct_type1"));
    }

    @Test
    public void testConnectionUrlIsValid() {
        Assertions.assertThatThrownBy(() -> TestBaseJdbcConfig.buildConfig((Map<String, String>)ImmutableMap.of((Object)"connection-url", (Object)"jdbc:"))).hasMessageContaining("must match the following regular expression: ^jdbc:[a-z0-9]+:(?s:.*)$");
        Assertions.assertThatThrownBy(() -> TestBaseJdbcConfig.buildConfig((Map<String, String>)ImmutableMap.of((Object)"connection-url", (Object)"jdbc:protocol"))).hasMessageContaining("must match the following regular expression: ^jdbc:[a-z0-9]+:(?s:.*)$");
        TestBaseJdbcConfig.buildConfig((Map<String, String>)ImmutableMap.of((Object)"connection-url", (Object)"jdbc:protocol:uri"));
        TestBaseJdbcConfig.buildConfig((Map<String, String>)ImmutableMap.of((Object)"connection-url", (Object)"jdbc:protocol:"));
    }

    private static void buildConfig(Map<String, String> properties) {
        ConfigurationFactory configurationFactory = new ConfigurationFactory(properties);
        configurationFactory.build(BaseJdbcConfig.class);
    }
}

