/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.TestingDatabase;
import io.prestosql.plugin.jdbc.TestingJdbcTypeHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.TestingSession;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJdbcClient {
    private static final ConnectorSession session = TestingSession.testSessionBuilder().build().toConnectorSession();
    private TestingDatabase database;
    private String catalogName;
    private JdbcClient jdbcClient;

    @BeforeClass
    public void setUp() throws Exception {
        this.database = new TestingDatabase();
        this.catalogName = this.database.getConnection().getCatalog();
        this.jdbcClient = this.database.getJdbcClient();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.database.close();
    }

    @Test
    public void testMetadata() {
        Assert.assertTrue((boolean)this.jdbcClient.getSchemaNames(session).containsAll((Collection<?>)ImmutableSet.of((Object)"example", (Object)"tpch")));
        Assert.assertEquals((Collection)this.jdbcClient.getTableNames(session, Optional.of("example")), (Collection)ImmutableList.of((Object)new SchemaTableName("example", "numbers"), (Object)new SchemaTableName("example", "view_source"), (Object)new SchemaTableName("example", "view")));
        Assert.assertEquals((Collection)this.jdbcClient.getTableNames(session, Optional.of("tpch")), (Collection)ImmutableList.of((Object)new SchemaTableName("tpch", "lineitem"), (Object)new SchemaTableName("tpch", "orders")));
        SchemaTableName schemaTableName = new SchemaTableName("example", "numbers");
        Optional table = this.jdbcClient.getTableHandle(session, schemaTableName);
        Assert.assertTrue((boolean)table.isPresent(), (String)"table is missing");
        Assert.assertEquals((String)((JdbcTableHandle)table.get()).getCatalogName(), (String)this.catalogName.toUpperCase(Locale.ENGLISH));
        Assert.assertEquals((String)((JdbcTableHandle)table.get()).getSchemaName(), (String)"EXAMPLE");
        Assert.assertEquals((String)((JdbcTableHandle)table.get()).getTableName(), (String)"NUMBERS");
        Assert.assertEquals((Object)((JdbcTableHandle)table.get()).getSchemaTableName(), (Object)schemaTableName);
        Assert.assertEquals((Collection)this.jdbcClient.getColumns(session, (JdbcTableHandle)table.orElse(null)), (Collection)ImmutableList.of((Object)new JdbcColumnHandle("TEXT", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), (Object)new JdbcColumnHandle("TEXT_SHORT", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.createVarcharType((int)32)), (Object)new JdbcColumnHandle("VALUE", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT)));
    }

    @Test
    public void testMetadataWithSchemaPattern() {
        SchemaTableName schemaTableName = new SchemaTableName("exa_ple", "num_ers");
        Optional table = this.jdbcClient.getTableHandle(session, schemaTableName);
        Assert.assertTrue((boolean)table.isPresent(), (String)"table is missing");
        Assert.assertEquals((Collection)this.jdbcClient.getColumns(session, (JdbcTableHandle)table.get()), (Collection)ImmutableList.of((Object)new JdbcColumnHandle("TE_T", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), (Object)new JdbcColumnHandle("VA%UE", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT)));
    }

    @Test
    public void testMetadataWithFloatAndDoubleCol() {
        SchemaTableName schemaTableName = new SchemaTableName("exa_ple", "table_with_float_col");
        Optional table = this.jdbcClient.getTableHandle(session, schemaTableName);
        Assert.assertTrue((boolean)table.isPresent(), (String)"table is missing");
        Assert.assertEquals((Collection)this.jdbcClient.getColumns(session, (JdbcTableHandle)table.get()), (Collection)ImmutableList.of((Object)new JdbcColumnHandle("COL1", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT), (Object)new JdbcColumnHandle("COL2", TestingJdbcTypeHandle.JDBC_DOUBLE, (Type)DoubleType.DOUBLE), (Object)new JdbcColumnHandle("COL3", TestingJdbcTypeHandle.JDBC_DOUBLE, (Type)DoubleType.DOUBLE), (Object)new JdbcColumnHandle("COL4", TestingJdbcTypeHandle.JDBC_REAL, (Type)RealType.REAL)));
    }
}

