/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.plugin.jdbc.H2QueryRunner;
import io.prestosql.plugin.jdbc.TestingH2JdbcModule;
import io.prestosql.plugin.jdbc.UnsupportedTypeHandling;
import io.prestosql.testing.AbstractTestIntegrationSmokeTest;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.sql.JdbcSqlExecutor;
import io.prestosql.testing.sql.SqlExecutor;
import io.prestosql.testing.sql.TestTable;
import io.prestosql.tpch.TpchTable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.annotations.Test;

public class TestJdbcIntegrationSmokeTest
extends AbstractTestIntegrationSmokeTest {
    private final Map<String, String> properties = TestingH2JdbcModule.createProperties();

    protected QueryRunner createQueryRunner() throws Exception {
        return H2QueryRunner.createH2QueryRunner(ImmutableList.copyOf((Collection)TpchTable.getTables()), this.properties);
    }

    @Test
    public void testUnknownTypeAsIgnored() {
        try (TestTable table = new TestTable((SqlExecutor)this.getSqlExecutor(), "tpch.test_failure_on_unknown_type_as_ignored", "(int_column int, geometry_column GEOMETRY)", (List)ImmutableList.of((Object)"1, NULL", (Object)"2, 'POINT(7 52)'"));){
            Session ignoreUnsupportedType = this.unsupportedTypeHandling(UnsupportedTypeHandling.IGNORE);
            this.assertQuery(ignoreUnsupportedType, "SELECT int_column FROM " + table.getName(), "VALUES 1, 2");
            this.assertQuery(ignoreUnsupportedType, "SELECT * FROM " + table.getName(), "VALUES 1, 2");
            this.assertQuery(ignoreUnsupportedType, "SELECT column_name, data_type FROM information_schema.columns WHERE table_name LIKE 'test_failure_on_unknown_type_as_ignored%'", "VALUES ('int_column', 'integer')");
            this.assertQuery(ignoreUnsupportedType, "DESCRIBE " + table.getName(), "VALUES ('int_column', 'integer', '', '')");
            this.assertUpdate(ignoreUnsupportedType, String.format("INSERT INTO %s (int_column) VALUES (3)", table.getName()), 1L);
            this.assertQuery(ignoreUnsupportedType, "SELECT * FROM " + table.getName(), "VALUES 1, 2, 3");
        }
    }

    @Test
    public void testUnknownTypeAsVarchar() {
        try (TestTable table = new TestTable((SqlExecutor)this.getSqlExecutor(), "tpch.test_failure_on_unknown_type_as_varchar", "(int_column int, geometry_column GEOMETRY)", (List)ImmutableList.of((Object)"1, NULL", (Object)"2, 'POINT(7 52)'"));){
            Session convertToVarcharUnsupportedTypes = this.unsupportedTypeHandling(UnsupportedTypeHandling.CONVERT_TO_VARCHAR);
            this.assertQuery(convertToVarcharUnsupportedTypes, "SELECT int_column FROM " + table.getName(), "VALUES 1, 2");
            this.assertQuery(convertToVarcharUnsupportedTypes, "SELECT * FROM " + table.getName(), "VALUES (1, NULL), (2, 'POINT (7 52)')");
            this.assertQuery(convertToVarcharUnsupportedTypes, String.format("SELECT int_column FROM %s WHERE geometry_column = 'POINT (7 52)'", table.getName()), "VALUES 2");
            this.assertQuery(convertToVarcharUnsupportedTypes, String.format("SELECT int_column FROM %s WHERE geometry_column = 'invalid data'", table.getName()), "SELECT 1 WHERE false");
            this.assertQuery(convertToVarcharUnsupportedTypes, "SELECT column_name, data_type FROM information_schema.columns WHERE table_name LIKE 'test_failure_on_unknown_type_as_varchar%'", "VALUES ('int_column', 'integer'), ('geometry_column', 'varchar')");
            this.assertQuery(convertToVarcharUnsupportedTypes, "DESCRIBE " + table.getName(), "VALUES ('int_column', 'integer', '', ''), ('geometry_column', 'varchar', '','')");
            this.assertUpdate(convertToVarcharUnsupportedTypes, String.format("INSERT INTO %s (int_column) VALUES (3)", table.getName()), 1L);
            this.assertQueryFails(convertToVarcharUnsupportedTypes, String.format("INSERT INTO %s (int_column, geometry_column) VALUES (3, 'POINT (7 52)')", table.getName()), "Underlying type that is mapped to VARCHAR is not supported for INSERT: GEOMETRY");
            this.assertQuery(convertToVarcharUnsupportedTypes, "SELECT * FROM " + table.getName(), "VALUES (1, NULL), (2, 'POINT (7 52)'), (3, NULL)");
        }
    }

    private Session unsupportedTypeHandling(UnsupportedTypeHandling unsupportedTypeHandling) {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty("jdbc", "unsupported_type_handling", unsupportedTypeHandling.name()).build();
    }

    private JdbcSqlExecutor getSqlExecutor() {
        return new JdbcSqlExecutor(this.properties.get("connection-url"), new Properties());
    }
}

