/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.prestosql.plugin.jdbc.ForwardingJdbcClient;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcMetadata;
import io.prestosql.plugin.jdbc.JdbcMetadataConfig;
import io.prestosql.plugin.jdbc.JdbcMetadataSessionProperties;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.TestingDatabase;
import io.prestosql.plugin.jdbc.TestingJdbcTypeHandle;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.AggregateFunction;
import io.prestosql.spi.connector.AggregationApplicationResult;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.TestingConnectorSession;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestJdbcMetadata {
    private TestingDatabase database;
    private JdbcMetadata metadata;
    private JdbcTableHandle tableHandle;

    @BeforeMethod
    public void setUp() throws Exception {
        this.database = new TestingDatabase();
        this.metadata = new JdbcMetadata((JdbcClient)new GroupingSetsEnabledJdbcClient(this.database.getJdbcClient()), false);
        this.tableHandle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "numbers"));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.database.close();
    }

    @Test
    public void testListSchemaNames() {
        Assert.assertTrue((boolean)this.metadata.listSchemaNames(TestingConnectorSession.SESSION).containsAll((Collection<?>)ImmutableSet.of((Object)"example", (Object)"tpch")));
    }

    @Test
    public void testGetTableHandle() {
        JdbcTableHandle tableHandle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "numbers"));
        Assert.assertEquals((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "numbers")), (Object)tableHandle);
        Assert.assertNull((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "unknown")));
        Assert.assertNull((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("unknown", "numbers")));
        Assert.assertNull((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("unknown", "unknown")));
    }

    @Test
    public void testGetColumnHandles() {
        Assert.assertEquals((Map)this.metadata.getColumnHandles(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle), (Map)ImmutableMap.of((Object)"text", (Object)new JdbcColumnHandle("TEXT", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), (Object)"text_short", (Object)new JdbcColumnHandle("TEXT_SHORT", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.createVarcharType((int)32)), (Object)"value", (Object)new JdbcColumnHandle("VALUE", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT)));
        this.unknownTableColumnHandle(new JdbcTableHandle(new SchemaTableName("unknown", "unknown"), "unknown", "unknown", "unknown"));
        this.unknownTableColumnHandle(new JdbcTableHandle(new SchemaTableName("example", "numbers"), null, "example", "unknown"));
    }

    private void unknownTableColumnHandle(JdbcTableHandle tableHandle) {
        try {
            this.metadata.getColumnHandles(TestingConnectorSession.SESSION, (ConnectorTableHandle)tableHandle);
            Assert.fail((String)"Expected getColumnHandle of unknown table to throw a TableNotFoundException");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void getTableMetadata() {
        ConnectorTableMetadata tableMetadata = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle);
        Assert.assertEquals((Object)tableMetadata.getTable(), (Object)new SchemaTableName("example", "numbers"));
        Assert.assertEquals((Collection)tableMetadata.getColumns(), (Collection)ImmutableList.of((Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR, false, null, null, false, Collections.emptyMap()), (Object)new ColumnMetadata("text_short", (Type)VarcharType.createVarcharType((int)32)), (Object)new ColumnMetadata("value", (Type)BigintType.BIGINT)));
        JdbcTableHandle specialTableHandle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("exa_ple", "num_ers"));
        ConnectorTableMetadata specialTableMetadata = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)specialTableHandle);
        Assert.assertEquals((Object)specialTableMetadata.getTable(), (Object)new SchemaTableName("exa_ple", "num_ers"));
        Assert.assertEquals((Collection)specialTableMetadata.getColumns(), (Collection)ImmutableList.of((Object)new ColumnMetadata("te_t", (Type)VarcharType.VARCHAR, false, null, null, false, Collections.emptyMap()), (Object)new ColumnMetadata("va%ue", (Type)BigintType.BIGINT)));
        this.unknownTableMetadata(new JdbcTableHandle(new SchemaTableName("u", "numbers"), null, "unknown", "unknown"));
        this.unknownTableMetadata(new JdbcTableHandle(new SchemaTableName("example", "numbers"), null, "example", "unknown"));
        this.unknownTableMetadata(new JdbcTableHandle(new SchemaTableName("example", "numbers"), null, "unknown", "numbers"));
    }

    private void unknownTableMetadata(JdbcTableHandle tableHandle) {
        try {
            this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)tableHandle);
            Assert.fail((String)"Expected getTableMetadata of unknown table to throw a TableNotFoundException");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testListTables() {
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.empty())), (Set)ImmutableSet.of((Object)new SchemaTableName("example", "numbers"), (Object)new SchemaTableName("example", "view_source"), (Object)new SchemaTableName("example", "view"), (Object)new SchemaTableName("tpch", "orders"), (Object)new SchemaTableName("tpch", "lineitem"), (Object)new SchemaTableName("exa_ple", "table_with_float_col"), (Object[])new SchemaTableName[]{new SchemaTableName("exa_ple", "num_ers")}));
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("example"))), (Set)ImmutableSet.of((Object)new SchemaTableName("example", "numbers"), (Object)new SchemaTableName("example", "view_source"), (Object)new SchemaTableName("example", "view")));
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("tpch"))), (Set)ImmutableSet.of((Object)new SchemaTableName("tpch", "orders"), (Object)new SchemaTableName("tpch", "lineitem")));
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("exa_ple"))), (Set)ImmutableSet.of((Object)new SchemaTableName("exa_ple", "num_ers"), (Object)new SchemaTableName("exa_ple", "table_with_float_col")));
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("unknown"))), (Set)ImmutableSet.of());
    }

    @Test
    public void getColumnMetadata() {
        Assert.assertEquals((Object)this.metadata.getColumnMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle, (ColumnHandle)new JdbcColumnHandle("text", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR)), (Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR));
    }

    @Test
    public void testCreateAndAlterTable() {
        SchemaTableName table = new SchemaTableName("example", "foo");
        this.metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(table, (List)ImmutableList.of((Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR))), false);
        JdbcTableHandle handle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, table);
        ConnectorTableMetadata layout = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle);
        Assert.assertEquals((Object)layout.getTable(), (Object)table);
        Assert.assertEquals((int)layout.getColumns().size(), (int)1);
        Assert.assertEquals(layout.getColumns().get(0), (Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR));
        this.metadata.addColumn(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle, new ColumnMetadata("x", (Type)VarcharType.VARCHAR));
        layout = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle);
        Assert.assertEquals((int)layout.getColumns().size(), (int)2);
        Assert.assertEquals(layout.getColumns().get(0), (Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR));
        Assert.assertEquals(layout.getColumns().get(1), (Object)new ColumnMetadata("x", (Type)VarcharType.VARCHAR));
        JdbcColumnHandle columnHandle = new JdbcColumnHandle("x", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR);
        this.metadata.dropColumn(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle, (ColumnHandle)columnHandle);
        layout = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle);
        Assert.assertEquals((int)layout.getColumns().size(), (int)1);
        Assert.assertEquals(layout.getColumns().get(0), (Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR));
        SchemaTableName newTableName = new SchemaTableName("example", "bar");
        this.metadata.renameTable(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle, newTableName);
        handle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, newTableName);
        layout = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle);
        Assert.assertEquals((Object)layout.getTable(), (Object)newTableName);
        Assert.assertEquals((int)layout.getColumns().size(), (int)1);
        Assert.assertEquals(layout.getColumns().get(0), (Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR));
    }

    @Test
    public void testDropTableTable() {
        try {
            this.metadata.dropTable(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.PERMISSION_DENIED.toErrorCode());
        }
        this.metadata = new JdbcMetadata(this.database.getJdbcClient(), true);
        this.metadata.dropTable(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle);
        try {
            this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_FOUND.toErrorCode());
        }
    }

    @Test
    public void testApplyFilterAfterAggregationPushdown() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        ColumnHandle groupByColumn = (ColumnHandle)this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle).get("text");
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"));
        JdbcTableHandle aggregatedTable = this.applyCountAggregation((ConnectorSession)session, (ConnectorTableHandle)baseTableHandle, (List<List<ColumnHandle>>)ImmutableList.of((Object)ImmutableList.of((Object)groupByColumn)));
        Domain domain = Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"one"));
        JdbcTableHandle tableHandleWithFilter = this.applyConstraint((ConnectorSession)session, (ConnectorTableHandle)aggregatedTable, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)groupByColumn, (Object)domain))));
        Assert.assertEquals((Object)tableHandleWithFilter.getConstraint().getDomains(), Optional.of(ImmutableMap.of((Object)groupByColumn, (Object)domain)));
    }

    @Test
    public void testCombineFiltersWithAggregationPushdown() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        ColumnHandle groupByColumn = (ColumnHandle)this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle).get("text");
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"));
        Domain firstDomain = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"one"), (Object)Slices.utf8Slice((String)"two")));
        JdbcTableHandle filterResult = this.applyConstraint((ConnectorSession)session, (ConnectorTableHandle)baseTableHandle, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)groupByColumn, (Object)firstDomain))));
        JdbcTableHandle aggregatedTable = this.applyCountAggregation((ConnectorSession)session, (ConnectorTableHandle)filterResult, (List<List<ColumnHandle>>)ImmutableList.of((Object)ImmutableList.of((Object)groupByColumn)));
        Domain secondDomain = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"one"), (Object)Slices.utf8Slice((String)"three")));
        JdbcTableHandle tableHandleWithFilter = this.applyConstraint((ConnectorSession)session, (ConnectorTableHandle)aggregatedTable, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)groupByColumn, (Object)secondDomain))));
        Assert.assertEquals((Object)tableHandleWithFilter.getConstraint().getDomains(), Optional.of(ImmutableMap.of((Object)groupByColumn, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"one")))));
    }

    @Test
    public void testNonGroupKeyPredicatePushdown() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        Map columnHandles = this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle);
        ColumnHandle groupByColumn = (ColumnHandle)columnHandles.get("text");
        ColumnHandle nonGroupByColumn = (ColumnHandle)columnHandles.get("value");
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"));
        JdbcTableHandle aggregatedTable = this.applyCountAggregation((ConnectorSession)session, (ConnectorTableHandle)baseTableHandle, (List<List<ColumnHandle>>)ImmutableList.of((Object)ImmutableList.of((Object)groupByColumn)));
        Domain domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)123L);
        Optional filterResult = this.metadata.applyFilter((ConnectorSession)session, (ConnectorTableHandle)aggregatedTable, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)nonGroupByColumn, (Object)domain))));
        Assertions.assertThat((Optional)filterResult).isEmpty();
    }

    @Test
    public void tesMultiGroupKeyPredicatePushdown() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        Map columnHandles = this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle);
        ColumnHandle textColumn = (ColumnHandle)columnHandles.get("text");
        ColumnHandle valueColumn = (ColumnHandle)columnHandles.get("value");
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"));
        JdbcTableHandle aggregatedTable = this.applyCountAggregation((ConnectorSession)session, (ConnectorTableHandle)baseTableHandle, (List<List<ColumnHandle>>)ImmutableList.of((Object)ImmutableList.of((Object)textColumn, (Object)valueColumn), (Object)ImmutableList.of((Object)textColumn)));
        Domain domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)123L);
        Optional filterResult = this.metadata.applyFilter((ConnectorSession)session, (ConnectorTableHandle)aggregatedTable, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)valueColumn, (Object)domain))));
        Assertions.assertThat((Optional)filterResult).isEmpty();
    }

    private JdbcTableHandle applyCountAggregation(ConnectorSession session, ConnectorTableHandle tableHandle, List<List<ColumnHandle>> groupByColumns) {
        Optional aggResult = this.metadata.applyAggregation(session, tableHandle, (List)ImmutableList.of((Object)new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(), List.of(), false, Optional.empty())), (Map)ImmutableMap.of(), groupByColumns);
        Assertions.assertThat((Optional)aggResult).isPresent();
        return (JdbcTableHandle)((AggregationApplicationResult)aggResult.get()).getHandle();
    }

    private JdbcTableHandle applyConstraint(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        Optional filterResult = this.metadata.applyFilter(session, tableHandle, constraint);
        Assertions.assertThat((Optional)filterResult).isPresent();
        return (JdbcTableHandle)((ConstraintApplicationResult)filterResult.get()).getHandle();
    }

    private static class GroupingSetsEnabledJdbcClient
    extends ForwardingJdbcClient {
        private final JdbcClient delegate;

        public GroupingSetsEnabledJdbcClient(JdbcClient jdbcClient) {
            this.delegate = jdbcClient;
        }

        protected JdbcClient delegate() {
            return this.delegate;
        }

        public boolean supportsGroupingSets() {
            return true;
        }
    }
}

