/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.prestosql.plugin.jdbc.JdbcMetadataConfig;
import java.util.Map;
import org.testng.annotations.Test;

public class TestJdbcMetadataConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((JdbcMetadataConfig)ConfigAssertions.recordDefaults(JdbcMetadataConfig.class)).setAllowDropTable(false).setAggregationPushdownEnabled(true).setDomainCompactionThreshold(32));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"allow-drop-table", (Object)"true").put((Object)"aggregation-pushdown.enabled", (Object)"false").put((Object)"domain-compaction-threshold", (Object)"42").build();
        JdbcMetadataConfig expected = new JdbcMetadataConfig().setAllowDropTable(true).setAggregationPushdownEnabled(false).setDomainCompactionThreshold(42);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

