/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import io.airlift.slice.Slices;
import io.prestosql.plugin.jdbc.ForwardingJdbcClient;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcMetadataConfig;
import io.prestosql.plugin.jdbc.JdbcMetadataSessionProperties;
import io.prestosql.plugin.jdbc.QueryBuilder;
import io.prestosql.plugin.jdbc.RemoteTableName;
import io.prestosql.plugin.jdbc.TestingDatabase;
import io.prestosql.plugin.jdbc.TestingJdbcTypeHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.SortedRangeSet;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.SqlTime;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.DateTimeTestingUtils;
import io.prestosql.testing.TestingConnectorSession;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.LongStream;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestJdbcQueryBuilder {
    private static final RemoteTableName TEST_TABLE = new RemoteTableName(Optional.empty(), Optional.empty(), "test_table");
    private static final ConnectorSession SESSION = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig(), Optional.empty()).getSessionProperties()).build();
    private TestingDatabase database;
    private JdbcClient jdbcClient;
    private List<JdbcColumnHandle> columns;
    private String lastQuery;

    @BeforeMethod
    public void setup() throws SQLException {
        this.database = new TestingDatabase();
        final JdbcClient jdbcClient = this.database.getJdbcClient();
        this.jdbcClient = new ForwardingJdbcClient(){

            protected JdbcClient delegate() {
                return jdbcClient;
            }

            public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
                TestJdbcQueryBuilder.this.lastQuery = sql;
                return super.getPreparedStatement(connection, sql);
            }
        };
        CharType charType = CharType.createCharType((long)0L);
        this.columns = ImmutableList.of((Object)new JdbcColumnHandle("col_0", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT), (Object)new JdbcColumnHandle("col_1", TestingJdbcTypeHandle.JDBC_DOUBLE, (Type)DoubleType.DOUBLE), (Object)new JdbcColumnHandle("col_2", TestingJdbcTypeHandle.JDBC_BOOLEAN, (Type)BooleanType.BOOLEAN), (Object)new JdbcColumnHandle("col_3", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), (Object)new JdbcColumnHandle("col_4", TestingJdbcTypeHandle.JDBC_DATE, (Type)DateType.DATE), (Object)new JdbcColumnHandle("col_5", TestingJdbcTypeHandle.JDBC_TIME, (Type)TimeType.TIME), (Object)new JdbcColumnHandle("col_6", TestingJdbcTypeHandle.JDBC_TIMESTAMP, (Type)TimestampType.TIMESTAMP_MILLIS), (Object)new JdbcColumnHandle("col_7", TestingJdbcTypeHandle.JDBC_TINYINT, (Type)TinyintType.TINYINT), (Object)new JdbcColumnHandle("col_8", TestingJdbcTypeHandle.JDBC_SMALLINT, (Type)SmallintType.SMALLINT), (Object)new JdbcColumnHandle("col_9", TestingJdbcTypeHandle.JDBC_INTEGER, (Type)IntegerType.INTEGER), (Object)new JdbcColumnHandle("col_10", TestingJdbcTypeHandle.JDBC_REAL, (Type)RealType.REAL), (Object)new JdbcColumnHandle("col_11", TestingJdbcTypeHandle.JDBC_CHAR, (Type)charType), (Object[])new JdbcColumnHandle[0]);
        Connection connection = this.database.getConnection();
        try (PreparedStatement preparedStatement = connection.prepareStatement("create table \"test_table\" (\"col_0\" BIGINT, \"col_1\" DOUBLE, \"col_2\" BOOLEAN, \"col_3\" VARCHAR(128), \"col_4\" DATE, \"col_5\" TIME, \"col_6\" TIMESTAMP, \"col_7\" TINYINT, \"col_8\" SMALLINT, \"col_9\" INTEGER, \"col_10\" REAL, \"col_11\" CHAR(128) )");){
            preparedStatement.execute();
            StringBuilder stringBuilder = new StringBuilder("insert into \"test_table\" values ");
            int len = 1000;
            LocalDateTime dateTime = LocalDateTime.of(2016, 3, 23, 12, 23, 37);
            for (int i = 0; i < len; ++i) {
                stringBuilder.append(String.format(Locale.ENGLISH, "(%d, %f, %b, 'test_str_%d', '%s', '%s', '%s', %d, %d, %d, %f, 'test_str_%d')", i, 200000.0 + (double)i / 2.0, i % 2 == 0, i, Date.valueOf(dateTime.toLocalDate()), Time.valueOf(dateTime.toLocalTime()), Timestamp.valueOf(dateTime), i % 128, -i, i - 100, Float.valueOf(100.0f + (float)i), i));
                dateTime = dateTime.plusHours(26L);
                if (i == len - 1) continue;
                stringBuilder.append(",");
            }
            try (PreparedStatement preparedStatement2 = connection.prepareStatement(stringBuilder.toString());){
                preparedStatement2.execute();
            }
        }
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws Exception {
        this.database.close();
    }

    @Test
    public void testNormalBuildSql() throws SQLException {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)((ColumnHandle)this.columns.get(0)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)128L), (Object)Range.equal((Type)BigintType.BIGINT, (Object)180L), (Object)Range.equal((Type)BigintType.BIGINT, (Object)233L), (Object)Range.lessThan((Type)BigintType.BIGINT, (Object)25L), (Object)Range.range((Type)BigintType.BIGINT, (Object)66L, (boolean)true, (Object)96L, (boolean)true), (Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)192L))), (boolean)false)).put((Object)((ColumnHandle)this.columns.get(1)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)Range.equal((Type)DoubleType.DOUBLE, (Object)200011.0), (Object)Range.equal((Type)DoubleType.DOUBLE, (Object)200014.0), (Object)Range.equal((Type)DoubleType.DOUBLE, (Object)200017.0), (Object)Range.equal((Type)DoubleType.DOUBLE, (Object)200116.5), (Object)Range.range((Type)DoubleType.DOUBLE, (Object)200030.0, (boolean)true, (Object)200036.0, (boolean)true), (Object)Range.range((Type)DoubleType.DOUBLE, (Object)200048.0, (boolean)true, (Object)200099.0, (boolean)true))), (boolean)false)).put((Object)((ColumnHandle)this.columns.get(7)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)TinyintType.TINYINT, (List)ImmutableList.of((Object)Range.range((Type)TinyintType.TINYINT, (Object)60L, (boolean)true, (Object)70L, (boolean)false), (Object)Range.range((Type)TinyintType.TINYINT, (Object)52L, (boolean)true, (Object)55L, (boolean)false))), (boolean)false)).put((Object)((ColumnHandle)this.columns.get(8)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)SmallintType.SMALLINT, (List)ImmutableList.of((Object)Range.range((Type)SmallintType.SMALLINT, (Object)-75L, (boolean)true, (Object)-68L, (boolean)true), (Object)Range.range((Type)SmallintType.SMALLINT, (Object)-200L, (boolean)true, (Object)-100L, (boolean)false))), (boolean)false)).put((Object)((ColumnHandle)this.columns.get(9)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)Range.equal((Type)IntegerType.INTEGER, (Object)80L), (Object)Range.equal((Type)IntegerType.INTEGER, (Object)96L), (Object)Range.lessThan((Type)IntegerType.INTEGER, (Object)0L))), (boolean)false)).put((Object)((ColumnHandle)this.columns.get(2)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Range.equal((Type)BooleanType.BOOLEAN, (Object)true))), (boolean)false)).build());
        Connection connection = this.database.getConnection();
        try (PreparedStatement preparedStatement = new QueryBuilder(this.jdbcClient).buildSql(SESSION, connection, TEST_TABLE, Optional.empty(), this.columns, tupleDomain, Optional.empty(), Function.identity());){
            Assertions.assertThat((String)this.lastQuery).isEqualTo("SELECT \"col_0\" AS \"col_0\", \"col_1\" AS \"col_1\", \"col_2\" AS \"col_2\", \"col_3\" AS \"col_3\", \"col_4\" AS \"col_4\", \"col_5\" AS \"col_5\", \"col_6\" AS \"col_6\", \"col_7\" AS \"col_7\", \"col_8\" AS \"col_8\", \"col_9\" AS \"col_9\", \"col_10\" AS \"col_10\", \"col_11\" AS \"col_11\" FROM \"test_table\" WHERE (\"col_0\" < ? OR (\"col_0\" >= ? AND \"col_0\" <= ?) OR \"col_0\" > ? OR \"col_0\" IN (?,?)) AND ((\"col_1\" >= ? AND \"col_1\" <= ?) OR (\"col_1\" >= ? AND \"col_1\" <= ?) OR \"col_1\" IN (?,?,?,?)) AND ((\"col_7\" >= ? AND \"col_7\" < ?) OR (\"col_7\" >= ? AND \"col_7\" < ?)) AND ((\"col_8\" >= ? AND \"col_8\" < ?) OR (\"col_8\" >= ? AND \"col_8\" <= ?)) AND (\"col_9\" < ? OR \"col_9\" IN (?,?)) AND \"col_2\" = ?");
            ImmutableSet.Builder builder = ImmutableSet.builder();
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    builder.add((Object)((Long)resultSet.getObject("col_0")));
                }
            }
            Assert.assertEquals((Set)builder.build(), (Set)ImmutableSet.of((Object)68L, (Object)180L, (Object)196L));
        }
    }

    @Test
    public void testBuildSqlWithDomainComplement() throws SQLException {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)((ColumnHandle)this.columns.get(0)), (Object)Domain.create((ValueSet)ValueSet.of((Type)BigintType.BIGINT, (Object)128L, (Object[])new Object[]{180L, 233L}), (boolean)false).complement()).put((Object)((ColumnHandle)this.columns.get(1)), (Object)Domain.create((ValueSet)ValueSet.of((Type)DoubleType.DOUBLE, (Object)200011.0, (Object[])new Object[]{200014.0, 200017.0}), (boolean)true).complement()).put((Object)((ColumnHandle)this.columns.get(9)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)IntegerType.INTEGER, (Object)880L), (Range[])new Range[0]), (boolean)false)).build());
        Connection connection = this.database.getConnection();
        try (PreparedStatement preparedStatement = new QueryBuilder(this.jdbcClient).buildSql(SESSION, connection, TEST_TABLE, Optional.empty(), List.of(this.columns.get(0), this.columns.get(3), this.columns.get(9)), tupleDomain, Optional.empty(), Function.identity());){
            Assertions.assertThat((String)this.lastQuery).isEqualTo("SELECT \"col_0\" AS \"col_0\", \"col_3\" AS \"col_3\", \"col_9\" AS \"col_9\" FROM \"test_table\" WHERE (NOT (\"col_0\" IN (?,?,?)) OR \"col_0\" IS NULL) AND NOT (\"col_1\" IN (?,?,?)) AND \"col_9\" >= ?");
            ImmutableSet.Builder builder = ImmutableSet.builder();
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    builder.add((Object)((Long)resultSet.getObject("col_0")));
                }
            }
            Assert.assertEquals((Collection)builder.build(), (Collection)((Collection)LongStream.range(980L, 1000L).boxed().collect(ImmutableList.toImmutableList())));
        }
    }

    @Test
    public void testBuildSqlWithFloat() throws SQLException {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((ColumnHandle)this.columns.get(10)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)RealType.REAL, (List)ImmutableList.of((Object)Range.equal((Type)RealType.REAL, (Object)Float.floatToRawIntBits(100.0f)), (Object)Range.equal((Type)RealType.REAL, (Object)Float.floatToRawIntBits(100.008f)), (Object)Range.equal((Type)RealType.REAL, (Object)Float.floatToRawIntBits(114.0f)))), (boolean)false)));
        Connection connection = this.database.getConnection();
        try (PreparedStatement preparedStatement = new QueryBuilder(this.jdbcClient).buildSql(SESSION, connection, TEST_TABLE, Optional.empty(), this.columns, tupleDomain, Optional.empty(), Function.identity());){
            Assertions.assertThat((String)this.lastQuery).isEqualTo("SELECT \"col_0\" AS \"col_0\", \"col_1\" AS \"col_1\", \"col_2\" AS \"col_2\", \"col_3\" AS \"col_3\", \"col_4\" AS \"col_4\", \"col_5\" AS \"col_5\", \"col_6\" AS \"col_6\", \"col_7\" AS \"col_7\", \"col_8\" AS \"col_8\", \"col_9\" AS \"col_9\", \"col_10\" AS \"col_10\", \"col_11\" AS \"col_11\" FROM \"test_table\" WHERE \"col_10\" IN (?,?,?)");
            ImmutableSet.Builder longBuilder = ImmutableSet.builder();
            ImmutableSet.Builder floatBuilder = ImmutableSet.builder();
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    longBuilder.add((Object)((Long)resultSet.getObject("col_0")));
                    floatBuilder.add((Object)((Float)resultSet.getObject("col_10")));
                }
            }
            Assert.assertEquals((Set)longBuilder.build(), (Set)ImmutableSet.of((Object)0L, (Object)14L));
            Assert.assertEquals((Set)floatBuilder.build(), (Set)ImmutableSet.of((Object)Float.valueOf(100.0f), (Object)Float.valueOf(114.0f)));
        }
    }

    @Test
    public void testBuildSqlWithVarchar() throws SQLException {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((ColumnHandle)this.columns.get(3)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_str_700"), (boolean)true, (Object)Slices.utf8Slice((String)"test_str_702"), (boolean)false), (Object)Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_str_180")), (Object)Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_str_196")))), (boolean)false)));
        Connection connection = this.database.getConnection();
        try (PreparedStatement preparedStatement = new QueryBuilder(this.jdbcClient).buildSql(SESSION, connection, TEST_TABLE, Optional.empty(), this.columns, tupleDomain, Optional.empty(), Function.identity());){
            Assertions.assertThat((String)this.lastQuery).isEqualTo("SELECT \"col_0\" AS \"col_0\", \"col_1\" AS \"col_1\", \"col_2\" AS \"col_2\", \"col_3\" AS \"col_3\", \"col_4\" AS \"col_4\", \"col_5\" AS \"col_5\", \"col_6\" AS \"col_6\", \"col_7\" AS \"col_7\", \"col_8\" AS \"col_8\", \"col_9\" AS \"col_9\", \"col_10\" AS \"col_10\", \"col_11\" AS \"col_11\" FROM \"test_table\" WHERE ((\"col_3\" >= ? AND \"col_3\" < ?) OR \"col_3\" IN (?,?))");
            ImmutableSet.Builder builder = ImmutableSet.builder();
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    builder.add((Object)((String)resultSet.getObject("col_3")));
                }
            }
            Assert.assertEquals((Set)builder.build(), (Set)ImmutableSet.of((Object)"test_str_700", (Object)"test_str_701", (Object)"test_str_180", (Object)"test_str_196"));
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_3\" >= ?");
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_3\" < ?");
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_3\" IN (?,?)");
        }
    }

    @Test
    public void testBuildSqlWithChar() throws SQLException {
        CharType charType = CharType.createCharType((long)0L);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((ColumnHandle)this.columns.get(11)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)charType, (List)ImmutableList.of((Object)Range.range((Type)charType, (Object)Slices.utf8Slice((String)"test_str_700"), (boolean)true, (Object)Slices.utf8Slice((String)"test_str_702"), (boolean)false), (Object)Range.equal((Type)charType, (Object)Slices.utf8Slice((String)"test_str_180")), (Object)Range.equal((Type)charType, (Object)Slices.utf8Slice((String)"test_str_196")))), (boolean)false)));
        Connection connection = this.database.getConnection();
        try (PreparedStatement preparedStatement = new QueryBuilder(this.jdbcClient).buildSql(SESSION, connection, TEST_TABLE, Optional.empty(), this.columns, tupleDomain, Optional.empty(), Function.identity());){
            Assertions.assertThat((String)this.lastQuery).isEqualTo("SELECT \"col_0\" AS \"col_0\", \"col_1\" AS \"col_1\", \"col_2\" AS \"col_2\", \"col_3\" AS \"col_3\", \"col_4\" AS \"col_4\", \"col_5\" AS \"col_5\", \"col_6\" AS \"col_6\", \"col_7\" AS \"col_7\", \"col_8\" AS \"col_8\", \"col_9\" AS \"col_9\", \"col_10\" AS \"col_10\", \"col_11\" AS \"col_11\" FROM \"test_table\" WHERE ((\"col_11\" >= ? AND \"col_11\" < ?) OR \"col_11\" IN (?,?))");
            ImmutableSet.Builder builder = ImmutableSet.builder();
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    builder.add((Object)((String)resultSet.getObject("col_11")));
                }
            }
            Assert.assertEquals((Set)builder.build(), (Set)ImmutableSet.of((Object)"test_str_700", (Object)"test_str_701", (Object)"test_str_180", (Object)"test_str_196"));
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_11\" >= ?");
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_11\" < ?");
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_11\" IN (?,?)");
        }
    }

    @Test
    public void testBuildSqlWithDateTime() throws SQLException {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((ColumnHandle)this.columns.get(4)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)DateType.DATE, (List)ImmutableList.of((Object)Range.range((Type)DateType.DATE, (Object)TestJdbcQueryBuilder.toDays(2016, 6, 7), (boolean)true, (Object)TestJdbcQueryBuilder.toDays(2016, 6, 17), (boolean)false), (Object)Range.equal((Type)DateType.DATE, (Object)TestJdbcQueryBuilder.toDays(2016, 6, 3)), (Object)Range.equal((Type)DateType.DATE, (Object)TestJdbcQueryBuilder.toDays(2016, 10, 21)))), (boolean)false), (Object)((ColumnHandle)this.columns.get(5)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)TimeType.TIME, (List)ImmutableList.of((Object)Range.range((Type)TimeType.TIME, (Object)TestJdbcQueryBuilder.toTimeRepresentation(6, 12, 23), (boolean)false, (Object)TestJdbcQueryBuilder.toTimeRepresentation(8, 23, 37), (boolean)true), (Object)Range.equal((Type)TimeType.TIME, (Object)TestJdbcQueryBuilder.toTimeRepresentation(2, 3, 4)), (Object)Range.equal((Type)TimeType.TIME, (Object)TestJdbcQueryBuilder.toTimeRepresentation(20, 23, 37)))), (boolean)false)));
        Connection connection = this.database.getConnection();
        try (PreparedStatement preparedStatement = new QueryBuilder(this.jdbcClient).buildSql(SESSION, connection, TEST_TABLE, Optional.empty(), this.columns, tupleDomain, Optional.empty(), Function.identity());){
            Assertions.assertThat((String)this.lastQuery).isEqualTo("SELECT \"col_0\" AS \"col_0\", \"col_1\" AS \"col_1\", \"col_2\" AS \"col_2\", \"col_3\" AS \"col_3\", \"col_4\" AS \"col_4\", \"col_5\" AS \"col_5\", \"col_6\" AS \"col_6\", \"col_7\" AS \"col_7\", \"col_8\" AS \"col_8\", \"col_9\" AS \"col_9\", \"col_10\" AS \"col_10\", \"col_11\" AS \"col_11\" FROM \"test_table\" WHERE ((\"col_4\" >= ? AND \"col_4\" < ?) OR \"col_4\" IN (?,?)) AND ((\"col_5\" > ? AND \"col_5\" <= ?) OR \"col_5\" IN (?,?))");
            ImmutableSet.Builder dateBuilder = ImmutableSet.builder();
            ImmutableSet.Builder timeBuilder = ImmutableSet.builder();
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    dateBuilder.add((Object)((Date)resultSet.getObject("col_4")));
                    timeBuilder.add((Object)((Time)resultSet.getObject("col_5")));
                }
            }
            Assert.assertEquals((Set)dateBuilder.build(), (Set)ImmutableSet.of((Object)TestJdbcQueryBuilder.toDate(2016, 6, 7), (Object)TestJdbcQueryBuilder.toDate(2016, 6, 13), (Object)TestJdbcQueryBuilder.toDate(2016, 10, 21)));
            Assert.assertEquals((Set)timeBuilder.build(), (Set)ImmutableSet.of((Object)TestJdbcQueryBuilder.toTime(8, 23, 37), (Object)TestJdbcQueryBuilder.toTime(20, 23, 37)));
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_4\" >= ?");
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_4\" < ?");
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_4\" IN (?,?)");
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_5\" > ?");
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_5\" <= ?");
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_5\" IN (?,?)");
        }
    }

    @Test
    public void testBuildSqlWithTimestamp() throws SQLException {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((ColumnHandle)this.columns.get(6)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)TimestampType.TIMESTAMP_MILLIS, (List)ImmutableList.of((Object)Range.equal((Type)TimestampType.TIMESTAMP_MILLIS, (Object)TestJdbcQueryBuilder.toPrestoTimestamp(2016, 6, 3, 0, 23, 37)), (Object)Range.equal((Type)TimestampType.TIMESTAMP_MILLIS, (Object)TestJdbcQueryBuilder.toPrestoTimestamp(2016, 10, 19, 16, 23, 37)), (Object)Range.range((Type)TimestampType.TIMESTAMP_MILLIS, (Object)TestJdbcQueryBuilder.toPrestoTimestamp(2016, 6, 7, 8, 23, 37), (boolean)false, (Object)TestJdbcQueryBuilder.toPrestoTimestamp(2016, 6, 9, 12, 23, 37), (boolean)true))), (boolean)false)));
        Connection connection = this.database.getConnection();
        try (PreparedStatement preparedStatement = new QueryBuilder(this.jdbcClient).buildSql(SESSION, connection, TEST_TABLE, Optional.empty(), this.columns, tupleDomain, Optional.empty(), Function.identity());){
            Assertions.assertThat((String)this.lastQuery).isEqualTo("SELECT \"col_0\" AS \"col_0\", \"col_1\" AS \"col_1\", \"col_2\" AS \"col_2\", \"col_3\" AS \"col_3\", \"col_4\" AS \"col_4\", \"col_5\" AS \"col_5\", \"col_6\" AS \"col_6\", \"col_7\" AS \"col_7\", \"col_8\" AS \"col_8\", \"col_9\" AS \"col_9\", \"col_10\" AS \"col_10\", \"col_11\" AS \"col_11\" FROM \"test_table\" WHERE ((\"col_6\" > ? AND \"col_6\" <= ?) OR \"col_6\" IN (?,?))");
            ImmutableSet.Builder builder = ImmutableSet.builder();
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    builder.add((Object)((Timestamp)resultSet.getObject("col_6")));
                }
            }
            Assert.assertEquals((Set)builder.build(), (Set)ImmutableSet.of((Object)TestJdbcQueryBuilder.toTimestamp(2016, 6, 3, 0, 23, 37), (Object)TestJdbcQueryBuilder.toTimestamp(2016, 6, 8, 10, 23, 37), (Object)TestJdbcQueryBuilder.toTimestamp(2016, 6, 9, 12, 23, 37), (Object)TestJdbcQueryBuilder.toTimestamp(2016, 10, 19, 16, 23, 37)));
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_6\" > ?");
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_6\" <= ?");
            io.airlift.testing.Assertions.assertContains((String)preparedStatement.toString(), (String)"\"col_6\" IN (?,?)");
        }
    }

    @Test
    public void testBuildSqlWithLimit() throws SQLException {
        Connection connection = this.database.getConnection();
        Function<String, String> function = sql -> sql + " LIMIT 10";
        try (PreparedStatement preparedStatement = new QueryBuilder(this.jdbcClient).buildSql(SESSION, connection, TEST_TABLE, Optional.empty(), this.columns, TupleDomain.all(), Optional.empty(), function);){
            Assertions.assertThat((String)this.lastQuery).isEqualTo("SELECT \"col_0\" AS \"col_0\", \"col_1\" AS \"col_1\", \"col_2\" AS \"col_2\", \"col_3\" AS \"col_3\", \"col_4\" AS \"col_4\", \"col_5\" AS \"col_5\", \"col_6\" AS \"col_6\", \"col_7\" AS \"col_7\", \"col_8\" AS \"col_8\", \"col_9\" AS \"col_9\", \"col_10\" AS \"col_10\", \"col_11\" AS \"col_11\" FROM \"test_table\" LIMIT 10");
            long count = 0L;
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    ++count;
                }
            }
            Assert.assertEquals((long)count, (long)10L);
        }
    }

    @Test
    public void testEmptyBuildSql() throws SQLException {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((ColumnHandle)this.columns.get(0)), (Object)Domain.all((Type)BigintType.BIGINT), (Object)((ColumnHandle)this.columns.get(1)), (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)));
        Connection connection = this.database.getConnection();
        try (PreparedStatement preparedStatement = new QueryBuilder(this.jdbcClient).buildSql(SESSION, connection, TEST_TABLE, Optional.empty(), this.columns, tupleDomain, Optional.empty(), Function.identity());){
            Assertions.assertThat((String)this.lastQuery).isEqualTo("SELECT \"col_0\" AS \"col_0\", \"col_1\" AS \"col_1\", \"col_2\" AS \"col_2\", \"col_3\" AS \"col_3\", \"col_4\" AS \"col_4\", \"col_5\" AS \"col_5\", \"col_6\" AS \"col_6\", \"col_7\" AS \"col_7\", \"col_8\" AS \"col_8\", \"col_9\" AS \"col_9\", \"col_10\" AS \"col_10\", \"col_11\" AS \"col_11\" FROM \"test_table\" WHERE \"col_1\" IS NULL");
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                Assert.assertEquals((boolean)resultSet.next(), (boolean)false);
            }
        }
    }

    @Test
    public void testAggregation() throws SQLException {
        ImmutableList projectedColumns = ImmutableList.of((Object)this.columns.get(2), (Object)new JdbcColumnHandle(Optional.of("sum(\"col_0\")"), "s", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT, true, Optional.empty()));
        Connection connection = this.database.getConnection();
        try (PreparedStatement preparedStatement = new QueryBuilder(this.jdbcClient).buildSql(SESSION, connection, TEST_TABLE, Optional.of(ImmutableList.of((Object)ImmutableList.of((Object)this.columns.get(2)))), (List)projectedColumns, TupleDomain.all(), Optional.empty(), Function.identity());){
            Assertions.assertThat((String)this.lastQuery).isEqualTo("SELECT \"col_2\" AS \"col_2\", sum(\"col_0\") AS \"s\" FROM \"test_table\" GROUP BY \"col_2\"");
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                Multiset<List<Object>> actual = TestJdbcQueryBuilder.read(resultSet);
                Assertions.assertThat(actual).isEqualTo((Object)ImmutableMultiset.of((Object)ImmutableList.of((Object)false, (Object)BigDecimal.valueOf(250000L)), (Object)ImmutableList.of((Object)true, (Object)BigDecimal.valueOf(249500L))));
            }
        }
    }

    @Test
    public void testAggregationWithFilter() throws SQLException {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((ColumnHandle)this.columns.get(1)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)DoubleType.DOUBLE, (Object)200042.0), (Range[])new Range[0]), (boolean)true)));
        ImmutableList projectedColumns = ImmutableList.of((Object)this.columns.get(2), (Object)new JdbcColumnHandle(Optional.of("sum(\"col_0\")"), "s", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT, true, Optional.empty()));
        Connection connection = this.database.getConnection();
        try (PreparedStatement preparedStatement = new QueryBuilder(this.jdbcClient).buildSql(SESSION, connection, TEST_TABLE, Optional.of(ImmutableList.of((Object)ImmutableList.of((Object)this.columns.get(2)))), (List)projectedColumns, tupleDomain, Optional.empty(), Function.identity());){
            Assertions.assertThat((String)this.lastQuery).isEqualTo("SELECT \"col_2\" AS \"col_2\", sum(\"col_0\") AS \"s\" FROM \"test_table\" WHERE (\"col_1\" < ? OR \"col_1\" IS NULL) GROUP BY \"col_2\"");
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                Multiset<List<Object>> actual = TestJdbcQueryBuilder.read(resultSet);
                Assertions.assertThat(actual).isEqualTo((Object)ImmutableMultiset.of((Object)ImmutableList.of((Object)false, (Object)BigDecimal.valueOf(1764L)), (Object)ImmutableList.of((Object)true, (Object)BigDecimal.valueOf(1722L))));
            }
        }
    }

    private static long toPrestoTimestamp(int year, int month, int day, int hour, int minute, int second) {
        return DateTimeTestingUtils.sqlTimestampOf((int)3, (int)year, (int)month, (int)day, (int)hour, (int)minute, (int)second, (int)0).getMillis() * 1000L;
    }

    private static Timestamp toTimestamp(int year, int month, int day, int hour, int minute, int second) {
        return Timestamp.valueOf(LocalDateTime.of(year, month, day, hour, minute, second));
    }

    private static long toDays(int year, int month, int day) {
        return ChronoUnit.DAYS.between(LocalDate.of(1970, 1, 1), LocalDate.of(year, month, day));
    }

    private static Date toDate(int year, int month, int day) {
        return Date.valueOf(String.format("%d-%d-%d", year, month, day));
    }

    private static Time toTime(int hour, int minute, int second) {
        return Time.valueOf(LocalTime.of(hour, minute, second));
    }

    private static long toTimeRepresentation(int hour, int minute, int second) {
        SqlTime time = DateTimeTestingUtils.sqlTimeOf((int)hour, (int)minute, (int)second, (int)0);
        return time.getPicos();
    }

    private static Multiset<List<Object>> read(ResultSet resultSet) throws SQLException {
        ImmutableMultiset.Builder result = ImmutableMultiset.builder();
        while (resultSet.next()) {
            ImmutableList.Builder row = ImmutableList.builder();
            for (int column = 1; column <= resultSet.getMetaData().getColumnCount(); ++column) {
                row.add(resultSet.getObject(column));
            }
            result.add((Object)row.build());
        }
        return result.build();
    }
}

