/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcRecordSet;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.TestingDatabase;
import io.prestosql.plugin.jdbc.TestingJdbcTypeHandle;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.TestingConnectorSession;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJdbcRecordSet {
    private TestingDatabase database;
    private JdbcClient jdbcClient;
    private JdbcTableHandle table;
    private JdbcSplit split;
    private Map<String, JdbcColumnHandle> columnHandles;

    @BeforeClass
    public void setUp() throws Exception {
        this.database = new TestingDatabase();
        this.jdbcClient = this.database.getJdbcClient();
        this.table = this.database.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "numbers"));
        this.split = this.database.getSplit(TestingConnectorSession.SESSION, this.table);
        this.columnHandles = this.database.getColumnHandles(TestingConnectorSession.SESSION, this.table);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.database.close();
    }

    @Test
    public void testGetColumnTypes() {
        JdbcRecordSet recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of((Object)new JdbcColumnHandle("text", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), (Object)new JdbcColumnHandle("text_short", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.createVarcharType((int)32)), (Object)new JdbcColumnHandle("value", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT)));
        Assert.assertEquals((Collection)recordSet.getColumnTypes(), (Collection)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.createVarcharType((int)32), (Object)BigintType.BIGINT));
        recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of((Object)new JdbcColumnHandle("value", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT), (Object)new JdbcColumnHandle("text", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR)));
        Assert.assertEquals((Collection)recordSet.getColumnTypes(), (Collection)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR));
        recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of((Object)new JdbcColumnHandle("value", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT), (Object)new JdbcColumnHandle("value", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT), (Object)new JdbcColumnHandle("text", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR)));
        Assert.assertEquals((Collection)recordSet.getColumnTypes(), (Collection)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR));
        recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of());
        Assert.assertEquals((Collection)recordSet.getColumnTypes(), (Collection)ImmutableList.of());
    }

    @Test
    public void testCursorSimple() {
        JdbcRecordSet recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of((Object)this.columnHandles.get("text"), (Object)this.columnHandles.get("text_short"), (Object)this.columnHandles.get("value")));
        try (RecordCursor cursor = recordSet.cursor();){
            Assert.assertEquals((Object)cursor.getType(0), (Object)VarcharType.VARCHAR);
            Assert.assertEquals((Object)cursor.getType(1), (Object)VarcharType.createVarcharType((int)32));
            Assert.assertEquals((Object)cursor.getType(2), (Object)BigintType.BIGINT);
            LinkedHashMap<String, Long> data = new LinkedHashMap<String, Long>();
            while (cursor.advanceNextPosition()) {
                data.put(cursor.getSlice(0).toStringUtf8(), cursor.getLong(2));
                Assert.assertEquals((Object)cursor.getSlice(0), (Object)cursor.getSlice(1));
                Assert.assertFalse((boolean)cursor.isNull(0));
                Assert.assertFalse((boolean)cursor.isNull(1));
                Assert.assertFalse((boolean)cursor.isNull(2));
            }
            Assert.assertEquals(data, (Map)ImmutableMap.builder().put((Object)"one", (Object)1L).put((Object)"two", (Object)2L).put((Object)"three", (Object)3L).put((Object)"ten", (Object)10L).put((Object)"eleven", (Object)11L).put((Object)"twelve", (Object)12L).build());
        }
    }

    @Test
    public void testCursorMixedOrder() {
        JdbcRecordSet recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of((Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("text")));
        try (RecordCursor cursor = recordSet.cursor();){
            Assert.assertEquals((Object)cursor.getType(0), (Object)BigintType.BIGINT);
            Assert.assertEquals((Object)cursor.getType(1), (Object)BigintType.BIGINT);
            Assert.assertEquals((Object)cursor.getType(2), (Object)VarcharType.VARCHAR);
            LinkedHashMap<String, Long> data = new LinkedHashMap<String, Long>();
            while (cursor.advanceNextPosition()) {
                Assert.assertEquals((long)cursor.getLong(0), (long)cursor.getLong(1));
                data.put(cursor.getSlice(2).toStringUtf8(), cursor.getLong(0));
            }
            Assert.assertEquals(data, (Map)ImmutableMap.builder().put((Object)"one", (Object)1L).put((Object)"two", (Object)2L).put((Object)"three", (Object)3L).put((Object)"ten", (Object)10L).put((Object)"eleven", (Object)11L).put((Object)"twelve", (Object)12L).build());
        }
    }

    @Test
    public void testIdempotentClose() {
        JdbcRecordSet recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of((Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("text")));
        RecordCursor cursor = recordSet.cursor();
        cursor.close();
        cursor.close();
    }

    private JdbcRecordSet createRecordSet(List<JdbcColumnHandle> columnHandles) {
        return new JdbcRecordSet(this.jdbcClient, TestingConnectorSession.SESSION, this.split, this.table, columnHandles);
    }
}

