/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import io.prestosql.plugin.jdbc.JdbcPlugin;
import io.prestosql.plugin.jdbc.TestingH2JdbcModule;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.testing.TestingConnectorContext;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJmxStats {
    @Test
    public void testJmxStatsExposure() throws Exception {
        JdbcPlugin plugin = new JdbcPlugin("base-jdbc", (Module)new TestingH2JdbcModule());
        ConnectorFactory factory = (ConnectorFactory)Iterables.getOnlyElement((Iterable)plugin.getConnectorFactories());
        factory.create("test", (Map)ImmutableMap.of((Object)"connection-url", (Object)"jdbc:driver:"), (ConnectorContext)new TestingConnectorContext());
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = mbeanServer.queryNames(new ObjectName("io.prestosql.plugin.jdbc:*"), null);
        Assert.assertTrue((boolean)objectNames.containsAll((Collection<?>)ImmutableSet.of((Object)new ObjectName("io.prestosql.plugin.jdbc:type=ConnectionFactory,name=test"), (Object)new ObjectName("io.prestosql.plugin.jdbc:type=JdbcClient,name=test"))));
        for (ObjectName objectName : objectNames) {
            MBeanInfo mbeanInfo = mbeanServer.getMBeanInfo(objectName);
            Assert.assertNotEquals((Object)mbeanInfo.getAttributes().length, (Object)0, (String)String.format("Object %s doesn't expose JMX stats", objectName.getCanonicalName()));
        }
    }
}

