/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.reflect.Reflection;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.RetryingConnectionFactory;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.TestingSession;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.testing.InterfaceTestUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRetryingConnectionFactory {
    @Test
    public void testEverythingImplemented() {
        InterfaceTestUtils.assertAllMethodsOverridden(ConnectionFactory.class, RetryingConnectionFactory.class);
    }

    @Test
    public void testSimplyReturnConnection() throws Exception {
        MockConnectorFactory mock = new MockConnectorFactory(MockConnectorFactory.Action.RETURN);
        RetryingConnectionFactory factory = new RetryingConnectionFactory((ConnectionFactory)mock);
        Assert.assertNotNull((Object)factory.openConnection(TestingSession.SESSION));
        Assert.assertEquals((int)mock.getCallCount(), (int)1);
    }

    @Test
    public void testRetryAndStopOnPrestoException() {
        MockConnectorFactory mock = new MockConnectorFactory(MockConnectorFactory.Action.THROW_SQL_RECOVERABLE_EXCEPTION, MockConnectorFactory.Action.THROW_PRESTO_EXCEPTION);
        RetryingConnectionFactory factory = new RetryingConnectionFactory((ConnectionFactory)mock);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestRetryingConnectionFactory.lambda$testRetryAndStopOnPrestoException$0((ConnectionFactory)factory)).isInstanceOf(PrestoException.class)).hasMessage("Testing presto exception");
        Assert.assertEquals((int)mock.getCallCount(), (int)2);
    }

    @Test
    public void testRetryAndStopOnSqlException() {
        MockConnectorFactory mock = new MockConnectorFactory(MockConnectorFactory.Action.THROW_SQL_RECOVERABLE_EXCEPTION, MockConnectorFactory.Action.THROW_SQL_EXCEPTION);
        RetryingConnectionFactory factory = new RetryingConnectionFactory((ConnectionFactory)mock);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestRetryingConnectionFactory.lambda$testRetryAndStopOnSqlException$1((ConnectionFactory)factory)).isInstanceOf(SQLException.class)).hasMessage("Testing sql exception");
        Assert.assertEquals((int)mock.getCallCount(), (int)2);
    }

    @Test
    public void testNullPointerException() {
        MockConnectorFactory mock = new MockConnectorFactory(MockConnectorFactory.Action.THROW_NPE);
        RetryingConnectionFactory factory = new RetryingConnectionFactory((ConnectionFactory)mock);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestRetryingConnectionFactory.lambda$testNullPointerException$2((ConnectionFactory)factory)).isInstanceOf(NullPointerException.class)).hasMessage("Testing NPE");
        Assert.assertEquals((int)mock.getCallCount(), (int)1);
    }

    @Test
    public void testRetryAndReturn() throws Exception {
        MockConnectorFactory mock = new MockConnectorFactory(MockConnectorFactory.Action.THROW_SQL_RECOVERABLE_EXCEPTION, MockConnectorFactory.Action.RETURN);
        RetryingConnectionFactory factory = new RetryingConnectionFactory((ConnectionFactory)mock);
        Assert.assertNotNull((Object)factory.openConnection(TestingSession.SESSION));
        Assert.assertEquals((int)mock.getCallCount(), (int)2);
    }

    @Test
    public void testRetryOnWrappedAndReturn() throws Exception {
        MockConnectorFactory mock = new MockConnectorFactory(MockConnectorFactory.Action.THROW_WRAPPED_SQL_RECOVERABLE_EXCEPTION, MockConnectorFactory.Action.RETURN);
        RetryingConnectionFactory factory = new RetryingConnectionFactory((ConnectionFactory)mock);
        Assert.assertNotNull((Object)factory.openConnection(TestingSession.SESSION));
        Assert.assertEquals((int)mock.getCallCount(), (int)2);
    }

    private static /* synthetic */ void lambda$testNullPointerException$2(ConnectionFactory factory) throws Throwable {
        factory.openConnection(TestingSession.SESSION);
    }

    private static /* synthetic */ void lambda$testRetryAndStopOnSqlException$1(ConnectionFactory factory) throws Throwable {
        factory.openConnection(TestingSession.SESSION);
    }

    private static /* synthetic */ void lambda$testRetryAndStopOnPrestoException$0(ConnectionFactory factory) throws Throwable {
        factory.openConnection(TestingSession.SESSION);
    }

    public static class MockConnectorFactory
    implements ConnectionFactory {
        private final Deque<Action> actions = new ArrayDeque<Action>();
        private int callCount;

        public MockConnectorFactory(Action ... actions) {
            Stream.of(actions).forEach(this.actions::push);
        }

        public int getCallCount() {
            return this.callCount;
        }

        public Connection openConnection(ConnectorSession session) throws SQLException {
            ++this.callCount;
            Action action = Objects.requireNonNull(this.actions.pollLast(), "actions.pollFirst() is null");
            switch (action) {
                case RETURN: {
                    return (Connection)Reflection.newProxy(Connection.class, (proxy, method, args) -> null);
                }
                case THROW_NPE: {
                    throw new NullPointerException("Testing NPE");
                }
                case THROW_PRESTO_EXCEPTION: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Testing presto exception");
                }
                case THROW_SQL_EXCEPTION: {
                    throw new SQLException("Testing sql exception");
                }
                case THROW_SQL_RECOVERABLE_EXCEPTION: {
                    throw new SQLRecoverableException("Testing sql recoverable exception");
                }
                case THROW_WRAPPED_SQL_RECOVERABLE_EXCEPTION: {
                    throw new RuntimeException(new SQLRecoverableException("Testing sql recoverable exception"));
                }
            }
            throw new IllegalStateException("Unsupported action:" + action);
        }

        public static enum Action {
            THROW_PRESTO_EXCEPTION,
            THROW_SQL_EXCEPTION,
            THROW_SQL_RECOVERABLE_EXCEPTION,
            THROW_WRAPPED_SQL_RECOVERABLE_EXCEPTION,
            THROW_NPE,
            RETURN;

        }
    }
}

