/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.MoreFutures;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.DriverConnectionFactory;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.TestingH2JdbcClient;
import io.prestosql.plugin.jdbc.credential.CredentialProvider;
import io.prestosql.plugin.jdbc.credential.EmptyCredentialProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.NotPartitionedPartitionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.h2.Driver;

final class TestingDatabase
implements AutoCloseable {
    private final Connection connection;
    private final JdbcClient jdbcClient;

    public TestingDatabase() throws SQLException {
        String connectionUrl = "jdbc:h2:mem:test" + System.nanoTime() + ThreadLocalRandom.current().nextLong();
        this.jdbcClient = new TestingH2JdbcClient(new BaseJdbcConfig(), (ConnectionFactory)new DriverConnectionFactory((java.sql.Driver)new Driver(), connectionUrl, new Properties(), (CredentialProvider)new EmptyCredentialProvider()));
        this.connection = DriverManager.getConnection(connectionUrl);
        this.connection.createStatement().execute("CREATE SCHEMA example");
        this.connection.createStatement().execute("CREATE TABLE example.numbers(text varchar primary key, text_short varchar(32), value bigint)");
        this.connection.createStatement().execute("INSERT INTO example.numbers(text, text_short, value) VALUES ('one', 'one', 1),('two', 'two', 2),('three', 'three', 3),('ten', 'ten', 10),('eleven', 'eleven', 11),('twelve', 'twelve', 12)");
        this.connection.createStatement().execute("CREATE TABLE example.view_source(id varchar primary key)");
        this.connection.createStatement().execute("CREATE VIEW example.view AS SELECT id FROM example.view_source");
        this.connection.createStatement().execute("CREATE SCHEMA tpch");
        this.connection.createStatement().execute("CREATE TABLE tpch.orders(orderkey bigint primary key, custkey bigint)");
        this.connection.createStatement().execute("CREATE TABLE tpch.lineitem(orderkey bigint primary key, partkey bigint)");
        this.connection.createStatement().execute("CREATE SCHEMA exa_ple");
        this.connection.createStatement().execute("CREATE TABLE exa_ple.num_ers(te_t varchar primary key, \"VA%UE\" bigint)");
        this.connection.createStatement().execute("CREATE TABLE exa_ple.table_with_float_col(col1 bigint, col2 double, col3 float, col4 real)");
        this.connection.commit();
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    public JdbcTableHandle getTableHandle(ConnectorSession session, SchemaTableName table) {
        return (JdbcTableHandle)this.jdbcClient.getTableHandle(session, table).orElseThrow(() -> new IllegalArgumentException("table not found: " + table));
    }

    public JdbcSplit getSplit(ConnectorSession session, JdbcTableHandle table) {
        ConnectorSplitSource splits = this.jdbcClient.getSplits(session, table);
        return (JdbcSplit)Iterables.getOnlyElement((Iterable)((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)splits.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, 1000))).getSplits());
    }

    public Map<String, JdbcColumnHandle> getColumnHandles(ConnectorSession session, JdbcTableHandle table) {
        return (Map)this.jdbcClient.getColumns(session, table).stream().collect(ImmutableMap.toImmutableMap(column -> column.getColumnMetadata().getName(), Function.identity()));
    }
}

