/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.DriverConnectionFactory;
import io.prestosql.plugin.jdbc.ForBaseJdbc;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.TestingH2JdbcClient;
import io.prestosql.plugin.jdbc.credential.CredentialProvider;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.h2.Driver;

public class TestingH2JdbcModule
implements Module {
    public void configure(Binder binder) {
    }

    @Provides
    @ForBaseJdbc
    public JdbcClient provideJdbcClient(BaseJdbcConfig config, ConnectionFactory connectionFactory) {
        return new TestingH2JdbcClient(config, connectionFactory);
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public ConnectionFactory getConnectionFactory(BaseJdbcConfig config, CredentialProvider credentialProvider) {
        return new DriverConnectionFactory((java.sql.Driver)new Driver(), config, credentialProvider);
    }

    public static Map<String, String> createProperties() {
        return ImmutableMap.builder().put((Object)"connection-url", (Object)String.format("jdbc:h2:mem:test%s;DB_CLOSE_DELAY=-1", System.nanoTime() + ThreadLocalRandom.current().nextLong())).build();
    }
}

