/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.credential;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.bootstrap.Bootstrap;
import io.prestosql.plugin.jdbc.credential.CredentialProvider;
import io.prestosql.plugin.jdbc.credential.CredentialProviderModule;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCredentialProvider {
    @Test
    public void testInlineCredentialProvider() {
        ImmutableMap properties = ImmutableMap.of((Object)"connection-url", (Object)"jdbc:h2:mem:config", (Object)"connection-user", (Object)"user_from_inline", (Object)"connection-password", (Object)"password_for_user_from_inline");
        CredentialProvider credentialProvider = this.getCredentialProvider((Map<String, String>)properties);
        Assert.assertEquals((String)((String)credentialProvider.getConnectionUser(Optional.empty()).get()), (String)"user_from_inline");
        Assert.assertEquals((String)((String)credentialProvider.getConnectionPassword(Optional.empty()).get()), (String)"password_for_user_from_inline");
    }

    @Test
    public void testFileCredentialProvider() {
        ImmutableMap properties = ImmutableMap.of((Object)"connection-url", (Object)"jdbc:h2:mem:config", (Object)"credential-provider.type", (Object)"FILE", (Object)"connection-credential-file", (Object)this.getResourceFilePath("credentials.properties"));
        CredentialProvider credentialProvider = this.getCredentialProvider((Map<String, String>)properties);
        Assert.assertEquals((String)((String)credentialProvider.getConnectionUser(Optional.empty()).get()), (String)"user_from_file");
        Assert.assertEquals((String)((String)credentialProvider.getConnectionPassword(Optional.empty()).get()), (String)"password_for_user_from_file");
    }

    @Test
    public void testKeyStoreBasedCredentialProvider() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"connection-url", (Object)"jdbc:h2:mem:config").put((Object)"credential-provider.type", (Object)"KEYSTORE").put((Object)"keystore-file-path", (Object)this.getResourceFilePath("credentials.jceks")).put((Object)"keystore-type", (Object)"JCEKS").put((Object)"keystore-password", (Object)"keystore_password").put((Object)"keystore-user-credential-name", (Object)"userName").put((Object)"keystore-user-credential-password", (Object)"keystore_password_for_user_name").put((Object)"keystore-password-credential-name", (Object)"password").put((Object)"keystore-password-credential-password", (Object)"keystore_password_for_password").build();
        CredentialProvider credentialProvider = this.getCredentialProvider((Map<String, String>)properties);
        Assert.assertEquals((String)((String)credentialProvider.getConnectionUser(Optional.empty()).get()), (String)"user_from_keystore");
        Assert.assertEquals((String)((String)credentialProvider.getConnectionPassword(Optional.empty()).get()), (String)"password_from_keystore");
    }

    private CredentialProvider getCredentialProvider(Map<String, String> properties) {
        return (CredentialProvider)new Bootstrap((Iterable)ImmutableList.of((Object)new CredentialProviderModule())).setOptionalConfigurationProperties(properties).initialize().getInstance(CredentialProvider.class);
    }

    private String getResourceFilePath(String fileName) {
        return this.getClass().getClassLoader().getResource(fileName).getPath();
    }
}

