/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.credential;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.credential.CredentialProvider;
import io.prestosql.plugin.jdbc.credential.CredentialProviderModule;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestExtraCredentialProvider {
    @Test
    public void testUserNameOverwritten() {
        ImmutableMap properties = ImmutableMap.of((Object)"connection-user", (Object)"default_user", (Object)"connection-password", (Object)"default_password", (Object)"user-credential-name", (Object)"user");
        CredentialProvider credentialProvider = TestExtraCredentialProvider.getCredentialProvider((Map<String, String>)properties);
        Optional<JdbcIdentity> jdbcIdentity = Optional.of(new JdbcIdentity("user", Optional.empty(), (Map)ImmutableMap.of((Object)"user", (Object)"overwritten_user")));
        Assert.assertEquals((String)((String)credentialProvider.getConnectionUser(jdbcIdentity).get()), (String)"overwritten_user");
        Assert.assertEquals((String)((String)credentialProvider.getConnectionPassword(jdbcIdentity).get()), (String)"default_password");
    }

    @Test
    public void testPasswordOverwritten() {
        ImmutableMap properties = ImmutableMap.of((Object)"connection-user", (Object)"default_user", (Object)"connection-password", (Object)"default_password", (Object)"password-credential-name", (Object)"password");
        CredentialProvider credentialProvider = TestExtraCredentialProvider.getCredentialProvider((Map<String, String>)properties);
        Optional<JdbcIdentity> jdbcIdentity = Optional.of(new JdbcIdentity("user", Optional.empty(), (Map)ImmutableMap.of((Object)"password", (Object)"overwritten_password")));
        Assert.assertEquals((String)((String)credentialProvider.getConnectionUser(jdbcIdentity).get()), (String)"default_user");
        Assert.assertEquals((String)((String)credentialProvider.getConnectionPassword(jdbcIdentity).get()), (String)"overwritten_password");
    }

    @Test
    public void testCredentialsOverwritten() {
        ImmutableMap properties = ImmutableMap.of((Object)"connection-user", (Object)"default_user", (Object)"connection-password", (Object)"default_password", (Object)"user-credential-name", (Object)"user", (Object)"password-credential-name", (Object)"password");
        CredentialProvider credentialProvider = TestExtraCredentialProvider.getCredentialProvider((Map<String, String>)properties);
        Optional<JdbcIdentity> jdbcIdentity = Optional.of(new JdbcIdentity("user", Optional.empty(), (Map)ImmutableMap.of((Object)"user", (Object)"overwritten_user", (Object)"password", (Object)"overwritten_password")));
        Assert.assertEquals((String)((String)credentialProvider.getConnectionUser(jdbcIdentity).get()), (String)"overwritten_user");
        Assert.assertEquals((String)((String)credentialProvider.getConnectionPassword(jdbcIdentity).get()), (String)"overwritten_password");
    }

    @Test
    public void testCredentialsNotOverwritten() {
        ImmutableMap properties = ImmutableMap.of((Object)"connection-user", (Object)"default_user", (Object)"connection-password", (Object)"default_password", (Object)"user-credential-name", (Object)"user", (Object)"password-credential-name", (Object)"password");
        CredentialProvider credentialProvider = TestExtraCredentialProvider.getCredentialProvider((Map<String, String>)properties);
        Optional<JdbcIdentity> jdbcIdentity = Optional.of(new JdbcIdentity("user", Optional.empty(), (Map)ImmutableMap.of()));
        Assert.assertEquals((String)((String)credentialProvider.getConnectionUser(jdbcIdentity).get()), (String)"default_user");
        Assert.assertEquals((String)((String)credentialProvider.getConnectionPassword(jdbcIdentity).get()), (String)"default_password");
        jdbcIdentity = Optional.of(new JdbcIdentity("user", Optional.empty(), (Map)ImmutableMap.of((Object)"connection_user", (Object)"overwritten_user", (Object)"connection_password", (Object)"overwritten_password")));
        Assert.assertEquals((String)((String)credentialProvider.getConnectionUser(jdbcIdentity).get()), (String)"default_user");
        Assert.assertEquals((String)((String)credentialProvider.getConnectionPassword(jdbcIdentity).get()), (String)"default_password");
    }

    private static CredentialProvider getCredentialProvider(Map<String, String> properties) {
        return (CredentialProvider)new Bootstrap(new Module[]{new CredentialProviderModule()}).strictConfig().doNotInitializeLogging().quiet().setRequiredConfigurationProperties(properties).initialize().getInstance(CredentialProvider.class);
    }
}

