/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import io.prestosql.plugin.bigquery.BigQueryConfig;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

class BigQueryClient {
    private final BigQuery bigQuery;
    private final Optional<String> viewMaterializationProject;
    private final Optional<String> viewMaterializationDataset;
    private final ConcurrentMap<TableId, TableId> tableIds = new ConcurrentHashMap<TableId, TableId>();
    private final ConcurrentMap<DatasetId, DatasetId> datasetIds = new ConcurrentHashMap<DatasetId, DatasetId>();

    BigQueryClient(BigQuery bigQuery, BigQueryConfig config) {
        this.bigQuery = bigQuery;
        this.viewMaterializationProject = config.getViewMaterializationProject();
        this.viewMaterializationDataset = config.getViewMaterializationDataset();
    }

    private static Optional<String> createWhereClause(String[] filters) {
        return Optional.empty();
    }

    TableInfo getTable(TableId tableId) {
        TableId bigQueryTableId = (TableId)this.tableIds.get(tableId);
        Table table = this.bigQuery.getTable(bigQueryTableId != null ? bigQueryTableId : tableId, new BigQuery.TableOption[0]);
        if (table != null) {
            this.tableIds.putIfAbsent(tableId, table.getTableId());
            this.datasetIds.putIfAbsent(this.toDatasetId(tableId), this.toDatasetId(table.getTableId()));
        }
        return table;
    }

    DatasetId toDatasetId(TableId tableId) {
        return DatasetId.of((String)tableId.getProject(), (String)tableId.getDataset());
    }

    String getProjectId() {
        return ((BigQueryOptions)this.bigQuery.getOptions()).getProjectId();
    }

    Iterable<Dataset> listDatasets(String projectId) {
        Iterator datasets = this.bigQuery.listDatasets(projectId, new BigQuery.DatasetListOption[0]).iterateAll().iterator();
        return () -> Iterators.transform((Iterator)datasets, this::addDataSetMappingIfNeeded);
    }

    Iterable<Table> listTables(DatasetId datasetId, TableDefinition.Type ... types) {
        ImmutableSet allowedTypes = ImmutableSet.copyOf((Object[])types);
        DatasetId bigQueryDatasetId = this.datasetIds.getOrDefault(datasetId, datasetId);
        Iterable allTables = this.bigQuery.listTables(bigQueryDatasetId, new BigQuery.TableListOption[0]).iterateAll();
        return (Iterable)StreamSupport.stream(allTables.spliterator(), false).filter(arg_0 -> BigQueryClient.lambda$listTables$1((Set)allowedTypes, arg_0)).collect(ImmutableList.toImmutableList());
    }

    private Dataset addDataSetMappingIfNeeded(Dataset dataset) {
        DatasetId bigQueryDatasetId = dataset.getDatasetId();
        DatasetId prestoDatasetId = DatasetId.of((String)bigQueryDatasetId.getProject(), (String)bigQueryDatasetId.getDataset().toLowerCase(Locale.ENGLISH));
        this.datasetIds.putIfAbsent(prestoDatasetId, bigQueryDatasetId);
        return dataset;
    }

    TableId createDestinationTable(TableId tableId) {
        String project = this.viewMaterializationProject.orElse(tableId.getProject());
        String dataset = this.viewMaterializationDataset.orElse(tableId.getDataset());
        DatasetId datasetId = this.mapIfNeeded(project, dataset);
        String name = String.format("_pbc_%s", UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", ""));
        return TableId.of((String)datasetId.getProject(), (String)datasetId.getDataset(), (String)name);
    }

    private DatasetId mapIfNeeded(String project, String dataset) {
        DatasetId datasetId = DatasetId.of((String)project, (String)dataset);
        return this.datasetIds.getOrDefault(datasetId, datasetId);
    }

    Table update(TableInfo table) {
        return this.bigQuery.update(table, new BigQuery.TableOption[0]);
    }

    Job create(JobInfo jobInfo) {
        return this.bigQuery.create(jobInfo, new BigQuery.JobOption[0]);
    }

    TableResult query(String sql) {
        try {
            return this.bigQuery.query(QueryJobConfiguration.of((String)sql), new BigQuery.JobOption[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BigQueryException(0, String.format("Failed to run the query [%s]", sql), (Throwable)e);
        }
    }

    String selectSql(TableId table, List<String> requiredColumns) {
        String columns = requiredColumns.isEmpty() ? "*" : requiredColumns.stream().map(column -> String.format("`%s`", column)).collect(Collectors.joining(","));
        return this.selectSql(table, columns, new String[0]);
    }

    String selectSql(TableId table, String formattedColumns, String[] filters) {
        String tableName = this.fullTableName(table);
        String whereClause = BigQueryClient.createWhereClause(filters).map(clause -> "WHERE " + clause).orElse("");
        return String.format("SELECT %s FROM `%s` %s", formattedColumns, tableName, whereClause);
    }

    private String fullTableName(TableId tableId) {
        tableId = this.tableIds.getOrDefault(tableId, tableId);
        return String.format("%s.%s.%s", tableId.getProject(), tableId.getDataset(), tableId.getTable());
    }

    private static /* synthetic */ boolean lambda$listTables$1(Set allowedTypes, Table table) {
        return allowedTypes.contains(table.getDefinition().getType());
    }
}

