/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import io.airlift.log.Logger;
import io.prestosql.plugin.bigquery.BigQueryMetadata;
import io.prestosql.plugin.bigquery.BigQueryPageSourceProvider;
import io.prestosql.plugin.bigquery.BigQuerySplitManager;
import io.prestosql.plugin.bigquery.BigQueryTransactionHandle;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.transaction.IsolationLevel;
import java.util.Objects;
import javax.inject.Inject;

public class BigQueryConnector
implements Connector {
    private static final Logger log = Logger.get(BigQueryConnector.class);
    private final BigQueryMetadata metadata;
    private final BigQuerySplitManager splitManager;
    private final BigQueryPageSourceProvider pageSourceProvider;

    @Inject
    public BigQueryConnector(BigQueryMetadata metadata, BigQuerySplitManager splitManager, BigQueryPageSourceProvider pageSourceProvider) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        log.debug("beginTransaction(isolationLevel=%s, readOnly=%s)", new Object[]{isolationLevel, readOnly});
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        return BigQueryTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }
}

