/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.prestosql.plugin.bigquery.BigQueryConnector;
import io.prestosql.plugin.bigquery.BigQueryConnectorModule;
import io.prestosql.plugin.bigquery.BigQueryHandleResolver;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;

public class BigQueryConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "bigquery";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new BigQueryHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(config, "config is null");
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new BigQueryConnectorModule(context.getNodeManager()), binder -> {
            binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
            binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
        }});
        Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(BigQueryConnector.class);
    }
}

