/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.plugin.bigquery.BigQueryClient;
import io.prestosql.plugin.bigquery.BigQueryConfig;
import io.prestosql.plugin.bigquery.BigQueryConnector;
import io.prestosql.plugin.bigquery.BigQueryCredentialsSupplier;
import io.prestosql.plugin.bigquery.BigQueryMetadata;
import io.prestosql.plugin.bigquery.BigQueryPageSourceProvider;
import io.prestosql.plugin.bigquery.BigQuerySplitManager;
import io.prestosql.plugin.bigquery.BigQueryStorageClientFactory;
import io.prestosql.spi.NodeManager;
import java.util.Optional;

public class BigQueryConnectorModule
implements Module {
    private final NodeManager nodeManager;

    public BigQueryConnectorModule(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    @Provides
    @Singleton
    public static HeaderProvider createHeaderProvider(NodeManager nodeManager) {
        return FixedHeaderProvider.create((String[])new String[]{"user-agent", "prestosql/" + nodeManager.getCurrentNode().getVersion()});
    }

    public void configure(Binder binder) {
        binder.bind(BigQueryStorageClientFactory.class).in(Scopes.SINGLETON);
        binder.bind(BigQueryConnector.class).in(Scopes.SINGLETON);
        binder.bind(BigQueryMetadata.class).in(Scopes.SINGLETON);
        binder.bind(BigQuerySplitManager.class).in(Scopes.SINGLETON);
        binder.bind(BigQueryPageSourceProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(BigQueryConfig.class);
    }

    @Provides
    @Singleton
    public BigQueryCredentialsSupplier provideBigQueryCredentialsSupplier(BigQueryConfig config) {
        return new BigQueryCredentialsSupplier(config.getCredentialsKey(), config.getCredentialsFile());
    }

    @Provides
    @Singleton
    public BigQueryClient provideBigQueryClient(BigQueryConfig config, HeaderProvider headerProvider, BigQueryCredentialsSupplier bigQueryCredentialsSupplier) {
        String billingProjectId = BigQueryConnectorModule.calculateBillingProjectId(config.getParentProjectId(), bigQueryCredentialsSupplier.getCredentials());
        BigQueryOptions.Builder options = (BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setHeaderProvider(headerProvider)).setProjectId(billingProjectId);
        bigQueryCredentialsSupplier.getCredentials().ifPresent(arg_0 -> ((BigQueryOptions.Builder)options).setCredentials(arg_0));
        return new BigQueryClient((BigQuery)options.build().getService(), config);
    }

    static String calculateBillingProjectId(Optional<String> configParentProjectId, Optional<Credentials> credentials) {
        if (configParentProjectId.isPresent()) {
            return configParentProjectId.get();
        }
        if (credentials.isPresent() && credentials.get() instanceof ServiceAccountCredentials) {
            return ((ServiceAccountCredentials)credentials.get()).getProjectId();
        }
        return BigQueryOptions.getDefaultProjectId();
    }
}

