/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.api.client.util.Base64;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Streams;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

class BigQueryCredentialsSupplier {
    private final Supplier<Optional<Credentials>> credentialsCreator;

    public BigQueryCredentialsSupplier(Optional<String> credentialsKey, Optional<String> credentialsFile) {
        Objects.requireNonNull(credentialsKey, "credentialsKey is null");
        Objects.requireNonNull(credentialsFile, "credentialsFile is null");
        this.credentialsCreator = Suppliers.memoize(() -> {
            Optional<Credentials> credentialsFromKey = credentialsKey.map(BigQueryCredentialsSupplier::createCredentialsFromKey);
            Optional<Credentials> credentialsFromFile = credentialsFile.map(BigQueryCredentialsSupplier::createCredentialsFromFile);
            return Stream.of(credentialsFromKey, credentialsFromFile).flatMap(Streams::stream).findFirst();
        });
    }

    private static Credentials createCredentialsFromKey(String key) {
        try {
            return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)key)));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Credentials from key", e);
        }
    }

    private static Credentials createCredentialsFromFile(String file) {
        try {
            return GoogleCredentials.fromStream((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Credentials from file", e);
        }
    }

    Optional<Credentials> getCredentials() {
        return (Optional)this.credentialsCreator.get();
    }
}

