/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.plugin.bigquery.BigQueryColumnHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class BigQueryFilterQueryBuilder {
    private static final String QUOTE = "`";
    private static final String ESCAPED_QUOTE = "``";
    private final TupleDomain<ColumnHandle> tupleDomain;

    public static Optional<String> buildFilter(TupleDomain<ColumnHandle> tupleDomain) {
        return new BigQueryFilterQueryBuilder(tupleDomain).buildFilter();
    }

    private BigQueryFilterQueryBuilder(TupleDomain<ColumnHandle> tupleDomain) {
        this.tupleDomain = tupleDomain;
    }

    private Optional<String> buildFilter() {
        Optional domains = this.tupleDomain.getDomains();
        return domains.map(this::toConjuncts).map(this::concat);
    }

    private String concat(List<String> clauses) {
        return clauses.isEmpty() ? null : clauses.stream().collect(Collectors.joining(" AND "));
    }

    private List<String> toConjuncts(Map<ColumnHandle, Domain> domains) {
        List<BigQueryColumnHandle> columns = domains.keySet().stream().map(BigQueryColumnHandle.class::cast).collect(Collectors.toList());
        return this.toConjuncts(columns);
    }

    private List<String> toConjuncts(List<BigQueryColumnHandle> columns) {
        if (this.tupleDomain.isNone()) {
            return ImmutableList.of((Object)"FALSE");
        }
        ImmutableList.Builder clauses = ImmutableList.builder();
        for (BigQueryColumnHandle column : columns) {
            Domain domain = (Domain)((Map)this.tupleDomain.getDomains().get()).get(column);
            if (domain == null) continue;
            clauses.add((Object)this.toPredicate(column.getName(), domain, column));
        }
        return clauses.build();
    }

    private String toPredicate(String columnName, Domain domain, BigQueryColumnHandle column) {
        if (domain.getValues().isNone()) {
            return domain.isNullAllowed() ? this.quote(columnName) + " IS NULL" : "FALSE";
        }
        if (domain.getValues().isAll()) {
            return domain.isNullAllowed() ? "TRUE" : this.quote(columnName) + " IS NOT NULL";
        }
        ArrayList<Object> disjuncts = new ArrayList<Object>();
        ArrayList<Object> singleValues = new ArrayList<Object>();
        for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                singleValues.add(range.getLow().getValue());
                continue;
            }
            ArrayList<String> rangeConjuncts = new ArrayList<String>();
            if (!range.getLow().isLowerUnbounded()) {
                switch (range.getLow().getBound()) {
                    case ABOVE: {
                        rangeConjuncts.add(this.toPredicate(columnName, ">", range.getLow().getValue(), column));
                        break;
                    }
                    case EXACTLY: {
                        rangeConjuncts.add(this.toPredicate(columnName, ">=", range.getLow().getValue(), column));
                        break;
                    }
                    case BELOW: {
                        throw new IllegalArgumentException("Low marker should never use BELOW bound");
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                    }
                }
            }
            if (!range.getHigh().isUpperUnbounded()) {
                switch (range.getHigh().getBound()) {
                    case ABOVE: {
                        throw new IllegalArgumentException("High marker should never use ABOVE bound");
                    }
                    case EXACTLY: {
                        rangeConjuncts.add(this.toPredicate(columnName, "<=", range.getHigh().getValue(), column));
                        break;
                    }
                    case BELOW: {
                        rangeConjuncts.add(this.toPredicate(columnName, "<", range.getHigh().getValue(), column));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                    }
                }
            }
            Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
            disjuncts.add("(" + this.concat(rangeConjuncts) + ")");
        }
        if (singleValues.size() == 1) {
            disjuncts.add(this.toPredicate(columnName, "=", Iterables.getOnlyElement(singleValues), column));
        } else if (singleValues.size() > 1) {
            String values = singleValues.stream().map(column.getBigQueryType()::convertToString).collect(Collectors.joining(","));
            disjuncts.add(this.quote(columnName) + " IN (" + values + ")");
        }
        Preconditions.checkState((!disjuncts.isEmpty() ? 1 : 0) != 0);
        if (domain.isNullAllowed()) {
            disjuncts.add(this.quote(columnName) + " IS NULL");
        }
        return "(" + String.join((CharSequence)" OR ", disjuncts) + ")";
    }

    private String toPredicate(String columnName, String operator, Object value, BigQueryColumnHandle column) {
        String valueAsString = column.getBigQueryType().convertToString(value);
        return this.quote(columnName) + " " + operator + " " + valueAsString;
    }

    private String quote(String name) {
        return QUOTE + name.replace(QUOTE, ESCAPED_QUOTE) + QUOTE;
    }
}

