/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.prestosql.plugin.bigquery.BigQueryColumnHandle;
import io.prestosql.plugin.bigquery.BigQueryConfig;
import io.prestosql.plugin.bigquery.BigQueryEmptyProjectionPageSource;
import io.prestosql.plugin.bigquery.BigQueryResultPageSource;
import io.prestosql.plugin.bigquery.BigQuerySplit;
import io.prestosql.plugin.bigquery.BigQueryStorageClientFactory;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class BigQueryPageSourceProvider
implements ConnectorPageSourceProvider {
    private static final Logger log = Logger.get(BigQueryPageSourceProvider.class);
    private final BigQueryStorageClientFactory bigQueryStorageClientFactory;
    private final int maxReadRowsRetries;

    @Inject
    public BigQueryPageSourceProvider(BigQueryStorageClientFactory bigQueryStorageClientFactory, BigQueryConfig config) {
        this.bigQueryStorageClientFactory = Objects.requireNonNull(bigQueryStorageClientFactory, "bigQueryStorageClientFactory is null");
        this.maxReadRowsRetries = Objects.requireNonNull(config, "config is null").getMaxReadRowsRetries();
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, TupleDomain<ColumnHandle> dynamicFilter) {
        log.debug("createPageSource(transaction=%s, session=%s, split=%s, table=%s, columns=%s)", new Object[]{transaction, session, split, table, columns});
        BigQuerySplit bigQuerySplit = (BigQuerySplit)split;
        if (bigQuerySplit.representsEmptyProjection()) {
            return new BigQueryEmptyProjectionPageSource(bigQuerySplit.getEmptyRowsToGenerate());
        }
        List bigQueryColumnHandles = (List)columns.stream().map(BigQueryColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        return new BigQueryResultPageSource(this.bigQueryStorageClientFactory, this.maxReadRowsRetries, bigQuerySplit, bigQueryColumnHandles);
    }
}

