/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.bigquery.BigQueryColumnHandle;
import io.prestosql.plugin.bigquery.BigQuerySplit;
import io.prestosql.plugin.bigquery.BigQueryStorageClientFactory;
import io.prestosql.plugin.bigquery.BigQueryType;
import io.prestosql.plugin.bigquery.ReadRowsHelper;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;

public class BigQueryResultPageSource
implements ConnectorPageSource {
    private static final Logger log = Logger.get(BigQueryResultPageSource.class);
    private static final AvroDecimalConverter DECIMAL_CONVERTER = new AvroDecimalConverter();
    private final BigQueryStorageClient bigQueryStorageClient;
    private final BigQuerySplit split;
    private final List<Type> columnTypes;
    private final AtomicLong readBytes;
    private final PageBuilder pageBuilder;
    private final Iterator<Storage.ReadRowsResponse> responses;

    public BigQueryResultPageSource(BigQueryStorageClientFactory bigQueryStorageClientFactory, int maxReadRowsRetries, BigQuerySplit split, List<BigQueryColumnHandle> columns) {
        this.bigQueryStorageClient = Objects.requireNonNull(bigQueryStorageClientFactory, "bigQueryStorageClientFactory is null").createBigQueryStorageClient();
        this.split = Objects.requireNonNull(split, "split is null");
        this.readBytes = new AtomicLong();
        this.columnTypes = (List)Objects.requireNonNull(columns, "columns is null").stream().map(BigQueryType.Adaptor::getPrestoType).collect(ImmutableList.toImmutableList());
        this.pageBuilder = new PageBuilder(this.columnTypes);
        log.debug("Starting to read from %s", new Object[]{split.getStreamName()});
        Storage.ReadRowsRequest.Builder readRowsRequest = Storage.ReadRowsRequest.newBuilder().setReadPosition(Storage.StreamPosition.newBuilder().setStream(Storage.Stream.newBuilder().setName(split.getStreamName())));
        this.responses = new ReadRowsHelper(this.bigQueryStorageClient, readRowsRequest, maxReadRowsRetries).readRows();
    }

    public long getCompletedBytes() {
        return this.readBytes.get();
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return !this.responses.hasNext();
    }

    public Page getNextPage() {
        Preconditions.checkState((boolean)this.pageBuilder.isEmpty(), (Object)"PageBuilder is not empty at the beginning of a new page");
        Storage.ReadRowsResponse response = this.responses.next();
        Iterable<GenericRecord> records = this.parse(response);
        for (GenericRecord record : records) {
            this.pageBuilder.declarePosition();
            for (int column = 0; column < this.columnTypes.size(); ++column) {
                BlockBuilder output = this.pageBuilder.getBlockBuilder(column);
                this.appendTo(this.columnTypes.get(column), record.get(column), output);
            }
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    private void appendTo(Type type, Object value, BlockBuilder output) {
        block14: {
            if (value == null) {
                output.appendNull();
                return;
            }
            Class javaType = type.getJavaType();
            try {
                if (javaType == Boolean.TYPE) {
                    type.writeBoolean(output, ((Boolean)value).booleanValue());
                    break block14;
                }
                if (javaType == Long.TYPE) {
                    if (type.equals(BigintType.BIGINT)) {
                        type.writeLong(output, ((Number)value).longValue());
                        break block14;
                    }
                    if (type.equals(IntegerType.INTEGER)) {
                        type.writeLong(output, (long)((Number)value).intValue());
                        break block14;
                    }
                    if (type.equals(DateType.DATE)) {
                        type.writeLong(output, (long)((Number)value).intValue());
                        break block14;
                    }
                    if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
                        type.writeLong(output, BigQueryType.toPrestoTimestamp(((Utf8)value).toString()));
                        break block14;
                    }
                    if (type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
                        type.writeLong(output, DateTimeEncoding.packDateTimeWithZone((long)((Long)value / 1000L), (TimeZoneKey)TimeZoneKey.UTC_KEY));
                        break block14;
                    }
                    if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
                        type.writeLong(output, DateTimeEncoding.packDateTimeWithZone((long)((Long)value / 1000L), (TimeZoneKey)TimeZoneKey.UTC_KEY));
                        break block14;
                    }
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type));
                }
                if (javaType == Double.TYPE) {
                    type.writeDouble(output, ((Number)value).doubleValue());
                    break block14;
                }
                if (javaType == Slice.class) {
                    BigQueryResultPageSource.writeSlice(output, type, value);
                    break block14;
                }
                if (javaType == Block.class) {
                    this.writeBlock(output, type, value);
                    break block14;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type));
            }
            catch (ClassCastException ignore) {
                output.appendNull();
            }
        }
    }

    private static void writeSlice(BlockBuilder output, Type type, Object value) {
        if (type instanceof VarcharType) {
            type.writeSlice(output, Slices.utf8Slice((String)((Utf8)value).toString()));
        } else if (type instanceof DecimalType) {
            BigDecimal bdValue = DECIMAL_CONVERTER.convert(value);
            type.writeSlice(output, Decimals.encodeScaledValue((BigDecimal)bdValue, (int)9));
        } else if (type instanceof VarbinaryType) {
            if (value instanceof ByteBuffer) {
                type.writeSlice(output, Slices.wrappedBuffer((ByteBuffer)((ByteBuffer)value)));
            } else {
                output.appendNull();
            }
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Slice: " + type.getTypeSignature());
        }
    }

    private void writeBlock(BlockBuilder output, Type type, Object value) {
        if (type instanceof ArrayType && value instanceof List) {
            BlockBuilder builder = output.beginBlockEntry();
            for (Object element : (List)value) {
                this.appendTo((Type)type.getTypeParameters().get(0), element, builder);
            }
            output.closeEntry();
            return;
        }
        if (type instanceof RowType && value instanceof GenericRecord) {
            GenericRecord record = (GenericRecord)value;
            BlockBuilder builder = output.beginBlockEntry();
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (int i = 0; i < type.getTypeSignature().getParameters().size(); ++i) {
                TypeSignatureParameter parameter = (TypeSignatureParameter)type.getTypeSignature().getParameters().get(i);
                fieldNames.add((String)((Object)parameter.getNamedTypeSignature().getName().orElse("field" + i)));
            }
            Preconditions.checkState((fieldNames.size() == type.getTypeParameters().size() ? 1 : 0) != 0, (String)"fieldName doesn't match with type size : %s", (Object)type);
            for (int index = 0; index < type.getTypeParameters().size(); ++index) {
                this.appendTo((Type)type.getTypeParameters().get(index), record.get((String)fieldNames.get(index)), builder);
            }
            output.closeEntry();
            return;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Block: " + type.getTypeSignature());
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() {
        this.bigQueryStorageClient.close();
    }

    Iterable<GenericRecord> parse(Storage.ReadRowsResponse response) {
        byte[] buffer = response.getAvroRows().getSerializedBinaryRows().toByteArray();
        this.readBytes.addAndGet(buffer.length);
        log.debug("Read %d bytes (total %d) from %s", new Object[]{buffer.length, this.readBytes.get(), this.split.getStreamName()});
        Schema avroSchema = new Schema.Parser().parse(this.split.getAvroSchema());
        return () -> new AvroBinaryIterator(avroSchema, buffer);
    }

    static class AvroDecimalConverter {
        private static final Conversions.DecimalConversion AVRO_DECIMAL_CONVERSION = new Conversions.DecimalConversion();
        private static final Schema AVRO_DECIMAL_SCHEMA = new Schema.Parser().parse(String.format("{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":%d,\"scale\":%d}", 38, 9));

        AvroDecimalConverter() {
        }

        BigDecimal convert(Object value) {
            return AVRO_DECIMAL_CONVERSION.fromBytes((ByteBuffer)value, AVRO_DECIMAL_SCHEMA, AVRO_DECIMAL_SCHEMA.getLogicalType());
        }
    }

    static class AvroBinaryIterator
    implements Iterator<GenericRecord> {
        GenericDatumReader<GenericRecord> reader;
        BinaryDecoder in;

        AvroBinaryIterator(Schema avroSchema, byte[] buffer) {
            this.reader = new GenericDatumReader(avroSchema);
            this.in = new DecoderFactory().binaryDecoder(buffer, null);
        }

        @Override
        public boolean hasNext() {
            try {
                return !this.in.isEnd();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error determining the end of Avro buffer", e);
            }
        }

        @Override
        public GenericRecord next() {
            try {
                return (GenericRecord)this.reader.read(null, (Decoder)this.in);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading next Avro Record", e);
            }
        }
    }
}

